/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.CollectionSupplier;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.operators.async.queue.StreamRecordQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.AecRecord;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.TableAsyncExecutionController;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableKeyedAsyncWaitOperator<IN, OUT, KEY>
extends AbstractUdfStreamOperator<OUT, AsyncFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    protected static final Logger LOG = LoggerFactory.getLogger(TableKeyedAsyncWaitOperator.class);
    private static final long serialVersionUID = 1L;
    private static final String STATE_NAME = "_keyed_async_wait_operator_state_";
    private final KeySelector<IN, KEY> keySelector;
    private final long timeout;
    private final transient int capacity;
    protected transient StreamElementSerializer<IN> inStreamElementSerializer;
    protected transient TimestampedCollector<OUT> timestampedCollector;
    protected transient boolean needDeepCopy;
    private transient TableAsyncExecutionController<IN, OUT, KEY> asyncExecutionController;
    private transient ListState<Tuple2<StreamElement, StreamElement>> recoveredStreamElements;
    private final transient MailboxExecutor mailboxExecutor;
    private final transient AtomicInteger totalInflightNum;

    public TableKeyedAsyncWaitOperator(AsyncFunction<IN, OUT> asyncFunction, KeySelector<IN, KEY> keySelector, long timeout, int capacity, ProcessingTimeService processingTimeService, MailboxExecutor mailboxExecutor) {
        super(asyncFunction);
        this.timeout = timeout;
        this.keySelector = keySelector;
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The maxInflight of concurrent async operation should be greater than 0.");
        this.capacity = capacity;
        this.totalInflightNum = new AtomicInteger(0);
        this.mailboxExecutor = mailboxExecutor;
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        super.setup(containingTask, config, output);
        this.inStreamElementSerializer = new StreamElementSerializer(this.getOperatorConfig().getTypeSerializerIn(0, this.getUserCodeClassloader()));
        this.timestampedCollector = new TimestampedCollector(this.output);
        this.asyncExecutionController = new TableAsyncExecutionController(this::invoke, (ThrowingConsumer<Watermark, Exception>)((ThrowingConsumer)x$0 -> super.processWatermark(x$0)), entry -> {
            entry.emitResult(this.timestampedCollector);
            this.totalInflightNum.decrementAndGet();
        }, entry -> 0, (record, inputIndex) -> this.keySelector.getKey(record.getValue()));
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        TypeSerializer[] elementSerializers = new TypeSerializer[]{this.inStreamElementSerializer, this.inStreamElementSerializer};
        TypeInformation typeInfo = Types.TUPLE((TypeInformation[])new TypeInformation[]{TypeInformation.of(StreamElement.class), TypeInformation.of(StreamElement.class)});
        Class type = typeInfo.getTypeClass();
        TupleSerializer stateSerializer = new TupleSerializer(type, elementSerializers);
        this.recoveredStreamElements = context.getKeyedStateStore().getListState(new ListStateDescriptor(STATE_NAME, (TypeSerializer)stateSerializer));
    }

    public void open() throws Exception {
        super.open();
        this.needDeepCopy = this.getExecutionConfig().isObjectReuseEnabled() && !this.config.isChainStart();
        List keys = this.getKeyedStateBackend().getKeys(STATE_NAME, (Object)VoidNamespace.INSTANCE).collect(Collectors.toList());
        for (Object key : keys) {
            this.setCurrentKey(key);
            this.triggerRecoveryProcess();
        }
    }

    public void processElement(StreamRecord<IN> record) throws Exception {
        this.tryProcess();
        StreamRecord element = this.needDeepCopy ? (StreamRecord)this.inStreamElementSerializer.copy(record) : record;
        this.asyncExecutionController.submitRecord(element, null, 0);
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.asyncExecutionController.submitWatermark(mark);
    }

    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory factory) throws Exception {
        Map<KEY, Deque<AecRecord<IN, OUT>>> pendingElements = this.asyncExecutionController.pendingElements();
        for (Map.Entry<KEY, Deque<AecRecord<IN, OUT>>> entry : pendingElements.entrySet()) {
            KEY key = entry.getKey();
            this.setCurrentKey(key);
            Deque<AecRecord<IN, OUT>> elements = entry.getValue();
            ArrayList<Tuple2> value = new ArrayList<Tuple2>();
            for (AecRecord<IN, OUT> aecRecord : elements) {
                value.add(Tuple2.of(aecRecord.getRecord(), (Object)aecRecord.getEpoch().getWatermark()));
            }
            this.recoveredStreamElements.update(value);
        }
        return super.snapshotState(checkpointId, timestamp, checkpointOptions, factory);
    }

    public void endInput() throws Exception {
        this.waitInFlightInputsFinished();
    }

    public void invoke(AecRecord<IN, OUT> element) throws Exception {
        KeyedResultHandler resultHandler = new KeyedResultHandler(element, new StreamRecordQueueEntry(element.getRecord()));
        if (this.timeout > 0L) {
            resultHandler.registerTimeout(this.getProcessingTimeService(), this.timeout);
        }
        ((AsyncFunction)this.userFunction).asyncInvoke(element.getRecord().getValue(), (ResultFuture)resultHandler);
    }

    public void emitWatermark(Watermark mark) {
        this.timestampedCollector.emitWatermark(mark);
    }

    public void waitInFlightInputsFinished() throws InterruptedException {
        while (!this.allInflightFinished()) {
            this.mailboxExecutor.yield();
        }
    }

    private void triggerRecoveryProcess() throws Exception {
        if (this.recoveredStreamElements != null) {
            for (Tuple2 tuple : (Iterable)this.recoveredStreamElements.get()) {
                this.tryProcess();
                this.asyncExecutionController.recovery((StreamRecord)tuple.f0, (Watermark)tuple.f1, 0);
            }
        }
    }

    private void tryProcess() throws Exception {
        while (this.totalInflightNum.get() >= this.capacity) {
            LOG.debug("Failed to put element into asyncExecutionController because totalInflightNum is greater or equal to maxInflight ({}/{}).", (Object)this.totalInflightNum.get(), (Object)this.capacity);
            this.mailboxExecutor.yield();
        }
        this.totalInflightNum.incrementAndGet();
    }

    private ScheduledFuture<?> registerTimer(ProcessingTimeService processingTimeService, long timeout, ThrowingConsumer<Void, Exception> callback) {
        long timeoutTimestamp = timeout + processingTimeService.getCurrentProcessingTime();
        return processingTimeService.registerTimer(timeoutTimestamp, timestamp -> callback.accept(null));
    }

    private boolean allInflightFinished() {
        return this.totalInflightNum.get() == 0;
    }

    public KEY getKey(AecRecord<IN, OUT> aecRecord) {
        StreamRecord<IN> record = aecRecord.getRecord();
        try {
            return (KEY)this.keySelector.getKey(record.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve key from record " + String.valueOf(record), e);
        }
    }

    @VisibleForTesting
    public TableAsyncExecutionController<IN, OUT, KEY> getAsyncExecutionController() {
        return this.asyncExecutionController;
    }

    private class KeyedResultHandler
    implements ResultFuture<OUT> {
        protected ScheduledFuture<?> timeoutTimer;
        protected final AecRecord<IN, OUT> inputRecord;
        protected final ResultFuture<OUT> resultFuture;
        protected final AtomicBoolean completed = new AtomicBoolean(false);

        KeyedResultHandler(AecRecord<IN, OUT> inputRecord, ResultFuture<OUT> resultFuture) {
            this.inputRecord = inputRecord;
            this.resultFuture = resultFuture;
        }

        public void complete(Collection<OUT> results) {
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            this.processInMailbox(results);
        }

        public void completeExceptionally(Throwable error) {
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            TableKeyedAsyncWaitOperator.this.getContainingTask().getEnvironment().failExternally((Throwable)new Exception("Could not complete the stream element: " + String.valueOf(this.inputRecord) + ".", error));
            this.processInMailbox(Collections.emptyList());
        }

        public void complete(CollectionSupplier<OUT> supplier) {
            throw new UnsupportedOperationException();
        }

        private void processInMailbox(Collection<OUT> results) {
            TableKeyedAsyncWaitOperator.this.mailboxExecutor.execute(() -> this.processResults(results), "Result in AsyncWaitOperator of input %s", new Object[]{results});
        }

        private void processResults(Collection<OUT> results) throws Exception {
            if (this.timeoutTimer != null) {
                this.timeoutTimer.cancel(true);
            }
            this.resultFuture.complete(results);
            TableKeyedAsyncWaitOperator.this.asyncExecutionController.completeRecord((StreamElementQueueEntry)((StreamRecordQueueEntry)this.resultFuture), this.inputRecord);
        }

        private void registerTimeout(ProcessingTimeService processingTimeService, long timeout) {
            this.timeoutTimer = TableKeyedAsyncWaitOperator.this.registerTimer(processingTimeService, timeout, (ThrowingConsumer<Void, Exception>)((ThrowingConsumer)t -> this.timerTriggered()));
        }

        private void timerTriggered() throws Exception {
            if (!this.completed.get()) {
                ((AsyncFunction)TableKeyedAsyncWaitOperator.this.userFunction).timeout(this.inputRecord.getRecord().getValue(), (ResultFuture)this);
            }
        }
    }
}

