/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.client.cli.CliRowView;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.cli.CliView;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.print.TableauStyle;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public abstract class CliResultView<O extends Enum<O>>
extends CliView<O, Void> {
    protected static final int NO_ROW_SELECTED = -1;
    protected static final List<Tuple2<String, Long>> REFRESH_INTERVALS = new ArrayList<Tuple2<String, Long>>();
    private final RefreshThread refreshThread;
    protected final ResultDescriptor resultDescriptor;
    protected final TableauStyle tableauStyle;
    protected final int[] columnWidths;
    protected int refreshInterval;
    protected List<String[]> previousResults;
    protected List<String[]> results;
    protected int selectedRow;

    public CliResultView(Terminal terminal, ResultDescriptor resultDescriptor, TableauStyle tableauStyle) {
        super(terminal);
        this.resultDescriptor = resultDescriptor;
        this.tableauStyle = tableauStyle;
        this.columnWidths = tableauStyle.getColumnWidths();
        this.refreshThread = new RefreshThread();
        this.selectedRow = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseRefreshInterval() {
        this.refreshInterval = Math.min(REFRESH_INTERVALS.size() - 1, this.refreshInterval + 1);
        this.resetAllParts();
        RefreshThread refreshThread = this.refreshThread;
        synchronized (refreshThread) {
            this.refreshThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseRefreshInterval(int minInterval) {
        this.refreshInterval = Math.max(minInterval, this.refreshInterval - 1);
        this.resetAllParts();
        RefreshThread refreshThread = this.refreshThread;
        synchronized (refreshThread) {
            this.refreshThread.notify();
        }
    }

    protected void selectRowUp() {
        int visibleRowTop = this.offsetY;
        if (this.selectedRow == -1) {
            if (!this.getMainLines().isEmpty()) {
                this.selectedRow = Math.min(this.getMainLines().size(), this.offsetY + this.getVisibleMainHeight()) - 1;
            }
        } else if (this.selectedRow > visibleRowTop) {
            --this.selectedRow;
        } else {
            this.selectedRow = Math.max(0, this.selectedRow - 1);
            this.scrollUp();
        }
        this.resetMainPart();
    }

    protected void selectRowDown() {
        int visibleRowBottom = Math.min(this.getMainLines().size(), this.offsetY + this.getVisibleMainHeight()) - 1;
        if (this.selectedRow == -1) {
            this.selectedRow = this.offsetY;
        } else if (visibleRowBottom >= 0 && this.selectedRow < visibleRowBottom) {
            ++this.selectedRow;
        } else {
            this.selectedRow = Math.min(Math.max(0, this.getMainLines().size() - 1), this.selectedRow + 1);
            this.scrollDown();
        }
        this.resetMainPart();
    }

    protected void openRow() {
        if (this.selectedRow == -1) {
            return;
        }
        CliRowView view = new CliRowView(this.terminal, this.resultDescriptor.getResultSchema().getColumnNames().toArray(new String[0]), CliUtils.typesToString(this.resultDescriptor.getResultSchema().getColumnDataTypes().toArray(new DataType[0])), this.getRow(this.results.get(this.selectedRow)));
        view.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRetrieval(boolean cleanUpQuery) {
        this.refreshThread.cleanUpQuery = cleanUpQuery;
        this.refreshThread.isRunning = false;
        RefreshThread refreshThread = this.refreshThread;
        synchronized (refreshThread) {
            this.refreshThread.notify();
        }
    }

    protected boolean isRetrieving() {
        return this.refreshThread.isRunning;
    }

    protected abstract void refresh();

    protected abstract String[] getRow(String[] var1);

    @Override
    protected void init() {
        this.refreshThread.start();
    }

    @Override
    protected List<AttributedString> computeMainLines() {
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        int lineIdx = 0;
        for (String[] line : this.results) {
            AttributedStringBuilder row = new AttributedStringBuilder();
            if (lineIdx == this.selectedRow) {
                row.style(AttributedStyle.DEFAULT.inverse());
            }
            for (int colIdx = 0; colIdx < line.length; ++colIdx) {
                String col = line[colIdx];
                row.append(' ');
                if (this.previousResults != null && lineIdx != this.selectedRow && this.refreshThread.isRunning && (lineIdx >= this.previousResults.size() || !col.equals(this.previousResults.get(lineIdx)[colIdx]))) {
                    row.style(AttributedStyle.BOLD);
                    CliUtils.normalizeColumn(row, col, this.columnWidths[colIdx]);
                    row.style(AttributedStyle.DEFAULT);
                    continue;
                }
                CliUtils.normalizeColumn(row, col, this.columnWidths[colIdx]);
            }
            lines.add(row.toAttributedString());
            ++lineIdx;
        }
        return lines;
    }

    @Override
    protected void cleanUp() {
        this.stopRetrieval(true);
        try {
            this.refreshThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    abstract void cleanUpQuery();

    static {
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"Fastest", (Object)0L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"100 ms", (Object)100L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"500 ms", (Object)100L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"1 s", (Object)1000L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"5 s", (Object)5000L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"10 s", (Object)10000L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"1 min", (Object)60000L));
        REFRESH_INTERVALS.add((Tuple2<String, Long>)Tuple2.of((Object)"-", (Object)-1L));
    }

    private class RefreshThread
    extends Thread {
        public volatile boolean isRunning = true;
        public volatile boolean cleanUpQuery = true;
        public long lastUpdatedResults = System.currentTimeMillis();

        private RefreshThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isRunning) {
                Object object;
                long interval = (Long)CliResultView.REFRESH_INTERVALS.get((int)CliResultView.this.refreshInterval).f1;
                if (interval >= 0L) {
                    if (interval > 0L) {
                        object = this;
                        synchronized (object) {
                            if (this.isRunning) {
                                try {
                                    this.wait(interval);
                                }
                                catch (InterruptedException e) {
                                    continue;
                                }
                            }
                        }
                    }
                    object = CliResultView.this;
                    synchronized (object) {
                        CliResultView.this.refresh();
                        if (System.currentTimeMillis() - this.lastUpdatedResults > 100L) {
                            if (CliResultView.this.isRunning()) {
                                CliResultView.this.display();
                            }
                            this.lastUpdatedResults = System.currentTimeMillis();
                        }
                        continue;
                    }
                }
                object = this;
                synchronized (object) {
                    if (this.isRunning) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            CliResultView cliResultView = CliResultView.this;
            synchronized (cliResultView) {
                if (CliResultView.this.isRunning()) {
                    CliResultView.this.display();
                }
            }
            if (this.cleanUpQuery) {
                CliResultView.this.cleanUpQuery();
            }
        }
    }
}

