/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.AbstractSliceWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.MergeCallback;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;

public final class SliceSharedWindowAggProcessor
extends AbstractSliceWindowAggProcessor
implements MergeCallback<Long, Iterable<Long>> {
    private static final long serialVersionUID = 1L;
    private final SliceSharedAssigner sliceSharedAssigner;
    private final SliceMergeTargetHelper mergeTargetHelper;

    public SliceSharedWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, WindowBuffer.Factory bufferFactory, SliceSharedAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, int indexOfCountStar, ZoneId shiftTimeZone) {
        super(genAggsHandler, bufferFactory, sliceAssigner, accSerializer, indexOfCountStar, shiftTimeZone);
        this.sliceSharedAssigner = sliceAssigner;
        this.mergeTargetHelper = new SliceMergeTargetHelper();
    }

    @Override
    public void fireWindow(long timerTimestamp, Long windowEnd) throws Exception {
        Optional<Long> nextWindowEndOptional;
        this.sliceSharedAssigner.mergeSlices(windowEnd, this);
        RowData aggResult = this.aggregator.getValue(windowEnd);
        if (!this.emptySupplier.get().booleanValue()) {
            this.collect(aggResult);
        }
        if ((nextWindowEndOptional = this.sliceSharedAssigner.nextTriggerWindow(windowEnd, this.emptySupplier)).isPresent()) {
            long nextWindowEnd = nextWindowEndOptional.get();
            if (this.sliceSharedAssigner.isEventTime()) {
                this.windowTimerService.registerEventTimeWindowTimer(nextWindowEnd);
            } else {
                this.windowTimerService.registerProcessingTimeWindowTimer(nextWindowEnd);
            }
        }
    }

    @Override
    public void merge(@Nullable Long mergeResult, Iterable<Long> toBeMerged) throws Exception {
        RowData stateAcc;
        RowData acc = mergeResult == null ? this.aggregator.createAccumulators() : ((stateAcc = this.windowState.value(mergeResult)) == null ? this.aggregator.createAccumulators() : stateAcc);
        this.aggregator.setAccumulators(mergeResult, acc);
        for (Long slice : toBeMerged) {
            RowData sliceAcc = this.windowState.value(slice);
            if (sliceAcc == null) continue;
            this.aggregator.merge(slice, sliceAcc);
        }
        if (mergeResult != null) {
            this.windowState.update(mergeResult, this.aggregator.getAccumulators());
        }
    }

    @Override
    protected long sliceStateMergeTarget(long sliceToMerge) throws Exception {
        this.mergeTargetHelper.setMergeTarget(null);
        this.sliceSharedAssigner.mergeSlices(sliceToMerge, this.mergeTargetHelper);
        if (this.mergeTargetHelper.getMergeTarget() != null) {
            return this.mergeTargetHelper.getMergeTarget();
        }
        return sliceToMerge;
    }

    private static final class SliceMergeTargetHelper
    implements MergeCallback<Long, Iterable<Long>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long mergeTarget = null;

        private SliceMergeTargetHelper() {
        }

        @Override
        public void merge(@Nullable Long mergeResult, Iterable<Long> toBeMerged) throws Exception {
            this.mergeTarget = mergeResult;
        }

        public Long getMergeTarget() {
            return this.mergeTarget;
        }

        public void setMergeTarget(Long mergeTarget) {
            this.mergeTarget = mergeTarget;
        }
    }
}

