/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hamcrest.collection
{
    import mx.collections.ArrayCollection;
    
    import org.hamcrest.AbstractMatcherTestCase;
    import org.hamcrest.Matcher;

    public class AbstractArrayMatcherTestCase extends AbstractMatcherTestCase
    {
        public function AbstractArrayMatcherTestCase()
        {
            super();
        }
        
        override public function assertMatches(message:String, matcher:Matcher, arg:Object):void 
        {
            super.assertMatches(message, matcher, arg);

            // To ensure that the matcher properly matches non-Array collecitons,
            // run the same test again, this time using an ArrayCollection.
            if (arg is Array) 
            {
                super.assertMatches(message + " (as ArrayCollection)", matcher, new ArrayCollection(arg as Array));
            }
        }
        
        override public function assertDoesNotMatch(message:String, matcher:Matcher, arg:Object):void
        {
            super.assertDoesNotMatch(message, matcher, arg);

            // To ensure that the matcher properly matches non-Array collecitons,
            // run the same test again, this time using an ArrayCollection.
            if (arg is Array) 
            {
                super.assertDoesNotMatch(message + " (as ArrayCollection)", matcher, new ArrayCollection(arg as Array));
            }
        }
    }
}
