/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import java.util.Arrays;

public final class FlashUUID {
    private static final int kUUIDSize = 16;
    public final byte[] bytes;

    public FlashUUID(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.bytes = byArray;
    }

    public FlashUUID() {
        this.bytes = new byte[16];
    }

    public String toString() {
        return FlashUUID.stringify(this.bytes);
    }

    private static String stringify(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xF0) >> 4;
            int n2 = byArray[i] & 0xF;
            stringBuilder.append((char)(n > 9 ? 65 + n - 10 : 48 + n));
            stringBuilder.append((char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n;
        int n2 = n = this.bytes.length;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 ^ this.bytes[i];
        }
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof FlashUUID) {
            FlashUUID flashUUID = (FlashUUID)object;
            if (Arrays.equals(flashUUID.bytes, this.bytes)) {
                bl = true;
            }
        }
        return bl;
    }
}

