/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.util.ThreadLocalToolkit;

public class ConfigurationException
extends Exception
implements ILocalizableMessage {
    private static final long serialVersionUID = -2435642161291588713L;
    public String var = null;
    public String source = null;
    public int line = -1;

    public ConfigurationException(String msg) {
        super(msg);
    }

    public ConfigurationException(String var, String source, int line) {
        this.var = var;
        this.source = source;
        this.line = line;
    }

    public String getLevel() {
        return "error";
    }

    public String getPath() {
        return this.source;
    }

    public void setPath(String path) {
        this.source = path;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return -1;
    }

    public void setColumn(int column) {
    }

    public Exception getExceptionDetail() {
        return null;
    }

    public boolean isPathAvailable() {
        return true;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        if (l10n == null) {
            return null;
        }
        return l10n.getLocalizedTextString((Object)this);
    }

    public String toString() {
        return this.getMessage();
    }

    public static class BadApplicationDomainValue
    extends ConfigurationException {
        private static final long serialVersionUID = -3575875352932278137L;
        public String swcPath;
        public String argument;

        public BadApplicationDomainValue(String swcPath, String argument, String var, String source, int line) {
            super(var, source, line);
            this.swcPath = swcPath;
            this.argument = argument;
        }
    }

    public static class SwcDoesNotHaveRslData
    extends ConfigurationException {
        private static final long serialVersionUID = 8048448308683132926L;
        public String swcPath;

        public SwcDoesNotHaveRslData(String swcPath, String var, String source, int line) {
            super(var, source, line);
            this.swcPath = swcPath;
        }
    }

    public static class MissingIncludeClasses
    extends ConfigurationException {
        private static final long serialVersionUID = 1631608860338388417L;

        public MissingIncludeClasses() {
            super(null, null, -1);
        }
    }

    public static class ToolsLocaleNotAvailable
    extends ConfigurationException {
        private static final long serialVersionUID = 1840362182782082437L;

        public ToolsLocaleNotAvailable(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class NamespaceMissingManifest
    extends ConfigurationException {
        private static final long serialVersionUID = 1840362182782082436L;

        public NamespaceMissingManifest(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class BadExcludeDependencies
    extends ConfigurationException {
        private static final long serialVersionUID = -8463049402307139110L;

        public BadExcludeDependencies() {
            super(null, null, -1);
        }
    }

    public static class NoASDocInputs
    extends ConfigurationException {
        private static final long serialVersionUID = 2151330864688948051L;

        public NoASDocInputs() {
            super(null, null, -1);
        }
    }

    public static class ObsoleteVariable
    extends ConfigurationException {
        private static final long serialVersionUID = 3622916477413320447L;
        public String replacement;

        public ObsoleteVariable(String replacement, String var, String source, int line) {
            super(var, source, line);
            this.replacement = replacement;
        }
    }

    public static class RedundantFile
    extends ConfigurationException {
        private static final long serialVersionUID = -6206003786362484586L;
        public String path;

        public RedundantFile(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class DirectoryNotEmpty
    extends ConfigurationException {
        private static final long serialVersionUID = 359443368875780282L;
        public String path;

        public DirectoryNotEmpty(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class UnknownNamespace
    extends ConfigurationException {
        private static final long serialVersionUID = -5393732592631516166L;
        public String namespace;

        public UnknownNamespace(String ns, String var, String source, int line) {
            super(var, source, line);
            this.namespace = ns;
        }
    }

    public static class CannotOpen
    extends ConfigurationException {
        private static final long serialVersionUID = -7773063809601129906L;
        public String path;

        public CannotOpen(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class IllegalDimensions
    extends ConfigurationException {
        private static final long serialVersionUID = -7259122437168158126L;
        public int width;
        public int height;

        public IllegalDimensions(int width, int height, String var, String source, int line) {
            super(var, source, line);
            this.width = width;
            this.height = height;
        }
    }

    public static class BadMetadataCombo
    extends ConfigurationException {
        private static final long serialVersionUID = 3406393415937431348L;

        public BadMetadataCombo(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class CouldNotCreateConfig
    extends ConfigurationException {
        private static final long serialVersionUID = -6969824220592565605L;

        public CouldNotCreateConfig(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class OnlyOneSource
    extends ConfigurationException {
        private static final long serialVersionUID = 1234968103239361023L;

        public OnlyOneSource(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class NoSwcInputs
    extends ConfigurationException {
        private static final long serialVersionUID = 3980913434019979144L;

        public NoSwcInputs(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class MustSpecifyTarget
    extends ConfigurationException {
        private static final long serialVersionUID = 9112152606473481404L;

        public MustSpecifyTarget(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class GreaterThanZero
    extends ConfigurationException {
        private static final long serialVersionUID = 3912071331977316395L;

        public GreaterThanZero(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class BadFrameParameters
    extends ConfigurationException {
        private static final long serialVersionUID = -2323511087396160382L;

        public BadFrameParameters(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class BadDefinition
    extends ConfigurationException {
        private static final long serialVersionUID = -325852269490101058L;
        public String argument;

        public BadDefinition(String argument, String var, String source, int line) {
            super(var, source, line);
            this.argument = argument;
        }
    }

    public static class FileTooBig
    extends ConfigurationException {
        private static final long serialVersionUID = -786476651372253779L;
        public String path;

        public FileTooBig(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class BadVersion
    extends ConfigurationException {
        private static final long serialVersionUID = 5226991469529337229L;
        public String version;

        public BadVersion(String version, String var) {
            super(var, null, -1);
            this.version = version;
        }
    }

    public static class BadAppendValue
    extends ConfigurationException {
        private static final long serialVersionUID = 1552561566382094415L;

        public BadAppendValue(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class UnexpectedArgument
    extends ConfigurationException {
        private static final long serialVersionUID = -8845402586579325956L;
        public String argument;
        public String expected;

        public UnexpectedArgument(String expected, String argument, String var, String source, int line) {
            super(var, source, line);
            this.expected = expected;
            this.argument = argument;
        }
    }

    public static class MissingArgument
    extends ConfigurationException {
        private static final long serialVersionUID = -5463734098797737741L;
        public String argument;

        public MissingArgument(String argument, String var, String source, int line) {
            super(var, source, line);
            this.argument = argument;
        }
    }

    public static class UnexpectedCDATA
    extends ConfigurationException {
        private static final long serialVersionUID = 7860440395272751620L;

        public UnexpectedCDATA(String source, int line) {
            super(null, source, line);
        }
    }

    public static class IncorrectElement
    extends ConfigurationException {
        private static final long serialVersionUID = -2038447202094268310L;
        public String expected;
        public String found;

        public IncorrectElement(String expected, String found, String source, int line) {
            super(null, source, line);
            this.expected = expected;
            this.found = found;
        }
    }

    public static class UnexpectedElement
    extends ConfigurationException {
        private static final long serialVersionUID = 7361308977824266323L;
        public String found;

        public UnexpectedElement(String found, String source, int line) {
            super(null, source, line);
            this.found = found;
        }
    }

    public static class NotADirectory
    extends ConfigurationException {
        private static final long serialVersionUID = 3299637904535594472L;
        public String path;

        public NotADirectory(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class NotAFile
    extends ConfigurationException {
        private static final long serialVersionUID = -6104353214119208388L;
        public String path;

        public NotAFile(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class NotDirectory
    extends ConfigurationException {
        private static final long serialVersionUID = -348688657801200826L;
        public String path;

        public NotDirectory(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class IOError
    extends ConfigurationIOError {
        private static final long serialVersionUID = -8336197665007633417L;

        public IOError(String path) {
            super(path, null, null, -1);
        }
    }

    public static class ConfigurationIOError
    extends ConfigurationException {
        private static final long serialVersionUID = 4447234734754165407L;
        public String path;

        public ConfigurationIOError(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class TypeMismatch
    extends BadValue {
        private static final long serialVersionUID = 4440833762090886016L;
        public static final String BOOLEAN = "Boolean";
        public static final String INTEGER = "Integer";
        public static final String LONG = "Long";
        public String id;

        public TypeMismatch(String type, String value, String var, String source, int line) {
            super(value, var, source, line);
            this.id = type;
        }
    }

    public static class BadValue
    extends ConfigurationException {
        private static final long serialVersionUID = 6359203893459990766L;
        public String value;

        public BadValue(String value, String var, String source, int line) {
            super(var, source, line);
            this.value = value;
        }
    }

    public static class OtherThrowable
    extends ConfigurationException {
        private static final long serialVersionUID = -6369637486598549167L;
        public Throwable throwable;

        public OtherThrowable(Throwable t, String var, String source, int line) {
            super(var, source, line);
            this.throwable = t;
        }
    }

    public static class MissingRequirement
    extends ConfigurationException {
        private static final long serialVersionUID = -5579697104441150933L;
        public String required;

        public MissingRequirement(String required, String var, String source, int line) {
            super(null, source, line);
            this.required = required;
        }
    }

    public static class VariableMissingRequirement
    extends ConfigurationException {
        private static final long serialVersionUID = -9165402878493963589L;
        public String required;

        public VariableMissingRequirement(String required, String var, String source, int line) {
            super(var, source, line);
            this.required = required;
        }
    }

    public static class IncorrectArgumentCount
    extends ConfigurationException {
        private static final long serialVersionUID = 7926363942942750268L;
        public int expected;
        public int passed;

        public IncorrectArgumentCount(int expected, int passed, String var, String source, int line) {
            super(var, source, line);
            this.expected = expected;
            this.passed = passed;
        }
    }

    public static class Token
    extends ConfigurationException {
        private static final long serialVersionUID = 9018726365196176871L;
        public static final String MISSING_DELIMITER = "MissingDelimiter";
        public static final String MULTIPLE_VALUES = "MultipleValues";
        public static final String UNKNOWN_TOKEN = "UnknownToken";
        public static final String RECURSION_LIMIT = "RecursionLimit";
        public static final String INSUFFICIENT_ARGS = "InsufficientArgs";
        public String id;
        public String token;

        public Token(String id, String token, String var, String source, int line) {
            super(var, source, line);
            this.token = token;
            this.id = id;
        }
    }

    public static class AmbiguousParse
    extends ConfigurationException {
        private static final long serialVersionUID = -8207848984128407945L;
        public String defaultvar;

        public AmbiguousParse(String defaultvar, String var, String source, int line) {
            super(var, source, line);
            this.defaultvar = defaultvar;
        }
    }

    public static class InterspersedDefaults
    extends ConfigurationException {
        private static final long serialVersionUID = 4604939375999662998L;

        public InterspersedDefaults(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class UnexpectedDefaults
    extends ConfigurationException {
        private static final long serialVersionUID = 3830239641111918142L;

        public UnexpectedDefaults(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class IllegalMultipleSet
    extends ConfigurationException {
        private static final long serialVersionUID = 7419980739937494086L;

        public IllegalMultipleSet(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class UnknownVariable
    extends ConfigurationException {
        private static final long serialVersionUID = 8571582080586301558L;

        public UnknownVariable(String var, String source, int line) {
            super(var, source, line);
        }
    }
}

