/*
 * Decompiled with CFR 0.152.
 */
package flex.ant.config;

import flex.ant.config.ConfigVariable;
import flex.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FlexInteger;

public class ConfigInt
extends ConfigVariable {
    private int value;
    private boolean isSet;

    public ConfigInt(OptionSpec option) {
        super(option);
        this.isSet = false;
    }

    public ConfigInt(OptionSpec option, int value) {
        super(option);
        this.set(value);
    }

    public void set(int value) {
        this.value = value;
        this.isSet = true;
    }

    public void set(String value) {
        int intVal;
        try {
            intVal = new FlexInteger(value).intValue();
        }
        catch (NumberFormatException e) {
            throw new BuildException("Not an integer: " + value);
        }
        this.value = intVal;
        this.isSet = true;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void addToCommandline(Commandline cmdl) {
        if (this.isSet) {
            cmdl.createArgument().setValue("-" + this.spec.getFullName());
            cmdl.createArgument().setValue(String.valueOf(this.value));
        }
    }
}

