/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.Info;
import flex2.compiler.util.MultiName;

public class InterfaceInfo
extends Info {
    private String interfaceName;
    private InterfaceInfo baseInterfaceInfo;
    private String baseInterfaceName;
    private MultiName baseInterfaceMultiName;

    public InterfaceInfo(String interfaceName) {
        this.interfaceName = interfaceName;
        int lastIndex = interfaceName.lastIndexOf(":");
        if (lastIndex > 0) {
            this.addImport(interfaceName.substring(0, lastIndex));
        }
    }

    public boolean definesFunction(String functionName, boolean inherited) {
        boolean result = super.definesFunction(functionName);
        if (!result && inherited && this.baseInterfaceInfo != null) {
            result = this.baseInterfaceInfo.definesFunction(functionName, inherited);
        }
        return result;
    }

    public boolean definesGetter(String getterName) {
        boolean result = super.definesGetter(getterName);
        if (!result && this.baseInterfaceInfo != null) {
            result = this.baseInterfaceInfo.definesGetter(getterName);
        }
        return result;
    }

    public boolean definesSetter(String setterName, boolean inherited) {
        boolean result = super.definesSetter(setterName);
        if (!result && inherited && this.baseInterfaceInfo != null) {
            result = this.baseInterfaceInfo.definesSetter(setterName, inherited);
        }
        return result;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getBaseInterfaceName() {
        return this.baseInterfaceName;
    }

    public MultiName getBaseInterfaceMultiName() {
        if (this.baseInterfaceMultiName == null) {
            this.baseInterfaceMultiName = this.getMultiName(this.baseInterfaceName);
        }
        return this.baseInterfaceMultiName;
    }

    public boolean extendsInterface(String namespace, String interfaceName) {
        boolean result = false;
        if (this.baseInterfaceInfo != null && !(result = this.baseInterfaceInfo.getInterfaceName().equals(namespace + ":" + interfaceName))) {
            result = this.baseInterfaceInfo.extendsInterface(namespace, interfaceName);
        }
        return result;
    }

    public boolean implementsInterface(String namespace, String interfaceName) {
        boolean result = super.implementsInterface(namespace, interfaceName);
        if (!result && this.baseInterfaceInfo != null) {
            result = this.baseInterfaceInfo.implementsInterface(namespace, interfaceName);
        }
        return result;
    }

    public void setBaseInterfaceInfo(InterfaceInfo baseInterfaceInfo) {
        assert (baseInterfaceInfo != null);
        this.baseInterfaceInfo = baseInterfaceInfo;
    }

    public void setBaseInterfaceName(String baseInterfaceName) {
        this.baseInterfaceName = baseInterfaceName;
    }

    public String toString() {
        return "InterfaceInfo: " + this.interfaceName;
    }
}

