/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.sax;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.DefinitionNode;
import com.adobe.internal.fxg.dom.DelegateNode;
import com.adobe.internal.fxg.dom.GraphicNode;
import com.adobe.internal.fxg.dom.PreserveWhiteSpaceNode;
import com.adobe.internal.fxg.sax.FXGVersionHandler;
import com.adobe.internal.fxg.sax.FXGVersionHandlerRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXGSAXScanner
extends DefaultHandler {
    public static final String APACHE_FLEX_NAMESPACE = "http://ns.apache.org/flex/2012";
    private static boolean REJECT_MAJOR_VERSION_MISMATCH = false;
    private static final String FXG_GROUP_DEFINITION_ELEMENT = "[GroupDefinition]";
    private String profile;
    private GraphicNode root;
    private Stack<FXGNode> stack;
    private int skippedElementCount;
    private boolean seenPrivateElement = false;
    private boolean inMaskAfterPrivateElement = false;
    private Locator locator;
    private int startLine = 0;
    private int startColumn = 0;
    private String documentName = null;
    private String unknownElement = null;
    private FXGVersionHandler versionHandler = null;

    public FXGSAXScanner(String profile) {
        this.profile = profile;
        this.versionHandler = profile.equals("mobile") ? FXGVersionHandlerRegistry.getDefaultMobileHandler() : FXGVersionHandlerRegistry.getDefaultHandler();
        if (this.versionHandler == null) {
            throw new FXGException("FXGVersionHandlerNotRegistered", FXGVersionHandlerRegistry.defaultVersion.asDouble());
        }
    }

    public FXGNode getRootNode() {
        return this.root;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        FXGNode node;
        if (this.isSkippedElement(uri, localName, true)) {
            ++this.skippedElementCount;
        }
        if (this.inSkippedElement()) {
            return;
        }
        if (this.unknownElement != null) {
            return;
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
        FXGNode parent = null;
        if (this.stack.size() > 0) {
            parent = this.stack.peek();
        }
        if (this.isFXGNamespace(uri) && parent instanceof DefinitionNode && "Group".equals(localName)) {
            localName = FXG_GROUP_DEFINITION_ELEMENT;
        }
        if ((node = this.createNode(uri, localName)) == null) {
            if (this.root != null) {
                if (this.root.isVersionGreaterThanCompiler()) {
                    FXGLog.getLogger().log(30000, "UnknownElement", null, this.documentName, this.startLine, this.startColumn, localName, this.versionHandler.getVersion().asString());
                    this.unknownElement = localName;
                    return;
                }
                throw new FXGException(this.startLine, this.startColumn, "UnknownElementInVersion", this.root.getFileVersion().asString(), localName);
            }
            throw new FXGException(this.startLine, this.startColumn, "InvalidFXGRootNode", new Object[0]);
        }
        if (this.root != null) {
            node.setDocumentNode(this.root);
        }
        if (node instanceof DelegateNode) {
            DelegateNode propertyNode = (DelegateNode)node;
            propertyNode.setName(localName);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeURI = attributes.getURI(i);
            if (attributeURI != null && attributeURI != "" && !this.isFXGNamespace(attributeURI) && !this.isApacheFlexNamespace(attributeURI)) continue;
            String attributeName = attributes.getLocalName(i);
            String attributeValue = attributes.getValue(i);
            node.setAttribute(attributeName, attributeValue);
        }
        if (parent != null) {
            if (node instanceof DelegateNode) {
                DelegateNode propertyNode = (DelegateNode)node;
                propertyNode.setDelegate(parent);
            } else {
                parent.addChild(node);
            }
        } else if (node instanceof GraphicNode) {
            this.root = (GraphicNode)node;
            node.setDocumentNode(this.root);
            if (this.root.getVersion() == null) {
                throw new FXGException(this.startLine, this.startColumn, "MissingVersionAttribute", new Object[0]);
            }
            if (!this.isMajorVersionMatch(this.root)) {
                FXGVersionHandler newVHandler = FXGVersionHandlerRegistry.getVersionHandler(this.root.getVersion());
                if (newVHandler == null) {
                    if (REJECT_MAJOR_VERSION_MISMATCH) {
                        throw new FXGException(this.startLine, this.startColumn, "InvalidFXGVersion", this.root.getVersion().asString());
                    }
                    FXGLog.getLogger().log(30000, "MajorVersionMismatch", null, this.getDocumentName(), this.startLine, this.startColumn);
                    this.versionHandler = FXGVersionHandlerRegistry.getLatestVersionHandler();
                    if (this.versionHandler == null) {
                        throw new FXGException("FXGVersionHandlerNotRegistered", this.root.getVersion().asString());
                    }
                } else {
                    this.versionHandler = newVHandler;
                }
            }
            this.root.setDocumentName(this.documentName);
            this.root.setVersionGreaterThanCompiler(this.root.getVersion().greaterThan(this.versionHandler.getVersion()));
            this.root.setReservedNodes(this.versionHandler.getElementNodes(uri));
            this.root.setCompilerVersion(this.versionHandler.getVersion());
            this.root.setProfile(this.profile);
        } else {
            throw new FXGException(this.startLine, this.startColumn, "InvalidFXGRootNode", new Object[0]);
        }
        this.stack.push(node);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stack != null && this.stack.size() > 0 && !this.inSkippedElement() && this.unknownElement == null) {
            FXGNode node = this.stack.peek();
            String content = new String(ch, start, length);
            if (!(node instanceof PreserveWhiteSpaceNode)) {
                content = content.trim();
            }
            if (content.length() > 0) {
                CDATANode cdata = new CDATANode();
                cdata.content = content;
                this.assignNodeLocation(cdata);
                node.addChild(cdata);
            }
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isSkippedElement(uri, localName, false)) {
            --this.skippedElementCount;
        } else if (this.unknownElement != null) {
            if (this.unknownElement.equals(localName)) {
                this.unknownElement = null;
            }
        } else if (!this.inSkippedElement()) {
            this.stack.pop();
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    protected boolean isFXGNamespace(String uri) {
        return "http://ns.adobe.com/fxg/2008".equals(uri);
    }

    protected boolean isApacheFlexNamespace(String uri) {
        return APACHE_FLEX_NAMESPACE.equals(uri);
    }

    protected void skipElement(double version, String uri, String localName) {
        if (localName == null) {
            return;
        }
        FXGVersionHandler versionHandler = FXGVersionHandlerRegistry.getVersionHandler(version);
        if (versionHandler == null) {
            throw new FXGException("FXGVersionHandlerNotRegistered", version);
        }
        HashSet<String> skippedElements = new HashSet<String>(1);
        skippedElements.add(localName);
        versionHandler.registerSkippedElements(uri, skippedElements);
    }

    protected boolean isSkippedElement(String uri, String localName, boolean startElement) {
        Set<String> skippedElements = this.versionHandler.getSkippedElements(uri);
        if (skippedElements != null) {
            if (skippedElements.contains("Private")) {
                this.validatePrivateElement(localName, startElement);
            }
            if (skippedElements.contains(localName)) {
                return true;
            }
        }
        return false;
    }

    protected FXGNode createNode(String uri, String localName) {
        FXGNode node = null;
        try {
            Map<String, Class<? extends FXGNode>> elementNodes = this.getElementNodes(uri);
            if (elementNodes != null) {
                Class<? extends FXGNode> nodeClass = elementNodes.get(localName);
                if (nodeClass != null) {
                    node = nodeClass.newInstance();
                } else if (this.root != null) {
                    node = this.root.getDefinitionInstance(localName);
                }
            }
        }
        catch (Throwable t) {
            throw new FXGException(this.startLine, this.startColumn, "ErrorScanningFXG", t, new Object[0]);
        }
        if (node != null) {
            this.assignNodeLocation(node);
        }
        return node;
    }

    private boolean inSkippedElement() {
        return this.skippedElementCount > 0;
    }

    protected void registerElementNode(double version, String uri, String localName, Class<? extends FXGNode> nodeClass) {
        FXGVersionHandler vHandler = FXGVersionHandlerRegistry.getVersionHandler(version);
        if (vHandler == null) {
            throw new FXGException("FXGVersionHandlerNotRegistered", version);
        }
        HashMap<String, Class<? extends FXGNode>> elementNodes = new HashMap<String, Class<? extends FXGNode>>(4);
        elementNodes.put(localName, nodeClass);
        vHandler.registerElementNodes(uri, elementNodes);
    }

    private void assignNodeLocation(FXGNode node) {
        if (node != null) {
            node.setStartLine(this.startLine);
            node.setStartColumn(this.startColumn);
            node.setEndLine(this.locator.getLineNumber());
            node.setEndColumn(this.locator.getColumnNumber());
        }
    }

    private Map<String, Class<? extends FXGNode>> getElementNodes(String uri) {
        return this.versionHandler.getElementNodes(uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validatePrivateElement(String localName, boolean startElement) {
        if (!startElement) {
            if (!this.inMaskAfterPrivateElement || !localName.equals("mask")) return;
            this.inMaskAfterPrivateElement = false;
            return;
        }
        if (localName.equals("Private")) {
            if (this.seenPrivateElement) {
                throw new FXGException("PrivateElementMultipleOccurrences", this.startLine, this.startColumn);
            }
            if (this.inSkippedElement() || this.stack.size() != 1) throw new FXGException("PrivateElementNotChildOfGraphic", this.startLine, this.startColumn);
            this.seenPrivateElement = true;
            return;
        } else {
            if (!this.seenPrivateElement || this.inSkippedElement()) return;
            if (!this.inMaskAfterPrivateElement && localName.equals("mask")) {
                this.inMaskAfterPrivateElement = true;
                return;
            } else {
                if (this.inMaskAfterPrivateElement) return;
                throw new FXGException("PrivateElementNotLast", this.startLine, this.startColumn);
            }
        }
    }

    private boolean isMajorVersionMatch(GraphicNode root) {
        long compilerMajorVersion;
        long majorVersion = root.getVersion().getMajorVersion();
        return majorVersion == (compilerMajorVersion = this.versionHandler.getVersion().getMajorVersion());
    }
}

