/*
 *
 *  THIS FILE IS AUTO-GENERATED. DO NOT EDIT THIS FILE.
 *  Use the script 'errorGen' to generate this file.
 */

/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *

/* 
 *  ErrorConstants.java defines the ID's of error messages output
 *  by the compiler.  Localized tables of strings exist for
 *  each language supported.  These ids are used to reference 
 *  the error message without regard to language 
 */

package macromedia.asc.embedding;
public interface ErrorConstants
{
   static final int kNumLanguages = 19;
   static final int kNumErrorConstants = 178;


      public static final int kError_OverrideOfFuncNotMarkedForOverride = 1024;
      public static final int kError_FinalMethodRedefinition = 1025;
      public static final int kError_ConstructorsMustBeInstanceMethods = 1026;
      public static final int kError_FuncIsStaticAndOverride = 1027;
      public static final int kError_FuncIsStaticAndVirtual = 1028;
      public static final int kError_FuncIsVirtualAndFinal = 1029;
      public static final int kError_RestParameterNotNamed = 1030;
      public static final int kError_VirtualVars = 1033;
      public static final int kError_NativeVars = 1034;
      public static final int kError_VarIsFinalAndVirtual = 1035;
      public static final int kError_NestedPackage = 1037;
      public static final int kError_BreakHasNoTarget = 1038;
      public static final int kError_ContinueHasNoTarget = 1039;
      public static final int kError_DuplicateLabel = 1040;
      public static final int kError_AttributesAreNotCallable = 1041;
      public static final int kError_ThisUsedInStaticFunction = 1042;
      public static final int kError_UndefinedNamespace = 1043;
      public static final int kError_UnknownInterfaceMethod = 1044;
      public static final int kError_UnknownInterface = 1045;
      public static final int kError_UnknownType = 1046;
      public static final int kError_NonConstantParamInitializer = 1047;
      public static final int kError_MethodIsNotAConstructor = 1048;
      public static final int kError_AssignmentToConstVar = 1049;
      public static final int kError_AssignmentToNonRefVar = 1050;
      public static final int kError_ReturnTypeMustBeUndefined = 1051;
      public static final int kError_ConstInitializerNotConst = 1052;
      public static final int kError_AccessorTypesMustMatch = 1053;
      public static final int kError_BadSetterReturnType = 1054;
      public static final int kError_PropertyIsWriteOnly = 1058;
      public static final int kError_PropertyIsReadOnly = 1059;
      public static final int kError_Strict_UndefinedMethod = 1061;
      public static final int kError_UnableToOpenFile = 1063;
      public static final int kError_InvalidMetaData = 1064;
      public static final int kError_MetaDataAttributesHasMoreThanOneElement = 1065;
      public static final int kError_ImplicitCoercisionOfUnrelatedType = 1067;
      public static final int kError_Parser_UnableToOpenFile = 1068;
      public static final int kError_Parser_DefinitionOrDirectiveExpected = 1069;
      public static final int kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes = 1071;
      public static final int kError_Parser_ExpectedXMLBeforeNameSpace = 1072;
      public static final int kError_Parser_ExpectingCatchOrFinally = 1073;
      public static final int kError_Parser_EachWithoutIn = 1075;
      public static final int kError_Parser_ExpectedLeftParen = 1076;
      public static final int kError_Parser_ExpectedCaseLabel = 1077;
      public static final int kError_Parser_LabelIsNotIdentifier = 1078;
      public static final int kError_Parser_WrongNumberOfSuperArgs = 1079;
      public static final int kError_Parser_ExpectingIncrOrDecrOperator = 1080;
      public static final int kError_Parser_ExpectingASingleExpressionWithinParenthesis = 1082;
      public static final int kError_Parser_ExpectedPrimaryExprBefore = 1083;
      public static final int kError_Parser_ExpectedToken = 1084;
      public static final int kError_Parser_ExpectedSemicolon = 1086;
      public static final int kError_Parser_ExtraCharsAfterEndOfProgram = 1087;
      public static final int kError_Lexical_General = 1093;
      public static final int kError_Lexical_LineTerminatorInSingleQuotedStringLiteral = 1094;
      public static final int kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral = 1095;
      public static final int kError_Lexical_EndOfStreamInStringLiteral = 1097;
      public static final int kError_Lexical_SyntaxError = 1099;
      public static final int kError_Lexical_NoMatchingTag = 1100;
      public static final int kError_CannotDeleteSuperDecendants = 1102;
      public static final int kError_DuplicateNamespaceDefinition = 1103;
      public static final int kError_ErrorNodeError = 1104;
      public static final int kError_AssignmentTargetNotRefVal = 1105;
      public static final int kError_IncrementOperatorNotAReference = 1106;
      public static final int kError_InvalidIncrementOperand = 1107;
      public static final int kError_InvalidDecrementOperand = 1108;
      public static final int kError_ExpectingExpression = 1109;
      public static final int kError_MissingXMLTagName = 1110;
      public static final int kError_InvalidAbcFile = 1111;
      public static final int kError_Parser_FileIncludesItself = 1112;
      public static final int kError_CircularReference = 1113;
      public static final int kError_InvalidPublic = 1114;
      public static final int kError_InvalidInternal = 1115;
      public static final int kError_InvalidNamespace = 1116;
      public static final int kError_ImplicitCoercionToSubtype = 1118;
      public static final int kError_UndefinedProperty = 1119;
      public static final int kError_UnfoundProperty = 1120;
      public static final int kError_GetterCannotHaveParameters = 1121;
      public static final int kError_SetterMustHaveOneParameter = 1122;
      public static final int kError_SetterCannotHaveOptional = 1123;
      public static final int kError_BadGetterReturnType = 1124;
      public static final int kError_InterfaceMethodWithBody = 1125;
      public static final int kError_FunctionWithoutBody = 1126;
      public static final int kError_DuplicateAttribute = 1127;
      public static final int kError_DuplicateInterfaceDefinition = 1129;
      public static final int kError_CtorWithReturnType = 1130;
      public static final int kError_InvalidClassNesting = 1131;
      public static final int kError_InvalidFinalUsage = 1132;
      public static final int kError_InvalidNative = 1133;
      public static final int kError_InvalidDynamic = 1134;
      public static final int kError_Parser_keywordInsteadOfTypeExpr = 1135;
      public static final int kError_WrongNumberOfArguments = 1136;
      public static final int kError_TooManyArguments = 1137;
      public static final int kError_BadRequiredParameter = 1138;
      public static final int kError_VarInInterface = 1139;
      public static final int kError_InvalidRestDecl = 1140;
      public static final int kError_CannotExtendInterface = 1141;
      public static final int kError_CannotExtendClass = 1142;
      public static final int kError_InvalidOverrideUsage = 1143;
      public static final int kError_IncompatibleInterfaceMethod = 1144;
      public static final int kError_NativeMethodWithBody = 1145;
      public static final int kError_ConstructorCannnotBeGetterSetter = 1146;
      public static final int kError_MissingFilespec = 1147;
      public static final int kError_CannotReturnFromStaticInit = 1149;
      public static final int kError_InvalidProtected = 1150;
      public static final int kError_ConflictingNameInNamespace = 1151;
      public static final int kError_ConflictingInheritedNameInNamespace = 1152;
      public static final int kError_ConstructorMustBePublic = 1153;
      public static final int kError_ConflictingAccessSpecifiers = 1154;
      public static final int kError_InvalidNestedAccessor = 1155;
      public static final int kError_CannotInstantiateInterface = 1156;
      public static final int kError_BadAccessInterfaceMember = 1157;
      public static final int kError_Parser_ExpectedLeftBrace = 1158;
      public static final int kError_CannotReturnFromPackageInit = 1159;
      public static final int kError_InvalidInterfaceNative = 1160;
      public static final int kError_MultipleNamespaceAttributes = 1162;
      public static final int kError_ConflictingInheritedNameInInterface = 1163;
      public static final int kError_InvalidInterfaceAttribute = 1165;
      public static final int kError_NamespaceInInterface = 1166;
      public static final int kError_DuplicateImplements = 1167;
      public static final int kError_AssignmentToDefinedFunction = 1168;
      public static final int kError_InterfaceNamespaceAttribute = 1169;
      public static final int kError_MustReturnValue = 1170;
      public static final int kError_InvalidNamespaceInitializer = 1171;
      public static final int kError_DefinitionNotFound = 1172;
      public static final int kError_InvalidLabel = 1173;
      public static final int kError_IncompatableValueComparison = 1176;
      public static final int kError_CannotReturnFromGlobalInit = 1177;
      public static final int kError_InaccessiblePropertyReference = 1178;
      public static final int kError_ColonObjectAnnoOutOfService = 1179;
      public static final int kError_Strict_PlainUndefinedMethod = 1180;
      public static final int kError_ForwardReferenceToBaseClass = 1181;
      public static final int kError_IllegalPackageReference = 1182;
      public static final int kError_IncompatibleDefaultValue = 1184;
      public static final int kError_MultipleSwitchDefaults = 1185;
      public static final int kError_AssignmentToDefinedClass = 1188;
      public static final int kError_Strict_AttemptToDeleteFixedProperty = 1189;
      public static final int kError_InvalidBaseTypeExpression = 1190;
      public static final int kError_InvalidInterfaceTypeExpression = 1191;
      public static final int kError_StaticModifiedNamespace = 1192;
      public static final int kError_InvalidInterfaceNesting = 1193;
      public static final int kError_PrototypeIsAnInvalidAttribute = 1194;
      public static final int kError_InaccessibleMethodReference = 1195;
      public static final int kError_Parser_ThrowWithoutExpression = 1196;
      public static final int kError_Authoring_SymbolClassInheritance = 1197;
      public static final int kError_AttributesOnPackage = 1198;
      public static final int kError_InternalError = 1199;
      public static final int kError_ParserInvalidForInInitializer = 1200;
      public static final int kError_IllegalSuperStatement = 1201;
      public static final int kError_UnfoundPackageProperty = 1202;
      public static final int kError_NoDefaultBaseclassCtor = 1203;
      public static final int kError_BlockCommentNotTerminated = 1204;
      public static final int kError_ParserExpectingLeftBraceOrStringLiteral = 1205;
      public static final int kError_InvalidES4SuperStatement = 1206;
      public static final int kError_ThisUsedInInitializer = 1207;
      public static final int kError_NonConstantConfigInit = 1208;
      public static final int kError_NonConstConfigVar = 1209;
      public static final int kError_InvalidConfigLocation = 1210;
      public static final int kError_ShadowedConfigNamespace = 1211;
      public static final int kError_InvalidPrecision = 1212;
      public static final int kError_WrongVersion = 1214;
      public static final int kError_LossyConversion = 1215;
      public static final int kError_AmbiguousReference = 1000;
      public static final int kError_NamespaceAccessSpecifiers = 1003;
      public static final int kError_Unknown_Namespace = 1004;
      public static final int kError_InvalidSuperExpression = 1006;
      public static final int kError_InvalidSuperStatement = 1007;
      public static final int kError_InvalidAttribute = 1008;
      public static final int kError_InvalidOverride = 1010;
      public static final int kError_InvalidVirtual = 1011;
      public static final int kError_InvalidStatic = 1012;
      public static final int kError_InvalidPrivate = 1013;
      public static final int kError_Unsupported_Intrinsic = 1014;
      public static final int kError_BaseClassIsFinal = 1016;
      public static final int kError_UnknownBaseClass = 1017;
      public static final int kError_DuplicateClassDefinition = 1018;
      public static final int kError_OverrideNotFound = 1020;
      public static final int kError_DuplicateFunction = 1021;
      public static final int kError_OverrideFinalAccessor = 1022;
      public static final int kError_IncompatibleOverride = 1023;
   
   public class AscError
   {
      public int code;  // enum used to identify or lookup this message/problem
      public String errorMsg; // a particular error message    '
      public AscError(int c, String s) { code = c; errorMsg = s; }
   } ;
   
   public static final AscError[] errorConstantsEN = { 
           new AscError(kError_AmbiguousReference, "Ambiguous reference to %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Access specifiers are not allowed with namespace attributes." ),
           new AscError(kError_Unknown_Namespace, "Namespace was not found or is not a compile-time constant." ),
           new AscError(kError_InvalidSuperExpression, "A super expression can be used only inside class instance methods." ),
           new AscError(kError_InvalidSuperStatement, "A super statement can be used only inside class instance constructors." ),
           new AscError(kError_InvalidAttribute, "Attribute is invalid." ),
           new AscError(kError_InvalidOverride, "The override attribute may be used only on class property definitions." ),
           new AscError(kError_InvalidVirtual, "The virtual attribute may be used only on class property definitions." ),
           new AscError(kError_InvalidStatic, "The static attribute may be used only on definitions inside a class." ),
           new AscError(kError_InvalidPrivate, "The private attribute may be used only on class property definitions." ),
           new AscError(kError_Unsupported_Intrinsic, "The intrinsic attribute is no longer supported." ),
           new AscError(kError_BaseClassIsFinal, "Base class is final." ),
           new AscError(kError_UnknownBaseClass, "The definition of base class %s was not found." ),
           new AscError(kError_DuplicateClassDefinition, "Duplicate class definition: %s." ),
           new AscError(kError_OverrideNotFound, "Method marked override must override another method." ),
           new AscError(kError_DuplicateFunction, "Duplicate function definition." ),
           new AscError(kError_OverrideFinalAccessor, "Cannot override a final accessor." ),
           new AscError(kError_IncompatibleOverride, "Incompatible override." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Overriding a function that is not marked for override." ),
           new AscError(kError_FinalMethodRedefinition, "Cannot redefine a final method." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Constructor functions must be instance methods." ),
           new AscError(kError_FuncIsStaticAndOverride, "Functions cannot be both static and override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Functions cannot be both static and virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Functions cannot be both final and virtual." ),
           new AscError(kError_RestParameterNotNamed, "Must specify name of variable arguments array." ),
           new AscError(kError_VirtualVars, "Virtual variables are not supported." ),
           new AscError(kError_NativeVars, "Variables cannot be native." ),
           new AscError(kError_VarIsFinalAndVirtual, "Variables cannot be both final and virtual." ),
           new AscError(kError_NestedPackage, "Packages cannot be nested." ),
           new AscError(kError_BreakHasNoTarget, "Target of break statement was not found." ),
           new AscError(kError_ContinueHasNoTarget, "Target of continue statement was not found." ),
           new AscError(kError_DuplicateLabel, "Duplicate label definition." ),
           new AscError(kError_AttributesAreNotCallable, "Attributes are not callable." ),
           new AscError(kError_ThisUsedInStaticFunction, "The this keyword can not be used in static methods. It can only be used in instance methods, function closures, and global code." ),
           new AscError(kError_UndefinedNamespace, "Undefined namespace." ),
           new AscError(kError_UnknownInterfaceMethod, "Interface method %s in namespace %s not implemented by class %s." ),
           new AscError(kError_UnknownInterface, "Interface %s was not found." ),
           new AscError(kError_UnknownType, "Type was not found or was not a compile-time constant: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parameter initializer unknown or is not a compile-time constant." ),
           new AscError(kError_MethodIsNotAConstructor, "Method cannot be used as a constructor." ),
           new AscError(kError_AssignmentToConstVar, "Illegal assignment to a variable specified as constant." ),
           new AscError(kError_AssignmentToNonRefVar, "Cannot assign to a non-reference value." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Return value must be undefined." ),
           new AscError(kError_ConstInitializerNotConst, "Constant initializer unknown or is not a compile-time constant." ),
           new AscError(kError_AccessorTypesMustMatch, "Accessor types must match." ),
           new AscError(kError_BadSetterReturnType, "Return type of a setter definition must be unspecified or void." ),
           new AscError(kError_PropertyIsWriteOnly, "Property is write-only." ),
           new AscError(kError_PropertyIsReadOnly, "Property is read-only." ),
           new AscError(kError_Strict_UndefinedMethod, "Call to a possibly undefined method %s through a reference with static type %s." ),
           new AscError(kError_UnableToOpenFile, "Unable to open file: %s." ),
           new AscError(kError_InvalidMetaData, "Invalid metadata." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Metadata attributes cannot have more than one element." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Implicit coercion of a value of type %s to an unrelated type %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Unable to open included file: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntax error: definition or directive expected." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntax error: expected a definition keyword (such as function) after attribute %s, not %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntax error: expecting xml before namespace." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntax error: expecting a catch or a finally clause." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntax error: the 'each' keyword is not allowed without an 'in' operator." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntax error: expecting left parenthesis before the identifier." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Expecting CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Label must be a simple identifier." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "A super expression must have one operand." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Expecting increment or decrement operator." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Expecting a single expression within parentheses." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntax error: %s is unexpected." ),
           new AscError(kError_Parser_ExpectedToken, "Syntax error: expecting %s before %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntax error: expecting semicolon before %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntax error: extra characters found after end of program." ),
           new AscError(kError_Lexical_General, "Syntax error." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntax error: A string literal must be terminated before the line break." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntax error: A string literal must be terminated before the line break." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntax error: input ended before reaching the closing quotation mark for a string literal." ),
           new AscError(kError_Lexical_SyntaxError, "Syntax error." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntax error: XML does not have matching begin and end tags." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Cannot delete super descendants." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Duplicate namespace definition." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Target of assignment must be a reference value." ),
           new AscError(kError_IncrementOperatorNotAReference, "Operand of increment must be a reference." ),
           new AscError(kError_InvalidIncrementOperand, "Increment operand is invalid." ),
           new AscError(kError_InvalidDecrementOperand, "Decrement operand is invalid." ),
           new AscError(kError_ExpectingExpression, "Expecting an expression." ),
           new AscError(kError_MissingXMLTagName, "Missing XML tag name." ),
           new AscError(kError_InvalidAbcFile, "The file %s is not a valid ABC file." ),
           new AscError(kError_Parser_FileIncludesItself, "Possible infinite recursion due to this file include: %s." ),
           new AscError(kError_CircularReference, "Circular type reference was detected in %s." ),
           new AscError(kError_InvalidPublic, "The public attribute can only be used inside a package." ),
           new AscError(kError_InvalidInternal, "The internal attribute can only be used inside a package." ),
           new AscError(kError_InvalidNamespace, "A user-defined namespace attribute can only be used at the top level of a class definition." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Implicit coercion of a value with static type %s to a possibly unrelated type %s." ),
           new AscError(kError_UndefinedProperty, "Access of possibly undefined property %s through a reference with static type %s." ),
           new AscError(kError_UnfoundProperty, "Access of undefined property %s." ),
           new AscError(kError_GetterCannotHaveParameters, "A getter definition must have no parameters." ),
           new AscError(kError_SetterMustHaveOneParameter, "A setter definition must have exactly one parameter." ),
           new AscError(kError_SetterCannotHaveOptional, "A setter definition cannot have optional parameters." ),
           new AscError(kError_BadGetterReturnType, "Return type of a getter definition must not be void." ),
           new AscError(kError_InterfaceMethodWithBody, "Methods defined in an interface must not have a body." ),
           new AscError(kError_FunctionWithoutBody, "Function does not have a body." ),
           new AscError(kError_DuplicateAttribute, "Attribute %s was specified multiple times." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Duplicate interface definition: %s." ),
           new AscError(kError_CtorWithReturnType, "A constructor cannot specify a return type." ),
           new AscError(kError_InvalidClassNesting, "Classes must not be nested." ),
           new AscError(kError_InvalidFinalUsage, "The attribute final can only be used on a method defined in a class." ),
           new AscError(kError_InvalidNative, "The native attribute can only be used with function definitions." ),
           new AscError(kError_InvalidDynamic, "The dynamic attribute can only be used with class definitions." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntax error: %s is not a valid type." ),
           new AscError(kError_WrongNumberOfArguments, "Incorrect number of arguments.  Expected %s." ),
           new AscError(kError_TooManyArguments, "Incorrect number of arguments.  Expected no more than %s." ),
           new AscError(kError_BadRequiredParameter, "Required parameters are not permitted after optional parameters." ),
           new AscError(kError_VarInInterface, "Variable declarations are not permitted in interfaces." ),
           new AscError(kError_InvalidRestDecl, "Parameters specified after the ...rest parameter definition keyword can only be an Array data type." ),
           new AscError(kError_CannotExtendInterface, "A class can only extend another class, not an interface." ),
           new AscError(kError_CannotExtendClass, "An interface can only extend other interfaces, but %s is a class." ),
           new AscError(kError_InvalidOverrideUsage, "The override attribute can only be used on a method defined in a class." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Interface method %s in namespace %s is implemented with an incompatible signature in class %s." ),
           new AscError(kError_NativeMethodWithBody, "Native methods cannot have a body." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "A constructor cannot be a getter or setter method." ),
           new AscError(kError_MissingFilespec, "An AS source file was not specified." ),
           new AscError(kError_CannotReturnFromStaticInit, "The return statement cannot be used in static initialization code." ),
           new AscError(kError_InvalidProtected, "The protected attribute can only be used on class property definitions." ),
           new AscError(kError_ConflictingNameInNamespace, "A conflict exists with definition %s in namespace %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "A conflict exists with inherited definition %s in namespace %s." ),
           new AscError(kError_ConstructorMustBePublic, "A constructor can only be declared public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Only one of public, private, protected, or internal can be specified on a definition." ),
           new AscError(kError_InvalidNestedAccessor, "Accessors cannot be nested inside other functions." ),
           new AscError(kError_CannotInstantiateInterface, "Interfaces cannot be instantiated with the new operator." ),
           new AscError(kError_BadAccessInterfaceMember, "Interface members cannot be declared public, private, protected, or internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntax error: missing left brace ({) before the function body." ),
           new AscError(kError_CannotReturnFromPackageInit, "The return statement cannot be used in package initialization code." ),
           new AscError(kError_InvalidInterfaceNative, "The native attribute cannot be used in interface definitions." ),
           new AscError(kError_MultipleNamespaceAttributes, "Only one namespace attribute can be used per definition." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Method %s conflicts with definition inherited from interface %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Interface attribute %s is invalid." ),
           new AscError(kError_NamespaceInInterface, "Namespace declarations are not permitted in interfaces." ),
           new AscError(kError_DuplicateImplements, "Class %s implements interface %s multiple times." ),
           new AscError(kError_AssignmentToDefinedFunction, "Illegal assignment to function %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Namespace attributes are not permitted on interface methods." ),
           new AscError(kError_MustReturnValue, "Function does not return a value." ),
           new AscError(kError_InvalidNamespaceInitializer, "A namespace initializer must be either a literal string or another namespace." ),
           new AscError(kError_DefinitionNotFound, "Definition %s could not be found." ),
           new AscError(kError_InvalidLabel, "Label definition is invalid." ),
           new AscError(kError_IncompatableValueComparison, "Comparison between a value with static type %s and a possibly unrelated type %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "The return statement cannot be used in global initialization code." ),
           new AscError(kError_InaccessiblePropertyReference, "Attempted access of inaccessible property %s through a reference with static type %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object is temporarily out of service. Use :* instead." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Call to a possibly undefined method %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Forward reference to base class %s." ),
           new AscError(kError_IllegalPackageReference, "Package cannot be used as a value: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Incompatible default value of type %s where %s is expected." ),
           new AscError(kError_MultipleSwitchDefaults, "The switch has more than one default, but only one default is allowed." ),
           new AscError(kError_AssignmentToDefinedClass, "Illegal assignment to class %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Attempt to delete the fixed property %s.  Only dynamically defined properties can be deleted." ),
           new AscError(kError_InvalidBaseTypeExpression, "Base class was not found or is not a compile-time constant." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Interface was not found or is not a compile-time constant." ),
           new AscError(kError_StaticModifiedNamespace, "The static attribute is not allowed on namespace definitions." ),
           new AscError(kError_InvalidInterfaceNesting, "Interface definitions must not be nested within class or other interface definitions." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "The prototype attribute is invalid." ),
           new AscError(kError_InaccessibleMethodReference, "Attempted access of inaccessible method %s through a reference with static type %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntax error: expecting an expression after the throw." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "The class %s cannot extend %s since both are associated with library symbols or the main timeline." ),
           new AscError(kError_AttributesOnPackage, "Attributes are not allowed on package definition." ),
           new AscError(kError_InternalError, "Internal error: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntax error: invalid for-in initializer, only 1 expression expected." ),
           new AscError(kError_IllegalSuperStatement, "A super statement cannot occur after a this, super, return, or throw statement." ),
           new AscError(kError_UnfoundPackageProperty, "Access of undefined property %s in package %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "No default constructor found in base class %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* found without matching */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntax Error: expecting a left brace({)or string literal(\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "A super statement can be used only as the last item in a constructor initializer list." ),
           new AscError(kError_ThisUsedInInitializer, "The this keyword can not be used in property initializers." ),
           new AscError(kError_NonConstantConfigInit, "The initializer for a configuration value must be a compile time constant." ),
           new AscError(kError_NonConstConfigVar, "A configuration variable may only be declared const." ),
           new AscError(kError_InvalidConfigLocation, "A configuration value must be declared at the top level of a program or package." ),
           new AscError(kError_ShadowedConfigNamespace, "Namespace %s conflicts with a configuration namespace." ),
           new AscError(kError_InvalidPrecision, "Precision must be an integer between 1 and 34." ),
           new AscError(kError_WrongVersion, "Incompatible Version: can not reference definition %s introduced in version %s from code with version %s." ),
           new AscError(kError_LossyConversion, "Invalid initialization: conversion to type %s loses data." ),
   };

   public static final AscError[] errorConstantsCN = { 
           new AscError(kError_AmbiguousReference, "对 %s 的引用有歧义。" ),
           new AscError(kError_NamespaceAccessSpecifiers, "不允许将访问说明符与 namespace 属性一同使用。" ),
           new AscError(kError_Unknown_Namespace, "namespace 要么找不到，要么不是编译时常数。" ),
           new AscError(kError_InvalidSuperExpression, "super 表达式只能在类实例方法内部使用。" ),
           new AscError(kError_InvalidSuperStatement, "super 语句只能在类实例构造函数内部使用。" ),
           new AscError(kError_InvalidAttribute, "属性无效。" ),
           new AscError(kError_InvalidOverride, "override 属性只能用于类属性定义。" ),
           new AscError(kError_InvalidVirtual, "virtual 属性只能用于类属性定义。" ),
           new AscError(kError_InvalidStatic, "static 属性只能用于类内部的定义。" ),
           new AscError(kError_InvalidPrivate, "private 属性只能用于类属性定义。" ),
           new AscError(kError_Unsupported_Intrinsic, "intrinsic 属性已不受支持。" ),
           new AscError(kError_BaseClassIsFinal, "基类为 final。" ),
           new AscError(kError_UnknownBaseClass, "找不到基类 %s 的定义。" ),
           new AscError(kError_DuplicateClassDefinition, "类定义重复: %s。" ),
           new AscError(kError_OverrideNotFound, "标记为 override 的方法必须覆盖另一方法。" ),
           new AscError(kError_DuplicateFunction, "函数定义重复。" ),
           new AscError(kError_OverrideFinalAccessor, "无法覆盖 final 存取器。" ),
           new AscError(kError_IncompatibleOverride, "不兼容的覆盖。" ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "正在覆盖未标记为 override 的函数。" ),
           new AscError(kError_FinalMethodRedefinition, "无法重定义 final 方法。" ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "构造函数必须是实例方法。" ),
           new AscError(kError_FuncIsStaticAndOverride, "函数不能同时标记为 static 和 override。" ),
           new AscError(kError_FuncIsStaticAndVirtual, "函数不能同时标记为 static 和 virtual。" ),
           new AscError(kError_FuncIsVirtualAndFinal, "函数不能同时标记为 final 和 virtual。" ),
           new AscError(kError_RestParameterNotNamed, "必须指定可变参数数组的名称。" ),
           new AscError(kError_VirtualVars, "不支持 virtual 变量。" ),
           new AscError(kError_NativeVars, "变量不能是内置变量。" ),
           new AscError(kError_VarIsFinalAndVirtual, "变量不能同时标记为 final 和 virtual。" ),
           new AscError(kError_NestedPackage, "包不能嵌套。" ),
           new AscError(kError_BreakHasNoTarget, "找不到 break 语句的目标。" ),
           new AscError(kError_ContinueHasNoTarget, "找不到 continue 语句的目标。" ),
           new AscError(kError_DuplicateLabel, "标签定义重复。" ),
           new AscError(kError_AttributesAreNotCallable, "属性不可调用。" ),
           new AscError(kError_ThisUsedInStaticFunction, "不能在 static 方法中使用 this 关键字。该关键字只能在实例方法、函数闭包和全局代码中使用。" ),
           new AscError(kError_UndefinedNamespace, "未定义的命名空间。" ),
           new AscError(kError_UnknownInterfaceMethod, "接口方法 %s (位于命名空间 %s 中)未由类 %s 实现。" ),
           new AscError(kError_UnknownInterface, "找不到接口 %s。" ),
           new AscError(kError_UnknownType, "找不到类型，或者它不是编译时常数: %s。" ),
           new AscError(kError_NonConstantParamInitializer, "参数初始值设定项未知或不是编译时常数。" ),
           new AscError(kError_MethodIsNotAConstructor, "方法不能用作构造函数。" ),
           new AscError(kError_AssignmentToConstVar, "对指定为常数的变量进行的赋值非法。" ),
           new AscError(kError_AssignmentToNonRefVar, "无法为非引用值赋值。" ),
           new AscError(kError_ReturnTypeMustBeUndefined, "返回值必须未定义。" ),
           new AscError(kError_ConstInitializerNotConst, "常数初始值设定项未知或不是编译时常数。" ),
           new AscError(kError_AccessorTypesMustMatch, "存取器类型必须相匹配。" ),
           new AscError(kError_BadSetterReturnType, "setter 定义的返回类型必须未指定或为 void。" ),
           new AscError(kError_PropertyIsWriteOnly, "属性是只写的。" ),
           new AscError(kError_PropertyIsReadOnly, "属性是只读的。" ),
           new AscError(kError_Strict_UndefinedMethod, "调用可能未定义的方法 %s (通过 static 类型 %s 引用)。" ),
           new AscError(kError_UnableToOpenFile, "无法打开文件: %s。" ),
           new AscError(kError_InvalidMetaData, "元数据无效。" ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "元数据属性不能包含多个元素。" ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "%s 类型值的隐式强制指令的目标是非相关类型 %s。" ),
           new AscError(kError_Parser_UnableToOpenFile, "无法打开所包含的文件: %s。" ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "语法错误: 需要定义或指令。" ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "语法错误: 在属性 %s (而不是 %s)之后需要一个定义关键字(如 function)。" ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "语法错误: 在 namespace 之前应该有 xml。" ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "语法错误: 需要 catch 或 finally 子句。" ),
           new AscError(kError_Parser_EachWithoutIn, "语法错误: 'each' 关键字必须带有 'in' 运算符。" ),
           new AscError(kError_Parser_ExpectedLeftParen, "语法错误: 在标识符之前应该有左括号。" ),
           new AscError(kError_Parser_ExpectedCaseLabel, "需要 CaseLabel。" ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "标签必须是简单标识符。" ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "super 表达式必须有一个操作数。" ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "需要增量或减量运算符。" ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "括号内应为单个表达式。" ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "语法错误: 不需要 %s。" ),
           new AscError(kError_Parser_ExpectedToken, "语法错误:  %s 应在 %s 之前。" ),
           new AscError(kError_Parser_ExpectedSemicolon, "语法错误: 在 %s 之前应该有分号。" ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "语法错误: 在程序结尾之后发现多余的字符。" ),
           new AscError(kError_Lexical_General, "语法错误。" ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "语法错误: 在换行之前必须结束字符串文本。" ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "语法错误: 在换行之前必须结束字符串文本。" ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "语法错误: 字符串文本的输入已在到达右引号之前结束。" ),
           new AscError(kError_Lexical_SyntaxError, "语法错误。" ),
           new AscError(kError_Lexical_NoMatchingTag, "语法错误: XML 的开始和结束标签不匹配。" ),
           new AscError(kError_CannotDeleteSuperDecendants, "无法删除 super 后代。" ),
           new AscError(kError_DuplicateNamespaceDefinition, "命名空间定义重复。" ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "赋值的目标必须是引用值。" ),
           new AscError(kError_IncrementOperatorNotAReference, "增量的操作数必须是引用。" ),
           new AscError(kError_InvalidIncrementOperand, "增量操作数无效。" ),
           new AscError(kError_InvalidDecrementOperand, "减量操作数无效。" ),
           new AscError(kError_ExpectingExpression, "需要表达式。" ),
           new AscError(kError_MissingXMLTagName, "缺少 XML 标签名称。" ),
           new AscError(kError_InvalidAbcFile, "文件 %s 不是有效的 ABC 文件。" ),
           new AscError(kError_Parser_FileIncludesItself, "可能导致无限递归，因为此文件包含: %s。" ),
           new AscError(kError_CircularReference, "在 %s 中检测到循环类型引用。" ),
           new AscError(kError_InvalidPublic, "public 属性只能在包的内部使用。" ),
           new AscError(kError_InvalidInternal, "internal 属性只能在包的内部使用。" ),
           new AscError(kError_InvalidNamespace, "用户定义的 namespace 属性只能在类定义的顶级使用。" ),
           new AscError(kError_ImplicitCoercionToSubtype, "属于 static 类型 %s 的值的隐式强制指令的目标可能是非相关类型 %s。" ),
           new AscError(kError_UndefinedProperty, "访问可能未定义的属性 %s (通过 static 类型 %s 引用)。" ),
           new AscError(kError_UnfoundProperty, "访问的属性 %s 未定义。" ),
           new AscError(kError_GetterCannotHaveParameters, "getter 定义不能有参数。" ),
           new AscError(kError_SetterMustHaveOneParameter, "setter 定义只能有一个参数。" ),
           new AscError(kError_SetterCannotHaveOptional, "setter 定义不能有可选参数。" ),
           new AscError(kError_BadGetterReturnType, "getter 定义的返回类型不能为 void。" ),
           new AscError(kError_InterfaceMethodWithBody, "接口中定义的方法不能含有过程体。" ),
           new AscError(kError_FunctionWithoutBody, "函数没有过程体。" ),
           new AscError(kError_DuplicateAttribute, "属性 %s 被多次指定。" ),
           new AscError(kError_DuplicateInterfaceDefinition, "接口定义重复: %s。" ),
           new AscError(kError_CtorWithReturnType, "构造函数不能指定返回类型。" ),
           new AscError(kError_InvalidClassNesting, "类不能嵌套。" ),
           new AscError(kError_InvalidFinalUsage, "final 属性只能用于类中定义的方法。" ),
           new AscError(kError_InvalidNative, "内置属性只能与函数定义一起使用。" ),
           new AscError(kError_InvalidDynamic, "动态属性只能与类定义一起使用。" ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "语法错误: %s 不是有效类型。" ),
           new AscError(kError_WrongNumberOfArguments, "参数个数不正确。应为 %s 个。" ),
           new AscError(kError_TooManyArguments, "参数个数不正确。不应超过 %s 个。" ),
           new AscError(kError_BadRequiredParameter, "必选参数不得位于可选参数之后。" ),
           new AscError(kError_VarInInterface, "不允许在接口中使用变量声明。" ),
           new AscError(kError_InvalidRestDecl, "在 ...rest 参数定义关键字之后指定的参数只能为 Array 数据类型。" ),
           new AscError(kError_CannotExtendInterface, "一个类只能扩展另一个类，不能扩展一个接口。" ),
           new AscError(kError_CannotExtendClass, "一个接口只能扩展其它接口，而 %s 是类。" ),
           new AscError(kError_InvalidOverrideUsage, "override 属性只能用于类中定义的方法。" ),
           new AscError(kError_IncompatibleInterfaceMethod, "接口方法 %s (位于命名空间 %s 中)是通过类 %s 中不兼容的签名实现的。" ),
           new AscError(kError_NativeMethodWithBody, "内置方法不能含有过程体。" ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "构造函数不能是 getter 方法或 setter 方法。" ),
           new AscError(kError_MissingFilespec, "没有指定 AS 源文件。" ),
           new AscError(kError_CannotReturnFromStaticInit, "不能在静态初始化代码中使用返回语句。" ),
           new AscError(kError_InvalidProtected, "protected 属性只能用于类属性定义。" ),
           new AscError(kError_ConflictingNameInNamespace, "定义 %s (在命名空间 %s 中)存在冲突。" ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "继承的定义 %s (在命名空间 %s 中)存在冲突。" ),
           new AscError(kError_ConstructorMustBePublic, "构造函数只能声明为 public。" ),
           new AscError(kError_ConflictingAccessSpecifiers, "在定义中只能指定 public、private、protected 或 internal 中的一个。" ),
           new AscError(kError_InvalidNestedAccessor, "存取器不能嵌套在其它函数中。" ),
           new AscError(kError_CannotInstantiateInterface, "不能使用新的运算符对接口进行实例化。" ),
           new AscError(kError_BadAccessInterfaceMember, "接口成员不能声明为 public、private、protected 或 internal。" ),
           new AscError(kError_Parser_ExpectedLeftBrace, "语法错误: 函数体之前缺少左大括号 ({)。" ),
           new AscError(kError_CannotReturnFromPackageInit, "不能在包初始化代码中使用返回语句。" ),
           new AscError(kError_InvalidInterfaceNative, "内置属性不能用于接口定义。" ),
           new AscError(kError_MultipleNamespaceAttributes, "每个定义只能使用一个 namespace 属性。" ),
           new AscError(kError_ConflictingInheritedNameInInterface, "方法 %s 与从接口 %s 继承的定义冲突。" ),
           new AscError(kError_InvalidInterfaceAttribute, "接口属性 %s 无效。" ),
           new AscError(kError_NamespaceInInterface, "不允许在接口中使用 namespace 声明。" ),
           new AscError(kError_DuplicateImplements, "类 %s 多次实现接口 %s。" ),
           new AscError(kError_AssignmentToDefinedFunction, "对函数 %s 的赋值非法。" ),
           new AscError(kError_InterfaceNamespaceAttribute, "不允许在接口方法中使用 namespace 属性。" ),
           new AscError(kError_MustReturnValue, "函数没有返回值。" ),
           new AscError(kError_InvalidNamespaceInitializer, "一个 namespace 的初始值设定项必须是一个原义字符串或者是另一个 namespace。" ),
           new AscError(kError_DefinitionNotFound, "找不到定义 %s。" ),
           new AscError(kError_InvalidLabel, "标签定义无效。" ),
           new AscError(kError_IncompatableValueComparison, "在属于 static 类型 %s 的值与可能的非相关类型 %s 之间进行比较。" ),
           new AscError(kError_CannotReturnFromGlobalInit, "不能在全局初始化代码中使用返回语句。" ),
           new AscError(kError_InaccessiblePropertyReference, "试图访问不可访问的属性 %s (通过 static 类型 %s 引用)。" ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object is temporarily out of service.Use :* instead." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "调用的方法 %s 可能未定义。" ),
           new AscError(kError_ForwardReferenceToBaseClass, "基类 %s 的向前引用。" ),
           new AscError(kError_IllegalPackageReference, "包不能作为以下值使用: %s。" ),
           new AscError(kError_IncompatibleDefaultValue, "类型 %s (应为 %s)的默认值不兼容。" ),
           new AscError(kError_MultipleSwitchDefaults, "switch 有多个默认值，但只允许有一个默认值。" ),
           new AscError(kError_AssignmentToDefinedClass, "对类 %s 的赋值非法。" ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "试图删除固定属性 %s。只能删除动态定义的属性。" ),
           new AscError(kError_InvalidBaseTypeExpression, "找不到基类，或者它不是编译时常数。" ),
           new AscError(kError_InvalidInterfaceTypeExpression, "找不到接口，或者它不是编译时常数。" ),
           new AscError(kError_StaticModifiedNamespace, "在 namespace 定义中不允许使用 static 属性。" ),
           new AscError(kError_InvalidInterfaceNesting, "接口定义不能嵌套在类或其它接口定义中。" ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "prototype 属性无效。" ),
           new AscError(kError_InaccessibleMethodReference, "试图访问不可访问的方法 %s (通过 static 类型 %s 引用)。" ),
           new AscError(kError_Parser_ThrowWithoutExpression, "语法错误: throw 之后应为表达式。" ),
           new AscError(kError_Authoring_SymbolClassInheritance, "类 %s 不能扩展 %s，因为两者均与库元件或主时间轴关联。" ),
           new AscError(kError_AttributesOnPackage, "在包的定义中不允许使用属性。" ),
           new AscError(kError_InternalError, "内部错误: %s。" ),
           new AscError(kError_ParserInvalidForInInitializer, "语法错误: for-in 初始值设定项无效，应该只有一个表达式。" ),
           new AscError(kError_IllegalSuperStatement, "this、super、return 或 throw 语句后面不能出现 super 语句。" ),
           new AscError(kError_UnfoundPackageProperty, "访问的属性 %s (在包 %s 中)未定义。" ),
           new AscError(kError_NoDefaultBaseclassCtor, "未在基类 %s 中找到默认的构造函数。" ),
           new AscError(kError_BlockCommentNotTerminated, "找到的 /* 没有匹配的 */。" ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "语法错误: 需要左花括号 ({) 或字符串文字 (\"\")。" ),
           new AscError(kError_InvalidES4SuperStatement, "super 语句只能用作构造函数初始值设定项列表中的最后一项。" ),
           new AscError(kError_ThisUsedInInitializer, "不能在属性初始值设定项中使用 this 关键字。" ),
           new AscError(kError_NonConstantConfigInit, "配置值的初始值设定项必须是编译时常量。" ),
           new AscError(kError_NonConstConfigVar, "配置变量只能声明为 const。" ),
           new AscError(kError_InvalidConfigLocation, "配置值必须在程序或包的顶级声明。" ),
           new AscError(kError_ShadowedConfigNamespace, "命名空间 %s 与配置命名空间冲突。" ),
           new AscError(kError_InvalidPrecision, "精度必须是一个介于 1 和 34 之间的整数。" ),
           new AscError(kError_WrongVersion, "不兼容的版本: 无法引用定义 %s（在版本 %s 中引入），来源为版本 %s 的代码。" ),
           new AscError(kError_LossyConversion, "初始化无效: 转换为类型 %s 会丢失数据。" ),
   };

   public static final AscError[] errorConstantsCS = { 
           new AscError(kError_AmbiguousReference, "Nejednoznačný odkaz na  %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Specifikátory přístupu nejsou povoleny u atributů prostoru názvů." ),
           new AscError(kError_Unknown_Namespace, "Prostor názvů nebyl nalezen nebo se jedná o konstantu v době kompilace." ),
           new AscError(kError_InvalidSuperExpression, "Výraz super lze použít pouze v rámci metod instancí tříd." ),
           new AscError(kError_InvalidSuperStatement, "Příkaz super lze použít pouze v rámci konstruktorů instancí tříd." ),
           new AscError(kError_InvalidAttribute, "Atribut je neplatný." ),
           new AscError(kError_InvalidOverride, "Atribut override smí být použit pouze v definicích vlastností tříd." ),
           new AscError(kError_InvalidVirtual, "Atribut virtual smí být použit pouze v definicích vlastností tříd." ),
           new AscError(kError_InvalidStatic, "Atribut static smí být použit pouze v definicích v rámci třídy." ),
           new AscError(kError_InvalidPrivate, "Atribut private smí být použit pouze v definicích vlastností tříd." ),
           new AscError(kError_Unsupported_Intrinsic, "Atribut intrinsic již není podporován." ),
           new AscError(kError_BaseClassIsFinal, "Základní třída je konečná." ),
           new AscError(kError_UnknownBaseClass, "Definice základní třídy %s nebyla nalezena." ),
           new AscError(kError_DuplicateClassDefinition, "Duplicitní definice třídy: %s." ),
           new AscError(kError_OverrideNotFound, "Metoda s označením přepis musí přepisovat jinou metodu." ),
           new AscError(kError_DuplicateFunction, "Duplicitní definice funkce." ),
           new AscError(kError_OverrideFinalAccessor, "Nelze přepsat konečný mechanismus přístupu." ),
           new AscError(kError_IncompatibleOverride, "Nekompatibilní přepis." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Probíhá pokus o přepis funkce neoznačené pro přepis." ),
           new AscError(kError_FinalMethodRedefinition, "Nelze předefinovat konečnou metodu." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Funkcemi konstruktorů musejí být metody instancí." ),
           new AscError(kError_FuncIsStaticAndOverride, "Funkce nemohou být statické a zároveň určené pro přepis." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Funkce nemohou být statické a zároveň virtuální." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Funkce nemohou být konečné a zároveň virtuální." ),
           new AscError(kError_RestParameterNotNamed, "Je třeba zadat název pole proměnných argumentů." ),
           new AscError(kError_VirtualVars, "Virtuální proměnné nejsou podporovány." ),
           new AscError(kError_NativeVars, "Proměnné nemohou být nativní." ),
           new AscError(kError_VarIsFinalAndVirtual, "Proměnné nemohou být konečné a zároveň virtuální." ),
           new AscError(kError_NestedPackage, "Balíčky nemohou být vnořené." ),
           new AscError(kError_BreakHasNoTarget, "Cíl příkazu break nebyl nalezen." ),
           new AscError(kError_ContinueHasNoTarget, "Cíl příkazu continue nebyl nalezen." ),
           new AscError(kError_DuplicateLabel, "Duplicitní definice popisu." ),
           new AscError(kError_AttributesAreNotCallable, "Atributy nejsou volatelné." ),
           new AscError(kError_ThisUsedInStaticFunction, "Klíčové slovo this nelze použít ve statických metodách. Lze je použít pouze v metodách instancí, uzavřeních funkcí a globálním kódu." ),
           new AscError(kError_UndefinedNamespace, "Nedefinovaný prostor názvů." ),
           new AscError(kError_UnknownInterfaceMethod, "Metoda rozhraní %s v prostoru názvů %s není implementována třídou %s." ),
           new AscError(kError_UnknownInterface, "Rozhraní %s nebylo nalezeno." ),
           new AscError(kError_UnknownType, "Typ nebyl nalezen nebo se nejednalo o konstantu v době kompilace: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Inicializátor parametru je neznámý nebo se nejedná o konstantu v době kompilace." ),
           new AscError(kError_MethodIsNotAConstructor, "Metodu nelze použít jako konstruktor." ),
           new AscError(kError_AssignmentToConstVar, "Neplatné přiřazení k proměnné zadáno jako konstanta." ),
           new AscError(kError_AssignmentToNonRefVar, "Nelze přiřadit k nereferenční hodnotě." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Vrácená hodnota musí být nedefinovaná." ),
           new AscError(kError_ConstInitializerNotConst, "Inicializátor konstanty je neznámý nebo se nejedná o konstantu v době kompilace." ),
           new AscError(kError_AccessorTypesMustMatch, "Typy mechanismů přístupu se musejí shodovat." ),
           new AscError(kError_BadSetterReturnType, "Vrácený typ v definici metody pro nastavení (setter) musí být nezadaný nebo prázdný." ),
           new AscError(kError_PropertyIsWriteOnly, "Vlastnost je pouze pro zápis." ),
           new AscError(kError_PropertyIsReadOnly, "Vlastnost je pouze pro čtení." ),
           new AscError(kError_Strict_UndefinedMethod, "Volání metody %s, která je možná nedefinovaná, přes odkaz se statickým typem %s." ),
           new AscError(kError_UnableToOpenFile, "Nelze otevřít soubor: %s." ),
           new AscError(kError_InvalidMetaData, "Neplatná metadata." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Atributy metadat nemohou obsahovat více než jeden prvek." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Implicitní vynucené nastavení hodnoty typu %s na nepřidružený typ %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Nelze otevřít zahrnutý soubor: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Chyba syntaxe: očekávána definice nebo instrukce." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Chyba syntaxe: klíčové slovo definice (například function) očekáváno za atributem %s, nikoli %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Chyba syntaxe: očekáváno xml před prostorem názvů." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Chyba syntaxe: očekávána klauzule catch nebo finally." ),
           new AscError(kError_Parser_EachWithoutIn, "Chyba syntaxe: klíčové slovo each není povoleno bez operátoru in." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Chyba syntaxe: očekávána levá závorka před identifikátorem." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Očekáván prvek CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Popisem musí být jednoduchý identifikátor." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Výraz super musí mít jeden operand." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Očekáván inkrementační nebo dekrementační operátor." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Očekáván jednoduchý výraz v závorkách." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Chyba syntaxe: %s je neočekávané." ),
           new AscError(kError_Parser_ExpectedToken, "Chyba syntaxe: očekává se %s před %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Chyba syntaxe: očekáván středník před %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Chyba syntaxe: byly nalezeny znaky navíc za koncem programu." ),
           new AscError(kError_Lexical_General, "Chyba syntaxe." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Chyba syntaxe: Řetězcová konstanta musí být ukončena před zalomením řádku." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Chyba syntaxe: Řetězcová konstanta musí být ukončena před zalomením řádku." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Chyba syntaxe: vstup dokončen před dosažením koncových uvozovek pro řetězcovou konstantu." ),
           new AscError(kError_Lexical_SyntaxError, "Chyba syntaxe." ),
           new AscError(kError_Lexical_NoMatchingTag, "Chyba syntaxe: XML nemá shodné zahajovací a ukončovací tagy." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Nelze odstranit potomky ve výrazu super." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Duplicitní definice prostoru názvů." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Cílem přiřazení musí být referenční hodnota." ),
           new AscError(kError_IncrementOperatorNotAReference, "Operandem přírůstku musí být odkaz." ),
           new AscError(kError_InvalidIncrementOperand, "Operand přírůstku je neplatný." ),
           new AscError(kError_InvalidDecrementOperand, "Operand snížení je neplatný." ),
           new AscError(kError_ExpectingExpression, "Očekáván výraz." ),
           new AscError(kError_MissingXMLTagName, "Chybí název tagu XML." ),
           new AscError(kError_InvalidAbcFile, "Soubor %s nepředstavuje platný soubor ABC." ),
           new AscError(kError_Parser_FileIncludesItself, "Možná nekonečná rekurze způsobená zahrnutím tohoto souboru: %s." ),
           new AscError(kError_CircularReference, "Byl zjištěn odkaz cyklického typu v %s." ),
           new AscError(kError_InvalidPublic, "Atribut public lze použít pouze uvnitř balíčku." ),
           new AscError(kError_InvalidInternal, "Atribut internal lze použít pouze uvnitř balíčku." ),
           new AscError(kError_InvalidNamespace, "Uživatelský atribut prostoru názvů lze použít pouze na nejvyšší úrovni definice třídy." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Implicitní vynucené nastavení hodnoty se statickým typem %s na možná nepřidružený typ %s." ),
           new AscError(kError_UndefinedProperty, "Přístup k vlastnosti %s, která je možná nedefinovaná, přes odkaz se statickým typem %s." ),
           new AscError(kError_UnfoundProperty, "Přístup k nedefinované vlastnosti %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Definice metody pro získání (getter) nesmí obsahovat žádné parametry." ),
           new AscError(kError_SetterMustHaveOneParameter, "Definice metody pro nastavení (setter) musí obsahovat přesně jeden parametr." ),
           new AscError(kError_SetterCannotHaveOptional, "Definice metody pro nastavení (setter) nemůže obsahovat volitelné parametry." ),
           new AscError(kError_BadGetterReturnType, "Vrácený typ definice metody pro získání (getter) nesmí být prázdný." ),
           new AscError(kError_InterfaceMethodWithBody, "Metody definované v rozhraní nesmějí mít tělo." ),
           new AscError(kError_FunctionWithoutBody, "Funkce nemá tělo." ),
           new AscError(kError_DuplicateAttribute, "Atribut %s byl zadán vícekrát." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Duplicitní definice rozhraní: %s." ),
           new AscError(kError_CtorWithReturnType, "U konstruktoru nemůže být určen vrácený typ." ),
           new AscError(kError_InvalidClassNesting, "Třídy nesmějí být vnořené." ),
           new AscError(kError_InvalidFinalUsage, "Atribut final lze použít pouze v metodě definované ve třídě." ),
           new AscError(kError_InvalidNative, "Atribut native lze použít pouze s definicemi funkcí." ),
           new AscError(kError_InvalidDynamic, "Atribut dynamic lze použít pouze s definicemi tříd." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Chyba syntaxe: %s nepředstavuje platný typ." ),
           new AscError(kError_WrongNumberOfArguments, "Nesprávný počet argumentů. Očekáváno: %s." ),
           new AscError(kError_TooManyArguments, "Nesprávný počet argumentů. Očekáváno více než: %s." ),
           new AscError(kError_BadRequiredParameter, "Vyžadované parametry nejsou povoleny po volitelných parametrech." ),
           new AscError(kError_VarInInterface, "Deklarace proměnných nejsou povoleny v rozhraních." ),
           new AscError(kError_InvalidRestDecl, "Parametry zadané za klíčovým slovem definice parametru ...rest mohou být pouze datového typu Pole." ),
           new AscError(kError_CannotExtendInterface, "Třída smí rozšiřovat pouze jinou třídu, nikoli rozhraní." ),
           new AscError(kError_CannotExtendClass, "Rozhraní smí rozšiřovat pouze jiná rozhraní, avšak %s představuje třídu." ),
           new AscError(kError_InvalidOverrideUsage, "Atribut override lze použít pouze v metodě definované ve třídě." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Metoda rozhraní %s v prostoru názvů %s je implementována s nekompatibilním podpisem ve třídě %s." ),
           new AscError(kError_NativeMethodWithBody, "Nativní metody nemohou mít tělo." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Konstruktor nemůže představovat metodu pro získání (getter) nebo pro nastavení (setter)." ),
           new AscError(kError_MissingFilespec, "Zdrojový soubor AS nebyl určen." ),
           new AscError(kError_CannotReturnFromStaticInit, "Příkaz return nelze použít ve statickém inicializačním kódu." ),
           new AscError(kError_InvalidProtected, "Atribut protected lze použít pouze v definicích vlastností tříd." ),
           new AscError(kError_ConflictingNameInNamespace, "Existuje konflikt s definicí %s v prostoru názvů %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Existuje konflikt s převzatou definicí %s v prostoru názvů %s." ),
           new AscError(kError_ConstructorMustBePublic, "Konstruktor lze deklarovat pouze jako veřejný." ),
           new AscError(kError_ConflictingAccessSpecifiers, "V definici lze zadat jen jednu z následujících možností: public, private, protected nebo internal." ),
           new AscError(kError_InvalidNestedAccessor, "Mechanismy přístupu nemohou být vnořeny do jiných funkcí." ),
           new AscError(kError_CannotInstantiateInterface, "Rozhraní nelze konkretizovat s novým operátorem." ),
           new AscError(kError_BadAccessInterfaceMember, "Členy rozhraní nelze deklarovat jako public, private, protected nebo internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Chyba syntaxe: chybějící levá složená závorka ({) před tělem funkce." ),
           new AscError(kError_CannotReturnFromPackageInit, "Příkaz return nelze použít v inicializačním kódu balíčku." ),
           new AscError(kError_InvalidInterfaceNative, "Atribut native nelze použít v definicích rozhraní." ),
           new AscError(kError_MultipleNamespaceAttributes, "Pro každou definici lze použít jen jeden atribut prostoru názvů." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Metoda %s je v konfliktu s definicí převzatou z rozhraní %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Atribut rozhraní %s je neplatný" ),
           new AscError(kError_NamespaceInInterface, "Deklarace prostoru názvů nejsou povoleny v rozhraních." ),
           new AscError(kError_DuplicateImplements, "Třída %s implementuje rozhraní %s vícekrát." ),
           new AscError(kError_AssignmentToDefinedFunction, "Neplatné přiřazení k funkci %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Atributy prostoru názvů nejsou povoleny v metodách rozhraní." ),
           new AscError(kError_MustReturnValue, "Funkce nevrací hodnotu." ),
           new AscError(kError_InvalidNamespaceInitializer, "Inicializátorem prostoru názvů musí být buď řetězcová konstanta, nebo jiný prostor názvů." ),
           new AscError(kError_DefinitionNotFound, "Definici %s nebylo možné najít." ),
           new AscError(kError_InvalidLabel, "Definice popisu je neplatná." ),
           new AscError(kError_IncompatableValueComparison, "Porovnání mezi hodnotou statického typu %s a možná nepřidruženým typem %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Příkaz return nelze použít v globálním inicializačním kódu." ),
           new AscError(kError_InaccessiblePropertyReference, "Došlo k pokusu o přístup k nepřístupné vlastnosti %s přes odkaz se statickým typem %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Objekt je dočasně mimo provoz. Použijte místo toho :*." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Volání možná nedefinované metody %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Předat odkaz na základní třídu %s." ),
           new AscError(kError_IllegalPackageReference, "Balíček nelze použít jako hodnotu: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Nekompatibilní výchozí hodnota typu %s na místě, kde bylo očekáváno: %s." ),
           new AscError(kError_MultipleSwitchDefaults, "Přepínač má více než jednu výchozí hodnotu, je však povolena pouze jedna výchozí hodnota." ),
           new AscError(kError_AssignmentToDefinedClass, "Neplatné přiřazení ke třídě %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Pokus o odstranění pevné vlastnosti %s. Lze odstranit pouze dynamicky definované vlastnosti." ),
           new AscError(kError_InvalidBaseTypeExpression, "Základní třída nebyla nalezena nebo se nejedná o konstantu v době kompilace." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Rozhraní nebylo nalezeno nebo se nejedná o konstantu v době kompilace." ),
           new AscError(kError_StaticModifiedNamespace, "Atribut static není povolen u definic prostorů názvů." ),
           new AscError(kError_InvalidInterfaceNesting, "Definice rozhraní nesmějí být vnořené do třídy nebo jiných definic rozhraní." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Atribut prototype je neplatný." ),
           new AscError(kError_InaccessibleMethodReference, "Došlo k pokusu o přístup k nepřístupné metodě %s přes odkaz se statickým typem %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Chyba syntaxe: očekáván výraz po příkazu throw." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Třída %s nemůže rozšířit %s, protože oba tyto objekty jsou přidruženy k symbolům knihovny nebo hlavní časové ose." ),
           new AscError(kError_AttributesOnPackage, "Atributy nejsou povoleny v definici balíčku." ),
           new AscError(kError_InternalError, "Interní chyba: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Chyba syntaxe: neplatný inicializátor for-in, očekáván pouze 1 výraz." ),
           new AscError(kError_IllegalSuperStatement, "Příkaz super se nemůže vyskytovat po příkazu this, super, return nebo throw." ),
           new AscError(kError_UnfoundPackageProperty, "Přístup k nedefinované vlastnosti %s v balíčku %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "V základní třídě %s nebyl nalezen žádný výchozí konstruktor." ),
           new AscError(kError_BlockCommentNotTerminated, "Nalezeny znaky /* bez odpovídajících znaků */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntax Error: expecting a left brace({)or string literal(\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "A super statement can be used only as the last item in a constructor initializer list." ),
           new AscError(kError_ThisUsedInInitializer, "The this keyword can not be used in property initializers." ),
           new AscError(kError_NonConstantConfigInit, "The initializer for a configuration value must be a compile time constant." ),
           new AscError(kError_NonConstConfigVar, "A configuration variable may only be declared const." ),
           new AscError(kError_InvalidConfigLocation, "A configuration value must be declared at the top level of a program or package." ),
           new AscError(kError_ShadowedConfigNamespace, "Namespace %s conflicts with a configuration namespace." ),
           new AscError(kError_InvalidPrecision, "Precision must be an integer between 1 and 34." ),
           new AscError(kError_WrongVersion, "Incompatible Version: can not reference definition %s introduced in version %s from code with version %s." ),
           new AscError(kError_LossyConversion, "Invalid initialization: conversion to type %s loses data." ),
   };

   public static final AscError[] errorConstantsDA = { 
           new AscError(kError_AmbiguousReference, "Tvetydig henvisning til %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Adgangsangivelser må ikke bruges med navneområdeattributter." ),
           new AscError(kError_Unknown_Namespace, "Navneområdet blev ikke fundet eller det er ikke en kompileringstidspunktskonstant." ),
           new AscError(kError_InvalidSuperExpression, "Et superudtryk kan kun bruges inden i klasseinstansmetoder." ),
           new AscError(kError_InvalidSuperStatement, "Et superudsagn kan kun bruges inden i klasseinstanskonstruktører." ),
           new AscError(kError_InvalidAttribute, "Attributten er ugyldig." ),
           new AscError(kError_InvalidOverride, "Tilsidesættelsesattributten kan kun bruges inden i definitioner af klasseegenskaber." ),
           new AscError(kError_InvalidVirtual, "Den virtuelle attribut kan kun bruges inden i definitioner af klasseegenskaber." ),
           new AscError(kError_InvalidStatic, "Den statiske attribut kan kun bruges i definitioner inden i klasser." ),
           new AscError(kError_InvalidPrivate, "Den private attribut kan kun bruges inden i definitioner af klasseegenskaber." ),
           new AscError(kError_Unsupported_Intrinsic, "Den indbyggede attribut understøttes ikke mere." ),
           new AscError(kError_BaseClassIsFinal, "Basisklassen er endelig." ),
           new AscError(kError_UnknownBaseClass, "Definitionen af basisklassen %s blev ikke fundet." ),
           new AscError(kError_DuplicateClassDefinition, "Dobbelt klassedefinition: %s." ),
           new AscError(kError_OverrideNotFound, "Metoden mærket tilsidesæt, skal tilsidesætte en anden metode." ),
           new AscError(kError_DuplicateFunction, "Basisklassen er endelig." ),
           new AscError(kError_OverrideFinalAccessor, "En sidste accessor kan ikke tilsidesættes." ),
           new AscError(kError_IncompatibleOverride, "Inkompatibel tilsidesættelse." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Tilsidesætter en funktion som ikke er mærket til tilsidesættelse." ),
           new AscError(kError_FinalMethodRedefinition, "En sidste metode kan ikke omdefineres." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Konstruktørfunktioner skal være instansmetoder." ),
           new AscError(kError_FuncIsStaticAndOverride, "Funktioner kan ikke være både statiske og tilsidesætte." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Funktioner kan ikke være både statiske og virtuelle." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Funktioner kan ikke være både sidste og virtuelle." ),
           new AscError(kError_RestParameterNotNamed, "Du skal angive navnet på sættet med variable argumenter." ),
           new AscError(kError_VirtualVars, "Virtuelle variable understøttes ikke." ),
           new AscError(kError_NativeVars, "Variable kan ikke være indbyggede." ),
           new AscError(kError_VarIsFinalAndVirtual, "Variable kan ikke være både sidste og virtuelle." ),
           new AscError(kError_NestedPackage, "Pakker kan ikke være indlejrede." ),
           new AscError(kError_BreakHasNoTarget, "Målet for break-udsagnet blev ikke fundet." ),
           new AscError(kError_ContinueHasNoTarget, "Målet for fortsæt-udsagnet blev ikke fundet." ),
           new AscError(kError_DuplicateLabel, "Dobbelt etiketdefinition." ),
           new AscError(kError_AttributesAreNotCallable, "Attributter kan ikke kaldes." ),
           new AscError(kError_ThisUsedInStaticFunction, "Nøgleordet kan ikke bruges i statiske metoder. Det kan kun bruges i instansmetoder, funktionslukninger og global kode." ),
           new AscError(kError_UndefinedNamespace, "Udefineret navneområde." ),
           new AscError(kError_UnknownInterfaceMethod, "Grænseflademetoden %s i navneområdet %s er ikke implementeret af klassen %s." ),
           new AscError(kError_UnknownInterface, "Grænsefladen %s blev ikke fundet." ),
           new AscError(kError_UnknownType, "Typen blev ikke fundet eller det er ikke en kompileringstidspunktskonstant: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parameterinitialiseringen er ukendt eller det er ikke en kompileringstidspunktskonstant." ),
           new AscError(kError_MethodIsNotAConstructor, "Metoden kan ikke bruges af en konstruktør." ),
           new AscError(kError_AssignmentToConstVar, "Ugyldig tildeling til en variabel specificeret som konstant." ),
           new AscError(kError_AssignmentToNonRefVar, "Der kan ikke tildeles en værdi, der ikke er refereret." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Returværdien må ikke være defineret." ),
           new AscError(kError_ConstInitializerNotConst, "Konstantinitialiseringen er ukendt eller det er ikke en kompileringstidspunktskonstant." ),
           new AscError(kError_AccessorTypesMustMatch, "Accessortyperne skal være ens." ),
           new AscError(kError_BadSetterReturnType, "Definitionen af en indstillingsfunktions returtype skal være uspecificeret eller ugyldig." ),
           new AscError(kError_PropertyIsWriteOnly, "Egenskaben er læsebeskyttet." ),
           new AscError(kError_PropertyIsReadOnly, "Egenskaben er skrivebeskyttet." ),
           new AscError(kError_Strict_UndefinedMethod, "Kald til en muligvis udefineret metode %s gennem en henvisning med statisk type %s." ),
           new AscError(kError_UnableToOpenFile, "Kan ikke åbne filen: %s." ),
           new AscError(kError_InvalidMetaData, "Ugyldige metadata." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Metadataattributter kan ikke have mere end ét element." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Implicit tvang af en værdi eller type %s til en urelateret type %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Kan ikke åbne den inkluderede fil: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntaksfejl: definition eller instruktion forventet." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntaksfejl: forventede et definitionsnøgleord (fx funktion) efter attributten %s, ikke %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntaksfejl: forventede xml før navneområde." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntaksfejl: forventede catch- eller finally-sætning." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntaksfejl: nøgleordet 'each' er ikke tilladt uden operatoren 'in'." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntaksfejl: forventede en venstreparentes før identifikatoren." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Forventer CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Etiket skal være en enkel identifikator." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Et superudtryk skal have en operand." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Forventede formindskelses- eller forøgelsesoperator." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Forventede et enkelt udtryk inde i parenteserne." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntaksfejl: %s er uventet." ),
           new AscError(kError_Parser_ExpectedToken, "Syntaksfejl: forventede %s før %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntaksfejl: forventede semikolon før %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntaksfejl: ekstra tegn fundet efter programmets afslutning." ),
           new AscError(kError_Lexical_General, "Syntaksfejl." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntaksfejl: En strengekonstant skal afsluttes før linjeskiftet." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntaksfejl: En strengekonstant skal afsluttes før linjeskiftet." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntaksfejl: inputtet sluttede før det afsluttende anførselstegn for en strengekonstant blev nået." ),
           new AscError(kError_Lexical_SyntaxError, "Syntaksfejl." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntaksfejl: XML har ikke start- og slutkoder der passer sammen." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Kan ikke slette superunderordnet." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Dobbelt navneområdedefinition." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Tildelingens mål skal være en referenceværdi." ),
           new AscError(kError_IncrementOperatorNotAReference, "Forøgelsens operand skal være en reference." ),
           new AscError(kError_InvalidIncrementOperand, "Forøgelsens operand er ugyldig." ),
           new AscError(kError_InvalidDecrementOperand, "Formindskelsens operand er ugyldig." ),
           new AscError(kError_ExpectingExpression, "Forventer et udtryk." ),
           new AscError(kError_MissingXMLTagName, "Manglende XML-kodenavn." ),
           new AscError(kError_InvalidAbcFile, "Filen %s er ikke en gyldig ABC-fil." ),
           new AscError(kError_Parser_FileIncludesItself, "Muligvis uendelig rekursion fordi denne fil er medtaget: %s." ),
           new AscError(kError_CircularReference, "Der er fundet en cirkulær typehenvisning i %s." ),
           new AscError(kError_InvalidPublic, "Den offentlige attribut kan kun bruges inden i en pakke." ),
           new AscError(kError_InvalidInternal, "Den interne attribut kan kun bruges inden i en pakke." ),
           new AscError(kError_InvalidNamespace, "En brugerdefineret navneområdeattribut kan kun bruges på det øverste niveau i en klassedefinition." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Implicit tvang af en værdi med den statiske type %s til en muligvis urelateret type %s." ),
           new AscError(kError_UndefinedProperty, "Adgang til en muligvis udefineret egenskab %s gennem en henvisning med statisk type %s." ),
           new AscError(kError_UnfoundProperty, "Adgang til en udefineret egenskab %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Definitionen af en hentefunktion kan ikke have parametre." ),
           new AscError(kError_SetterMustHaveOneParameter, "Definitionen af en indstillingsfunktion skal have præcis én parameter." ),
           new AscError(kError_SetterCannotHaveOptional, "Definitionen af en indstillingsfunktion kan ikke have valgfri parametre." ),
           new AscError(kError_BadGetterReturnType, "Definitionen af en hentefunktions returtype kan ikke være ugyldig." ),
           new AscError(kError_InterfaceMethodWithBody, "Metoder der er defineret i en grænseflade, kan ikke have en krop." ),
           new AscError(kError_FunctionWithoutBody, "Funktioner har ikke en krop." ),
           new AscError(kError_DuplicateAttribute, "Attributten %s er specificeret flere gange." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Dobbelt definition af grænseflade: %s." ),
           new AscError(kError_CtorWithReturnType, "En konstruktør kan ikke specificere en returtype." ),
           new AscError(kError_InvalidClassNesting, "Klasser må ikke være indlejrede." ),
           new AscError(kError_InvalidFinalUsage, "Den afsluttende attribut kan kun bruges på en metode som er defineret i en klasse." ),
           new AscError(kError_InvalidNative, "Den indbyggede attribut kan kun bruges med funktionsdefinitioner." ),
           new AscError(kError_InvalidDynamic, "Den dynamiske attribut kan kun bruges med klassedefinitioner." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntaksfejl: %s er ikke en gyldig type." ),
           new AscError(kError_WrongNumberOfArguments, "Forkert antal argumenter.  Forventede %s." ),
           new AscError(kError_TooManyArguments, "Forkert antal argumenter.  Forventede ikke flere end %s." ),
           new AscError(kError_BadRequiredParameter, "Påkrævede parametre er ikke tilladte efter valgfri parametre." ),
           new AscError(kError_VarInInterface, "Erklæringer af variable er ikke tilladte i grænseflader." ),
           new AscError(kError_InvalidRestDecl, "Parametre som er specificeret efter parameterdefinitionsnøgleordet ...rest, kan kun være en Array-datatype." ),
           new AscError(kError_CannotExtendInterface, "En klasse kan kun udvide en anden klasse, ikke en grænseflade." ),
           new AscError(kError_CannotExtendClass, "En grænseflade kan kun udvide andre grænseflader, men %s er en klasse." ),
           new AscError(kError_InvalidOverrideUsage, "Tilsidesættelsesattributten kan kun bruges på en metode som er defineret i en klasse." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Grænseflademetoden %s i navneområdet %s er implementeret med en inkompatibel signatur i klassen %s." ),
           new AscError(kError_NativeMethodWithBody, "Indbyggede funktioner kan ikke have en krop." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "En konstruktør kan ikke være en hente- eller indstillingsmetode." ),
           new AscError(kError_MissingFilespec, "Der er ikke angivet en AS-kildefil." ),
           new AscError(kError_CannotReturnFromStaticInit, "Det returnerede udsagn kan ikke bruges i statiske initialiseringskoder." ),
           new AscError(kError_InvalidProtected, "Den beskyttede attribut kan kun bruges inden i definitioner af klasseegenskaber." ),
           new AscError(kError_ConflictingNameInNamespace, "Der er en konflikt med definitionen %s i navneområdet %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Der er en konflikt med den nedarvede definition %s i navneområdet %s." ),
           new AscError(kError_ConstructorMustBePublic, "En konstruktør kan kun erklæres offentligt." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Man kan kun specificere en af konstanterne public, private, protected og internal i en definition." ),
           new AscError(kError_InvalidNestedAccessor, "Accessorer kan ikke indlejres inden i andre funktioner." ),
           new AscError(kError_CannotInstantiateInterface, "Grænseflader kan ikke oprettes med den nye operator." ),
           new AscError(kError_BadAccessInterfaceMember, "Grænseflademedlemmer kan ikke erklæres public, private, protected eller internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntaksfejl: manglende venstre klammeparentes ({) før funktionskroppen." ),
           new AscError(kError_CannotReturnFromPackageInit, "Det returnerede udsagn kan ikke bruges i pakkeinitialiseringskoder." ),
           new AscError(kError_InvalidInterfaceNative, "Den indbyggede attribut kan ikke bruges med grænsefladedefinitioner." ),
           new AscError(kError_MultipleNamespaceAttributes, "Der kan kun benyttes én navneområdeattribut pr. definition." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Metoden %s skaber konflikt med definitionen der er nedarvet fra grænsefladen %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Grænsefladeattributten %s er ugyldig." ),
           new AscError(kError_NamespaceInInterface, "Navneområdeerklæringer er ikke tilladte i grænseflader." ),
           new AscError(kError_DuplicateImplements, "Klassen %s implementerer grænsefladen %s flere gange." ),
           new AscError(kError_AssignmentToDefinedFunction, "Ugyldig tildeling til funktionen %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Navneområdeattributter er ikke tilladte i grænseflademetoder." ),
           new AscError(kError_MustReturnValue, "Funktioner returnerer ikke en værdi." ),
           new AscError(kError_InvalidNamespaceInitializer, "Initialisering af et navneområde skal ske med enten en konstant streng eller et andet navneområde." ),
           new AscError(kError_DefinitionNotFound, "Definitionen %s blev ikke fundet." ),
           new AscError(kError_InvalidLabel, "Etiketdefinitionen er ugyldig." ),
           new AscError(kError_IncompatableValueComparison, "Sammenligning af en værdi med den statiske type %s til en muligvis urelateret type %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Det returnerede udsagn kan ikke bruges i globale initialiseringskoder." ),
           new AscError(kError_InaccessiblePropertyReference, "Forsøg på at få adgang til egenskab %s der ikke er adgang til, gennem en henvisning med statisk type %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object er ikke i brug i øjeblikket. Brug :* i stedet." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Kald til en mulig udefineret metode %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Videresend henvisning til basisklassen %s." ),
           new AscError(kError_IllegalPackageReference, "Pakken kan ikke bruges af en værdi: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Inkompatibel standardværdi af typen %s hvor %s er forventet." ),
           new AscError(kError_MultipleSwitchDefaults, "Switch-sætningen har mere end én standarddefinition, men det er kun tilladt at have én." ),
           new AscError(kError_AssignmentToDefinedClass, "Ugyldig tildeling til klassen %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Forsøg på at slette den faste egenskab %s. Kun dynamisk definerede egenskaber kan slettes." ),
           new AscError(kError_InvalidBaseTypeExpression, "Basisklassen blev ikke fundet eller den er ikke en kompileringstidspunktskonstant." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Grænsefladen blev ikke fundet eller den er ikke en kompileringstidspunktskonstant." ),
           new AscError(kError_StaticModifiedNamespace, "Den statiske attribut er ikke tilladt i navneområdedefinitioner." ),
           new AscError(kError_InvalidInterfaceNesting, "Grænsefladedefinitioner må ikke være indlejrede i en klasse eller andre grænsefladedefinitioner." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Prototypeattributten er ugyldig." ),
           new AscError(kError_InaccessibleMethodReference, "Forsøg på at få adgang til metoden %s der ikke er adgang til, gennem en henvisning med statisk type %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntaksfejl: forventede et udtryk efter udløsningen." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Klassen %s kan ikke udvide %s da begge er associeret med bibliotekssymboler eller hovedtidslinjen." ),
           new AscError(kError_AttributesOnPackage, "Attributter er ikke tilladt i pakkedefinitioner." ),
           new AscError(kError_InternalError, "Intern fejl: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntaksfejl: ugyldig for-in-initialisering, der blev kun forventet 1 udtryk." ),
           new AscError(kError_IllegalSuperStatement, "Et superudsagn kan ikke bruges efter udsagnene this, super, return eller throw." ),
           new AscError(kError_UnfoundPackageProperty, "Adgang til en udefineret egenskab %s i pakken %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Der blev ikke fundet en konstruktør i basisklassen %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* fundet uden tilsvarende */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntaksfejl: forventede en venstre klammeparentes ({) eller strengekonstant (\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "Et superudsagn kan kun bruges som det sidste element i en konstruktørinitialiseringsliste." ),
           new AscError(kError_ThisUsedInInitializer, "Nøgleordet kan ikke bruges til initialisering af egenskaber." ),
           new AscError(kError_NonConstantConfigInit, "Initialiseringen for en konfigurationsværdi skal være en kompileringstidspunktskonstant." ),
           new AscError(kError_NonConstConfigVar, "En konfigurationsvariabel kan kun erklæres som const." ),
           new AscError(kError_InvalidConfigLocation, "En konfigurationsværdi skal erklæres på et programs eller en pakkes øverste niveau." ),
           new AscError(kError_ShadowedConfigNamespace, "Navneområdet %s skaber konflikt med en konfigurationsnavneområde." ),
           new AscError(kError_InvalidPrecision, "Præcision skal være et heltal mellem 1 og 34." ),
           new AscError(kError_WrongVersion, "Inkompatibel version: kan ikke henvise til definitionen %s introduceret i version %s fra kode med version %s." ),
           new AscError(kError_LossyConversion, "Ugyldig initialisering: Der mistes data ved konvertering til typen %s." ),
   };

   public static final AscError[] errorConstantsDE = { 
           new AscError(kError_AmbiguousReference, "Unklarer Verweis auf %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Zugriffsspezifikatoren sind in Kombination mit Namespace-Attributen nicht zulässig." ),
           new AscError(kError_Unknown_Namespace, "Namespace wurde nicht gefunden oder ist keine Kompilierungszeit-Konstante." ),
           new AscError(kError_InvalidSuperExpression, "Super-Ausdrücke können nur innerhalb von Klasseninstanzmethoden verwendet werden." ),
           new AscError(kError_InvalidSuperStatement, "Super-Anweisungen können nur innerhalb von Klasseninstanzkonstruktoren verwendet werden." ),
           new AscError(kError_InvalidAttribute, "Ungültiges Attribut." ),
           new AscError(kError_InvalidOverride, "Das override-Attribut kann nur für Klasseneigenschaftendefinitionen verwendet werden." ),
           new AscError(kError_InvalidVirtual, "Das virtual-Attribut kann nur für Klasseneigenschaftendefinitionen verwendet werden." ),
           new AscError(kError_InvalidStatic, "Das static-Attribut kann nur für Definitionen innerhalb einer Klasse verwendet werden." ),
           new AscError(kError_InvalidPrivate, "Das private-Attribut kann nur für Klasseneigenschaftendefinitionen verwendet werden." ),
           new AscError(kError_Unsupported_Intrinsic, "Das intrinsic-Attribut wird nicht mehr unterstützt." ),
           new AscError(kError_BaseClassIsFinal, "Basisklasse ist endgültig." ),
           new AscError(kError_UnknownBaseClass, "Die Definition der Basisklasse %s wurde nicht gefunden." ),
           new AscError(kError_DuplicateClassDefinition, "Doppelte Klassendefinition: %s." ),
           new AscError(kError_OverrideNotFound, "Mit 'override' gekennzeichnete Methode muss eine andere Methode außer Kraft setzen." ),
           new AscError(kError_DuplicateFunction, "Doppelte Funktionsdefinition." ),
           new AscError(kError_OverrideFinalAccessor, "Endgültiger Zugriff kann nicht außer Kraft gesetzt werden." ),
           new AscError(kError_IncompatibleOverride, "Nicht zulässiges außer Kraft Setzen." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Eine nicht für 'override' gekennzeichnete Funktion wird außer Kraft gesetzt." ),
           new AscError(kError_FinalMethodRedefinition, "Eine endgültige Methode kann nicht neu definiert werden." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Konstruktorfunktionen müssen Instanzmethoden sein." ),
           new AscError(kError_FuncIsStaticAndOverride, "Für Funktionen kann nicht gleichzeitig 'static' und 'override' gelten." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Für Funktionen kann nicht gleichzeitig 'static' und 'virtual' gelten." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Für Funktionen kann nicht gleichzeitig 'final' und 'virtual' gelten." ),
           new AscError(kError_RestParameterNotNamed, "Name des variablen Argument-Arrays muss angegeben werden." ),
           new AscError(kError_VirtualVars, "Virtuelle Variablen werden nicht unterstützt." ),
           new AscError(kError_NativeVars, "Variablen dürfen nicht nativ sein." ),
           new AscError(kError_VarIsFinalAndVirtual, "Für Variablen kann nicht gleichzeitig 'final' und 'virtual' gelten." ),
           new AscError(kError_NestedPackage, "Pakete dürfen nicht verschachtelt sein." ),
           new AscError(kError_BreakHasNoTarget, "Ziel der Anweisung 'break' wurde nicht gefunden." ),
           new AscError(kError_ContinueHasNoTarget, "Ziel der Anweisung 'continue' wurde nicht gefunden." ),
           new AscError(kError_DuplicateLabel, "Doppelte Labeldefinition." ),
           new AscError(kError_AttributesAreNotCallable, "Attribute sind nicht aufrufbar." ),
           new AscError(kError_ThisUsedInStaticFunction, "Dieses Schlüsselwort kann in statischen Methoden nicht verwendet werden. Es kann nur in Instanzmethoden, Funktionsauflösungen und globalem Code verwendet werden." ),
           new AscError(kError_UndefinedNamespace, "Nicht definierter Namespace." ),
           new AscError(kError_UnknownInterfaceMethod, "Schnittstellenmethode %s in Namespace %s nicht durch Klasse %s implementiert." ),
           new AscError(kError_UnknownInterface, "Schnittstelle %s wurde nicht gefunden." ),
           new AscError(kError_UnknownType, "Typ wurde nicht gefunden oder war keine Kompilierungszeit-Konstante: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parameterinitialisierer unbekannt oder keine Kompilierungszeit-Konstante." ),
           new AscError(kError_MethodIsNotAConstructor, "Methode kann nicht als Konstruktor verwendet werden." ),
           new AscError(kError_AssignmentToConstVar, "Unzulässige Zuweisung zu einer als Konstante angegebenen Variablen." ),
           new AscError(kError_AssignmentToNonRefVar, "Zuweisung zu einem Wert ohne integrierte Verweisfunktion nicht möglich." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Rückgabewert darf nicht definiert sein." ),
           new AscError(kError_ConstInitializerNotConst, "Konstanteninitialisierer unbekannt oder keine Kompilierungszeit-Konstante." ),
           new AscError(kError_AccessorTypesMustMatch, "Zugriffsarten müssen übereinstimmen." ),
           new AscError(kError_BadSetterReturnType, "Rückgabetyp einer setter-Definition muss 'unspecified' oder 'void' sein." ),
           new AscError(kError_PropertyIsWriteOnly, "Eigenschaft verfügt über Schreibzugriff." ),
           new AscError(kError_PropertyIsReadOnly, "Eigenschaft ist schreibgeschützt." ),
           new AscError(kError_Strict_UndefinedMethod, "Aufruf für eine möglicherweise nicht definierte Methode %s über einen Verweis mit statischem Typ %s." ),
           new AscError(kError_UnableToOpenFile, "Datei konnte nicht geöffnet werden: %s." ),
           new AscError(kError_InvalidMetaData, "Ungültige Metadaten." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Metadaten-Attribute dürfen nur ein Element enthalten." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Implizite Umwandlung eines Werts des Typs %s in einen nicht verwandten Typ %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Enthaltene Datei konnte nicht geöffnet werden: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntaxfehler: Definition oder Direktive erforderlich." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntaxfehler: Definitionsschlüsselwort (z. B. 'function') wurde nicht nach %s, sondern nach Attribut %s erwartet." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntaxfehler: xml vor namespace erforderlich." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntaxfehler: catch- oder finally-Klausel erforderlich." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntaxfehler: each-Schlüsselwort ohne in-Operator nicht zulässig." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntaxfehler: öffnende Klammer vor Bezeichner erforderlich." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel erforderlich." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Label muss ein einfacher Bezeichner sein." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Ein Super-Ausdruck muss über einen Operanden verfügen." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Inkrement- oder Dekrement-Operator erforderlich." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Einfacher Ausdruck in Klammern erforderlich." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntaxfehler: %s wurde nicht erwartet." ),
           new AscError(kError_Parser_ExpectedToken, "Syntaxfehler: %s vor %s erforderlich." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntaxfehler: Semikolon vor %s erforderlich." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntaxfehler: zusätzliche Zeichen wurden nach Ende des Programms gefunden." ),
           new AscError(kError_Lexical_General, "Syntaxfehler." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntaxfehler: Ein Stringliteral muss vor dem Zeilenumbruch beendet werden." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntaxfehler: Ein Stringliteral muss vor dem Zeilenumbruch beendet werden." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntaxfehler: Eingabe wurde vor Erreichen der schließenden Anführungszeichen für ein Stringliteral beendet." ),
           new AscError(kError_Lexical_SyntaxError, "Syntaxfehler." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntaxfehler: XML verfügt nicht über zueinander passende Anfangs- und Endtags." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Löschen von super-Nachkommen nicht möglich." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Doppelte Namespace-Definition." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Ziel der Zuweisung muss ein Verweiswert sein." ),
           new AscError(kError_IncrementOperatorNotAReference, "Operand des Inkrements muss ein Verweis sein." ),
           new AscError(kError_InvalidIncrementOperand, "Ungültiger Inkrement-Operand." ),
           new AscError(kError_InvalidDecrementOperand, "Ungültiger Dekrement-Operand." ),
           new AscError(kError_ExpectingExpression, "Ausdruck erforderlich." ),
           new AscError(kError_MissingXMLTagName, "Fehlender XML-Tagname." ),
           new AscError(kError_InvalidAbcFile, "Die Datei %s ist keine gültige ABC-Datei." ),
           new AscError(kError_Parser_FileIncludesItself, "Mögliche infinite Rekursion aufgrund dieser Datei: %s." ),
           new AscError(kError_CircularReference, "Ringverweis wurde in %s gefunden." ),
           new AscError(kError_InvalidPublic, "Das public-Attribut kann nur innerhalb eines Pakets verwendet werden." ),
           new AscError(kError_InvalidInternal, "Das internal-Attribut kann nur innerhalb eines Pakets verwendet werden." ),
           new AscError(kError_InvalidNamespace, "Ein benutzerdefiniertes Namespace-Attribut kann nur auf der obersten Ebene einer Klassendefinition verwendet werden." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Implizite Umwandlung von einem Wert mit statischem Typ %s in einen möglicherweise nicht verwandten Typ %s." ),
           new AscError(kError_UndefinedProperty, "Zugriff auf eine möglicherweise nicht definierte Eigenschaft %s über einen Verweis mit statischem Typ %s" ),
           new AscError(kError_UnfoundProperty, "Zugriff auf eine nicht definierte Eigenschaft %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Eine getter-Definition darf keine Parameter enthalten." ),
           new AscError(kError_SetterMustHaveOneParameter, "Eine setter-Definition muss genau einen Parameter enthalten." ),
           new AscError(kError_SetterCannotHaveOptional, "Eine setter-Definition darf nicht über optionale Parameter verfügen." ),
           new AscError(kError_BadGetterReturnType, "Rückgabetyp einer getter-Definition darf nicht 'void' sein." ),
           new AscError(kError_InterfaceMethodWithBody, "In einer Schnittstelle definierte Methoden dürfen keinen Hauptteil haben." ),
           new AscError(kError_FunctionWithoutBody, "Funktion enthält keinen Hauptteil." ),
           new AscError(kError_DuplicateAttribute, "Das Attribut %s wurde mehrfach angegeben." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Doppelte Schnittstellendefinition: %s." ),
           new AscError(kError_CtorWithReturnType, "Ein Konstruktor kann keinen Rückgabetyp angeben." ),
           new AscError(kError_InvalidClassNesting, "Klassen dürfen nicht verschachtelt werden." ),
           new AscError(kError_InvalidFinalUsage, "Das final-Attribut kann nur für eine in einer Klasse definierte Methode verwendet werden." ),
           new AscError(kError_InvalidNative, "Das native-Attribut kann nur mit Funktionsdefinitionen verwendet werden." ),
           new AscError(kError_InvalidDynamic, "Das dynamic-Attribut kann nur mit Klassendefinitionen verwendet werden." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntaxfehler: %s ist kein gültiger Typ." ),
           new AscError(kError_WrongNumberOfArguments, "Falsche Anzahl von Argumenten. %s erforderlich." ),
           new AscError(kError_TooManyArguments, "Falsche Anzahl von Argumenten. Nicht mehr als %s erwartet." ),
           new AscError(kError_BadRequiredParameter, "Erforderliche Parameter sind nach optionalen Parametern nicht zulässig." ),
           new AscError(kError_VarInInterface, "Variablendeklarationen sind in Schnittstellen nicht zulässig." ),
           new AscError(kError_InvalidRestDecl, "Nach dem Parameterdefinitionsschlüsselwort '...rest' angegebene Parameter können nur vom Array-Datentyp sein." ),
           new AscError(kError_CannotExtendInterface, "Eine Klasse kann nur eine andere Klasse, jedoch keine Schnittstelle erweitern." ),
           new AscError(kError_CannotExtendClass, "Eine Schnittstelle kann nur andere Schnittstellen erweitern, %s ist jedoch eine Klasse." ),
           new AscError(kError_InvalidOverrideUsage, "Das override-Attribut kann nur für eine in einer Klasse definierte Methode verwendet werden." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Die Schnittstellenmethode %s in Namespace %s wird mit einer inkompatiblen Signatur in Klasse %s implementiert." ),
           new AscError(kError_NativeMethodWithBody, "Native Methoden können nicht über einen Hauptteil verfügen." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Ein Konstruktor kann keine Get- oder Set-Methode sein." ),
           new AscError(kError_MissingFilespec, "Eine AS-Quelldatei wurde nicht definiert." ),
           new AscError(kError_CannotReturnFromStaticInit, "Die return-Anweisung kann im statischen Initialisierungscode verwendet werden." ),
           new AscError(kError_InvalidProtected, "Das protected-Attribut kann nur für Definitionen von  Klasseneigenschaften verwendet werden." ),
           new AscError(kError_ConflictingNameInNamespace, "In Definition %s im Namespace %s liegt ein Konflikt vor." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "In der übernommenen Definition %s im Namespace %s liegt ein Konflikt vor." ),
           new AscError(kError_ConstructorMustBePublic, "Ein Konstruktor kann nur als 'public' deklariert werden." ),
           new AscError(kError_ConflictingAccessSpecifiers, "In einer Definition kann nur eine Instanz von 'public', 'private', 'protected' oder 'internal' angegeben werden." ),
           new AscError(kError_InvalidNestedAccessor, "Zugriffsmodule dürfen nicht in anderen Funktionen verschachtelt sein." ),
           new AscError(kError_CannotInstantiateInterface, "Schnittstellen dürfen nicht mit dem neuen Operator instanziiert werden." ),
           new AscError(kError_BadAccessInterfaceMember, "Schnittstellenmitglieder dürfen nicht als 'public', 'private', 'protected' oder 'internal' deklariert werden." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntaxfehler: Vor dem Funktionstext fehlt die linke Klammer ({)." ),
           new AscError(kError_CannotReturnFromPackageInit, "Die return-Anweisung kann im Initialisierungscode des Pakets nicht verwendet werden." ),
           new AscError(kError_InvalidInterfaceNative, "Das native-Attribut kann nicht in Schnittstellendefinitionen verwendet werden." ),
           new AscError(kError_MultipleNamespaceAttributes, "Pro Definition darf nur ein Namespace-Attribut verwendet werden." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Methode %s steht in Konflikt mit der aus Schnittstelle %s übernommenen Definition." ),
           new AscError(kError_InvalidInterfaceAttribute, "Schnittstellenattribut %s ist ungültig." ),
           new AscError(kError_NamespaceInInterface, "Namespace-Deklarationen sind in Schnittstellen nicht zulässig." ),
           new AscError(kError_DuplicateImplements, "In Klasse %s ist die Schnittstelle %s mehrfach implementiert." ),
           new AscError(kError_AssignmentToDefinedFunction, "Unzulässige Zuweisung zu Funktion %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Namespace-Attribute sind für Schnittstellenmethoden nicht zulässig." ),
           new AscError(kError_MustReturnValue, "Funktion gibt keinen Wert zurück." ),
           new AscError(kError_InvalidNamespaceInitializer, "Eine Namespace-Initialisierung muss entweder ein Literalstring oder ein anderer Namespace sein." ),
           new AscError(kError_DefinitionNotFound, "Definition %s wurde nicht gefunden." ),
           new AscError(kError_InvalidLabel, "Bezeichnungsdefinition ist ungültig." ),
           new AscError(kError_IncompatableValueComparison, "Vergleich zwischen einem Wert mit statischem Typ %s und einem möglicherweise nicht verwandten Typ %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Die return-Anweisung kann im globalen Initialisierungscode verwendet werden." ),
           new AscError(kError_InaccessiblePropertyReference, "Versuchter Aufruf einer nicht verfügbaren Eigenschaft %s über einen Verweis mit statischem Typ %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Objekt ist vorübergehend nicht verfügbar. Verwenden Sie stattdessen :*." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Aufruf einer möglicherweise undefinierten Methode %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Verweis an Basisklasse %s weiterleiten." ),
           new AscError(kError_IllegalPackageReference, "Paket kann nicht als Wert verwendet werden: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Inkompatibler Standardwert vom Typ %s, bei dem %s erwartet wird." ),
           new AscError(kError_MultipleSwitchDefaults, "Für 'switch' sind mehrere Standardwerte vorhanden, es ist jedoch nur ein Standardwert zulässig." ),
           new AscError(kError_AssignmentToDefinedClass, "Unzulässige Zuweisung zu Klasse %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Es wird versucht, die feste Eigenschaft %s zu löschen. Nur dynamisch definierte Eigenschaften können gelöscht werden." ),
           new AscError(kError_InvalidBaseTypeExpression, "Basisklasse wurde nicht gefunden oder ist keine Kompilierungszeit-Konstante." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Schnittstelle wurde nicht gefunden oder ist keine Kompilierungszeit-Konstante." ),
           new AscError(kError_StaticModifiedNamespace, "Das static-Attribut ist in Namespace-Definitionen nicht zulässig." ),
           new AscError(kError_InvalidInterfaceNesting, "Schnittstellendefinitionen dürfen nicht in Klassen oder anderen Schnittstellendefinitionen verschachtelt werden." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Das prototype-Attribut ist ungültig." ),
           new AscError(kError_InaccessibleMethodReference, "Versuchter Aufruf der nicht verfügbaren Methode %s über einen Verweis mit statischem Typ %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntaxfehler: Nach dem Throw wird eine Ausdruck erwartet." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Die Klasse %s kann nicht mit %s erweitert werden, da beide Bibliothekssymbolen oder der Hauptzeitleiste zugewiesen sind." ),
           new AscError(kError_AttributesOnPackage, "Attribute sind in Definitionen von Paketen nicht zulässig." ),
           new AscError(kError_InternalError, "Interner Fehler: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntaxfehler: Ungültige for-in-Initialisierung, nur 1 Ausdruck erwartet." ),
           new AscError(kError_IllegalSuperStatement, "Eine super-Anweisung darf nicht einer this-, super-, return- oder throw-Anweisung folgen." ),
           new AscError(kError_UnfoundPackageProperty, "Zugriff auf die undefinierte Eigenschaft %s in Paket %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Kein Standardkonstruktor in Basisklasse %s gefunden." ),
           new AscError(kError_BlockCommentNotTerminated, "/* gefunden ohne Übereinstimmung mit */." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntaxfehler: linke geschweifte Klammer ({) oder Stringliteral (\"\") erwartet." ),
           new AscError(kError_InvalidES4SuperStatement, "super-Anweisungen können nur als letztes Element in einer Konstruktor-Initialisierungsliste verwendet werden." ),
           new AscError(kError_ThisUsedInInitializer, "Dieses Schlüsselwort kann nicht in Initialisierungsoperatoren für Eigenschaften verwendet werden." ),
           new AscError(kError_NonConstantConfigInit, "Initialisierungsoperatoren für Konfigurationswerte müssen Kompilierzeitkonstanten sein." ),
           new AscError(kError_NonConstConfigVar, "Konfigurationsvariablen können nur als Konstanten deklariert werden." ),
           new AscError(kError_InvalidConfigLocation, "Konfigurationswerte müssen auf der obersten Ebene eines Programms oder Pakets deklariert werden." ),
           new AscError(kError_ShadowedConfigNamespace, "Namespace %s konfligiert mit einem Konfigurations-Namespace." ),
           new AscError(kError_InvalidPrecision, "Präzision muss eine ganze Zahl zwischen 1 und 34 sein." ),
           new AscError(kError_WrongVersion, "Inkompatible Version: Definition %s, die aus Code von Version %s eingeführt wurde, kann nicht mit Version %s referenziert werden." ),
           new AscError(kError_LossyConversion, "Ungültige Initialisierung: Konvertierung in Typ „%s“ führt zu Datenverlust." ),
   };

   public static final AscError[] errorConstantsES = { 
           new AscError(kError_AmbiguousReference, "Referencia ambigua a %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "No se permiten los especificadores de acceso con atributos de espacio de nombres." ),
           new AscError(kError_Unknown_Namespace, "No se encontró el espacio de nombres o no es una constante en tiempo de compilación." ),
           new AscError(kError_InvalidSuperExpression, "Una expresión super sólo se puede utilizar dentro de métodos de instancia de clase." ),
           new AscError(kError_InvalidSuperStatement, "Una sentencia super sólo se puede utilizar dentro de constructores de instancia de clase." ),
           new AscError(kError_InvalidAttribute, "El atributo no es válido." ),
           new AscError(kError_InvalidOverride, "El atributo override sólo se puede utilizar en definiciones de propiedad de clase." ),
           new AscError(kError_InvalidVirtual, "El atributo virtual sólo se puede utilizar en definiciones de propiedad de clase." ),
           new AscError(kError_InvalidStatic, "El atributo static sólo se puede utilizar en definiciones dentro de una clase." ),
           new AscError(kError_InvalidPrivate, "El atributo private sólo se puede utilizar en definiciones de propiedad de clase." ),
           new AscError(kError_Unsupported_Intrinsic, "El atributo intrinsic ya no se admite." ),
           new AscError(kError_BaseClassIsFinal, "La clase base es final." ),
           new AscError(kError_UnknownBaseClass, "No se encontró la definición de la clase base %s." ),
           new AscError(kError_DuplicateClassDefinition, "Definición de clase duplicada: %s." ),
           new AscError(kError_OverrideNotFound, "El método marcado como override debe sustituir a otro método." ),
           new AscError(kError_DuplicateFunction, "Definición de función duplicada." ),
           new AscError(kError_OverrideFinalAccessor, "No se puede sustituir un descriptor de acceso final." ),
           new AscError(kError_IncompatibleOverride, "Sustitución no compatible." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Sustitución de una función no marcada como override." ),
           new AscError(kError_FinalMethodRedefinition, "No se puede redefinir un método final." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Las funciones de constructor deben ser métodos de instancia." ),
           new AscError(kError_FuncIsStaticAndOverride, "Las funciones no pueden ser al mismo tiempo static y override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Las funciones no pueden ser al mismo tiempo static y virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Las funciones no pueden ser al mismo tiempo final y virtual." ),
           new AscError(kError_RestParameterNotNamed, "Debe especificar el nombre de la matriz de argumentos de variable." ),
           new AscError(kError_VirtualVars, "Las variables virtual no se admiten." ),
           new AscError(kError_NativeVars, "Las variables no pueden ser nativas." ),
           new AscError(kError_VarIsFinalAndVirtual, "Las variables no pueden ser al mismo tiempo final y virtual." ),
           new AscError(kError_NestedPackage, "Los paquetes no se pueden anidar." ),
           new AscError(kError_BreakHasNoTarget, "No se encontró el destino de la sentencia break." ),
           new AscError(kError_ContinueHasNoTarget, "No se encontró el destino de la sentencia continue." ),
           new AscError(kError_DuplicateLabel, "Definición de etiqueta duplicada." ),
           new AscError(kError_AttributesAreNotCallable, "No se puede llamar a los atributos." ),
           new AscError(kError_ThisUsedInStaticFunction, "La palabra clave this no se puede utilizar en métodos static. Sólo se puede utilizar en métodos de instancia, cierres de funciones y código global." ),
           new AscError(kError_UndefinedNamespace, "Espacio de nombres no definido." ),
           new AscError(kError_UnknownInterfaceMethod, "El método de interfaz %s del espacio de nombres %s no se implementa con la clase %s." ),
           new AscError(kError_UnknownInterface, "No se encontró la interfaz %s." ),
           new AscError(kError_UnknownType, "No se encontró el tipo o no es una constante en tiempo de compilación: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Se desconoce el inicializador de parámetros o no es una constante en tiempo de compilación." ),
           new AscError(kError_MethodIsNotAConstructor, "No se puede utilizar el método como constructor." ),
           new AscError(kError_AssignmentToConstVar, "Asignación no válida a una variable especificada como constante." ),
           new AscError(kError_AssignmentToNonRefVar, "No se puede asignar a un valor sin referencia." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "El valor devuelto no debe estar definido." ),
           new AscError(kError_ConstInitializerNotConst, "Se desconoce el inicializador de constantes o no es una constante en tiempo de compilación." ),
           new AscError(kError_AccessorTypesMustMatch, "Los tipos de descriptor de acceso deben coincidir." ),
           new AscError(kError_BadSetterReturnType, "El tipo devuelto de una definición de establecimiento debe ser unspecified o void." ),
           new AscError(kError_PropertyIsWriteOnly, "La propiedad es de sólo escritura." ),
           new AscError(kError_PropertyIsReadOnly, "La propiedad es de sólo lectura." ),
           new AscError(kError_Strict_UndefinedMethod, "Llamada a un método %s posiblemente no definido mediante una referencia con tipo estático %s." ),
           new AscError(kError_UnableToOpenFile, "No se puede abrir el archivo: %s." ),
           new AscError(kError_InvalidMetaData, "Metadatos no válidos." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Los atributos de metadatos no pueden tener más de un elemento." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Conversión implícita de un valor de tipo %s a un tipo %s no relacionado." ),
           new AscError(kError_Parser_UnableToOpenFile, "No se puede abrir el archivo incluido: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Error de sintaxis: se esperaba una definición o directiva." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Error de sintaxis: se esperaba una palabra clave de definición (como function) después del atributo %s, no %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Error de sintaxis: se esperaba xml antes del espacio de nombres." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Error de sintaxis: se esperaba una cláusula catch o finally." ),
           new AscError(kError_Parser_EachWithoutIn, "Error de sintaxis: la palabra clave 'each' no se admite sin un operador 'in'." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Error de sintaxis: se esperaba el paréntesis de apertura antes del identificador." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Se esperaba CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "La etiqueta debe ser un identificador sencillo." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Una expresión super debe tener un operando." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Se esperaba un operador de incremento o decremento." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Se esperaba una sola expresión entre paréntesis." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Error de sintaxis: no se esperaba %s." ),
           new AscError(kError_Parser_ExpectedToken, "Error de sintaxis: se esperaba %s antes de %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Error de sintaxis: se esperaba un punto y coma antes de %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Error de sintaxis: se encontraron caracteres adicionales tras el final del programa." ),
           new AscError(kError_Lexical_General, "Error de sintaxis." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Error de sintaxis: un literal de cadena debe terminarse antes del salto de línea." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Error de sintaxis: un literal de cadena debe terminarse antes del salto de línea." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Error de sintaxis: entrada finalizada antes de alcanzar las comillas de cierre de un literal de cadena." ),
           new AscError(kError_Lexical_SyntaxError, "Error de sintaxis." ),
           new AscError(kError_Lexical_NoMatchingTag, "Error de sintaxis: la etiqueta inicial y la etiqueta final de XML no coinciden." ),
           new AscError(kError_CannotDeleteSuperDecendants, "No se pueden eliminar los descendientes de super." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Definición de espacio de nombres duplicada." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "El destino de la asignación debe ser un valor de referencia." ),
           new AscError(kError_IncrementOperatorNotAReference, "El operando de incremento debe ser una referencia." ),
           new AscError(kError_InvalidIncrementOperand, "El operando de incremento no es válido." ),
           new AscError(kError_InvalidDecrementOperand, "El operando de decremento no es válido." ),
           new AscError(kError_ExpectingExpression, "Se esperaba una expresión." ),
           new AscError(kError_MissingXMLTagName, "Falta el nombre de la etiqueta XML." ),
           new AscError(kError_InvalidAbcFile, "El archivo %s no es un archivo ABC válido." ),
           new AscError(kError_Parser_FileIncludesItself, "La posible recursión infinita debida a este archivo incluido: %s." ),
           new AscError(kError_CircularReference, "Se detectó una referencia de tipo circular en %s." ),
           new AscError(kError_InvalidPublic, "El atributo public sólo se puede utilizar dentro de un paquete." ),
           new AscError(kError_InvalidInternal, "El atributo internal sólo se puede utilizar dentro de un paquete." ),
           new AscError(kError_InvalidNamespace, "Un atributo de espacio de nombres definido por el usuario sólo se puede utilizar en el nivel superior de una definición de clase." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Conversión implícita de un valor con tipo estático %s a un tipo %s posiblemente no relacionado." ),
           new AscError(kError_UndefinedProperty, "Acceso a una propiedad %s posiblemente no definida mediante una referencia con tipo estático %s." ),
           new AscError(kError_UnfoundProperty, "Acceso a una propiedad %s no definida." ),
           new AscError(kError_GetterCannotHaveParameters, "Una definición captadora no debe tener parámetros." ),
           new AscError(kError_SetterMustHaveOneParameter, "Una definición de establecimiento debe tener exactamente un parámetro." ),
           new AscError(kError_SetterCannotHaveOptional, "Una definición de establecimiento no puede tener parámetros opcionales." ),
           new AscError(kError_BadGetterReturnType, "El tipo devuelto de una definición captadora no debe ser void." ),
           new AscError(kError_InterfaceMethodWithBody, "Los métodos definidos en una interfaz no pueden tener cuerpo." ),
           new AscError(kError_FunctionWithoutBody, "Las función no tiene cuerpo." ),
           new AscError(kError_DuplicateAttribute, "El atributo %s se especificó varias veces." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Definición de interfaz duplicada: %s." ),
           new AscError(kError_CtorWithReturnType, "Un constructor no puede especificar un tipo devuelto." ),
           new AscError(kError_InvalidClassNesting, "Las clases no deben anidarse." ),
           new AscError(kError_InvalidFinalUsage, "El atributo final sólo se puede utilizar en un método definido en una clase." ),
           new AscError(kError_InvalidNative, "El atributo native sólo se puede utilizar con definiciones de función." ),
           new AscError(kError_InvalidDynamic, "El atributo dynamic sólo se puede utilizar con definiciones de clase." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Error de sintaxis: %s no es un tipo válido." ),
           new AscError(kError_WrongNumberOfArguments, "Número de argumentos incorrecto.  Se esperaba %s." ),
           new AscError(kError_TooManyArguments, "Número de argumentos incorrecto.  No se esperaba más de %s." ),
           new AscError(kError_BadRequiredParameter, "Los parámetros necesarios no se permiten después de los parámetros opcionales." ),
           new AscError(kError_VarInInterface, "Las interfaces no admiten declaraciones de variables." ),
           new AscError(kError_InvalidRestDecl, "Los parámetros especificados después de la palabra clave de definición de parámetro ...rest sólo pueden ser un tipo de datos Array." ),
           new AscError(kError_CannotExtendInterface, "Una clase sólo puede ampliar otra clase, no una interfaz." ),
           new AscError(kError_CannotExtendClass, "Una interfaz sólo puede ampliar otras interfaces, pero %s es una clase." ),
           new AscError(kError_InvalidOverrideUsage, "El atributo override sólo se puede utilizar en un método definido en una clase." ),
           new AscError(kError_IncompatibleInterfaceMethod, "El método de interfaz %s del espacio de nombres %s está implementado con una firma no compatible en la clase %s." ),
           new AscError(kError_NativeMethodWithBody, "Los métodos nativos no pueden tener cuerpo." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Un constructor no puede ser un método getter o setter." ),
           new AscError(kError_MissingFilespec, "No se especificó ningún archivo AS de origen." ),
           new AscError(kError_CannotReturnFromStaticInit, "La sentencia return no se puede utilizar en código de inicialización estático." ),
           new AscError(kError_InvalidProtected, "El atributo protected sólo se puede utilizar en definiciones de propiedad de clase." ),
           new AscError(kError_ConflictingNameInNamespace, "Existe un conflicto con la definición %s del espacio de nombres %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Existe un conflicto con la definición heredada %s del espacio de nombres %s." ),
           new AscError(kError_ConstructorMustBePublic, "Un constructor sólo puede declararse como public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "En una definición, sólo se puede especificar una instancia de public, private, protected o internal." ),
           new AscError(kError_InvalidNestedAccessor, "Los descriptores de acceso no se pueden anidar dentro de otras funciones." ),
           new AscError(kError_CannotInstantiateInterface, "No se pueden crear instancias de las interfaces con el operador new." ),
           new AscError(kError_BadAccessInterfaceMember, "Los miembros de la interfaz no se pueden declarar como public, private, protected o internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Error de sintaxis: falta la llave izquierda de apertura ({) antes del cuerpo de la función." ),
           new AscError(kError_CannotReturnFromPackageInit, "La sentencia devuelta no se puede utilizar en código de inicialización de paquetes." ),
           new AscError(kError_InvalidInterfaceNative, "El atributo native no se puede utilizar en definiciones de interfaz." ),
           new AscError(kError_MultipleNamespaceAttributes, "Sólo se puede utilizar un atributo de espacio de nombres por definición." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Existe un conflicto entre el método %s y la definición heredada de la interfaz %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "El atributo de interfaz %s no es válido." ),
           new AscError(kError_NamespaceInInterface, "Las interfaces no admiten declaraciones de espacio de nombres." ),
           new AscError(kError_DuplicateImplements, "La clase %s implementa la interfaz %s varias veces." ),
           new AscError(kError_AssignmentToDefinedFunction, "Asignación no válida a la función %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Los métodos de interfaz no admiten atributos de espacio de nombres." ),
           new AscError(kError_MustReturnValue, "La función no devuelve un valor." ),
           new AscError(kError_InvalidNamespaceInitializer, "Un inicializador de espacio de nombres debe ser un literal de cadena u otro espacio de nombres." ),
           new AscError(kError_DefinitionNotFound, "No se encontró la definición %s." ),
           new AscError(kError_InvalidLabel, "La definición de etiqueta no es válida." ),
           new AscError(kError_IncompatableValueComparison, "Comparación entre un valor con tipo estático %s y un tipo %s posiblemente no relacionado." ),
           new AscError(kError_CannotReturnFromGlobalInit, "La sentencia return no se puede utilizar en código de inicialización global." ),
           new AscError(kError_InaccessiblePropertyReference, "Intento de acceso a una propiedad %s no accesible mediante una referencia con tipo estático %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object está fuera de servicio temporalmente. Utilice :* en su lugar." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Llamada a un método %s posiblemente no definido." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Referencia a la clase base %s, que se define más adelante" ),
           new AscError(kError_IllegalPackageReference, "No se puede utilizar el paquete como un valor: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Valor predeterminado no compatible de tipo %s donde se esperaba %s." ),
           new AscError(kError_MultipleSwitchDefaults, "El conmutador tiene más de un valor predeterminado, pero sólo se admite uno." ),
           new AscError(kError_AssignmentToDefinedClass, "Asignación no válida a la clase %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Intento de eliminación de la propiedad fija %s.  Sólo se pueden eliminar propiedades definidas dinámicamente." ),
           new AscError(kError_InvalidBaseTypeExpression, "No se encontró la clase base o no es una constante en tiempo de compilación." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "No se encontró la interfaz o no es una constante en tiempo de compilación." ),
           new AscError(kError_StaticModifiedNamespace, "El atributo static no se admite en definiciones de espacio de nombres." ),
           new AscError(kError_InvalidInterfaceNesting, "Las definiciones de interfaz no se pueden anidar dentro de la clase o de otras definiciones de interfaz." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "El atributo prototype no es válido." ),
           new AscError(kError_InaccessibleMethodReference, "Intento de acceso a un método %s no accesible mediante una referencia con tipo estático %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Error de sintaxis: se esperaba una expresión después de la sentencia throw." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "La clase %s no puede ampliar %s, ya que ambas están asociadas a símbolos de biblioteca o a la línea de tiempo principal." ),
           new AscError(kError_AttributesOnPackage, "La definición de paquetes no admite atributos." ),
           new AscError(kError_InternalError, "Error interno: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Error de sintaxis: inicializador for-in no válido; sólo se esperaba 1 expresión." ),
           new AscError(kError_IllegalSuperStatement, "Una sentencia super no puede aparecer después de una sentencia this, super, return o throw." ),
           new AscError(kError_UnfoundPackageProperty, "Acceso a una propiedad %s no definida en el paquete %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "No se encontró ningún constructor predefinido en la clase base %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* encontrado sin coincidencia con */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Error de sintaxis: se esperaba una llave izquierda de apertura ({) o un literal de cadena (\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "Una sentencia super sólo se puede utilizar como el último elemento de la lista de inicializadores de un constructor." ),
           new AscError(kError_ThisUsedInInitializer, "La palabra clave this no se puede utilizar en inicializadores de propiedades." ),
           new AscError(kError_NonConstantConfigInit, "El inicializador de un valor de configuración debe ser una constante en tiempo de compilación." ),
           new AscError(kError_NonConstConfigVar, "Una variable de configuración sólo se puede declarar const." ),
           new AscError(kError_InvalidConfigLocation, "Debe declararse un valor de configuración en el nivel superior de un programa o paquete." ),
           new AscError(kError_ShadowedConfigNamespace, "Existe un conflicto entre el espacio de nombres %s y un espacio de nombres de configuración." ),
           new AscError(kError_InvalidPrecision, "La precisión debe ser un número entero entre 1 y 34." ),
           new AscError(kError_WrongVersion, "Versión no compatible: no se puede hacer referencia a la definición %s introducida en la versión %s del código con la versión %s." ),
           new AscError(kError_LossyConversion, "Inicialización no válida: la conversión a tipo %s pierde datos." ),
   };

   public static final AscError[] errorConstantsFI = { 
           new AscError(kError_AmbiguousReference, "Epäselvä viite kohteeseen %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Access-määritteet eivät ole sallittuja namespace-attribuuttien kanssa." ),
           new AscError(kError_Unknown_Namespace, "Nimitilaa ei löytynyt tai se ei ole kokoamisenaikainen vakio." ),
           new AscError(kError_InvalidSuperExpression, "Super-ilmausta voidaan käyttää vain luokan esiintymämetodeissa." ),
           new AscError(kError_InvalidSuperStatement, "Super-lausetta voidaan käyttää vain luokan esiintymäkonstruktoreissa." ),
           new AscError(kError_InvalidAttribute, "Virheellinen attribuutti." ),
           new AscError(kError_InvalidOverride, "Override-attribuuttia voidaan käyttää vain luokan ominaisuusmäärityksissä." ),
           new AscError(kError_InvalidVirtual, "Virtual-attribuuttia voidaan käyttää vain luokan ominaisuusmäärityksissä." ),
           new AscError(kError_InvalidStatic, "Static-attribuuttia voidaan käyttää vain luokan sisäisissä määrityksissä." ),
           new AscError(kError_InvalidPrivate, "Private-attribuuttia voidaan käyttää vain luokan ominaisuusmäärityksissä." ),
           new AscError(kError_Unsupported_Intrinsic, "Intrinsic-attribuuttia ei enää tueta." ),
           new AscError(kError_BaseClassIsFinal, "Perusluokka on final." ),
           new AscError(kError_UnknownBaseClass, "Perusluokan %s määritystä ei löytynyt." ),
           new AscError(kError_DuplicateClassDefinition, "Toistuva luokan määritys: %s." ),
           new AscError(kError_OverrideNotFound, "Override-tyyppiseksi merkityn metodin pitää korvata toinen metodi." ),
           new AscError(kError_DuplicateFunction, "Toistuva funktion määritys." ),
           new AscError(kError_OverrideFinalAccessor, "Final-aksessoria ei voi korvata." ),
           new AscError(kError_IncompatibleOverride, "Epäyhteensopiva korvaus." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Korvataan funktiota, jota ei ole merkitty korvattavaksi." ),
           new AscError(kError_FinalMethodRedefinition, "Final-metodia ei voi määrittää uudelleen." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Konstruktorin funktioiden pitää olla instance-metodeja." ),
           new AscError(kError_FuncIsStaticAndOverride, "Funktiot eivät voi olla sekä static- että override-tyyppisiä." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Funktiot eivät voi olla sekä static- että virtual-tyyppisiä." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Funktiot eivät voi olla sekä final- että virtual-tyyppisiä." ),
           new AscError(kError_RestParameterNotNamed, "Nimi pitää määrittää muuttuja-argumenteista." ),
           new AscError(kError_VirtualVars, "Virtual-muuttujia ei tueta." ),
           new AscError(kError_NativeVars, "Muuttujat eivät voi olla native-tyyppisiä." ),
           new AscError(kError_VarIsFinalAndVirtual, "Muuttujat eivät voi olla sekä final- että virtual-tyyppisiä." ),
           new AscError(kError_NestedPackage, "Paketit eivät voi olla sisäkkäisiä." ),
           new AscError(kError_BreakHasNoTarget, "Break-ilmaisun kohdetta ei löytynyt." ),
           new AscError(kError_ContinueHasNoTarget, "Continue-ilmaisun kohdetta ei löytynyt." ),
           new AscError(kError_DuplicateLabel, "Toistuva nimimääritys." ),
           new AscError(kError_AttributesAreNotCallable, "Attribuutit eivät ole kutsuttavia." ),
           new AscError(kError_ThisUsedInStaticFunction, "Tätä avainsanaa ei voida käyttää static-metodeissa. Sitä voidaan käyttää vain esiintymämetodeissa, funktioiden sulkemisissa ja yleiskoodissa." ),
           new AscError(kError_UndefinedNamespace, "Määrittämätön nimitila." ),
           new AscError(kError_UnknownInterfaceMethod, "Luokka %s ei ole ottanut käyttöön liittymämetodia %s nimitilassa %s." ),
           new AscError(kError_UnknownInterface, "Liittymää %s ei löytynyt." ),
           new AscError(kError_UnknownType, "Tyypiä ei löytynyt tai se ei ole kokoamisenaikainen vakio: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parameter-alustaja on tuntematon tai se ei ole kokoamisenaikainen vakio." ),
           new AscError(kError_MethodIsNotAConstructor, "Metodia ei voida käyttää konstruktorina." ),
           new AscError(kError_AssignmentToConstVar, "Virheellinen määritys muuttujaan, joka on määritetty vakioksi." ),
           new AscError(kError_AssignmentToNonRefVar, "Ei voi määrittää ei-viitteelliselle arvolle." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Return-arvon pitää olla määrittämätön." ),
           new AscError(kError_ConstInitializerNotConst, "Vakion alustaja on tuntematon tai se ei ole kokoamisenaikainen vakio." ),
           new AscError(kError_AccessorTypesMustMatch, "Aksessorityyppien on vastattava toisiaan." ),
           new AscError(kError_BadSetterReturnType, "Set-funktion määrityksen return-tyypin pitää olla unspecified tai void." ),
           new AscError(kError_PropertyIsWriteOnly, "Ominaisuuteen voi vain kirjoittaa." ),
           new AscError(kError_PropertyIsReadOnly, "Ominaisuus on vain luku." ),
           new AscError(kError_Strict_UndefinedMethod, "Kutsu mahdollisesti määrittämättömään metodiin %s staattisella tyypillä %s varustetun viitteen kautta." ),
           new AscError(kError_UnableToOpenFile, "Ei voi avata tiedostoa: %s." ),
           new AscError(kError_InvalidMetaData, "Virheelliset metatiedot." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Metadata-attribuuteilla voi olla korkeintaan yksi elementti." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Tyypin %s arvon implisiittinen pakottaminen liittymättömään tyyppiin %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Ei voi avata sisällytettyä tiedostoa: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntaksivirhe: odotettiin määritystä tai direktiiviä." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntaksivirhe: odotettiin määritysavainsanaa (esimerkiksi funktiota) attribuutin %s jälkeen, ei attribuutin %s jälkeen." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntaksivirhe: odotettiin xml:ää ennen nimitilaa." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntaksivirhe: odotetaan catch- tai finally-ehtoa." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntaksivirhe: Avainsanaa each ei sallita ilman in-operaattoria." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntaksivirhe: odotetaan vasenta suljetta ennen tunnusta." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Odotetaan tapauksen nimeä." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Nimen pitää olla yksinkertainen tunnus." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Super-ilmauksella pitää olla yksi operandi." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Odotetaan increment- tai decrement-operaattoria." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Odotetaan yhtä ilmausta sulkeissa." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntaksivirhe: %s on odottamaton." ),
           new AscError(kError_Parser_ExpectedToken, "Syntaksivirhe: odotettiin kohdetta %s ennen kohdetta %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntaksivirhe: odotetaan puolipistettä ennen kohdetta %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntaksivirhe: ohjelman lopun jälkeen löytyi ylimääräisiä merkkejä." ),
           new AscError(kError_Lexical_General, "Syntaksivirhe." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntaksivirhe: merkkijonoliteraali pitää päättää ennen rivinvaihtoa." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntaksivirhe: merkkijonoliteraali pitää päättää ennen rivinvaihtoa." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntaksivirhe: syöttö loppui ennen merkkijonoliteraalin päättävää lainausmerkkiä." ),
           new AscError(kError_Lexical_SyntaxError, "Syntaksivirhe." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntaksivirhe: XML:llä ei ole toisiaan vastaavia aloitus- ja lopetustunnisteita." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Super-alikohteita ei voi poistaa." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Toistuva nimitilan määritys." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Määrityksen kohteen pitää olla viitearvo." ),
           new AscError(kError_IncrementOperatorNotAReference, "Increment-operandin pitää olla viite." ),
           new AscError(kError_InvalidIncrementOperand, "Increment-operandi ei kelpaa." ),
           new AscError(kError_InvalidDecrementOperand, "Decrement-operandi ei kelpaa." ),
           new AscError(kError_ExpectingExpression, "Odotetaan ilmausta." ),
           new AscError(kError_MissingXMLTagName, "XML-tunnisteen nimi puuttuu." ),
           new AscError(kError_InvalidAbcFile, "Tiedosto %s ei ole kelvollinen ABC-tiedosto." ),
           new AscError(kError_Parser_FileIncludesItself, "Tästä tiedostosta johtuvaan mahdolliseen päättymättömään rekursioon sisältyy: %s." ),
           new AscError(kError_CircularReference, "Circular-tyypin viite havaittiin kohteessa %s." ),
           new AscError(kError_InvalidPublic, "Public-attribuuttia voidaan käyttää vain paketin sisällä." ),
           new AscError(kError_InvalidInternal, "Internal-attribuuttia voidaan käyttää vain paketin sisällä." ),
           new AscError(kError_InvalidNamespace, "Käyttäjän määrittämää namespace-attribuuttia voidaan käyttää vain luokkamäärityksen ylimmällä tasolla." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Static-tyypillä %s varustetun arvon implisiittinen pakottaminen mahdollisesti liittymättömään tyyppiin %s." ),
           new AscError(kError_UndefinedProperty, "Mahdollisesti määrittämättömän ominaisuuden %s käyttö static-tyypillä %s varustetun viitteen kautta." ),
           new AscError(kError_UnfoundProperty, "Määrittämättömän ominaisuuden %s käyttö." ),
           new AscError(kError_GetterCannotHaveParameters, "Get-funktion määrityksellä ei saa olla parametrejä." ),
           new AscError(kError_SetterMustHaveOneParameter, "Set-funktion määrityksellä on oltava täsmälleen yksi parametri." ),
           new AscError(kError_SetterCannotHaveOptional, "Set-funktion määrityksellä ei voi olla valinnaisia parametrejä." ),
           new AscError(kError_BadGetterReturnType, "Get-funktion määritteen return-tyyppi ei voi olla tyhjä." ),
           new AscError(kError_InterfaceMethodWithBody, "Liittymässä määritetyillä metodeilla ei voi olla vartaloa." ),
           new AscError(kError_FunctionWithoutBody, "Funktiolla ei ole vartaloa." ),
           new AscError(kError_DuplicateAttribute, "Attribuutti %s määritettiin useita kertoja." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Toistuva liittymän määritys: %s." ),
           new AscError(kError_CtorWithReturnType, "Konstruktori ei voi määrittää return-tyyppiä." ),
           new AscError(kError_InvalidClassNesting, "Luokat eivät voi olla sisäkkäin." ),
           new AscError(kError_InvalidFinalUsage, "Final-attribuuttia voidaan käyttää vain luokassa määritetyssä metodissa." ),
           new AscError(kError_InvalidNative, "Native-attribuuttia voidaan käyttää vain funktion määritysten kanssa." ),
           new AscError(kError_InvalidDynamic, "Dynamic-attribuuttia voidaan käyttää vain luokan määritysten kanssa." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntaksivirhe: %s ei ole kelvollinen tyyppi." ),
           new AscError(kError_WrongNumberOfArguments, "Virheellinen määrä argumentteja.  Odotettu määrä %s." ),
           new AscError(kError_TooManyArguments, "Virheellinen määrä argumentteja.  Odotettu määrä korkeintaan %s." ),
           new AscError(kError_BadRequiredParameter, "Vaaditut parametrit eivät ole sallittuja valinnaisten parametrien jälkeen." ),
           new AscError(kError_VarInInterface, "Muuttujamääritykset eivät ole sallittuja liittymissä." ),
           new AscError(kError_InvalidRestDecl, "Parametrit, jotka on määritetty ...rest-parametrimäärityksen avainsanan jälkeen, voivat olla vain Array-tietotyyppiä." ),
           new AscError(kError_CannotExtendInterface, "Luokka voi laajentaa vain toista luokkaa, ei liittymää." ),
           new AscError(kError_CannotExtendClass, "Liittymä voi laajentaa vain toisia liittymiä. %s on luokka." ),
           new AscError(kError_InvalidOverrideUsage, "Override-attribuuttia voidaan käyttää vain luokassa määritetyssä metodissa." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Interface-metodi %s nimitilassa %s on otettu käyttöön yhteensopimattoman allekirjoituksen kanssa luokassa %s." ),
           new AscError(kError_NativeMethodWithBody, "Native-metodeilla ei voi olla vartaloa." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Konstruktori ei voi olla get- tai set-funktiometodi." ),
           new AscError(kError_MissingFilespec, "AS-lähdetiedostoa ei määritetty." ),
           new AscError(kError_CannotReturnFromStaticInit, "Return-ilmaisua ei voida käyttää staattisessa alustuskoodissa." ),
           new AscError(kError_InvalidProtected, "Protected-attribuuttia voidaan käyttää vain luokan ominaisuusmäärityksissä." ),
           new AscError(kError_ConflictingNameInNamespace, "Määrityksen %s kanssa on ristiriita nimitilassa %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Perityn määrityksen %s kanssa on ristiriita nimitilassa %s." ),
           new AscError(kError_ConstructorMustBePublic, "Konstruktori voidaan määrittää vain public-tyyppiseksi." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Vain yksi seuraavista voidaan määrittää määritelmässä: public, private, protected, internal." ),
           new AscError(kError_InvalidNestedAccessor, "Aksessorit eivät voi olla sisäkkäin muiden funktioiden kanssa." ),
           new AscError(kError_CannotInstantiateInterface, "Liittymiä ei voida luoda uudella operaattorilla." ),
           new AscError(kError_BadAccessInterfaceMember, "Liittymän jäseniä ei voida määrittää public-, private-, protected- tai internal-tyyppisiksi." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntaksivirhe: vasen sulje ({) puuttuu ennen funktion vartaloa." ),
           new AscError(kError_CannotReturnFromPackageInit, "Return-ilmaisua ei voida käyttää paketin alustuskoodissa." ),
           new AscError(kError_InvalidInterfaceNative, "Native-attribuuttia ei voi käyttää liittymämäärityksissä." ),
           new AscError(kError_MultipleNamespaceAttributes, "Vain yhtä namespace-attribuuttia voidaan käyttää määritystä kohti." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Metodi %s on ristiriidassa liittymästä %s perityn määrityksen kanssa." ),
           new AscError(kError_InvalidInterfaceAttribute, "Interface-attribuutti %s ei kelpaa." ),
           new AscError(kError_NamespaceInInterface, "Namespace-määritykset eivät ole sallittuja liittymissä." ),
           new AscError(kError_DuplicateImplements, "Luokka %s ottaa liittymän %s käyttöön useita kertoja." ),
           new AscError(kError_AssignmentToDefinedFunction, "Virheellinen määritys funktioon %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Namespace-attribuutit eivät ole sallittuja interface-metodeissa." ),
           new AscError(kError_MustReturnValue, "Funktio ei palauta arvoa." ),
           new AscError(kError_InvalidNamespaceInitializer, "Namespace-alustajan pitää olla joko merkkijonoliteraali tai toinen nimitila." ),
           new AscError(kError_DefinitionNotFound, "Määritelmää %s ei löytynyt." ),
           new AscError(kError_InvalidLabel, "Label-määritys ei kelpaa." ),
           new AscError(kError_IncompatableValueComparison, "Vertailu staattista tyyppiä %s ja mahdollisesti liittymätöntä tyyppiä %s olevien arvojen välillä." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Return-ilmaisua ei voida käyttää yleisessä alustuskoodissa." ),
           new AscError(kError_InaccessiblePropertyReference, "Yritys käyttää ei käytettävissä olevaa ominaisuutta %s staattista tyypiä %s olevan viitteen kautta." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Objekti on tilapäisesti poissa käytöstä. Käytä sen sijaan objektia :*." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Kutsu mahdollisesti määrittämätöntä metodia %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Välitä viite perusluokkaan %s." ),
           new AscError(kError_IllegalPackageReference, "Pakettia ei voi käyttää arvona: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Tyyppi %s on epäyhteensopiva oletusarvo. Odotetaan arvoa %s." ),
           new AscError(kError_MultipleSwitchDefaults, "Valitsimella on useampi kuin yksi oletusarvo. Vain yksi oletusarvo sallitaan." ),
           new AscError(kError_AssignmentToDefinedClass, "Virheellinen määritys luokkaan %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Yritys poistaa kiinteä ominaisuus %s.  Vain dynaamisesti määritetyt ominaisuudet voidaan poistaa." ),
           new AscError(kError_InvalidBaseTypeExpression, "Perusluokkaa ei löytynyt tai se ei ole kokoamisenaikainen vakio." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Liittymää ei löytynyt tai se ei ole kokoamisenaikainen vakio." ),
           new AscError(kError_StaticModifiedNamespace, "Static-attribuutti ei ole sallittu namespace-määrityksissä." ),
           new AscError(kError_InvalidInterfaceNesting, "Interface-määritykset eivät voi olla sisäkkäin luokan tai muiden interface-määritysten kanssa." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Prototype-attribuutti ei kelpaa." ),
           new AscError(kError_InaccessibleMethodReference, "Yritys käyttää ei käytettävissä olevaa metodia %s staattisella tyypillä %s varustetun viitteen kautta." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntaksivirhe: odotettiin ilmausta palautuksen jälkeen." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Luokka %s ei voi laajentaa kohdetta %s, koska kummatkin liittyvät kirjastosymboleihin tai pääaikajanaan." ),
           new AscError(kError_AttributesOnPackage, "Attribuutteja ei sallita pakettimäärityksessä." ),
           new AscError(kError_InternalError, "Sisäinen virhe: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntaksivirhe: virheellinen for-in-alustaja, odotettiin vain yhtä ilmausta." ),
           new AscError(kError_IllegalSuperStatement, "Tämän lauseen, super-lauseen, return-lauseen tai throw-lauseen jälkeen ei voi olla super-lausetta." ),
           new AscError(kError_UnfoundPackageProperty, "Määrittämättömän ominaisuuden %s käyttö paketissa %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Oletuskonstruktoria ei löytynyt perusluokasta %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* löytyi ilman vastaavaa kohdetta */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntaksivirhe: odotettiin vasenta suljetta({)tai merkkijonoliteraalia(\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "Super-ilmaisua voidaan käyttää vain konstruktorin alustajaluettelon viimeisenä kohtana." ),
           new AscError(kError_ThisUsedInInitializer, "Tätä avainsanaa ei voida käyttää ominaisuuksien alustajissa." ),
           new AscError(kError_NonConstantConfigInit, "Määritysarvon alustajan pitää olla kokoamisenaikainen vakio." ),
           new AscError(kError_NonConstConfigVar, "Määritysmuuttuja voi olla vain määritetty vakio." ),
           new AscError(kError_InvalidConfigLocation, "Määritysarvo pitää määrittää ohjelman tai paketin ylimmällä tasolla." ),
           new AscError(kError_ShadowedConfigNamespace, "Nimitila %s on ristiriidassa määritysnimitilan kanssa." ),
           new AscError(kError_InvalidPrecision, "Tarkkuuden pitää olla kokonaisluku 1-34." ),
           new AscError(kError_WrongVersion, "Yhteensopimaton versio: määritykseen %s, joka esiteltiin versiossa %s, ei voi viitata version %s koodista." ),
           new AscError(kError_LossyConversion, "Virheellinen alustus: muunnoksessa tyyppiin %s menetetään tietoja." ),
   };

   public static final AscError[] errorConstantsFR = { 
           new AscError(kError_AmbiguousReference, "Référence ambiguë à %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Les spécificateurs d'accès sont interdits avec les attributs des espaces de nom." ),
           new AscError(kError_Unknown_Namespace, "Cet espace de nom est introuvable ou n'est pas une constante de compilation." ),
           new AscError(kError_InvalidSuperExpression, "Une expression super ne peut être utilisée que dans des méthodes d'instance de classe." ),
           new AscError(kError_InvalidSuperStatement, "Une instruction super ne peut être utilisée que dans des constructeurs d'instance de classe." ),
           new AscError(kError_InvalidAttribute, "Attribut non valide." ),
           new AscError(kError_InvalidOverride, "L'attribut override ne peut être utilisé que dans des définitions de propriétés de classes." ),
           new AscError(kError_InvalidVirtual, "L'attribut virtual ne peut être utilisé que dans des définitions de propriétés de classes." ),
           new AscError(kError_InvalidStatic, "L'attribut static ne peut être utilisé que dans des définitions dans une classe." ),
           new AscError(kError_InvalidPrivate, "L'attribut private ne peut être utilisé que dans des définitions de propriétés de classes." ),
           new AscError(kError_Unsupported_Intrinsic, "L'attribut intrinsic n'est plus pris en charge." ),
           new AscError(kError_BaseClassIsFinal, "La classe de base est finale." ),
           new AscError(kError_UnknownBaseClass, "La définition de la classe de base %s est introuvable." ),
           new AscError(kError_DuplicateClassDefinition, "Définition de classe dupliquée : %s." ),
           new AscError(kError_OverrideNotFound, "La méthode marquée override doit neutraliser une autre méthode." ),
           new AscError(kError_DuplicateFunction, "Définition de fonction dupliquée." ),
           new AscError(kError_OverrideFinalAccessor, "Impossible de neutraliser un accesseur final." ),
           new AscError(kError_IncompatibleOverride, "override non compatible." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Neutralisation d'une fonction non marquée override." ),
           new AscError(kError_FinalMethodRedefinition, "Impossible de redéfinir une méthode finale." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Les fonctions de type constructor doivent être des méthodes d'une instance." ),
           new AscError(kError_FuncIsStaticAndOverride, "Une fonction ne peut pas avoir à la fois les attributs static et override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Une fonction ne peut pas avoir à la fois les attributs static et virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Une fonction ne peut pas avoir à la fois les attributs final et virtual." ),
           new AscError(kError_RestParameterNotNamed, "Le nom du tableau d'arguments de variables doit être spécifié." ),
           new AscError(kError_VirtualVars, "Les variables virtuelles ne sont pas prises en charge." ),
           new AscError(kError_NativeVars, "Les variables ne peuvent pas avoir l'attribut native." ),
           new AscError(kError_VarIsFinalAndVirtual, "Une variable ne peut pas avoir à la fois les attributs final et virtual." ),
           new AscError(kError_NestedPackage, "Les packages ne peuvent pas être imbriqués." ),
           new AscError(kError_BreakHasNoTarget, "La cible de l'instruction break est introuvable." ),
           new AscError(kError_ContinueHasNoTarget, "La cible de l'instruction continue est introuvable." ),
           new AscError(kError_DuplicateLabel, "Définition d'étiquette dupliquée." ),
           new AscError(kError_AttributesAreNotCallable, "Les attributs ne peuvent pas être appelés." ),
           new AscError(kError_ThisUsedInStaticFunction, "Il est impossible d'utiliser le mot-clé this dans une méthode statique. Il ne peut être utilisé que dans les méthodes d'une instance, la fermeture d'une fonction et le code global." ),
           new AscError(kError_UndefinedNamespace, "Espace de nom non défini." ),
           new AscError(kError_UnknownInterfaceMethod, "La méthode d'interface %s de l'espace de nom %s n'est pas implémentée par la classe %s." ),
           new AscError(kError_UnknownInterface, "L'interface %s est introuvable." ),
           new AscError(kError_UnknownType, "Ce type est introuvable ou n'est pas une constante de compilation : %s." ),
           new AscError(kError_NonConstantParamInitializer, "Initialiseur de paramètre inconnu, ou ce n'est pas une constante de compilation." ),
           new AscError(kError_MethodIsNotAConstructor, "Impossible d'utiliser une méthode comme constructeur." ),
           new AscError(kError_AssignmentToConstVar, "Affectation illégale à une variable déclarée comme une constante." ),
           new AscError(kError_AssignmentToNonRefVar, "Affectation impossible à une valeur non référentielle." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "La valeur renvoyée doit être de type undefined." ),
           new AscError(kError_ConstInitializerNotConst, "Initialiseur de constante inconnu, ou ce n'est pas une constante de compilation." ),
           new AscError(kError_AccessorTypesMustMatch, "Les types des accesseurs doivent correspondre." ),
           new AscError(kError_BadSetterReturnType, "Le type de valeur renvoyée par une définition doit être unspecified ou void." ),
           new AscError(kError_PropertyIsWriteOnly, "Cette propriété est en écriture seule." ),
           new AscError(kError_PropertyIsReadOnly, "Cette propriété est en lecture seule." ),
           new AscError(kError_Strict_UndefinedMethod, "Appel à la méthode %s peut-être non définie, via la référence de type static %s." ),
           new AscError(kError_UnableToOpenFile, "Impossible d'ouvrir le fichier : %s." ),
           new AscError(kError_InvalidMetaData, "Métadonnées non valides." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Les attributs des métadonnées ne doivent pas comporter plusieurs éléments." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Contrainte implicite d'une valeur du type %s vers un type sans rapport %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Impossible d'ouvrir le fichier inclus : %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Erreur de syntaxe : définition ou directive attendue." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Erreur de syntaxe : un mot-clé de définition (par exemple function) est attendu après l'attribut %s, et non pas %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Erreur de syntaxe : code xml attendu avant l'espace de nom." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Erreur de syntaxe : instruction catch ou clause finally attendue." ),
           new AscError(kError_Parser_EachWithoutIn, "Erreur de syntaxe : le mot-clé 'each' n'est pas autorisé sans l'opérateur 'in'." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Erreur de syntaxe : parenthèse ouvrante attendue devant l'identifiant." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel attendu." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Label doit être un simple identifiant." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Une expression super doit comporter un opérande." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Opérateur d'incrémentation ou décrémentation attendu." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Expression unique entre parenthèses attendue." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Erreur de syntaxe : %s non attendu." ),
           new AscError(kError_Parser_ExpectedToken, "Erreur de syntaxe : %s est attendu devant %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Erreur de syntaxe : un point-virgule est attendu avant %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Erreur de syntaxe : caractères excédentaires détectés après la fin du programme." ),
           new AscError(kError_Lexical_General, "Erreur de syntaxe." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Erreur de syntaxe : un littéral de chaîne doit être terminé avant le saut de ligne." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Erreur de syntaxe : un littéral de chaîne doit être terminé avant le saut de ligne." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Erreur de syntaxe : input terminé avant le guillemet de fin d'un littéral de chaîne." ),
           new AscError(kError_Lexical_SyntaxError, "Erreur de syntaxe." ),
           new AscError(kError_Lexical_NoMatchingTag, "Erreur de syntaxe : code XML sans balises de début et de fin appariées." ),
           new AscError(kError_CannotDeleteSuperDecendants, "impossible de supprimer des descendants super." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Définition d'espace de nom dupliquée." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "La cible d'une affectation doit être une valeur de référence." ),
           new AscError(kError_IncrementOperatorNotAReference, "L'opérande d'un incrément doit être une référence." ),
           new AscError(kError_InvalidIncrementOperand, "L'opérande d'incrémentation n'est pas valide." ),
           new AscError(kError_InvalidDecrementOperand, "L'opérande de décrémentation n'est pas valide." ),
           new AscError(kError_ExpectingExpression, "Expression attendue." ),
           new AscError(kError_MissingXMLTagName, "Nom de balise XML absent." ),
           new AscError(kError_InvalidAbcFile, "Le fichier %s n'est pas un fichier ABC valide." ),
           new AscError(kError_Parser_FileIncludesItself, "Risque de récursivité à l'infini, en raison du fichier include : %s." ),
           new AscError(kError_CircularReference, "Référence de type circulaire détectée dans %s." ),
           new AscError(kError_InvalidPublic, "L'attribut public ne peut être utilisé que dans un package." ),
           new AscError(kError_InvalidInternal, "L'attribut internal ne peut être utilisé que dans un package." ),
           new AscError(kError_InvalidNamespace, "Un attribut d'espace de nom défini par l'utilisateur ne peut être utilisé qu'au niveau supérieur d'une définition de classe." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Contrainte implicite d'une valeur du type statique %s vers un type peut-être sans rapport %s." ),
           new AscError(kError_UndefinedProperty, "Accès à la propriété %s peut-être non définie, via la référence de type static %s." ),
           new AscError(kError_UnfoundProperty, "Accès à la propriété non définie %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Une définition get (lecture) ne prend aucun paramètre." ),
           new AscError(kError_SetterMustHaveOneParameter, "Une définition set (définition) attend exactement un paramètre." ),
           new AscError(kError_SetterCannotHaveOptional, "Une définition set (définition) ne prend pas de paramètres optionnels." ),
           new AscError(kError_BadGetterReturnType, "Le type de valeur renvoyée par une définition get (lecture) ne doit pas être void." ),
           new AscError(kError_InterfaceMethodWithBody, "Les méthodes définies dans une interface n'ont pas d'élément body." ),
           new AscError(kError_FunctionWithoutBody, "La fonction ne comporte pas d'élément body." ),
           new AscError(kError_DuplicateAttribute, "L'attribut %s a été spécifié à plusieurs reprises." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Définition d'interface dupliquée : %s." ),
           new AscError(kError_CtorWithReturnType, "Un constructeur ne peut pas spécifier de type de renvoi." ),
           new AscError(kError_InvalidClassNesting, "Les classes ne peuvent pas être imbriquées." ),
           new AscError(kError_InvalidFinalUsage, "L'attribut final ne peut être utilisé que dans une méthode définie dans une classe." ),
           new AscError(kError_InvalidNative, "L'attribut native ne peut être utilisé que dans la définition d'une fonction." ),
           new AscError(kError_InvalidDynamic, "L'attribut dynamic ne peut être utilisé que dans la définition d'une classe." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Erreur de syntaxe : %s n'est pas un type valide." ),
           new AscError(kError_WrongNumberOfArguments, "Nombre d'arguments incorrect.  %s attendus." ),
           new AscError(kError_TooManyArguments, "Nombre d'arguments incorrect.  Nombre maximum attendu : %s." ),
           new AscError(kError_BadRequiredParameter, "Les paramètres obligatoires sont interdits après les paramètres facultatifs." ),
           new AscError(kError_VarInInterface, "Déclarations de variables interdites dans les interfaces." ),
           new AscError(kError_InvalidRestDecl, "Les paramètres spécifiés après le mot-clé de définition de paramètres ...rest sont obligatoirement de type Array." ),
           new AscError(kError_CannotExtendInterface, "Une classe ne peut étendre qu'une autre classe, pas une interface." ),
           new AscError(kError_CannotExtendClass, "Une interface ne peut étendre qu'une autre interface, mais %s est une classe." ),
           new AscError(kError_InvalidOverrideUsage, "L'attribut override ne peut être utilisé que dans une méthode définie dans une classe." ),
           new AscError(kError_IncompatibleInterfaceMethod, "La méthode d'interface %s de l'espace de nom %s est implémentée avec une signature incompatible dans la classe %s." ),
           new AscError(kError_NativeMethodWithBody, "Les méthodes ayant l'attribut native ne peuvent pas avoir d'élément body." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Une méthode de lecture/définition (get ou set) ne peut pas être un constructeur." ),
           new AscError(kError_MissingFilespec, "Aucun fichier source AS spécifié." ),
           new AscError(kError_CannotReturnFromStaticInit, "L'instruction return ne peut pas être utilisée dans du code d'initialisation statique." ),
           new AscError(kError_InvalidProtected, "L'attribut protected ne peut être utilisé que dans des définitions de propriétés de classes." ),
           new AscError(kError_ConflictingNameInNamespace, "Conflit dans la définition %s dans l'espace de nom %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Conflit dans la définition héritée %s dans l'espace de nom %s." ),
           new AscError(kError_ConstructorMustBePublic, "Un constructeur ne peut être déclaré que comme public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Une définition ne peut contenir qu'un seul des attributs suivants : public, private, protected ou internal." ),
           new AscError(kError_InvalidNestedAccessor, "Les accesseurs ne peuvent pas être imbriqués dans d'autres fonctions." ),
           new AscError(kError_CannotInstantiateInterface, "Les interfaces ne peuvent pas être instanciées avec l'opérateur new." ),
           new AscError(kError_BadAccessInterfaceMember, "Les membres d'une interface ne peuvent pas être déclarés public, private, protected ou internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Erreur de syntaxe : il manque une accolade d'ouverture ({) avant le corps de la fonction." ),
           new AscError(kError_CannotReturnFromPackageInit, "L'instruction return ne peut pas être utilisée dans du code d'initialisation de package." ),
           new AscError(kError_InvalidInterfaceNative, "L'attribut native ne peut pas être utilisé dans la définition d'une interface." ),
           new AscError(kError_MultipleNamespaceAttributes, "Un seul attribut d'espace de nom par définition." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "La méthode %s est en conflit avec la définition héritée de l'interface %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Attribut d'interface %s non valide." ),
           new AscError(kError_NamespaceInInterface, "Déclarations d'espaces de nom interdites dans les interfaces." ),
           new AscError(kError_DuplicateImplements, "La classe %s implémente l'interface %s à plusieurs reprises." ),
           new AscError(kError_AssignmentToDefinedFunction, "Affectation à la fonction %s incorrecte." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Attributs d'espaces de nom interdits dans les méthodes d'interfaces." ),
           new AscError(kError_MustReturnValue, "La fonction ne renvoie pas de valeur." ),
           new AscError(kError_InvalidNamespaceInitializer, "L'initialiseur d'un espace de nom doit être une chaîne littérale ou un autre espace de nom." ),
           new AscError(kError_DefinitionNotFound, "La définition %s est introuvable." ),
           new AscError(kError_InvalidLabel, "Définition d'étiquette non valide." ),
           new AscError(kError_IncompatableValueComparison, "Comparaison entre une valeur du type statique %s et un type peut-être sans rapport %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "L'instruction return ne peut pas être utilisée dans du code d'initialisation global." ),
           new AscError(kError_InaccessiblePropertyReference, "Tentative d'accès à la propriété inaccessible %s, via la référence de type static %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ": objet provisoirement hors de service. Utilisez plutôt :*." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Appel à une méthode qui ne semble pas définie, %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Pré-référence à la classe de base %s." ),
           new AscError(kError_IllegalPackageReference, "Impossible d'utiliser un package comme valeur : %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Valeur par défaut non compatible, du type %s alors que %s est attendu." ),
           new AscError(kError_MultipleSwitchDefaults, "switch accepte plusieurs valeurs par défaut, mais une seule valeur par défaut est autorisée." ),
           new AscError(kError_AssignmentToDefinedClass, "Affectation à la classe %s incorrecte." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Tentative de suppression de la propriété fixe %s.  Seules les propriétés définies dynamiquement peuvent être supprimées." ),
           new AscError(kError_InvalidBaseTypeExpression, "Cette classe de base est introuvable ou n'est pas une constante de compilation." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Cette interface est introuvable ou n'est pas une constante de compilation." ),
           new AscError(kError_StaticModifiedNamespace, "L'attribut static n'est pas autorisé dans les définitions d'espaces de nom." ),
           new AscError(kError_InvalidInterfaceNesting, "Les définitions d'interfaces ne peuvent pas être imbriquées dans une classe ou une autre définition d'interface." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Attribut prototype non valide." ),
           new AscError(kError_InaccessibleMethodReference, "Tentative d'accès à la méthode inaccessible %s, via la référence de type static %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Erreur de syntaxe : expression attendue après le retour." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "La classe %s ne peut pas étendre %s car les deux sont associées à des symboles de bibliothèque ou au scénario principal." ),
           new AscError(kError_AttributesOnPackage, "Les attributs ne sont pas autorisés dans la définition d'un package." ),
           new AscError(kError_InternalError, "Erreur interne : %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Erreur de syntaxe : initialiseur for-in non valide, une seule expression attendue." ),
           new AscError(kError_IllegalSuperStatement, "Une instruction super ne peut pas apparaître après une instruction this, super, return ou throw." ),
           new AscError(kError_UnfoundPackageProperty, "Accès à la propriété non définie %s dans le package %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Aucun constructeur par défaut n'a été défini dans la classe de base %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* sans correspondance */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Erreur de syntaxe : une accolade ouvrante ({) ou un littéral de chaîne (\"\") est attendu." ),
           new AscError(kError_InvalidES4SuperStatement, "Une instruction super peut uniquement être utilisée en tant que dernier élément de la liste d’initialiseurs du constructeur." ),
           new AscError(kError_ThisUsedInInitializer, "Le mot-clé this ne peut pas être utilisé dans des initialiseurs de propriétés." ),
           new AscError(kError_NonConstantConfigInit, "L’initialiseur d’une valeur de configuration doit être une constante de compilation." ),
           new AscError(kError_NonConstConfigVar, "Une variable de configuration peut uniquement être déclarée const." ),
           new AscError(kError_InvalidConfigLocation, "Une valeur de configuration doit être déclarée au niveau supérieur d’un programme ou d’un package." ),
           new AscError(kError_ShadowedConfigNamespace, "L’espace de noms %s est en conflit avec un espace de noms de configuration." ),
           new AscError(kError_InvalidPrecision, "La valeur de précision doit être un entier compris entre 1 et 34." ),
           new AscError(kError_WrongVersion, "Version incompatible : impossible de référencer la définition %s introduite dans la version %s à partir de code associé à la version %s." ),
           new AscError(kError_LossyConversion, "Initialisation non valide : la conversion au type %s provoque une perte de données." ),
   };

   public static final AscError[] errorConstantsIT = { 
           new AscError(kError_AmbiguousReference, "Riferimento ambiguo a %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Specificatori di accesso non consentiti con gli attributi namespace." ),
           new AscError(kError_Unknown_Namespace, "Namespace non trovato o non è una costante specificata in fase di compilazione." ),
           new AscError(kError_InvalidSuperExpression, "Un'espressione super può essere utilizzata solo nei metodi di istanze di classe." ),
           new AscError(kError_InvalidSuperStatement, "Un'istruzione super può essere utilizzata solo nelle funzioni di costruzione di istanze di classe." ),
           new AscError(kError_InvalidAttribute, "Attributo non valido." ),
           new AscError(kError_InvalidOverride, "L'attributo override può essere utilizzato solo nelle definizioni delle proprietà di classe." ),
           new AscError(kError_InvalidVirtual, "L'attributo virtual può essere utilizzato solo nelle definizioni delle proprietà di classe." ),
           new AscError(kError_InvalidStatic, "L'attributo static può essere utilizzato solo nelle definizioni all'interno di una classe." ),
           new AscError(kError_InvalidPrivate, "L'attributo private può essere utilizzato solo nelle definizioni delle proprietà di classe." ),
           new AscError(kError_Unsupported_Intrinsic, "L'attributo intrinsic non è più supportato." ),
           new AscError(kError_BaseClassIsFinal, "La classe base è final." ),
           new AscError(kError_UnknownBaseClass, "Impossibile trovare la definizione della classe base %s." ),
           new AscError(kError_DuplicateClassDefinition, "Definizione di classe duplicata: %s." ),
           new AscError(kError_OverrideNotFound, "Il metodo contrassegnato come override deve sostituire un altro metodo." ),
           new AscError(kError_DuplicateFunction, "Definizione di funzione duplicata." ),
           new AscError(kError_OverrideFinalAccessor, "Impossibile eseguire l'override di un metodo di accesso final." ),
           new AscError(kError_IncompatibleOverride, "Override incompatibile." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Override di una funzione non contrassegnata per l'override." ),
           new AscError(kError_FinalMethodRedefinition, "Impossibile ridefinire un metodo final." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Le funzioni di costruzione devono essere metodi di istanze." ),
           new AscError(kError_FuncIsStaticAndOverride, "Le funzioni non possono essere sia static che override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Le funzioni non possono essere sia static che virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Le funzioni non possono essere sia final che virtual." ),
           new AscError(kError_RestParameterNotNamed, "È necessario specificare il nome dell'array di argomenti della variabile." ),
           new AscError(kError_VirtualVars, "Le variabili virtual non sono supportate." ),
           new AscError(kError_NativeVars, "Le variabili non possono essere native." ),
           new AscError(kError_VarIsFinalAndVirtual, "Le variabili non possono essere sia final che virtual." ),
           new AscError(kError_NestedPackage, "I pacchetti non possono essere nidificati." ),
           new AscError(kError_BreakHasNoTarget, "Impossibile trovare la destinazione dell'istruzione break." ),
           new AscError(kError_ContinueHasNoTarget, "Impossibile trovare la destinazione dell'istruzione continue." ),
           new AscError(kError_DuplicateLabel, "Definizione di etichetta duplicata." ),
           new AscError(kError_AttributesAreNotCallable, "Gli attributi non sono richiamabili." ),
           new AscError(kError_ThisUsedInStaticFunction, "Impossibile utilizzare la parola chiave this nei metodi statici. Può essere utilizzata solo nei metodi di istanza, nelle chiusure di funzioni e nel codice globale." ),
           new AscError(kError_UndefinedNamespace, "Spazio dei nomi non definito." ),
           new AscError(kError_UnknownInterfaceMethod, "Metodo di interfaccia %s nello spazio dei nomi %s non implementato dalla classe %s." ),
           new AscError(kError_UnknownInterface, "Impossibile trovare l'interfaccia %s." ),
           new AscError(kError_UnknownType, "Tipo non trovato o non è una costante della fase di compilazione: %s." ),
           new AscError(kError_NonConstantParamInitializer, "L'inizializzatore di parametro non è noto oppure non è una costante della fase di compilazione." ),
           new AscError(kError_MethodIsNotAConstructor, "Il metodo non può essere utilizzato come funzione di costruzione." ),
           new AscError(kError_AssignmentToConstVar, "Assegnazione non valida a una variabile specificata come costante." ),
           new AscError(kError_AssignmentToNonRefVar, "Impossibile assegnare a un valore non di riferimento." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Il valore restituito deve essere undefined." ),
           new AscError(kError_ConstInitializerNotConst, "L'inizializzatore di costante non è noto oppure non è una costante della fase di compilazione." ),
           new AscError(kError_AccessorTypesMustMatch, "I tipi di accessor devono corrispondere." ),
           new AscError(kError_BadSetterReturnType, "Il tipo restituito di una definizione setter non deve essere specificato o deve essere void." ),
           new AscError(kError_PropertyIsWriteOnly, "La proprietà è di sola scrittura." ),
           new AscError(kError_PropertyIsReadOnly, "La proprietà è di sola lettura." ),
           new AscError(kError_Strict_UndefinedMethod, "Chiamata a un metodo non definito %s mediante un riferimento con tipo statico %s." ),
           new AscError(kError_UnableToOpenFile, "Impossibile aprire il file: %s." ),
           new AscError(kError_InvalidMetaData, "Metadati non validi." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Gli attributi dei metadati non possono avere più di un elemento." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Assegnazione forzata implicita di un valore del tipo %s a un tipo %s non correlato." ),
           new AscError(kError_Parser_UnableToOpenFile, "Impossibile aprire il file incluso: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Errore di sintassi: è prevista una definizione o una direttiva." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Errore di sintassi: è prevista la definizione di una parola chiave (ad esempio function) dopo l'attributo %s, non %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Errore di sintassi: previsto xml prima di namespace." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Errore di sintassi: è prevista una proposizione catch o finally." ),
           new AscError(kError_Parser_EachWithoutIn, "Errore di sintassi: la parola chiave 'each' non è consentita senza un operatore 'in'." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Errore di sintassi: è prevista una parentesi sinistra prima dell'identificatore." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "È previsto CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "L'etichetta deve essere un identificatore semplice." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Un'espressione super deve avere un solo operando." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "È previsto un operatore di incremento o decremento." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "È prevista un'espressione singola racchiusa tra parentesi." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Errore di sintassi: non è previsto %s." ),
           new AscError(kError_Parser_ExpectedToken, "Errore di sintassi: è previsto %s prima di %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Errore di sintassi: è previsto un punto e virgola prima di %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Errore di sintassi: trovati caratteri supplementari dopo la fine del programma." ),
           new AscError(kError_Lexical_General, "Errore di sintassi." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Errore di sintassi: il valore letterale della stringa deve essere terminato prima dell'interruzione di riga." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Errore di sintassi: il valore letterale della stringa deve essere terminato prima dell'interruzione di riga." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Errore di sintassi: input terminato prima della virgoletta di chiusura per un letterale di stringa." ),
           new AscError(kError_Lexical_SyntaxError, "Errore di sintassi." ),
           new AscError(kError_Lexical_NoMatchingTag, "Errore di sintassi: XML senza tag di inizio e di fine corrispondenti." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Impossibile eliminare discendenti super." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Definizione dello spazio dei nomi duplicata." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "La destinazione dell'assegnazione deve essere un valore di riferimento." ),
           new AscError(kError_IncrementOperatorNotAReference, "L'operando di incremento deve essere un riferimento." ),
           new AscError(kError_InvalidIncrementOperand, "L'operando di incremento non è valido." ),
           new AscError(kError_InvalidDecrementOperand, "L'operando di decremento non è valido." ),
           new AscError(kError_ExpectingExpression, "È prevista un'espressione." ),
           new AscError(kError_MissingXMLTagName, "Nome di tag XML mancante." ),
           new AscError(kError_InvalidAbcFile, "Il file %s non è un file ABC valido." ),
           new AscError(kError_Parser_FileIncludesItself, "Possibile ricorsività infinita dovuta a questo file include: %s." ),
           new AscError(kError_CircularReference, "Tipo di riferimento circolare rilevato in %s." ),
           new AscError(kError_InvalidPublic, "L'attributo public può essere utilizzato solo all'interno di un pacchetto." ),
           new AscError(kError_InvalidInternal, "L'attributo internal può essere utilizzato solo all'interno di un pacchetto." ),
           new AscError(kError_InvalidNamespace, "Un attributo namespace definito dall'utente può essere utilizzato solo al livello principale di una definizione di classe." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Assegnazione forzata implicita di un valore di tipo statico %s a un tipo %s che potrebbe non essere correlato." ),
           new AscError(kError_UndefinedProperty, "Accesso a una proprietà non definita %s mediante un riferimento con tipo statico %s." ),
           new AscError(kError_UnfoundProperty, "Accesso alla proprietà non definita %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Una definizione getter non può avere alcun parametro." ),
           new AscError(kError_SetterMustHaveOneParameter, "Una definizione setter deve avere un solo parametro." ),
           new AscError(kError_SetterCannotHaveOptional, "Una definizione setter non può avere parametri opzionali." ),
           new AscError(kError_BadGetterReturnType, "Il tipo restituito di una definizione getter non può essere void." ),
           new AscError(kError_InterfaceMethodWithBody, "I metodi definiti in un'interfaccia non possono avere un corpo." ),
           new AscError(kError_FunctionWithoutBody, "La funzione non ha un corpo." ),
           new AscError(kError_DuplicateAttribute, "L'attributo %s è stato specificato più volte." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Definizione di interfaccia duplicata: %s." ),
           new AscError(kError_CtorWithReturnType, "Una funzione di costruzione non può specificare un tipo restituito." ),
           new AscError(kError_InvalidClassNesting, "Le classi non possono essere nidificate." ),
           new AscError(kError_InvalidFinalUsage, "L'attributo final può essere utilizzato solo in un metodo definito in una classe." ),
           new AscError(kError_InvalidNative, "L'attributo native può essere utilizzato solo nelle definizioni di funzioni." ),
           new AscError(kError_InvalidDynamic, "L'attributo dynamic può essere utilizzato solo nelle definizioni di classi." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Errore di sintassi: %s non è un tipo valido." ),
           new AscError(kError_WrongNumberOfArguments, "Numero di argomenti non valido.  Numero previsto: %s." ),
           new AscError(kError_TooManyArguments, "Numero di argomenti non valido.  Ne è previsto un massimo di %s." ),
           new AscError(kError_BadRequiredParameter, "I parametri obbligatori non sono consentiti dopo i parametri opzionali." ),
           new AscError(kError_VarInInterface, "Le dichiarazioni di variabili non sono consentite nelle interfacce." ),
           new AscError(kError_InvalidRestDecl, "I parametri specificati dopo la parola chiave di definizione parametro ...rest possono essere solo del tipo di dati Array." ),
           new AscError(kError_CannotExtendInterface, "Una classe può estendere solo un'altra classe, non un'interfaccia." ),
           new AscError(kError_CannotExtendClass, "Un'interfaccia può estendere solo altre interfacce, ma %s è una classe." ),
           new AscError(kError_InvalidOverrideUsage, "L'attributo override può essere utilizzato solo in un metodo definito in una classe." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Il metodo di interfaccia %s nello spazio dei nomi %s è implementato con una firma non compatibile nella classe %s." ),
           new AscError(kError_NativeMethodWithBody, "I metodi native non possono avere un corpo." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Una funzione di costruzione non può essere un metodo getter o setter." ),
           new AscError(kError_MissingFilespec, "Non è stato specificato un file di origine AS." ),
           new AscError(kError_CannotReturnFromStaticInit, "L'istruzione return non può essere utilizzata nel codice di inizializzazione statico." ),
           new AscError(kError_InvalidProtected, "L'attributo protected può essere utilizzato solo nelle definizioni delle proprietà di classe." ),
           new AscError(kError_ConflictingNameInNamespace, "Rilevato un conflitto con la definizione %s nello spazio dei nomi %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Rilevato un conflitto nella definizione ereditata %s nello spazio dei nomi %s." ),
           new AscError(kError_ConstructorMustBePublic, "Una funzione di costruzione può essere dichiarata solo public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "In una definizione è possibile specificare solo uno dei seguenti attributi: public, private, protected e internal." ),
           new AscError(kError_InvalidNestedAccessor, "Le accessor non possono essere nidificate all'interno di altre funzioni." ),
           new AscError(kError_CannotInstantiateInterface, "Non è possibile creare istanze di interfacce con l'operatore new." ),
           new AscError(kError_BadAccessInterfaceMember, "I membri di interfaccia non possono essere dichiarati public, private, protected o internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Errore di sintassi: parentesi graffa sinistra ({) mancante prima del corpo della funzione." ),
           new AscError(kError_CannotReturnFromPackageInit, "L'istruzione return non può essere utilizzata nel codice di inizializzazione di un pacchetto." ),
           new AscError(kError_InvalidInterfaceNative, "L'attributo native non può essere utilizzato nelle definizioni di interfacce." ),
           new AscError(kError_MultipleNamespaceAttributes, "Un solo attributo namespace può essere utilizzato in una singola definizione." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Il metodo %s è in conflitto con la definizione ereditata dall'interfaccia %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "L'attributo di interfaccia %s non è valido." ),
           new AscError(kError_NamespaceInInterface, "Le dichiarazioni namespace non sono consentite nelle interfacce." ),
           new AscError(kError_DuplicateImplements, "La classe %s implementa l'interfaccia %s più volte." ),
           new AscError(kError_AssignmentToDefinedFunction, "Assegnazione non valida alla funzione %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Gli attributi namespace non sono consentiti nei metodi di interfaccia." ),
           new AscError(kError_MustReturnValue, "La funzione non restituisce un valore." ),
           new AscError(kError_InvalidNamespaceInitializer, "Un inizializzatore namespace deve essere una stringa letterale o un altro spazio dei nomi." ),
           new AscError(kError_DefinitionNotFound, "Impossibile trovare la definizione %s." ),
           new AscError(kError_InvalidLabel, "Definizione di etichetta non valida." ),
           new AscError(kError_IncompatableValueComparison, "Confronto tra un valore di tipo statico %s e un tipo %s che potrebbe non essere correlato." ),
           new AscError(kError_CannotReturnFromGlobalInit, "L'istruzione return non può essere utilizzata nel codice di inizializzazione globale." ),
           new AscError(kError_InaccessiblePropertyReference, "Tentativo di accesso alla proprietà non accessibile %s mediante un riferimento con tipo statico %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object è temporaneamente inutilizzabile. Utilizzare :* al suo posto." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Chiamata al metodo non definito %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Riferimento in avanti alla classe base %s." ),
           new AscError(kError_IllegalPackageReference, "Il pacchetto non può essere utilizzato come valore: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Valore predefinito non compatibile del tipo %s invece del tipo previsto %s." ),
           new AscError(kError_MultipleSwitchDefaults, "L'istruzione switch ha più valori predefiniti, mentre ne è consentito solo uno." ),
           new AscError(kError_AssignmentToDefinedClass, "Assegnazione non valida alla classe %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Tentativo di eliminare la proprietà fissa %s.  Solo le proprietà definite dinamicamente possono essere eliminate." ),
           new AscError(kError_InvalidBaseTypeExpression, "Classe base non trovata o non è una costante della fase di compilazione." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Interfaccia non trovata o non è una costante della fase di compilazione." ),
           new AscError(kError_StaticModifiedNamespace, "L'attributo static non è consentito nelle definizioni di namespace." ),
           new AscError(kError_InvalidInterfaceNesting, "Le definizioni di interfaccia non possono essere nidificate all'interno di definizioni di classi o di altre interfacce." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "L'attributo prototype non è valido." ),
           new AscError(kError_InaccessibleMethodReference, "Tentativo di accesso al metodo non accessibile %s mediante un riferimento con tipo statico %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Errore di sintassi: era prevista un'espressione dopo l'istruzione throw." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "La classe %s non può estendere %s perché entrambe sono associate a simboli di libreria o alla linea temporale principale." ),
           new AscError(kError_AttributesOnPackage, "Gli attributi non sono consentiti all'interno di una definizione di pacchetto." ),
           new AscError(kError_InternalError, "Errore interno: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Errore di sintassi: inizializzatore for-in non valido; è prevista una sola espressione." ),
           new AscError(kError_IllegalSuperStatement, "Un'istruzione super non può seguire un'istruzione this, super, return o throw." ),
           new AscError(kError_UnfoundPackageProperty, "Accesso alla proprietà non definita %s nel pacchetto %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Nessuna funzione di costruzione predefinita trovata nella classe base %s." ),
           new AscError(kError_BlockCommentNotTerminated, "Trovato /* senza */ corrispondente." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Errore di sintassi: è prevista una parentesi graffa aperta ({) o una stringa letterale (\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "L'istruzione super può essere utilizzata solo come ultimo elemento di un elenco inizializzatore della funzione di costruzione." ),
           new AscError(kError_ThisUsedInInitializer, "Questa parola chiave non può essere utilizzata negli inizializzatori di proprietà." ),
           new AscError(kError_NonConstantConfigInit, "L'inizializzatore di un valore di configurazione deve essere una costante della fase di compilazione." ),
           new AscError(kError_NonConstConfigVar, "Una variabile di configurazione può essere dichiarata solo const." ),
           new AscError(kError_InvalidConfigLocation, "Un valore di configurazione deve essere dichiarato nel livello principale di un programma o di un pacchetto." ),
           new AscError(kError_ShadowedConfigNamespace, "Lo spazio dei nomi % è in conflitto con uno spazio dei nomi di configurazione." ),
           new AscError(kError_InvalidPrecision, "Il valore di Precision deve essere un numero intero compreso tra 1 e 34." ),
           new AscError(kError_WrongVersion, "Versione incompatibile: impossibile fare riferimento alla definizione %s introdotta nella versione %s dal codice della versione %s." ),
           new AscError(kError_LossyConversion, "Inizializzazione non valida: la conversione al tipo %s causa la perdita di dati." ),
   };

   public static final AscError[] errorConstantsJP = { 
           new AscError(kError_AmbiguousReference, "%s への参照があいまいです。" ),
           new AscError(kError_NamespaceAccessSpecifiers, "名前空間の属性にはアクセス指定子を使用できません。" ),
           new AscError(kError_Unknown_Namespace, "名前空間が見つからないか、コンパイル時定数ではありません。" ),
           new AscError(kError_InvalidSuperExpression, "super 式はクラスインスタンスのメソッド内でのみ使用できます。" ),
           new AscError(kError_InvalidSuperStatement, "super 式はクラスインスタンスのコンストラクタ内でのみ使用できます。" ),
           new AscError(kError_InvalidAttribute, "属性が無効です。" ),
           new AscError(kError_InvalidOverride, "override 属性はクラスプロパティの定義でのみ使用できます。" ),
           new AscError(kError_InvalidVirtual, "virtual 属性はクラスプロパティの定義でのみ使用できます。" ),
           new AscError(kError_InvalidStatic, "static 属性はクラス内の定義でのみ使用できます。" ),
           new AscError(kError_InvalidPrivate, "private 属性はクラスプロパティの定義でのみ使用できます。" ),
           new AscError(kError_Unsupported_Intrinsic, "intrinsic 属性はサポートされていません。" ),
           new AscError(kError_BaseClassIsFinal, "基本クラスは final です。" ),
           new AscError(kError_UnknownBaseClass, "基本クラス %s の定義が見つかりませんでした。" ),
           new AscError(kError_DuplicateClassDefinition, "クラス定義が重複しています :%s。" ),
           new AscError(kError_OverrideNotFound, "override としてマークされたメソッドは、別のメソッドをオーバーライドする必要があります。" ),
           new AscError(kError_DuplicateFunction, "関数の定義が重複しています。" ),
           new AscError(kError_OverrideFinalAccessor, "final アクセサをオーバーライドすることはできません。" ),
           new AscError(kError_IncompatibleOverride, "オーバーライドに対応していません。" ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "オーバーライドに対応していない関数をオーバーライドしています。" ),
           new AscError(kError_FinalMethodRedefinition, "最後のメソッドを再定義することはできません。" ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "コンストラクタ関数はインスタンスメソッドでなければなりません。" ),
           new AscError(kError_FuncIsStaticAndOverride, "関数を同時に static および override として設定することはできません。" ),
           new AscError(kError_FuncIsStaticAndVirtual, "関数を同時に static および virtual として設定することはできません。" ),
           new AscError(kError_FuncIsVirtualAndFinal, "関数を同時に final および virtual として設定することはできません。" ),
           new AscError(kError_RestParameterNotNamed, "変数の引数配列の名前を指定する必要があります。" ),
           new AscError(kError_VirtualVars, "仮想変数はサポートされていません。" ),
           new AscError(kError_NativeVars, "変数がネイティブであることはできません。" ),
           new AscError(kError_VarIsFinalAndVirtual, "変数を同時に final および virtual として設定することはできません。" ),
           new AscError(kError_NestedPackage, "パッケージをネストすることはできません。" ),
           new AscError(kError_BreakHasNoTarget, "break ステートメントのターゲットが見つかりませんでした。" ),
           new AscError(kError_ContinueHasNoTarget, "continue ステートメントのターゲットが見つかりませんでした。" ),
           new AscError(kError_DuplicateLabel, "ラベルの定義が重複しています。" ),
           new AscError(kError_AttributesAreNotCallable, "属性は呼び出し可能ではありません。" ),
           new AscError(kError_ThisUsedInStaticFunction, "this キーワードは静的メソッドで使用できません。このキーワードはインスタンスのメソッド、関数閉包、グローバルコード内でのみ使用できます。" ),
           new AscError(kError_UndefinedNamespace, "名前空間が未定義です。" ),
           new AscError(kError_UnknownInterfaceMethod, "インターフェイスメソッド %s (名前空間 %s) はクラス %s によって実装されません。" ),
           new AscError(kError_UnknownInterface, "インターフェイス %s が見つかりませんでした。" ),
           new AscError(kError_UnknownType, "型が見つからないか、コンパイル時定数ではありません : %s。" ),
           new AscError(kError_NonConstantParamInitializer, "パラメータ初期化子が不明か、コンパイル時定数ではありません。" ),
           new AscError(kError_MethodIsNotAConstructor, "メソッドをコンストラクタとして使用することはできません。" ),
           new AscError(kError_AssignmentToConstVar, "定数として指定した変数への代入が無効です。" ),
           new AscError(kError_AssignmentToNonRefVar, "参照値以外の代入はできません。" ),
           new AscError(kError_ReturnTypeMustBeUndefined, "戻り値は未定義でなければなりません。" ),
           new AscError(kError_ConstInitializerNotConst, "定数初期化子が不明か、コンパイル時定数ではありません。" ),
           new AscError(kError_AccessorTypesMustMatch, "アクセサの型が一致している必要があります。" ),
           new AscError(kError_BadSetterReturnType, "setter 定義の戻り型は未指定または void でなければなりません。" ),
           new AscError(kError_PropertyIsWriteOnly, "プロパティは書き込み専用です。" ),
           new AscError(kError_PropertyIsReadOnly, "プロパティは読み取り専用です。" ),
           new AscError(kError_Strict_UndefinedMethod, "未定義である可能性のあるメソッド %s を、静的型 %s の参照を使用して呼び出しました。" ),
           new AscError(kError_UnableToOpenFile, "ファイルを開けません :%s。" ),
           new AscError(kError_InvalidMetaData, "メタデータが無効です。" ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "メタデータ属性が複数のエレメントを持つことはできません。" ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "型 %s の値が、関連しない型 %s に暗黙で型変換されています。" ),
           new AscError(kError_Parser_UnableToOpenFile, "付属ファイルを開けません : %s。" ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "シンタックスエラー : 定義またはディレクティブが必要です。" ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "シンタックスエラー : 属性 %s の後には、%s ではなく定義キーワード (関数など) が必要です。" ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "シンタックスエラー : namespace の前に xml が必要です。" ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "シンタックスエラー : catch 節または finally 節が必要です。" ),
           new AscError(kError_Parser_EachWithoutIn, "シンタックスエラー : 'each' キーワードを 'in' 演算子なしで使用することはできません。" ),
           new AscError(kError_Parser_ExpectedLeftParen, "シンタックスエラー : 識別子の前に左括弧が必要です。" ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel が必要です。" ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "ラベルは単純な識別子でなければなりません。" ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "super 式には 1 つのオペランドが必要です。" ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "インクリメント演算子またはデクリメント演算子が必要です。" ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "括弧内に 1 つの式が必要です。" ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "シンタックスエラー : %s は不要です。" ),
           new AscError(kError_Parser_ExpectedToken, "シンタックスエラー : %s が %s の前に必要です。" ),
           new AscError(kError_Parser_ExpectedSemicolon, "シンタックスエラー : %s の前にセミコロンが必要です。" ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "シンタックスエラー : プログラムの末尾の後に余分な文字が見つかりました。" ),
           new AscError(kError_Lexical_General, "シンタックスエラー。" ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "シンタックスエラー : ストリングリテラルは改行の前に終了する必要があります。" ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "シンタックスエラー : ストリングリテラルは改行の前に終了する必要があります。" ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "シンタックスエラー : ストリングリテラルを閉じる引用符に達する前に入力が終了しました。" ),
           new AscError(kError_Lexical_SyntaxError, "シンタックスエラー。" ),
           new AscError(kError_Lexical_NoMatchingTag, "シンタックスエラー : XML の開始タグと終了タグが一致していません。" ),
           new AscError(kError_CannotDeleteSuperDecendants, "super の子孫を削除することはできません。" ),
           new AscError(kError_DuplicateNamespaceDefinition, "名前空間の定義が重複しています。" ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "代入のターゲットは参照値でなければなりません。" ),
           new AscError(kError_IncrementOperatorNotAReference, "インクリメントのオペランドは参照でなければなりません。" ),
           new AscError(kError_InvalidIncrementOperand, "インクリメントのオペランドが無効です。" ),
           new AscError(kError_InvalidDecrementOperand, "デクリメントのオペランドが無効です。" ),
           new AscError(kError_ExpectingExpression, "式が必要です。" ),
           new AscError(kError_MissingXMLTagName, "XML タグ名が見つかりません。" ),
           new AscError(kError_InvalidAbcFile, "ファイル %s は有効な ABC ファイルではありません。" ),
           new AscError(kError_Parser_FileIncludesItself, "このファイルインクルードにより、無限再帰の可能性があります : %s。" ),
           new AscError(kError_CircularReference, "%s で循環型参照が検出されました。" ),
           new AscError(kError_InvalidPublic, "public 属性はパッケージ内でのみ使用できます。" ),
           new AscError(kError_InvalidInternal, "internal 属性はパッケージ内でのみ使用できます。" ),
           new AscError(kError_InvalidNamespace, "ユーザー定義の名前空間の属性は、クラス定義のトップレベルでのみ使用できます。" ),
           new AscError(kError_ImplicitCoercionToSubtype, "静的型 %s の値が、関連しない可能性が高い型 %s に暗黙で型変換されています。" ),
           new AscError(kError_UndefinedProperty, "未定義である可能性が高いプロパティ %s に静的型 %s の参照を使用してアクセスしています。" ),
           new AscError(kError_UnfoundProperty, "未定義のプロパティ %s へのアクセスです。" ),
           new AscError(kError_GetterCannotHaveParameters, "getter 定義にはパラメータを使用できません。" ),
           new AscError(kError_SetterMustHaveOneParameter, "setter 定義には 1 つのパラメータが必要です。" ),
           new AscError(kError_SetterCannotHaveOptional, "setter 定義には任意指定のパラメータを使用できません。" ),
           new AscError(kError_BadGetterReturnType, "getter 定義の戻り型は void 以外でなければなりません。" ),
           new AscError(kError_InterfaceMethodWithBody, "インターフェイスで定義されたメソッドにボディを含めることはできません。" ),
           new AscError(kError_FunctionWithoutBody, "関数にボディを含めることはできません。" ),
           new AscError(kError_DuplicateAttribute, "属性 %s は複数回指定されています。" ),
           new AscError(kError_DuplicateInterfaceDefinition, "インターフェイス定義が重複しています : %s。" ),
           new AscError(kError_CtorWithReturnType, "コンストラクタは戻り型を指定できません。" ),
           new AscError(kError_InvalidClassNesting, "クラスをネストすることはできません。" ),
           new AscError(kError_InvalidFinalUsage, "final 属性はクラス内で定義されたメソッドでのみ使用できます。" ),
           new AscError(kError_InvalidNative, "native 属性は関数定義でのみ使用できます。" ),
           new AscError(kError_InvalidDynamic, "dynamic 属性はクラス定義でのみ使用できます。" ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "シンタックスエラー : %s は有効なタイプではありません。" ),
           new AscError(kError_WrongNumberOfArguments, "引数の数が正しくありません。正しくは %s です。" ),
           new AscError(kError_TooManyArguments, "引数の数が正しくありません。%s 個以下であることが必要です。" ),
           new AscError(kError_BadRequiredParameter, "必須パラメータを任意パラメータの後に指定することはできません。" ),
           new AscError(kError_VarInInterface, "インターフェイスでは変数の宣言が許可されていません。" ),
           new AscError(kError_InvalidRestDecl, "...残りパラメータ定義のキーワードの後に指定したパラメータで使用できるのは、Array データ型のみです。" ),
           new AscError(kError_CannotExtendInterface, "クラスが拡張できるのは別のクラスのみです。インターフェイスを拡張することはできません。" ),
           new AscError(kError_CannotExtendClass, "インターフェイスが拡張できるのは別のインターフェイスのみです。%s はクラスです。" ),
           new AscError(kError_InvalidOverrideUsage, "override 属性はクラス内で定義されたメソッドでのみ使用できます。" ),
           new AscError(kError_IncompatibleInterfaceMethod, "インターフェイスメソッド %s (名前空間 %s) は、対応していないシグネチャでクラス %s に実装されています。" ),
           new AscError(kError_NativeMethodWithBody, "ネイティブなメソッドにボディを含めることはできません。" ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "コンストラクタは getter メソッドまたは setter メソッド以外でなければなりません。" ),
           new AscError(kError_MissingFilespec, "AS ソースファイルが指定されていません。" ),
           new AscError(kError_CannotReturnFromStaticInit, "return ステートメントを static 初期化コードで使用することはできません。" ),
           new AscError(kError_InvalidProtected, "protected 属性はクラスプロパティの定義でのみ使用できます。" ),
           new AscError(kError_ConflictingNameInNamespace, "定義 %s (名前空間 %s) にコンフリクトが存在します。" ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "継承した定義 %s (名前空間 %s) にコンフリクトが存在します。" ),
           new AscError(kError_ConstructorMustBePublic, "コンストラクタは public としてのみ宣言できます。" ),
           new AscError(kError_ConflictingAccessSpecifiers, "定義には、public、private、protected、または internal のいずれか 1 つのみを指定できます。" ),
           new AscError(kError_InvalidNestedAccessor, "アクセサを他の関数内にネストすることはできません。" ),
           new AscError(kError_CannotInstantiateInterface, "インターフェイスを新しい演算子でインスタンス化することはできません。" ),
           new AscError(kError_BadAccessInterfaceMember, "インターフェイスのメンバーを public、private、protected、または internal として宣言することはできません。" ),
           new AscError(kError_Parser_ExpectedLeftBrace, "シンタックスエラー : 関数ボディの前に左括弧 ({) がありません。" ),
           new AscError(kError_CannotReturnFromPackageInit, "return ステートメントを package 初期化コードで使用することはできません。" ),
           new AscError(kError_InvalidInterfaceNative, "native 属性をインターフェイスの定義で使用することはできません。" ),
           new AscError(kError_MultipleNamespaceAttributes, "1 つの定義に使用できる名前空間の属性は 1 つのみです。" ),
           new AscError(kError_ConflictingInheritedNameInInterface, "メソッド %s は、インターフェイス %s から継承した定義とコンフリクトしています。" ),
           new AscError(kError_InvalidInterfaceAttribute, "インターフェイスの属性 %s が無効です。" ),
           new AscError(kError_NamespaceInInterface, "インターフェイスでは名前空間の宣言が許可されていません。" ),
           new AscError(kError_DuplicateImplements, "クラス %s はインターフェイス %s を複数回実装しています。" ),
           new AscError(kError_AssignmentToDefinedFunction, "関数 %s への代入が不正です。" ),
           new AscError(kError_InterfaceNamespaceAttribute, "インターフェイスのメソッドでは名前空間の属性が許可されていません。" ),
           new AscError(kError_MustReturnValue, "関数は値を返しません。" ),
           new AscError(kError_InvalidNamespaceInitializer, "名前空間の初期化子は、リテラルストリングまたは別の名前空間でなければなりません。" ),
           new AscError(kError_DefinitionNotFound, "定義 %s が見つかりません。" ),
           new AscError(kError_InvalidLabel, "ラベルの定義が無効です。" ),
           new AscError(kError_IncompatableValueComparison, "静的型 %s の値と、関連しない可能性が高い型 %s の値とを比較しています。" ),
           new AscError(kError_CannotReturnFromGlobalInit, "return ステートメントを global 初期化コードで使用することはできません。" ),
           new AscError(kError_InaccessiblePropertyReference, "アクセスできないプロパティ %s へのアクセスを、静的型 %s の参照を使用して試行しました。" ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object は一時的に使用できなくなっています。代わりに :* を使用してください。" ),
           new AscError(kError_Strict_PlainUndefinedMethod, "未定義である可能性が高いメソッド %s の呼び出しです。" ),
           new AscError(kError_ForwardReferenceToBaseClass, "参照を基本クラス %s に送ります。" ),
           new AscError(kError_IllegalPackageReference, "パッケージを値として使用することはできません : %s。" ),
           new AscError(kError_IncompatibleDefaultValue, "対応していない型 %s のデフォルト値です。%s が必要です。" ),
           new AscError(kError_MultipleSwitchDefaults, "switch には 1 つ以上のデフォルトがありますが、デフォルトは 1 つでなければなりません。" ),
           new AscError(kError_AssignmentToDefinedClass, "クラス %s への代入が無効です。" ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "固定プロパティ %s を削除しようとしています。削除できるのは、動的に定義されたプロパティだけです。" ),
           new AscError(kError_InvalidBaseTypeExpression, "基本クラスが見つからないか、コンパイル時定数ではありません。" ),
           new AscError(kError_InvalidInterfaceTypeExpression, "インターフェイスが見つからないか、コンパイル時定数ではありません。" ),
           new AscError(kError_StaticModifiedNamespace, "static 属性を名前空間の定義で使用することはできません。" ),
           new AscError(kError_InvalidInterfaceNesting, "インターフェイスの定義をクラスまたは他のインターフェイスの定義内にネストすることはできません。" ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "プロトタイプの属性が無効です。" ),
           new AscError(kError_InaccessibleMethodReference, "アクセスできないメソッド %s へのアクセスを、静的型 %s の参照を使用して試行しました。" ),
           new AscError(kError_Parser_ThrowWithoutExpression, "シンタックスエラー : throw の後には式が必要です。" ),
           new AscError(kError_Authoring_SymbolClassInheritance, "クラス %s は %s を拡張できません。これらは両方ともライブラリのシンボルまたはメインタイムラインに関連付けられているからです。" ),
           new AscError(kError_AttributesOnPackage, "属性はパッケージ定義で許可されていません。" ),
           new AscError(kError_InternalError, "内部エラー :%s。" ),
           new AscError(kError_ParserInvalidForInInitializer, "シンタックスエラー : 無効な for-in イニシャライザです。式は 1 つだけにしてください。" ),
           new AscError(kError_IllegalSuperStatement, "super ステートメントは、このステートメント、super ステートメント、return ステートメント、または throw ステートメントの後に続けることはできません。" ),
           new AscError(kError_UnfoundPackageProperty, "パッケージ %s 内の未定義のプロパティ %s へのアクセスです。" ),
           new AscError(kError_NoDefaultBaseclassCtor, "基本クラス %s にデフォルトコンストラクタがありません。" ),
           new AscError(kError_BlockCommentNotTerminated, "対応する */ がない /* が見つかりました。" ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "シンタックスエラー : 左かっこ ({) または文字列リテラル (\"\") が必要です。" ),
           new AscError(kError_InvalidES4SuperStatement, "super ステートメントはコンストラクターのイニシャライザーリスト内の最後のアイテムとしてのみ使用できます。" ),
           new AscError(kError_ThisUsedInInitializer, "このキーワードはプロパティのイニシャライザーでは使用できません。" ),
           new AscError(kError_NonConstantConfigInit, "設定値のイニシャライザーはコンパイル時定数である必要があります。" ),
           new AscError(kError_NonConstConfigVar, "設定変数は宣言された定数である必要があります。" ),
           new AscError(kError_InvalidConfigLocation, "設定値はプログラムまたはパッケージの最上位レベルで宣言される必要があります。" ),
           new AscError(kError_ShadowedConfigNamespace, "名前空間 %s は設定名前空間と競合しています。" ),
           new AscError(kError_InvalidPrecision, "精度は 1 ～ 34 の整数である必要があります。" ),
           new AscError(kError_WrongVersion, "互換性のないバージョン : 定義 %s (バージョン %s で導入) をバージョン %s のコードから参照できません。" ),
           new AscError(kError_LossyConversion, "無効な初期化 : タイプ %s に変換すると、データが失われます。" ),
   };

   public static final AscError[] errorConstantsKR = { 
           new AscError(kError_AmbiguousReference, "%s에 대한 참조가 모호합니다." ),
           new AscError(kError_NamespaceAccessSpecifiers, "액세스 지정자는 네임스페이스 속성과 함께 사용할 수 없습니다." ),
           new AscError(kError_Unknown_Namespace, "네임스페이스가 없거나 컴파일 타임 상수가 아닙니다." ),
           new AscError(kError_InvalidSuperExpression, "super 표현식은 클래스 인스턴스 메서드 내에서만 사용할 수 있습니다." ),
           new AscError(kError_InvalidSuperStatement, "super 문은 클래스 인스턴스 생성자 내에서만 사용할 수 있습니다." ),
           new AscError(kError_InvalidAttribute, "속성이 유효하지 않습니다." ),
           new AscError(kError_InvalidOverride, "override 속성은 클래스 속성 정의에만 사용할 수 있습니다." ),
           new AscError(kError_InvalidVirtual, "virtual 속성은 클래스 속성 정의에만 사용할 수 있습니다." ),
           new AscError(kError_InvalidStatic, "static 속성은 클래스 내의 정의에만 사용할 수 있습니다." ),
           new AscError(kError_InvalidPrivate, "private 속성은 클래스 속성 정의에만 사용할 수 있습니다." ),
           new AscError(kError_Unsupported_Intrinsic, "intrinsic 속성은 더 이상 지원되지 않습니다." ),
           new AscError(kError_BaseClassIsFinal, "기저 클래스는 final입니다." ),
           new AscError(kError_UnknownBaseClass, "기저 클래스 %s의 정의를 찾을 수 없습니다." ),
           new AscError(kError_DuplicateClassDefinition, "중복된 클래스 정의: %s." ),
           new AscError(kError_OverrideNotFound, "override로 표시된 메서드에서 다른 메서드를 재정의해야 합니다." ),
           new AscError(kError_DuplicateFunction, "함수 정의가 중복되었습니다." ),
           new AscError(kError_OverrideFinalAccessor, "final 접근자를 재정의할 수 없습니다." ),
           new AscError(kError_IncompatibleOverride, "호환되지 않는 재정의입니다." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "override로 표시되지 않은 함수를 재정의하고 있습니다." ),
           new AscError(kError_FinalMethodRedefinition, "final 메서드를 재정의할 수 없습니다." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "생성자 함수는 인스턴스 메서드여야 합니다." ),
           new AscError(kError_FuncIsStaticAndOverride, "함수는 static이면서 override일 수 없습니다." ),
           new AscError(kError_FuncIsStaticAndVirtual, "함수는 static이면서 virtual일 수 없습니다." ),
           new AscError(kError_FuncIsVirtualAndFinal, "함수는 final이면서 virtual일 수 없습니다." ),
           new AscError(kError_RestParameterNotNamed, "가변 인수 배열의 이름을 지정해야 합니다." ),
           new AscError(kError_VirtualVars, "virtual 변수는 지원되지 않습니다." ),
           new AscError(kError_NativeVars, "변수는 native일 수 없습니다." ),
           new AscError(kError_VarIsFinalAndVirtual, "변수는 final이면서 virtual일 수 없습니다." ),
           new AscError(kError_NestedPackage, "패키지는 중첩될 수 없습니다." ),
           new AscError(kError_BreakHasNoTarget, "break 문의 대상을 찾을 수 없습니다." ),
           new AscError(kError_ContinueHasNoTarget, "continue 문의 대상을 찾을 수 없습니다." ),
           new AscError(kError_DuplicateLabel, "레이블 정의가 중복되었습니다." ),
           new AscError(kError_AttributesAreNotCallable, "속성을 호출할 수 없습니다." ),
           new AscError(kError_ThisUsedInStaticFunction, "this 키워드는 정적 메서드에 사용할 수 없습니다. 인스턴스 메서드, 함수 종결 및 전역 코드에만 이 키워드를 사용할 수 있습니다." ),
           new AscError(kError_UndefinedNamespace, "정의되지 않은 네임스페이스입니다." ),
           new AscError(kError_UnknownInterfaceMethod, "인터페이스 메서드 %s(%s 네임스페이스)이(가) %s 클래스에서 구현되지 않았습니다." ),
           new AscError(kError_UnknownInterface, "%s 인터페이스를 찾을 수 없습니다." ),
           new AscError(kError_UnknownType, "유형이 없거나 컴파일 타임 상수가 아닙니다: %s." ),
           new AscError(kError_NonConstantParamInitializer, "매개 변수 이니셜라이저가 컴파일 타임 상수가 아니거나 알 수 없습니다." ),
           new AscError(kError_MethodIsNotAConstructor, "메서드를 생성자로 사용할 수 없습니다." ),
           new AscError(kError_AssignmentToConstVar, "상수로 지정된 변수에 대한 할당이 잘못되었습니다." ),
           new AscError(kError_AssignmentToNonRefVar, "참조가 아닌 값에 할당할 수 없습니다." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "반환 값이 정의되지 않아야 합니다." ),
           new AscError(kError_ConstInitializerNotConst, "상수 이니셜라이저가 컴파일 타임 상수가 아니거나 알 수 없습니다." ),
           new AscError(kError_AccessorTypesMustMatch, "접근자 유형이 일치해야 합니다." ),
           new AscError(kError_BadSetterReturnType, "setter 정의의 반환 유형은 지정되지 않거나 void여야 합니다." ),
           new AscError(kError_PropertyIsWriteOnly, "속성이 쓰기 전용입니다." ),
           new AscError(kError_PropertyIsReadOnly, "속성이 읽기 전용입니다." ),
           new AscError(kError_Strict_UndefinedMethod, "정의되지 않은 메서드 %s을(를) 정적 유형 %s의 참조를 통해 호출했습니다." ),
           new AscError(kError_UnableToOpenFile, "다음 파일을 열 수 없습니다: %s." ),
           new AscError(kError_InvalidMetaData, "메타데이터가 잘못되었습니다." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "메타데이터 속성은 여러 요소를 가질 수 없습니다." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "%s 유형의 값을 관련되지 않은 유형 %s(으)로 암시적으로 강제 변환하려고 했습니다." ),
           new AscError(kError_Parser_UnableToOpenFile, "포함된 다음 파일을 열 수 없습니다: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "구문 오류: 정의 또는 지시문이 필요합니다." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "구문 오류: %s 속성(%s 아님) 다음에 함수 등의 정의 키워드가 필요합니다." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "구문 오류: 네임스페이스 앞에 xml이 필요합니다." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "구문 오류: catch 또는 finally 절이 필요합니다." ),
           new AscError(kError_Parser_EachWithoutIn, "구문 오류: 'each' 키워드는 'in' 연산자가 있어야 사용할 수 있습니다." ),
           new AscError(kError_Parser_ExpectedLeftParen, "구문 오류: 식별자 앞에 여는 괄호가 필요합니다." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel이 필요합니다." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "레이블은 간단한 식별자여야 합니다." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "super 표현식에는 피연산자가 하나만 있어야 합니다." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "증가 또는 감소 연산자가 필요합니다." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "괄호 안에 단일 표현식이 필요합니다." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "구문 오류: 예기치 못한 %s입니다." ),
           new AscError(kError_Parser_ExpectedToken, "구문 오류: %s이(가) %s 앞에 필요합니다." ),
           new AscError(kError_Parser_ExpectedSemicolon, "구문 오류: %s 앞에 세미콜론이 필요합니다." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "구문 오류: 프로그램 끝 다음에 추가 문자가 있습니다." ),
           new AscError(kError_Lexical_General, "구문 오류입니다." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "구문 오류: 문자열 리터럴은 행 분리 문자 앞에서 끝나야 합니다." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "구문 오류: 문자열 리터럴은 행 분리 문자 앞에서 끝나야 합니다." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "구문 오류: 문자열 리터럴의 닫는 따옴표에 도달하기 전에 입력이 끝났습니다." ),
           new AscError(kError_Lexical_SyntaxError, "구문 오류입니다." ),
           new AscError(kError_Lexical_NoMatchingTag, "구문 오류: XML에서 상응하는 시작 및 종료 태그가 없습니다." ),
           new AscError(kError_CannotDeleteSuperDecendants, "super 자손은 삭제할 수 없습니다." ),
           new AscError(kError_DuplicateNamespaceDefinition, "중복된 네임스페이스 정의입니다." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "할당 대상은 참조 값이어야 합니다." ),
           new AscError(kError_IncrementOperatorNotAReference, "증가의 피연산자는 참조여야 합니다." ),
           new AscError(kError_InvalidIncrementOperand, "증가 피연산자가 잘못되었습니다." ),
           new AscError(kError_InvalidDecrementOperand, "감소 피연산자가 잘못되었습니다." ),
           new AscError(kError_ExpectingExpression, "표현식이 필요합니다." ),
           new AscError(kError_MissingXMLTagName, "XML 태그 이름이 없습니다." ),
           new AscError(kError_InvalidAbcFile, "%s 파일은 올바른 ABC 파일이 아닙니다." ),
           new AscError(kError_Parser_FileIncludesItself, "이 파일에는 다음이 포함되어 있으므로 무한 재귀가 발생할 수 있습니다: %s." ),
           new AscError(kError_CircularReference, "%s에서 순환 유형 참조가 발견되었습니다." ),
           new AscError(kError_InvalidPublic, "public 속성은 패키지 내에서만 사용할 수 있습니다." ),
           new AscError(kError_InvalidInternal, "internal 속성은 패키지 내에서만 사용할 수 있습니다." ),
           new AscError(kError_InvalidNamespace, "사용자 정의 네임스페이스 속성은 최상위 클래스 정의에서만 사용할 수 있습니다." ),
           new AscError(kError_ImplicitCoercionToSubtype, "정적 유형 %s의 값을 관련되지 않은 유형 %s(으)로 암시적으로 강제 변환하려고 했습니다." ),
           new AscError(kError_UndefinedProperty, "정의되지 않은 속성 %s을(를) 정적 유형 %s의 참조를 통해 액세스했습니다." ),
           new AscError(kError_UnfoundProperty, "정의되지 않은 속성 %s에 액세스했습니다." ),
           new AscError(kError_GetterCannotHaveParameters, "getter 정의에는 매개 변수가 없어야 합니다." ),
           new AscError(kError_SetterMustHaveOneParameter, "setter 정의에는 매개 변수가 하나만 있어야 합니다." ),
           new AscError(kError_SetterCannotHaveOptional, "setter 정의에는 선택적 매개 변수를 포함할 수 없습니다." ),
           new AscError(kError_BadGetterReturnType, "getter 정의의 반환 유형은 void가 아니어야 합니다." ),
           new AscError(kError_InterfaceMethodWithBody, "인터페이스에 정의된 메서드에는 본문이 없어야 합니다." ),
           new AscError(kError_FunctionWithoutBody, "함수에 본문이 없습니다." ),
           new AscError(kError_DuplicateAttribute, "%s 속성이 여러 번 지정되었습니다." ),
           new AscError(kError_DuplicateInterfaceDefinition, "중복된 인터페이스 정의: %s." ),
           new AscError(kError_CtorWithReturnType, "생성자는 반환 유형을 지정할 수 없습니다." ),
           new AscError(kError_InvalidClassNesting, "클래스는 중첩되면 안됩니다." ),
           new AscError(kError_InvalidFinalUsage, "클래스에 정의된 메서드에만 final 속성을 사용할 수 있습니다." ),
           new AscError(kError_InvalidNative, "native 속성은 함수 정의와 함께 사용해야 합니다." ),
           new AscError(kError_InvalidDynamic, "dynamic 속성은 클래스 정의와 함께 사용해야 합니다." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "구문 오류: %s은(는) 유효한 유형이 아닙니다." ),
           new AscError(kError_WrongNumberOfArguments, "인수 개수가 잘못되었습니다. %s개의 인수가 필요합니다." ),
           new AscError(kError_TooManyArguments, "인수 개수가 잘못되었습니다. %s개 이하여야 합니다." ),
           new AscError(kError_BadRequiredParameter, "선택적 매개 변수 다음에는 필수 매개 변수가 올 수 없습니다." ),
           new AscError(kError_VarInInterface, "인터페이스에서는 변수를 선언할 수 없습니다." ),
           new AscError(kError_InvalidRestDecl, "...rest 매개 변수 정의 키워드 다음에 지정되는 매개 변수는 Array 데이터 유형이어야 합니다." ),
           new AscError(kError_CannotExtendInterface, "클래스는 인터페이스를 확장할 수 없고 다른 클래스만 확장할 수 있습니다." ),
           new AscError(kError_CannotExtendClass, "인터페이스는 다른 인터페이스만 확장할 수 있는데 %s은(는) 클래스입니다." ),
           new AscError(kError_InvalidOverrideUsage, "override 속성은 클래스에 정의된 메서드에만 사용할 수 있습니다." ),
           new AscError(kError_IncompatibleInterfaceMethod, "인터페이스 메서드 %s(%s 네임스페이스)이(가) %s 클래스의 호환되지 않는 서명으로 구현되었습니다." ),
           new AscError(kError_NativeMethodWithBody, "원시 메서드는 본문을 포함할 수 없습니다." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "생성자는 getter 또는 setter 메서드일 수 없습니다." ),
           new AscError(kError_MissingFilespec, "AS 소스 파일이 지정되지 않았습니다." ),
           new AscError(kError_CannotReturnFromStaticInit, "정적 초기화 코드에는 return 문을 사용할 수 없습니다." ),
           new AscError(kError_InvalidProtected, "protected 속성은 클래스 속성 정의에만 사용할 수 있습니다." ),
           new AscError(kError_ConflictingNameInNamespace, "%s 정의(%s 네임스페이스)와 충돌이 발생했습니다." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "상속된 정의 %s(%s 네임스페이스)과(와) 충돌이 발생했습니다." ),
           new AscError(kError_ConstructorMustBePublic, "생성자는 public으로만 선언될 수 있습니다." ),
           new AscError(kError_ConflictingAccessSpecifiers, "public, private, protected 또는 internal 중 하나만 정의에 지정될 수 있습니다." ),
           new AscError(kError_InvalidNestedAccessor, "접근자는 다른 함수 내에 중첩될 수 없습니다." ),
           new AscError(kError_CannotInstantiateInterface, "새 연산자로 인터페이스를 인스턴스화할 수 없습니다." ),
           new AscError(kError_BadAccessInterfaceMember, "인터페이스 멤버는 public, private, protected 또는 internal로 선언될 수 없습니다." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "구문 오류: 함수 본문 앞에 여는 중괄호({)가 없습니다." ),
           new AscError(kError_CannotReturnFromPackageInit, "패키지 초기화 코드에는 return 문을 사용할 수 없습니다." ),
           new AscError(kError_InvalidInterfaceNative, "인터페이스 정의에는 native 속성을 사용할 수 없습니다." ),
           new AscError(kError_MultipleNamespaceAttributes, "namespace 속성은 정의당 하나만 사용할 수 있습니다." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "%s 메서드가 %s 인터페이스에서 상속된 정의와 충돌합니다." ),
           new AscError(kError_InvalidInterfaceAttribute, "인터페이스 속성 %s이(가) 잘못되었습니다." ),
           new AscError(kError_NamespaceInInterface, "인터페이스에는 네임스페이스를 선언할 수 없습니다." ),
           new AscError(kError_DuplicateImplements, "%s 클래스에서 %s 인터페이스를 여러 번 구현합니다." ),
           new AscError(kError_AssignmentToDefinedFunction, "%s 함수에 대한 할당이 잘못되었습니다." ),
           new AscError(kError_InterfaceNamespaceAttribute, "인터페이스 메서드에는 namespace 속성을 사용할 수 없습니다." ),
           new AscError(kError_MustReturnValue, "함수에서 값을 반환하지 않습니다." ),
           new AscError(kError_InvalidNamespaceInitializer, "네임스페이스 이니셜라이저는 리터럴 문자열이나 다른 네임스페이스여야 합니다." ),
           new AscError(kError_DefinitionNotFound, "%s 정의를 찾을 수 없습니다." ),
           new AscError(kError_InvalidLabel, "레이블 정의가 잘못되었습니다." ),
           new AscError(kError_IncompatableValueComparison, "정적 유형 %s의 값과 관련되지 않은 유형 %s을(를) 비교하려고 했습니다." ),
           new AscError(kError_CannotReturnFromGlobalInit, "전역 초기화 코드에는 return 문을 사용할 수 없습니다." ),
           new AscError(kError_InaccessiblePropertyReference, "액세스할 수 없는 속성 %s을(를) 정적 유형 %s의 참조를 통해 액세스하려고 했습니다." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object is temporarily out of service. Use :* instead." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "정의되지 않은 메서드 %s을(를) 호출했습니다." ),
           new AscError(kError_ForwardReferenceToBaseClass, "기저 클래스 %s에 대한 전방 참조입니다." ),
           new AscError(kError_IllegalPackageReference, "패키지를 값으로 사용할 수 없습니다: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "%s 유형의 호환되지 않는 기본값입니다. %s이(가) 필요합니다." ),
           new AscError(kError_MultipleSwitchDefaults, "switch 문의 기본값이 여러 개입니다. 기본값은 하나만 사용할 수 있습니다." ),
           new AscError(kError_AssignmentToDefinedClass, "%s 클래스에 대한 할당이 잘못되었습니다." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "고정된 속성 %s을(를) 삭제하려고 합니다. 동적으로 정의된 속성만 삭제할 수 있습니다." ),
           new AscError(kError_InvalidBaseTypeExpression, "기저 클래스가 없거나 컴파일 타임 상수가 아닙니다." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "인터페이스가 없거나 컴파일 타임 상수가 아닙니다." ),
           new AscError(kError_StaticModifiedNamespace, "네임스페이스 정의에는 static 속성을 사용할 수 없습니다." ),
           new AscError(kError_InvalidInterfaceNesting, "인터페이스 정의는 클래스나 다른 인터페이스 정의 내에 중첩되면 안됩니다." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "prototype 속성이 잘못되었습니다." ),
           new AscError(kError_InaccessibleMethodReference, "액세스할 수 없는 메서드 %s을(를) 정적 유형 %s의 참조를 통해 액세스하려고 했습니다." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "구문 오류: throw 다음에 표현식이 필요합니다." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "%s 클래스에서 %s을(를) 확장할 수 없습니다. 둘 다 라이브러리 심볼이나 기본 타임라인과 연결되어 있기 때문입니다." ),
           new AscError(kError_AttributesOnPackage, "패키지 정의에는 속성을 사용할 수 없습니다." ),
           new AscError(kError_InternalError, "내부 오류: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "구문 오류: for-in 이니셜라이저가 잘못되었습니다. 하나의 표현식만 필요합니다." ),
           new AscError(kError_IllegalSuperStatement, "this, super, return 또는 throw 문 다음에는 super 문이 올 수 없습니다." ),
           new AscError(kError_UnfoundPackageProperty, "정의되지 않은 속성 %s(%s 패키지)에 액세스했습니다." ),
           new AscError(kError_NoDefaultBaseclassCtor, "기저 클래스 %s에 기본 생성자가 없습니다." ),
           new AscError(kError_BlockCommentNotTerminated, "/* 일치 항목 없음 */" ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "구문 오류: 왼쪽 중괄호({) 또는 문자열 리터럴(\"\")이 있어야 합니다." ),
           new AscError(kError_InvalidES4SuperStatement, "super 명령문은 생성자 이니셜라이저 목록의 마지막 항목으로만 사용할 수 있습니다." ),
           new AscError(kError_ThisUsedInInitializer, "이 키워드는 특성 이니셜라이저에 사용할 수 없습니다." ),
           new AscError(kError_NonConstantConfigInit, "구성 값의 이니셜라이저는 컴파일 타임 상수여야 합니다." ),
           new AscError(kError_NonConstConfigVar, "구성 변수는 선언된 상수여야만 합니다." ),
           new AscError(kError_InvalidConfigLocation, "구성 값은 프로그램 또는 패키지의 맨 위 레벨에서 선언되어야 합니다." ),
           new AscError(kError_ShadowedConfigNamespace, "네임스페이스 %s이(가) 구성 네임스페이스와 충돌합니다." ),
           new AscError(kError_InvalidPrecision, "정밀도는 1 - 34 사이의 정수여야 합니다." ),
           new AscError(kError_WrongVersion, "호환되지 않는 버전: 정의 %s(%s 버전에 도입됨)을(를) %s 버전의 코드에서 참조할 수 없습니다." ),
           new AscError(kError_LossyConversion, "잘못된 초기화: 유형 %s(으)로 변환하면 데이터가 손실됩니다." ),
   };

   public static final AscError[] errorConstantsNB = { 
           new AscError(kError_AmbiguousReference, "Tvetydig referanse til %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Tilgangsspesifikasjoner er ikke tillatt med navneområdeattributter." ),
           new AscError(kError_Unknown_Namespace, "Finner ikke navneområde, eller så er det ikke en konstant under kompilering." ),
           new AscError(kError_InvalidSuperExpression, "Et superuttrykk kan kun brukes i klasseforekomstmetoder." ),
           new AscError(kError_InvalidSuperStatement, "En supersetning kan kun brukes i klasseforekomstkonstruktører." ),
           new AscError(kError_InvalidAttribute, "Attributtet er ugyldig." ),
           new AscError(kError_InvalidOverride, "Attributtet override kan kun brukes på klasseegenskapsdefinisjoner." ),
           new AscError(kError_InvalidVirtual, "Attributtet virtual kan kun brukes på klasseegenskapsdefinisjoner." ),
           new AscError(kError_InvalidStatic, "Attributtet static kan bare brukes på definisjoner i en klasse." ),
           new AscError(kError_InvalidPrivate, "Attributtet private kan kun brukes på klasseegenskapsdefinisjoner." ),
           new AscError(kError_Unsupported_Intrinsic, "Attributtet intrinsic støttes ikke lenger." ),
           new AscError(kError_BaseClassIsFinal, "Grunnklassen er final." ),
           new AscError(kError_UnknownBaseClass, "Finner ikke definisjonen av grunnklassen %s." ),
           new AscError(kError_DuplicateClassDefinition, "Duplisert klassedefinisjon: %s." ),
           new AscError(kError_OverrideNotFound, "Metoden som er markert som overstyring, må overstyre en annen metode." ),
           new AscError(kError_DuplicateFunction, "Duplisert funksjonsdefinisjon." ),
           new AscError(kError_OverrideFinalAccessor, "Kan ikke overstyre en final-aksessor." ),
           new AscError(kError_IncompatibleOverride, "Inkompatibel overstyring." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Overstyrer en funksjon som ikke er merket for overstyring." ),
           new AscError(kError_FinalMethodRedefinition, "Kan ikke omdefinere en final-metode." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Konstruktørfunksjoner må være forekomstmetoder." ),
           new AscError(kError_FuncIsStaticAndOverride, "Funksjoner kan ikke være både static og override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Funksjoner kan ikke være både static og virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Funksjoner kan ikke være både final og virtual." ),
           new AscError(kError_RestParameterNotNamed, "Navn på matrise med variable argumenter må angis." ),
           new AscError(kError_VirtualVars, "Virtual-variabler støttes ikke." ),
           new AscError(kError_NativeVars, "Variabler kan ikke være innebygde." ),
           new AscError(kError_VarIsFinalAndVirtual, "Variabler kan ikke være både final og virtual." ),
           new AscError(kError_NestedPackage, "Pakker kan ikke nestes." ),
           new AscError(kError_BreakHasNoTarget, "Finner ikke målet for bruddsetningen." ),
           new AscError(kError_ContinueHasNoTarget, "Finner ikke målet for fortsett-setningen." ),
           new AscError(kError_DuplicateLabel, "Duplisert etikettdefinisjon." ),
           new AscError(kError_AttributesAreNotCallable, "Attributter kan ikke kalles på." ),
           new AscError(kError_ThisUsedInStaticFunction, "Nøkkelordet «this» kan ikke brukes i statiske metoder. Det kan bare brukes i forekomstmetoder, funksjonsavslutninger og global kode." ),
           new AscError(kError_UndefinedNamespace, "Udefinert navneområde." ),
           new AscError(kError_UnknownInterfaceMethod, "Grensesnittmetoden %s i navneområdet %s er ikke implementert av klassen %s." ),
           new AscError(kError_UnknownInterface, "Finner ikke grensesnittet %s." ),
           new AscError(kError_UnknownType, "Finner ikke typen, eller så er den ikke en konstant under kompilering: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Initialisering for parameter ukjent, eller så er den ikke en konstant under kompilering." ),
           new AscError(kError_MethodIsNotAConstructor, "Metoden kan ikke brukes som en konstruktør." ),
           new AscError(kError_AssignmentToConstVar, "Ugyldig tilordning til en variabel som er angitt som en konstant." ),
           new AscError(kError_AssignmentToNonRefVar, "Kan ikke tilordne en verdi som ikke er en referanse." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Returverdien må være udefinert." ),
           new AscError(kError_ConstInitializerNotConst, "Initialisering for konstant er ukjent, eller så er den ikke en konstant under kompilering." ),
           new AscError(kError_AccessorTypesMustMatch, "Aksessortyper må stemme overens." ),
           new AscError(kError_BadSetterReturnType, "Returtype for en setterdefinisjon må være uspesifisert eller tom." ),
           new AscError(kError_PropertyIsWriteOnly, "Egenskapen er skrivebeskyttet." ),
           new AscError(kError_PropertyIsReadOnly, "Egenskapen er skrivebeskyttet." ),
           new AscError(kError_Strict_UndefinedMethod, "Kall til en mulig udefinert metode %s via en referanse med statisk type %s." ),
           new AscError(kError_UnableToOpenFile, "Kan ikke åpne fil: %s." ),
           new AscError(kError_InvalidMetaData, "Ugyldig metadata." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Metadataattributter kan ikke ha mer enn ett element." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Implisitt tvang av en verdi av typen %s til en urelatert type, %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Kan ikke åpne inkludert fil: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntaksfeil: forventet definisjon eller direktiv." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntaksfeil: forventet et definisjonsnøkkelord (f.eks. en funksjon) etter attributtet %s, ikke %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntaksfeil: forventer xml før navneområde." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntaksfeil: forventer en catch- eller finally-klausul." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntaksfeil: Nøkkelordet «each» er ikke tillatt uten en «in»-operator." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntaksfeil: forventer parentes begynner-tegn før identifikator." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Forventer CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Etiketten må være en enkel identifikator." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Et superuttrykk må ha én operand." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Forventer øknings- eller senkningsoperator." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Forventer ett enkelt uttrykk i parentes." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntaksfeil: %s er ikke forventet." ),
           new AscError(kError_Parser_ExpectedToken, "Syntaksfeil: forventer %s før %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntaksfeil: forventer semikolon før %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntaksfeil: fant ekstra tegn etter slutten på programmet." ),
           new AscError(kError_Lexical_General, "Syntaksfeil." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntaksfeil: En strenglitteral må avsluttes før linjeskiftet." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntaksfeil: En strenglitteral må avsluttes før linjeskiftet." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntaksfeil: Inndata ble avsluttet før det nådde anførselstegnet som avslutter en strenglitteral." ),
           new AscError(kError_Lexical_SyntaxError, "Syntaksfeil." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntaksfeil: XML har ikke overensstemmende start- og sluttkoder." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Kan ikke slette superetterkommere." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Duplisert navneområdedefinisjon." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Målet for tilordningen må være en referanseverdi." ),
           new AscError(kError_IncrementOperatorNotAReference, "Operanden for økningen må være en referanse." ),
           new AscError(kError_InvalidIncrementOperand, "Økningsoperanden er ugyldig." ),
           new AscError(kError_InvalidDecrementOperand, "Senkningsoperanden er ugyldig." ),
           new AscError(kError_ExpectingExpression, "Forventer et uttrykk." ),
           new AscError(kError_MissingXMLTagName, "Mangler XML-kodenavn." ),
           new AscError(kError_InvalidAbcFile, "Filen %s er ikke en gyldig ABC-fil." ),
           new AscError(kError_Parser_FileIncludesItself, "Mulig uendelig rekursjon som skyldes denne filen, inkluderer: %s." ),
           new AscError(kError_CircularReference, "Referanse med sirkulær type funnet i %s." ),
           new AscError(kError_InvalidPublic, "Attributtet public kan kun brukes i en pakke." ),
           new AscError(kError_InvalidInternal, "Attributtet internal kan kun brukes i en pakke." ),
           new AscError(kError_InvalidNamespace, "Et brukerdefinert navneområdeattributt kan kun brukes i toppnivået til en klassedefinisjon." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Implisitt tvang av en verdi med den statiske typen %s til en mulig urelatert type, %s." ),
           new AscError(kError_UndefinedProperty, "Tilgang til den mulig udefinerte egenskapen %s via en referanse med statisk type %s." ),
           new AscError(kError_UnfoundProperty, "Tilgang til den udefinerte egenskapen %s." ),
           new AscError(kError_GetterCannotHaveParameters, "En getter-definisjon kan ikke ha noen parametere." ),
           new AscError(kError_SetterMustHaveOneParameter, "En setter-definisjon må ha én enkelt parameter." ),
           new AscError(kError_SetterCannotHaveOptional, "En setter-definisjon kan ikke ha valgfrie parametere." ),
           new AscError(kError_BadGetterReturnType, "Returtypen til en getter-definisjon kan ikke være tom." ),
           new AscError(kError_InterfaceMethodWithBody, "Metoder som er definert i et grensesnitt, kan ikke ha en kropp." ),
           new AscError(kError_FunctionWithoutBody, "Funksjonen har ikke en kropp." ),
           new AscError(kError_DuplicateAttribute, "Attributtet %s ble spesifisert flere ganger." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Duplisert grensesnittdefinisjon: %s." ),
           new AscError(kError_CtorWithReturnType, "En konstruktør kan ikke spesifisere en returtype." ),
           new AscError(kError_InvalidClassNesting, "Klasser kan ikke være nestet." ),
           new AscError(kError_InvalidFinalUsage, "Attributtet final kan bare brukes på en metode som er definert i en klasse." ),
           new AscError(kError_InvalidNative, "Attributtet native kan kun brukes med funksjonsdefinisjoner." ),
           new AscError(kError_InvalidDynamic, "Attributtet dynamic kan kun brukes med klassedefinisjoner." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntaksfeil: %s er ikke en gyldig type." ),
           new AscError(kError_WrongNumberOfArguments, "Feil antall argumenter. Forventet %s." ),
           new AscError(kError_TooManyArguments, "Feil antall argumenter. Forventet maksimum %s." ),
           new AscError(kError_BadRequiredParameter, "De påkrevde parametrene er ikke tillatt etter valgfrie parametere." ),
           new AscError(kError_VarInInterface, "Variabeldeklarasjoner er ikke tillatt i grensesnitt." ),
           new AscError(kError_InvalidRestDecl, "Parametere som er angitt etter parameterdefinisjonsnøkkelordet ...rest, kan kun være en Array-datatype." ),
           new AscError(kError_CannotExtendInterface, "En klasse kan kun forlenge en annen klasse, ikke et grensesnitt." ),
           new AscError(kError_CannotExtendClass, "Et grensesnitt kan kun forlenge andre grensesnitt, men %s er en klasse." ),
           new AscError(kError_InvalidOverrideUsage, "Attributtet override kan bare brukes på en metode som er definert i en klasse." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Grensesnittmetoden %s i navneområdet %s er implementert med en inkompatibel signatur i klassen %s." ),
           new AscError(kError_NativeMethodWithBody, "Innebygde metoder kan ikke ha en kropp." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "En konstruktør kan ikke være en getter- eller settermetode." ),
           new AscError(kError_MissingFilespec, "Ingen AS-kildefil ble spesifisert." ),
           new AscError(kError_CannotReturnFromStaticInit, "Retursetningen kan ikke brukes i statisk initialiseringskode." ),
           new AscError(kError_InvalidProtected, "Attributtet protected kan kun brukes på klasseegenskapsdefinisjoner." ),
           new AscError(kError_ConflictingNameInNamespace, "Det finnes en konflikt med definisjonen %s i navneområdet %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Det finnes en konflikt med den arvede definisjonen %s i navneområdet %s." ),
           new AscError(kError_ConstructorMustBePublic, "En konstruktør kan kun deklareres som public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Du kan bare spesifisere ett av attributtene public, private, protected og internal i en definisjon." ),
           new AscError(kError_InvalidNestedAccessor, "Aksessorer kan ikke nestes i andre funksjoner." ),
           new AscError(kError_CannotInstantiateInterface, "Grensesnitt kan ikke representeres med den nye operatoren." ),
           new AscError(kError_BadAccessInterfaceMember, "Grensesnittmedlemmer kan ikke deklareres som public, private, protected eller internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntaksfeil: mangler venstre klamme ({) før funksjonens kropp." ),
           new AscError(kError_CannotReturnFromPackageInit, "Retursetningen kan ikke brukes i pakkeinitialiseringskode." ),
           new AscError(kError_InvalidInterfaceNative, "Det innebygde attributtet kan ikke brukes i grensesnittdefinisjoner." ),
           new AscError(kError_MultipleNamespaceAttributes, "Bare ett navneområdeattributt kan brukes per definisjon." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Metoden %s er i konflikt med definisjonen som er arvet fra grensesnittet %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Grensesnittattributtet %s er ugyldig." ),
           new AscError(kError_NamespaceInInterface, "Navneområdedeklarasjoner er ikke tillatt i grensesnitt." ),
           new AscError(kError_DuplicateImplements, "Klassen %s implementerer grensesnittet %s flere ganger." ),
           new AscError(kError_AssignmentToDefinedFunction, "Ugyldig tilordning til funksjonen %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Navneområdeattributter er ikke tillatt på grensesnittmetoder." ),
           new AscError(kError_MustReturnValue, "Funksjonen returnerer ikke en verdi." ),
           new AscError(kError_InvalidNamespaceInitializer, "En navneområdeinitialisering må være enten en litteralstreng eller et annet navneområde." ),
           new AscError(kError_DefinitionNotFound, "Finner ikke definisjonen %s." ),
           new AscError(kError_InvalidLabel, "Etikettdefinisjonen er ugyldig." ),
           new AscError(kError_IncompatableValueComparison, "Sammenligning mellom en verdi med den statiske typen %s og en mulig urelatert type, %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Retursetningen kan ikke brukes i global initialiseringskode." ),
           new AscError(kError_InaccessiblePropertyReference, "Forsøkte å få tilgang til en egenskap, %s, som ikke er tilgjengelig, via en referanse med statisk type %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Objektet er midlertidig utilgjengelig. Bruk :* i stedet." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Kall til en mulig udefinert metode, %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Foroverrettet referanse til grunnklasse %s." ),
           new AscError(kError_IllegalPackageReference, "Pakken kan ikke brukes som en verdi: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Inkompatibel standardverdi av typen %s der det er forventet %s." ),
           new AscError(kError_MultipleSwitchDefaults, "Bryteren har mer enn én standard, men bare én standard er tillatt." ),
           new AscError(kError_AssignmentToDefinedClass, "Ikke tillatt tilordning til klassen %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Forsøker å slette den faste egenskapen %s. Kun dynamisk definerte egenskaper kan slettes." ),
           new AscError(kError_InvalidBaseTypeExpression, "Finner ikke grunnklassen, eller så er den ikke en konstant under kompilering." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Finner ikke grensesnittet, eller så er det ikke en konstant under kompilering." ),
           new AscError(kError_StaticModifiedNamespace, "Attributtet static er ikke tillatt i navneområdedefinisjoner." ),
           new AscError(kError_InvalidInterfaceNesting, "Grensesnittdefinisjoner kan ikke være nestet i klassedefinisjoner eller andre grensesnittdefinisjoner." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Prototypeattributtet er ugyldig." ),
           new AscError(kError_InaccessibleMethodReference, "Forsøkte å få tilgang til en metode som ikke er tilgjengelig, %s, via en referanse med statisk type %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntaksfeil: forventer et uttrykk etter kastet." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Klassen %s kan ikke forlenge %s, da begge er tilordnet biblioteksymboler eller hovedtidslinjen." ),
           new AscError(kError_AttributesOnPackage, "Attributter er ikke tillatt på pakkedefinisjon." ),
           new AscError(kError_InternalError, "Intern feil: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntaksfeil: ugyldig for-in-initialisering, forventet kun ett uttrykk." ),
           new AscError(kError_IllegalSuperStatement, "En supersetning kan ikke forekomme etter en setning av typen this, super, return eller throw." ),
           new AscError(kError_UnfoundPackageProperty, "Tilgang til den udefinerte egenskapen %s i pakken %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Finner ingen standardkonstruktør i grunnklassen %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* funnet uten tilsvarende */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntaksfeil: forventer en venstreklamme ({) eller strenglitteral (\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "En supersetning kan kun brukes som det siste elementet i en liste for konstruktørinitialisering." ),
           new AscError(kError_ThisUsedInInitializer, "Nøkkelordet «this» kan ikke brukes i egenskapsinitialiseringer." ),
           new AscError(kError_NonConstantConfigInit, "Initialiseringen for en konfigureringsverdi må være en konstant under kompilering." ),
           new AscError(kError_NonConstConfigVar, "En konfigureringsvariabel kan kun deklareres som const." ),
           new AscError(kError_InvalidConfigLocation, "En konfigureringsverdi må deklareres på toppnivå i et program eller en pakke." ),
           new AscError(kError_ShadowedConfigNamespace, "Navneområdet %s er i konflikt med et konfigureringsnavneområde." ),
           new AscError(kError_InvalidPrecision, "Nøyaktigheten må være et heltall mellom 1 og 34." ),
           new AscError(kError_WrongVersion, "Inkompatibel versjon: kan ikke referere til definisjonen %s som ble introdusert i versjon %s fra kode med versjon %s." ),
           new AscError(kError_LossyConversion, "Ugyldig initialisering: konvertering til type %s medfører datatap." ),
   };

   public static final AscError[] errorConstantsNL = { 
           new AscError(kError_AmbiguousReference, "Dubbelzinnige verwijzing naar %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Toegangsspecificaties zijn niet toegestaan met naamruimtekenmerken." ),
           new AscError(kError_Unknown_Namespace, "Naamruimte niet gevonden of geen constante bij compilatie." ),
           new AscError(kError_InvalidSuperExpression, "Een expressie 'super' kan alleen worden gebruikt binnen methoden van klasse-instanties." ),
           new AscError(kError_InvalidSuperStatement, "Een instructie 'super' kan alleen worden gebruikt binnen constructors van klasse-instanties." ),
           new AscError(kError_InvalidAttribute, "Ongeldig attribuut." ),
           new AscError(kError_InvalidOverride, "Het attribuut 'override' mag alleen worden gebruikt in definities van klasse-eigenschappen." ),
           new AscError(kError_InvalidVirtual, "Het attribuut 'virtual' mag alleen worden gebruikt in definities van klasse-eigenschappen." ),
           new AscError(kError_InvalidStatic, "Het attribuut 'static' mag alleen worden gebruikt in definities binnen een klasse." ),
           new AscError(kError_InvalidPrivate, "Het attribuut 'private' mag alleen worden gebruikt in definities van klasse-eigenschappen." ),
           new AscError(kError_Unsupported_Intrinsic, "Het attribuut 'intrinsic' wordt niet meer ondersteund." ),
           new AscError(kError_BaseClassIsFinal, "Basisklasse is 'final'." ),
           new AscError(kError_UnknownBaseClass, "De definitie van basisklasse %s is niet gevonden." ),
           new AscError(kError_DuplicateClassDefinition, "Dubbele klassedefinitie: %s." ),
           new AscError(kError_OverrideNotFound, "Een methode gemarkeerd als 'override' moet een andere methode overschrijven." ),
           new AscError(kError_DuplicateFunction, "Dubbele functiedefinitie" ),
           new AscError(kError_OverrideFinalAccessor, "Een accessor van het type 'final' kan niet worden overschreven." ),
           new AscError(kError_IncompatibleOverride, "Incompatibele overschrijving." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Er wordt een functie overschreven die niet is gemarkeerd voor overschrijven." ),
           new AscError(kError_FinalMethodRedefinition, "Een methode van het type 'final' kan niet opnieuw worden gedefinieerd." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Constructorfuncties moeten instantiemethoden zijn." ),
           new AscError(kError_FuncIsStaticAndOverride, "Functies kunnen niet zowel 'static' als 'override' zijn." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Functies kunnen niet zowel 'static' als 'virtual' zijn." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Functies kunnen niet zowel 'final' als 'virtual' zijn." ),
           new AscError(kError_RestParameterNotNamed, "U moet een naam opgeven van de array met variabele argumenten." ),
           new AscError(kError_VirtualVars, "Virtuele variabelen worden niet ondersteund." ),
           new AscError(kError_NativeVars, "Variabelen kunnen niet native zijn." ),
           new AscError(kError_VarIsFinalAndVirtual, "Variabelen kunnen niet zowel 'final' als 'virtual' zijn." ),
           new AscError(kError_NestedPackage, "Pakketten kunnen niet worden genest." ),
           new AscError(kError_BreakHasNoTarget, "Kan doel van instructie 'break' niet vinden" ),
           new AscError(kError_ContinueHasNoTarget, "Kan doel van instructie 'continue' niet vinden" ),
           new AscError(kError_DuplicateLabel, "Dubbele labeldefinitie." ),
           new AscError(kError_AttributesAreNotCallable, "Attributen kunnen niet worden aangeroepen." ),
           new AscError(kError_ThisUsedInStaticFunction, "Het trefwoord 'this' kan niet worden gebruikt in statische methoden. 'this' kan alleen worden gebruikt in instantiemethoden, closures van functies en algemene code." ),
           new AscError(kError_UndefinedNamespace, "Niet-gedefinieerde naamruimte." ),
           new AscError(kError_UnknownInterfaceMethod, "Interfacemethode %s in naamruimte %s niet geïmplementeerd door klasse %s." ),
           new AscError(kError_UnknownInterface, "Interface %s niet gevonden." ),
           new AscError(kError_UnknownType, "Type niet gevonden of geen constante bij compilatie. %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parameterinitialisatie onbekend of is geen constante bij compilatie." ),
           new AscError(kError_MethodIsNotAConstructor, "Methode kan niet worden gebruikt als een constructor." ),
           new AscError(kError_AssignmentToConstVar, "Ongeldige toewijzing aan een variabele die is opgegeven als constante." ),
           new AscError(kError_AssignmentToNonRefVar, "Toewijzing aan niet-verwijzingswaarde is onmogelijk." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Geretourneerde waarde moet 'undefined' zijn." ),
           new AscError(kError_ConstInitializerNotConst, "Constante-initialisatie onbekend of is geen constante bij compilatie." ),
           new AscError(kError_AccessorTypesMustMatch, "Accessortypen moeten overeenkomen." ),
           new AscError(kError_BadSetterReturnType, "Retourneringstype van een definitie setter mag niet zijn opgegeven of 'void' zijn." ),
           new AscError(kError_PropertyIsWriteOnly, "Eigenschap is alleen-schrijven." ),
           new AscError(kError_PropertyIsReadOnly, "Eigenschap is alleen-lezen." ),
           new AscError(kError_Strict_UndefinedMethod, "Aanroep van een mogelijk niet-gedefinieerde methode %s via een verwijzing van het type 'static' %s." ),
           new AscError(kError_UnableToOpenFile, "Kan bestand niet openen: %s." ),
           new AscError(kError_InvalidMetaData, "Ongeldige metagegevens." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Attributen van metagegevens kunnen niet meerdere elementen hebben." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Impliciete afgedwongen omzetting van een waarde van het type %s in een niet-gerelateerd type %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Kan opgenomen bestand niet openen: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntaxisfout: definitie of compilerinstructie verwacht." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntaxisfout: trefwoord voor definitie (zoals 'function') verwacht na kenmerk %s, niet %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntaxisfout: 'xml' verwacht vóór 'namespace'." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntaxisfout: clausule 'catch' of 'finally' verwacht." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntaxisfout: het trefwoord 'each' is niet toegestaan zonder de operator 'in'." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntaxisfout: haakje openen verwacht vóór de id." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel verwacht." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Label moet een eenvoudige id zijn." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Een expressie 'super' moet één operand hebben." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Operator voor verhogen of verlagen verwacht." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Eén expressie tussen haakjes verwacht." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntaxisfout: %s niet verwacht." ),
           new AscError(kError_Parser_ExpectedToken, "Syntaxisfout: %s verwacht vóór %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntaxisfout: puntkomma verwacht vóór %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntaxisfout: extra tekens gevonden na einde van programma." ),
           new AscError(kError_Lexical_General, "Syntaxisfout." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntaxisfout: een letterlijke tekenreeks moet worden afgesloten vóór het regeleinde." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntaxisfout: een letterlijke tekenreeks moet worden afgesloten vóór het regeleinde." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntaxisfout: einde van invoer bereikt vóór afsluitend aanhalingsteken voor een letterlijke tekenreeks." ),
           new AscError(kError_Lexical_SyntaxError, "Syntaxisfout." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntaxisfout: XML heeft geen overeenkomende start- en eindtags." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Kan afstammingen 'super' niet verwijderen." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Dubbele naamruimtedefinitie." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Doel van toewijzing moet een verwijzingswaarde zijn." ),
           new AscError(kError_IncrementOperatorNotAReference, "De operand van verhogen moet een verwijzing zijn." ),
           new AscError(kError_InvalidIncrementOperand, "De operand van verhogen is ongeldig." ),
           new AscError(kError_InvalidDecrementOperand, "De operand van verlagen is ongeldig." ),
           new AscError(kError_ExpectingExpression, "Expressie verwacht." ),
           new AscError(kError_MissingXMLTagName, "XML-tagnaam ontbreekt." ),
           new AscError(kError_InvalidAbcFile, "Het bestand %s is geen geldig ABC-bestand." ),
           new AscError(kError_Parser_FileIncludesItself, "Mogelijk oneindige herhaling door opnemen van dit bestand: %s." ),
           new AscError(kError_CircularReference, "Kringverwijzing gevonden in %s." ),
           new AscError(kError_InvalidPublic, "Het attribuut 'public' mag alleen binnen een pakket worden gebruikt." ),
           new AscError(kError_InvalidInternal, "Het attribuut 'internal' mag alleen binnen een pakket worden gebruikt." ),
           new AscError(kError_InvalidNamespace, "Een door de gebruiker gedefinieerd naamruimteattribuut kan alleen op het hoofdniveau van een klassedefinitie worden gebruikt." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Impliciete afgedwongen omzetting van een waarde van het type static %s in een mogelijk niet-gerelateerd type %s." ),
           new AscError(kError_UndefinedProperty, "Gebruik van een mogelijk niet-gedefinieerde eigenschap %s via een verwijzing van het type static %s." ),
           new AscError(kError_UnfoundProperty, "Gebruik van niet-gedefinieerde eigenschap %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Een definitie getter mag geen parameters hebben." ),
           new AscError(kError_SetterMustHaveOneParameter, "Een definitie setter moet precies één parameter hebben." ),
           new AscError(kError_SetterCannotHaveOptional, "Een definitie setter kan geen optionele parameters hebben." ),
           new AscError(kError_BadGetterReturnType, "Retourneringstype van een definitie getter mag niet 'void' zijn." ),
           new AscError(kError_InterfaceMethodWithBody, "Methoden die zijn gedefinieerd in een interface mogen geen hoofdtekst hebben." ),
           new AscError(kError_FunctionWithoutBody, "Functie heeft geen hoofdtekst." ),
           new AscError(kError_DuplicateAttribute, "Attribuut %s is verschillende keren opgegeven." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Dubbele interfacedefinitie: %s." ),
           new AscError(kError_CtorWithReturnType, "Een constructor kan geen retourneringstype opgeven." ),
           new AscError(kError_InvalidClassNesting, "Klassen mogen niet genest zijn." ),
           new AscError(kError_InvalidFinalUsage, "Het attribuut 'final' kan alleen worden gebruikt voor een methode die is gedefinieerd in een klasse." ),
           new AscError(kError_InvalidNative, "Het attribuut 'native' mag alleen worden gebruikt bij functiedefinities." ),
           new AscError(kError_InvalidDynamic, "Het attribuut 'dynamic' mag alleen worden gebruikt bij functiedefinities." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntaxisfout: %s is geen geldig type." ),
           new AscError(kError_WrongNumberOfArguments, "Onjuist aantal argumenten. %s verwacht." ),
           new AscError(kError_TooManyArguments, "Onjuist aantal argumenten. Niet meer dan %s verwacht." ),
           new AscError(kError_BadRequiredParameter, "Vereiste parameters zijn niet toegestaan na optionele parameters." ),
           new AscError(kError_VarInInterface, "Declaraties van variabelen zijn niet toegestaan in interfaces." ),
           new AscError(kError_InvalidRestDecl, "Parameters opgegeven na het trefwoord ...rest voor een parameterdefinitie moeten van het gegevenstype Array zijn." ),
           new AscError(kError_CannotExtendInterface, "Een klasse kan alleen een andere klasse uitbreiden, niet een interface." ),
           new AscError(kError_CannotExtendClass, "Een interface kan alleen andere interfaces uitbreiden, maar %s is een klasse." ),
           new AscError(kError_InvalidOverrideUsage, "Het attribuut 'override' kan alleen worden gebruikt voor een methode die is gedefinieerd in een klasse." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Interfacemethode %s in naamruimte %s is geïmplementeerd met een incompatibele handtekening in klasse %s." ),
           new AscError(kError_NativeMethodWithBody, "Native methoden mogen geen hoofdtekst hebben." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Een constructor mag geen methode getter of setter zijn." ),
           new AscError(kError_MissingFilespec, "Er is geen ActionScript-bronbestand opgegeven." ),
           new AscError(kError_CannotReturnFromStaticInit, "De instructie 'return' mag niet worden gebruikt in statische initialisatiecode." ),
           new AscError(kError_InvalidProtected, "Het attribuut 'protected' mag alleen worden gebruikt in definities van klasse-eigenschappen." ),
           new AscError(kError_ConflictingNameInNamespace, "Er is een conflict met definitie %s in naamruimte %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Er is een conflict met overerfde definitie %s in naamruimte %s." ),
           new AscError(kError_ConstructorMustBePublic, "Een constructor kan alleen als 'public' worden gedeclareerd." ),
           new AscError(kError_ConflictingAccessSpecifiers, "In een definitie mogen 'public', 'private', 'protected' en 'internal' maar één keer worden opgegeven." ),
           new AscError(kError_InvalidNestedAccessor, "Accessors kunnen niet worden genest binnen andere functies." ),
           new AscError(kError_CannotInstantiateInterface, "De operator 'new' kan niet worden gebruikt voor het maken van nieuwe instanties van interfaces." ),
           new AscError(kError_BadAccessInterfaceMember, "Interfaceleden kunnen niet als 'public', 'private', 'protected' of 'internal' worden gedeclareerd." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntaxisfout: er ontbreekt een accolade ({) vóór de hoofdtekst van de functie." ),
           new AscError(kError_CannotReturnFromPackageInit, "De instructie 'return' mag niet worden gebruikt in initialisatiecode voor pakketten." ),
           new AscError(kError_InvalidInterfaceNative, "Het kenmerk 'native' kan niet worden gebruikt in interfacedefinities." ),
           new AscError(kError_MultipleNamespaceAttributes, "Per definitie kan maar één naamruimteattribuut worden gebruikt." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Methode %s veroorzaakt een conflict met de definitie die is overerfd van interface %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Interfaceattribuut %s is ongeldig." ),
           new AscError(kError_NamespaceInInterface, "Declaraties van naamruimten zijn niet toegestaan in interfaces." ),
           new AscError(kError_DuplicateImplements, "Klasse %s implementeert interface %s meerdere keren." ),
           new AscError(kError_AssignmentToDefinedFunction, "Ongeldige toewijzing aan functie %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Naamruimteattributen zijn niet toegestaan bij interfacemethoden." ),
           new AscError(kError_MustReturnValue, "Functie retourneert geen waarde." ),
           new AscError(kError_InvalidNamespaceInitializer, "Een naamruimte-initialisatie moet een letterlijke tekenreeks of een andere naamruimte zijn." ),
           new AscError(kError_DefinitionNotFound, "Kan definitie %s niet vinden." ),
           new AscError(kError_InvalidLabel, "Labeldefinitie is ongeldig." ),
           new AscError(kError_IncompatableValueComparison, "Vergelijking van een waarde van het type 'static' %s en een mogelijk niet-gerelateerd type %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "De instructie 'return' mag niet worden gebruikt in algemene initialisatiecode." ),
           new AscError(kError_InaccessiblePropertyReference, "Er is geprobeerd toegang te krijgen tot een niet-toegankelijke eigenschap %s via een verwijzing van het type 'static' %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object is tijdelijk buiten gebruik. Gebruik in plaats hiervan :*." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Aanroep van een mogelijk niet-gedefinieerde methode %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Voorwaartse verwijzing naar basisklasse %s." ),
           new AscError(kError_IllegalPackageReference, "Pakket kan niet als een waarde worden gebruikt: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Incompatibele standaardwaarde van het type %s waar %s wordt verwacht." ),
           new AscError(kError_MultipleSwitchDefaults, "De instructie 'switch' heeft verschillende standaardwaarden, terwijl maar één standaardwaarde is toegestaan." ),
           new AscError(kError_AssignmentToDefinedClass, "Ongeldige toewijzing aan klasse %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "U wilt de vaste eigenschap %s verwijderen. Alleen dynamisch gedefinieerde eigenschappen kunnen worden verwijderd." ),
           new AscError(kError_InvalidBaseTypeExpression, "Basisklasse niet gevonden of geen constante bij compilatie." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Interface niet gevonden of geen constante bij compilatie." ),
           new AscError(kError_StaticModifiedNamespace, "Het attribuut 'static' is niet toegestaan in naamruimtedefinities." ),
           new AscError(kError_InvalidInterfaceNesting, "Interfacedefinities mogen niet zijn genest binnen klasse- of andere interfacedefinities." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Het attribuut 'prototype' is ongeldig." ),
           new AscError(kError_InaccessibleMethodReference, "Toegang tot een niet-toegankelijke methode %s via een verwijzing van het type 'static' %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntaxisfout: expressie verwacht na 'throw'." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "De klasse %s kan %s niet uitbreiden aangezien beiden zijn gekoppeld aan bibliotheeksymbolen of de hoofdtijdlijn." ),
           new AscError(kError_AttributesOnPackage, "Attributen zijn niet toegestaan in een pakketdefinitie." ),
           new AscError(kError_InternalError, "Interne fout: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntaxisfout: ongeldige initialisatie for-in, maar 1 expressie verwacht." ),
           new AscError(kError_IllegalSuperStatement, "Een instructie 'super' is niet toegestaan na een instructie 'this', 'super', 'return' of 'throw'." ),
           new AscError(kError_UnfoundPackageProperty, "Gebruik van niet-gedefinieerde eigenschap %s in pakket %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Geen standaardconstructor gevonden in basisklasse %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* gevonden zonder bijbehorende */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntaxisfout: er wordt een linkeraccolade ({) of letterlijke tekenreeks (\"\") verwacht." ),
           new AscError(kError_InvalidES4SuperStatement, "Een instructie 'super' kan alleen als het laatste item worden gebruikt in een constructie-initialisatielijst." ),
           new AscError(kError_ThisUsedInInitializer, "Dit sleutelwoord kan niet worden gebruikt in eigenschapsinitialisatiefuncties." ),
           new AscError(kError_NonConstantConfigInit, "De initialisatiefunctie voor een configuratiewaarde moet een constante tijdens compilatie zijn." ),
           new AscError(kError_NonConstConfigVar, "Een configuratievariabele kan alleen als 'const' worden gedeclareerd." ),
           new AscError(kError_InvalidConfigLocation, "Een configuratiewaarde moet op het bovenste niveau van een programma of pakket worden gedeclareerd." ),
           new AscError(kError_ShadowedConfigNamespace, "Naamruimte %s veroorzaakt een conflict met een configuratienaamruimte." ),
           new AscError(kError_InvalidPrecision, "Precisie moet een geheel getal tussen 1 en 34 zijn." ),
           new AscError(kError_WrongVersion, "Incompatibele versie: kan niet verwijzen naar definitie %s die in versie %s is geïntroduceerd via code met versie %s." ),
           new AscError(kError_LossyConversion, "Ongeldige initialisatie: bij conversie naar type %s gaan gegevens verloren." ),
   };

   public static final AscError[] errorConstantsPL = { 
           new AscError(kError_AmbiguousReference, "Niejednoznaczne odniesienie do %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Dla atrybutów namespace nie są dozwolone specyfikatory dostępu." ),
           new AscError(kError_Unknown_Namespace, "Nie znaleziono przestrzeni nazw lub nie jest ona stałą czasu kompilacji." ),
           new AscError(kError_InvalidSuperExpression, "Wyrażenie super może być używane tylko w metodach instancji klasy." ),
           new AscError(kError_InvalidSuperStatement, "Instrukcja super może być używana tylko w konstruktorach instancji klasy." ),
           new AscError(kError_InvalidAttribute, "Atrybut jest nieprawidłowy." ),
           new AscError(kError_InvalidOverride, "Atrybut override może być używany tylko dla definicji właściwości klas." ),
           new AscError(kError_InvalidVirtual, "Atrybut virtual może być używany tylko dla definicji właściwości klas." ),
           new AscError(kError_InvalidStatic, "Atrybut static może być używany tylko dla definicji w klasie." ),
           new AscError(kError_InvalidPrivate, "Atrybut private może być używany tylko dla definicji właściwości klas." ),
           new AscError(kError_Unsupported_Intrinsic, "Atrybut intrinsic nie jest już obsługiwany." ),
           new AscError(kError_BaseClassIsFinal, "Klasa bazowa ma atrybut final." ),
           new AscError(kError_UnknownBaseClass, "Nie znaleziono definicji klasy bazowej %s." ),
           new AscError(kError_DuplicateClassDefinition, "Powielona definicja klasy: %s." ),
           new AscError(kError_OverrideNotFound, "Metoda oznaczona atrybutem override musi przesłaniać inną metodę." ),
           new AscError(kError_DuplicateFunction, "Powielona definicja funkcji." ),
           new AscError(kError_OverrideFinalAccessor, "Nie można przesłonić metody uzyskiwania dostępu mającej atrybut final." ),
           new AscError(kError_IncompatibleOverride, "Niezgodne przesłanianie." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Przesłanianie funkcji, która nie jest oznaczona do przesłonięcia." ),
           new AscError(kError_FinalMethodRedefinition, "Nie można zmienić definicji metody z atrybutem final." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Funkcje konstruktora muszą być metodami instancji." ),
           new AscError(kError_FuncIsStaticAndOverride, "Funkcje nie mogą mieć jednocześnie atrybutów static i override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Funkcje nie mogą mieć jednocześnie atrybutów static i virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Funkcje nie mogą mieć jednocześnie atrybutów final i virtual." ),
           new AscError(kError_RestParameterNotNamed, "Należy określić nazwę tablicy argumentów zmiennych." ),
           new AscError(kError_VirtualVars, "Zmienne wirtualne nie są obsługiwane." ),
           new AscError(kError_NativeVars, "Zmienne nie mogą mieć atrybutu native." ),
           new AscError(kError_VarIsFinalAndVirtual, "Zmienne nie mogą mieć jednocześnie atrybutów final i virtual." ),
           new AscError(kError_NestedPackage, "Pakiety nie mogą być zagnieżdżone." ),
           new AscError(kError_BreakHasNoTarget, "Nie znaleziono obiektu docelowego instrukcji break." ),
           new AscError(kError_ContinueHasNoTarget, "Nie znaleziono obiektu docelowego instrukcji continue." ),
           new AscError(kError_DuplicateLabel, "Powielona definicja etykiety." ),
           new AscError(kError_AttributesAreNotCallable, "Dla atrybutów nie istnieje możliwość wywołania." ),
           new AscError(kError_ThisUsedInStaticFunction, "Słowo kluczowe this nie może być używane w metodach statycznych. Można je stosować tylko w metodach instancji, w ramach zamknięcia funkcji i w kodzie globalnym." ),
           new AscError(kError_UndefinedNamespace, "Niezdefiniowana przestrzeń nazw." ),
           new AscError(kError_UnknownInterfaceMethod, "Metoda interfejsu %s w przestrzeni nazw %s nie jest implementowana przez klasę %s." ),
           new AscError(kError_UnknownInterface, "Nie znaleziono interfejsu %s." ),
           new AscError(kError_UnknownType, "Nie znaleziono typu lub nie jest on stałą czasu kompilacji: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Obiekt inicjujący parametr jest nieznany lub nie jest stałą czasu kompilacji." ),
           new AscError(kError_MethodIsNotAConstructor, "Nie można użyć metody jako konstruktora." ),
           new AscError(kError_AssignmentToConstVar, "Nieprawidłowe przypisanie do zmiennej określonej jako stała." ),
           new AscError(kError_AssignmentToNonRefVar, "Przypisanie do wartości niebędącej odniesieniem jest niemożliwe." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Zwracana wartość musi być niezdefiniowana." ),
           new AscError(kError_ConstInitializerNotConst, "Obiekt inicjujący stałej jest nieznany lub nie jest stałą czasu kompilacji." ),
           new AscError(kError_AccessorTypesMustMatch, "Typy metod uzyskiwania dostępu muszą być zgodne." ),
           new AscError(kError_BadSetterReturnType, "Zwracany typ w definicji metody ustawiającej musi być nieokreślony lub ustawiony na void." ),
           new AscError(kError_PropertyIsWriteOnly, "Ta właściwość jest tylko do zapisu." ),
           new AscError(kError_PropertyIsReadOnly, "Ta właściwość jest tylko do odczytu." ),
           new AscError(kError_Strict_UndefinedMethod, "Wywołanie potencjalnie niezdefiniowanej metody %s za pośrednictwem odniesienia z typem statycznym %s." ),
           new AscError(kError_UnableToOpenFile, "Nie można otworzyć pliku: %s." ),
           new AscError(kError_InvalidMetaData, "Nieprawidłowe metadane." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Atrybuty metadanych nie mogą mieć więcej niż jednego elementu." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Niejawne wymuszenie dla wartości typu %s do niepowiązanego typu %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Nie można otworzyć dołączonego pliku: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Błąd składniowy: oczekiwano definicji lub dyrektywy." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Błąd składniowy: oczekiwano słowa kluczowego definicji (na przykład funkcji) po atrybucie %s, nie %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Błąd składniowy: oczekiwano wartości XML przed przestrzenią nazw." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Błąd składniowy: oczekiwano klauzuli catch lub finally." ),
           new AscError(kError_Parser_EachWithoutIn, "Błąd składniowy: Słowo kluczowe each nie może występować bez operatora in." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Błąd składniowy: oczekiwano lewego nawiasu przed identyfikatorem." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Oczekiwano etykiety case." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Etykieta musi być prostym identyfikatorem." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Wyrażenie super musi mieć jeden argument." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Oczekiwano operatora zwiększenia lub zmniejszenia." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Oczekiwano pojedynczego wyrażenia w nawiasach." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Błąd składniowy: nieoczekiwana pozycja %s." ),
           new AscError(kError_Parser_ExpectedToken, "Błąd składniowy: oczekiwano wartości %s przed %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Błąd składniowy: oczekiwano średnika przed wartością %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Błąd składniowy: znaleziono dodatkowe znaki za końcem programu." ),
           new AscError(kError_Lexical_General, "Błąd składniowy." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Błąd składniowy: literał ciągu znaków musi zostać zakończony przed znakiem podziału." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Błąd składniowy: literał ciągu znaków musi zostać zakończony przed znakiem podziału." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Błąd składniowy: dane wejściowe skończyły się przed wystąpieniem cudzysłowu zamykającego literał ciągu znaków." ),
           new AscError(kError_Lexical_SyntaxError, "Błąd składniowy." ),
           new AscError(kError_Lexical_NoMatchingTag, "Błąd składniowy: kod XML nie zawiera zgodnych znaczników początkowego i końcowego." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Nie można usunąć obiektów potomnych obiektu nadrzędnego." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Powielona definicja przestrzeni nazw." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Obiekt docelowy przypisania musi być wartością odniesienia." ),
           new AscError(kError_IncrementOperatorNotAReference, "Argument zwiększenia musi być odniesieniem." ),
           new AscError(kError_InvalidIncrementOperand, "Argument zwiększenia jest nieprawidłowy." ),
           new AscError(kError_InvalidDecrementOperand, "Argument zmniejszenia jest nieprawidłowy." ),
           new AscError(kError_ExpectingExpression, "Oczekiwano wyrażenia." ),
           new AscError(kError_MissingXMLTagName, "Brak nazwy znacznika XML." ),
           new AscError(kError_InvalidAbcFile, "Plik %s nie jest prawidłowym plikiem ABC." ),
           new AscError(kError_Parser_FileIncludesItself, "Niektóre możliwe nieskończone rekursje spowodowane przez ten plik: %s." ),
           new AscError(kError_CircularReference, "W %s zostało wykryte cykliczne odniesienie do typu." ),
           new AscError(kError_InvalidPublic, "Atrybutu public można używać tylko w pakiecie." ),
           new AscError(kError_InvalidInternal, "Atrybutu internal można używać tylko w pakiecie." ),
           new AscError(kError_InvalidNamespace, "Atrybutu namespace zdefiniowanego przez użytkownika można użyć tylko na najwyższym poziomie definicji klasy." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Niejawne wymuszenie dla wartości o statycznym typie %s do prawdopodobnie niepowiązanego typu %s." ),
           new AscError(kError_UndefinedProperty, "Dostęp do potencjalnie niezdefiniowanej właściwości %s przez odniesienie z typem statycznym %s." ),
           new AscError(kError_UnfoundProperty, "Dostęp do niezdefiniowanej właściwości %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Definicja metody pobierającej nie może zawierać parametrów." ),
           new AscError(kError_SetterMustHaveOneParameter, "Definicja metody ustawiającej musi mieć dokładnie jeden parametr." ),
           new AscError(kError_SetterCannotHaveOptional, "Definicja metody ustawiającej nie może zawierać parametrów opcjonalnych." ),
           new AscError(kError_BadGetterReturnType, "Zwracany typ w definicji metody pobierającej nie może być ustawiony na void." ),
           new AscError(kError_InterfaceMethodWithBody, "Metody zdefiniowane w interfejsie nie mogą zawierać tekstu głównego." ),
           new AscError(kError_FunctionWithoutBody, "Funkcja nie ma tekstu głównego." ),
           new AscError(kError_DuplicateAttribute, "Wielokrotnie określono atrybut %s." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Powielona definicja interfejsu: %s." ),
           new AscError(kError_CtorWithReturnType, "Konstruktor nie może określać typu zwracanej wartości." ),
           new AscError(kError_InvalidClassNesting, "Klasy nie mogą być zagnieżdżone." ),
           new AscError(kError_InvalidFinalUsage, "Atrybut final może zostać użyty tylko dla metody zdefiniowanej w klasie." ),
           new AscError(kError_InvalidNative, "Atrybut native może być używany tylko z definicjami funkcji." ),
           new AscError(kError_InvalidDynamic, "Atrybut dynamic może być używany tylko z definicjami klas." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Błąd składniowy: %s nie jest prawidłowym typem." ),
           new AscError(kError_WrongNumberOfArguments, "Niepoprawna liczba argumentów.  Oczekiwano %s." ),
           new AscError(kError_TooManyArguments, "Niepoprawna liczba argumentów.  Oczekiwano nie więcej niż %s." ),
           new AscError(kError_BadRequiredParameter, "Parametry wymagane nie mogą występować po parametrach opcjonalnych." ),
           new AscError(kError_VarInInterface, "W przypadku interfejsów nie są dozwolone deklaracje zmiennych." ),
           new AscError(kError_InvalidRestDecl, "Parametry określone po słowie kluczowym definicji parametrów „...” (reszta) mogą mieć tylko typ danych Array." ),
           new AscError(kError_CannotExtendInterface, "Klasa może rozszerzać tylko inną klasę, nie interfejs." ),
           new AscError(kError_CannotExtendClass, "Interfejs może rozszerzać tylko inne interfejsy, a %s jest klasą." ),
           new AscError(kError_InvalidOverrideUsage, "Atrybut override może zostać użyty tylko dla metody zdefiniowanej w klasie." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Metoda interfejsu %s w przestrzeni nazw %s jest zaimplementowana z niezgodnym podpisem w klasie %s." ),
           new AscError(kError_NativeMethodWithBody, "Metody macierzyste nie mogą mieć treści głównej." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Konstruktor nie może być metodą pobierającą ani ustawiającą." ),
           new AscError(kError_MissingFilespec, "Nie został określony plik źródłowy AS." ),
           new AscError(kError_CannotReturnFromStaticInit, "Instrukcja return nie może być używana w statycznym kodzie inicjującym." ),
           new AscError(kError_InvalidProtected, "Atrybut protected może być używany tylko dla definicji właściwości klas." ),
           new AscError(kError_ConflictingNameInNamespace, "Istnieje konflikt z definicją %s w przestrzeni nazw %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Istnieje konflikt z dziedziczoną definicją %s w przestrzeni nazw %s." ),
           new AscError(kError_ConstructorMustBePublic, "Konstruktor może być zadeklarowany tylko z atrybutem public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Dla definicji można określić tylko jeden z atrybutów: public, private, protected i internal." ),
           new AscError(kError_InvalidNestedAccessor, "Metody uzyskiwania dostępu nie mogą być zagnieżdżone w innych funkcjach." ),
           new AscError(kError_CannotInstantiateInterface, "Nie można tworzyć instancji interfejsów za pomocą operatora new." ),
           new AscError(kError_BadAccessInterfaceMember, "Elementy interfejsów nie mogą być deklarowane z atrybutami: public, private, protected i internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Błąd składniowy: brak lewego nawiasu klamrowego „{” przed tekstem głównym funkcji." ),
           new AscError(kError_CannotReturnFromPackageInit, "Instrukcja return nie może być używana w kodzie inicjującym pakietu." ),
           new AscError(kError_InvalidInterfaceNative, "Atrybut native nie może być używany w definicjach interfejsów." ),
           new AscError(kError_MultipleNamespaceAttributes, "Można użyć tylko jednego atrybutu namespace na definicję." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Metoda %s powoduje konflikt z definicją dziedziczoną po interfejsie %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Atrybut interfejsu %s jest nieprawidłowy." ),
           new AscError(kError_NamespaceInInterface, "W przypadku interfejsów nie są dozwolone deklaracje przestrzeni nazw." ),
           new AscError(kError_DuplicateImplements, "Klasa %s wielokrotnie implementuje interfejs %s." ),
           new AscError(kError_AssignmentToDefinedFunction, "Nieprawidłowe przypisanie do funkcji %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "W metodach interfejsów nie są dozwolone atrybuty namespace." ),
           new AscError(kError_MustReturnValue, "Funkcja nie zwraca wartości." ),
           new AscError(kError_InvalidNamespaceInitializer, "Obiektem inicjującym przestrzeń nazw musi być literał ciągu znaków lub inna przestrzeń nazw." ),
           new AscError(kError_DefinitionNotFound, "Nie znaleziono definicji %s." ),
           new AscError(kError_InvalidLabel, "Definicja etykiety jest nieprawidłowa." ),
           new AscError(kError_IncompatableValueComparison, "Porównanie między wartością o statycznym typie %s a prawdopodobnie niepowiązanym typem %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Instrukcja return nie może być używana w globalnym kodzie inicjującym." ),
           new AscError(kError_InaccessiblePropertyReference, "Próba uzyskania dostępu do niedostępnej właściwości %s przy użyciu odniesienia z typem statycznym %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, "Klasa :Object jest tymczasowo niedostępna. Należy użyć wartości „:*”." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Wywołanie potencjalnie niezdefiniowanej metody %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Odniesienie do klasy bazowej %s." ),
           new AscError(kError_IllegalPackageReference, "Nie można użyć pakietu jako wartości: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Niezgodna wartość domyślna typu %s (oczekiwano %s)." ),
           new AscError(kError_MultipleSwitchDefaults, "Instrukcja switch ma więcej niż jedną wartość domyślną, podczas gdy jest dozwolona tylko jedna taka wartość." ),
           new AscError(kError_AssignmentToDefinedClass, "Nieprawidłowe przypisanie do klasy %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Próba usunięcia stałej właściwości %s. Można usuwać tylko właściwości definiowane dynamicznie." ),
           new AscError(kError_InvalidBaseTypeExpression, "Nie znaleziono klasy bazowej lub nie jest ona stałą czasu kompilacji." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Nie znaleziono interfejsu lub nie jest on stałą czasu kompilacji." ),
           new AscError(kError_StaticModifiedNamespace, "Atrybut static jest niedozwolony w przypadku definicji przestrzeni nazw." ),
           new AscError(kError_InvalidInterfaceNesting, "Definicji interfejsów nie można zagnieżdżać w klasach ani w innych definicjach interfejsów." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Atrybut prototypu jest nieprawidłowy." ),
           new AscError(kError_InaccessibleMethodReference, "Próba uzyskania dostępu do niedostępnej metody %s przez odniesienie z typem statycznym %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Błąd składniowy: oczekiwano wyrażenia po instrukcji throw." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Klasa %s nie może rozszerzać interfejsu %s, ponieważ oba te elementy są powiązane z symbolami biblioteki lub główną osią czasu." ),
           new AscError(kError_AttributesOnPackage, "Atrybuty są niedozwolone w definicji pakietu." ),
           new AscError(kError_InternalError, "Błąd wewnętrzny: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Błąd składniowy: Nieprawidłowy obiekt inicjujący pętli for-in. Oczekiwano tylko jednego wyrażenia." ),
           new AscError(kError_IllegalSuperStatement, "Instrukcja super nie może wystąpić po instrukcji: this, super, return lub throw." ),
           new AscError(kError_UnfoundPackageProperty, "Dostęp do niezdefiniowanej właściwości %s w pakiecie %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "W klasie bazowej %s nie znaleziono konstruktora domyślnego." ),
           new AscError(kError_BlockCommentNotTerminated, "/* znalezione bez dopasowywania */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntax Error: expecting a left brace({)or string literal(\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "A super statement can be used only as the last item in a constructor initializer list." ),
           new AscError(kError_ThisUsedInInitializer, "The this keyword can not be used in property initializers." ),
           new AscError(kError_NonConstantConfigInit, "The initializer for a configuration value must be a compile time constant." ),
           new AscError(kError_NonConstConfigVar, "A configuration variable may only be declared const." ),
           new AscError(kError_InvalidConfigLocation, "A configuration value must be declared at the top level of a program or package." ),
           new AscError(kError_ShadowedConfigNamespace, "Namespace %s conflicts with a configuration namespace." ),
           new AscError(kError_InvalidPrecision, "Precision must be an integer between 1 and 34." ),
           new AscError(kError_WrongVersion, "Incompatible Version: can not reference definition %s introduced in version %s from code with version %s." ),
           new AscError(kError_LossyConversion, "Invalid initialization: conversion to type %s loses data." ),
   };

   public static final AscError[] errorConstantsPT = { 
           new AscError(kError_AmbiguousReference, "Referência ambígua a %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Os especificadores de acesso não são permitidos com atributo de namespace." ),
           new AscError(kError_Unknown_Namespace, "O namespace não foi encontrado ou não é uma constante de tempo de compilação." ),
           new AscError(kError_InvalidSuperExpression, "Uma superexpressão só pode ser usada dentro de métodos da instância da classe" ),
           new AscError(kError_InvalidSuperStatement, "Uma instrução super só pode ser usada dentro de construtores da instância da classe." ),
           new AscError(kError_InvalidAttribute, "O atributo é inválido." ),
           new AscError(kError_InvalidOverride, "O atributo override só pode ser usado em definições de propriedade de classe." ),
           new AscError(kError_InvalidVirtual, "O atributo virtual só pode ser usado em definições de propriedade de classe." ),
           new AscError(kError_InvalidStatic, "O atributo static só pode ser usado em definições dentro de uma classe" ),
           new AscError(kError_InvalidPrivate, "O atributo private só pode ser usado em definições de propriedade de classe." ),
           new AscError(kError_Unsupported_Intrinsic, "O atributo intrinsic não é mais suportado." ),
           new AscError(kError_BaseClassIsFinal, "A classe base é final." ),
           new AscError(kError_UnknownBaseClass, "A definição da classe base %s não foi encontrada." ),
           new AscError(kError_DuplicateClassDefinition, "Definição da classe duplicada: %s." ),
           new AscError(kError_OverrideNotFound, "O método marcado como override deve substituir outro método." ),
           new AscError(kError_DuplicateFunction, "Definição da função duplicada." ),
           new AscError(kError_OverrideFinalAccessor, "Não é possível substituir um acessador final" ),
           new AscError(kError_IncompatibleOverride, "Substituição incompatível." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Substituindo uma função que não está marcada para ser substituída." ),
           new AscError(kError_FinalMethodRedefinition, "Não é possível redefinir um método final." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "As funções do construtor devem ser métodos de instância." ),
           new AscError(kError_FuncIsStaticAndOverride, "As funções não podem ser static e override ao mesmo tempo." ),
           new AscError(kError_FuncIsStaticAndVirtual, "As funções não podem ser static e virtual ao mesmo tempo." ),
           new AscError(kError_FuncIsVirtualAndFinal, "As funções não podem ser final e virtual ao mesmo tempo." ),
           new AscError(kError_RestParameterNotNamed, "É necessário especificar o nome da matriz de argumentos variável." ),
           new AscError(kError_VirtualVars, "As variáveis virtuais não são suportadas." ),
           new AscError(kError_NativeVars, "Variáveis não podem ser nativas." ),
           new AscError(kError_VarIsFinalAndVirtual, "As variáveis não podem ser final e virtual ao mesmo tempo." ),
           new AscError(kError_NestedPackage, "Os pacotes não podem ser aninhados." ),
           new AscError(kError_BreakHasNoTarget, "O destino da instrução break não foi encontrado." ),
           new AscError(kError_ContinueHasNoTarget, "O destino da instrução continue não foi encontrado." ),
           new AscError(kError_DuplicateLabel, "Definição de rótulo duplicada." ),
           new AscError(kError_AttributesAreNotCallable, "Os atributos não podem ser chamados." ),
           new AscError(kError_ThisUsedInStaticFunction, "A palavra-chave this não pode ser usada em métodos estáticos. Ela só pode ser usada em métodos da instância, em fechamentos de função e em código global." ),
           new AscError(kError_UndefinedNamespace, "Namespace indefinido." ),
           new AscError(kError_UnknownInterfaceMethod, "O método de interface %s no namespace %s não foi implementado pela classe %s." ),
           new AscError(kError_UnknownInterface, "A interface %s não foi encontrada." ),
           new AscError(kError_UnknownType, "O tipo não foi encontrado ou não é uma constante de tempo de compilação: %s." ),
           new AscError(kError_NonConstantParamInitializer, "O inicializador do parâmetro é desconhecido ou não é uma constante de tempo de compilação." ),
           new AscError(kError_MethodIsNotAConstructor, "O método não pode ser usado como um construtor." ),
           new AscError(kError_AssignmentToConstVar, "Atribuições ilegais para uma variável especificada como constante." ),
           new AscError(kError_AssignmentToNonRefVar, "Não é possível atribuir a um valor de não referência." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "O valor de retorno deve ser indefinido." ),
           new AscError(kError_ConstInitializerNotConst, "O inicializador constante é desconhecido ou não é uma constante de tempo de compilação." ),
           new AscError(kError_AccessorTypesMustMatch, "Os tipos de acessadores devem ser correspondentes." ),
           new AscError(kError_BadSetterReturnType, "O tipo de retorno de uma definição setter deve ser não especificado ou nulo." ),
           new AscError(kError_PropertyIsWriteOnly, "A propriedade é somente gravação" ),
           new AscError(kError_PropertyIsReadOnly, "A propriedade é somente leitura." ),
           new AscError(kError_Strict_UndefinedMethod, "Chamar um método possivelmente indefinido %s por meio de uma referência com tipo estático %s." ),
           new AscError(kError_UnableToOpenFile, "Não foi possível abrir o arquivo: %s." ),
           new AscError(kError_InvalidMetaData, "Metadados inválidos." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Os atributos dos metadados não podem ter mais de um elemento." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Coerção implícita de um valor do tipo %s para um tipo %s não relacionado." ),
           new AscError(kError_Parser_UnableToOpenFile, "Não foi possível abrir o arquivo incluído: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Erro de sintaxe: definição ou diretiva esperada." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Erro de sintaxe: esperada uma palavra-chave de definição (como uma função) depois do atributo %s, e não %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Erro de sintaxe: esperando xml antes do namespace." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Erro de sintaxe: esperando uma cláusula catch ou finally." ),
           new AscError(kError_Parser_EachWithoutIn, "Erro de sintaxe: a palavra-chave ‘each’ não é permitida sem um operador ‘in’." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Erro de sintaxe: esperando o parêntese esquerdo antes do identificador." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Esperando CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "O rótulo deve ser um identificador simples." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Uma superexpressão deve ter um operando." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Esperando operador de incremento ou decremento." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Esperando uma única expressão entre parênteses." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Erro de sintaxe: %s é inesperado." ),
           new AscError(kError_Parser_ExpectedToken, "Erro de sintaxe: esperando %s antes de %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Erro de sintaxe: esperando ponto-e-vírgula antes de %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Erro de sintaxe: caracteres extras encontrados depois do fim do programa." ),
           new AscError(kError_Lexical_General, "Erro de sintaxe." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Erro de sintaxe: uma literal de string deve ser encerrada antes da quebra de linha." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Erro de sintaxe: uma literal de string deve ser encerrada antes da quebra de linha." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Erro de sintaxe: a entrada terminou antes de atingir as aspas de fechamento de uma literal de string." ),
           new AscError(kError_Lexical_SyntaxError, "Erro de sintaxe." ),
           new AscError(kError_Lexical_NoMatchingTag, "Erro de sintaxe: o XML não tem marcas de início e fim correspondentes." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Não é possível excluir descendentes de super." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Definição de namespace duplicada." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "O destino da atribuição deve ser um valor de referência." ),
           new AscError(kError_IncrementOperatorNotAReference, "O incremento do operando deve ser uma referência." ),
           new AscError(kError_InvalidIncrementOperand, "O operando do incremento é inválido." ),
           new AscError(kError_InvalidDecrementOperand, "O operando do decremento é inválido." ),
           new AscError(kError_ExpectingExpression, "Esperando uma expressão." ),
           new AscError(kError_MissingXMLTagName, "Nome da marca XML ausente." ),
           new AscError(kError_InvalidAbcFile, "O arquivo %s não é um arquivo ABC válido." ),
           new AscError(kError_Parser_FileIncludesItself, "Recursão infinita possível porque este arquivo inclui: %s." ),
           new AscError(kError_CircularReference, "Referência do tipo circular detectada em %s." ),
           new AscError(kError_InvalidPublic, "O atributo public só pode ser usado dentro de um pacote." ),
           new AscError(kError_InvalidInternal, "O atributo internal só pode ser usado dentro de um pacote." ),
           new AscError(kError_InvalidNamespace, "Um atributo de namespace definido pelo usuário só pode ser usado no nível superior de uma definição de classe." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Coerção implícita de um valor com tipo estático %s para um tipo %s possivelmente não relacionado." ),
           new AscError(kError_UndefinedProperty, "Acesso de propriedade possivelmente indefinida %s por meio de uma referência com tipo estático %s." ),
           new AscError(kError_UnfoundProperty, "Acesso de propriedade indefinida %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Uma definição getter não deve ter parâmetros." ),
           new AscError(kError_SetterMustHaveOneParameter, "Uma definição setter deve ter exatamente um parâmetro." ),
           new AscError(kError_SetterCannotHaveOptional, "Uma definição setter não pode ter parâmetros opcionais." ),
           new AscError(kError_BadGetterReturnType, "O tipo de retorno de uma definição getter não deve ser nulo." ),
           new AscError(kError_InterfaceMethodWithBody, "Métodos definidos em uma interface não devem ter um corpo." ),
           new AscError(kError_FunctionWithoutBody, "A função não tem um corpo." ),
           new AscError(kError_DuplicateAttribute, "O atributo %s foi especificado várias vezes." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Definição da interface duplicada: %s." ),
           new AscError(kError_CtorWithReturnType, "Um construtor não pode especificar um tipo de retorno." ),
           new AscError(kError_InvalidClassNesting, "As classes não devem ser aninhadas." ),
           new AscError(kError_InvalidFinalUsage, "O atributo final só pode ser usado em um método definido em uma classe." ),
           new AscError(kError_InvalidNative, "O atributo native só pode ser usado com definições de função." ),
           new AscError(kError_InvalidDynamic, "O atributo dynamic só pode ser usado com definições de classe." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Erro de sintaxe: %s não é um tipo válido." ),
           new AscError(kError_WrongNumberOfArguments, "Número incorreto de argumentos. Esperado %s." ),
           new AscError(kError_TooManyArguments, "Número incorreto de argumentos. Não é esperado mais do que %s." ),
           new AscError(kError_BadRequiredParameter, "Parâmetros necessários não são permitidos depois dos parâmetros opcionais." ),
           new AscError(kError_VarInInterface, "Declarações de variáveis não permitidas em interfaces." ),
           new AscError(kError_InvalidRestDecl, "Os parâmetros especificados depois da palavra-chave de definição do parâmetro ...rest só podem ser do tipo de dados Array." ),
           new AscError(kError_CannotExtendInterface, "Uma classe só pode estender outra classe, não uma interface." ),
           new AscError(kError_CannotExtendClass, "Uma interface só pode estender outras interfaces, mas %s é uma classe." ),
           new AscError(kError_InvalidOverrideUsage, "O atributo override só pode ser usado em um método definido em uma classe." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Método de interface %s no namespace %s implementado com assinatura incompatível na classe %s." ),
           new AscError(kError_NativeMethodWithBody, "Os métodos nativos não podem ter um corpo." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Um construtor não pode ser um método getter ou setter." ),
           new AscError(kError_MissingFilespec, "Um arquivo de origem AS não especificado." ),
           new AscError(kError_CannotReturnFromStaticInit, "A instrução return não pode ser usada no código de inicialização estática." ),
           new AscError(kError_InvalidProtected, "O atributo protected só pode ser usado em definições de propriedade de classe." ),
           new AscError(kError_ConflictingNameInNamespace, "Existe um conflito com a definição %s no namespace %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Existe um conflito com a definição %s herdada no namespace %s." ),
           new AscError(kError_ConstructorMustBePublic, "Um construtor só pode ser declarado público." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Somente um public, private, protected ou internal pode ser especificado em uma definição." ),
           new AscError(kError_InvalidNestedAccessor, "Os acessadores não podem ser aninhados dentro de outras funções." ),
           new AscError(kError_CannotInstantiateInterface, "Não é possível iniciar uma instância das interfaces com o novo operador." ),
           new AscError(kError_BadAccessInterfaceMember, "Os membros da interface não podem ser declarados público, privado, protegido ou interno." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Erro de sintaxe: chave esquerda ausente ({) antes do corpo da função." ),
           new AscError(kError_CannotReturnFromPackageInit, "A instrução return não pode ser usada no código de inicialização do pacote." ),
           new AscError(kError_InvalidInterfaceNative, "O atributo native não pode ser usado nas definições na interface." ),
           new AscError(kError_MultipleNamespaceAttributes, "Somente um atributo do namespace pode ser usado por definição." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "O método %s entra em conflito com as definições herdadas da interface %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "O atributo de interface %s é inválido." ),
           new AscError(kError_NamespaceInInterface, "Declarações de namespaces não permitidas em interfaces." ),
           new AscError(kError_DuplicateImplements, "A classe %s implementa a interface %s várias vezes." ),
           new AscError(kError_AssignmentToDefinedFunction, "Atribuição ilegal à função %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Os atributos do namespace não têm permissão em métodos da interface." ),
           new AscError(kError_MustReturnValue, "A função não retorna um valor." ),
           new AscError(kError_InvalidNamespaceInitializer, "Um inicializador de namespace deve ser uma literal de string ou outro namespace." ),
           new AscError(kError_DefinitionNotFound, "Não foi possível encontrar a definição %s." ),
           new AscError(kError_InvalidLabel, "A definição do rótulo é inválida." ),
           new AscError(kError_IncompatableValueComparison, "Comparação entre um valor com tipo estático %s e um tipo %s possivelmente não relacionado." ),
           new AscError(kError_CannotReturnFromGlobalInit, "A instrução return não pode ser usada no código de inicialização global." ),
           new AscError(kError_InaccessiblePropertyReference, "Tentativa de acesso à propriedade inacessível %s por meio de uma referência com tipo estático %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object está temporariamente fora de serviço. Use :*." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Chamada para um método possivelmente indefinido %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Encaminhar referência para uma classe base %s." ),
           new AscError(kError_IllegalPackageReference, "O pacote não pode ser usado como um valor: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Valor padrão incompatível do tipo %s em que %s é esperado." ),
           new AscError(kError_MultipleSwitchDefaults, "O switch tem mais de um padrão, mas somente um padrão é permitido." ),
           new AscError(kError_AssignmentToDefinedClass, "Atribuição ilegal à classe %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Tentativa de excluir a propriedade fixa %s. Somente as propriedades definidas dinamicamente podem ser excluídas." ),
           new AscError(kError_InvalidBaseTypeExpression, "A classe base não foi encontrada ou não é uma constante de tempo de compilação." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "A interface não foi encontrada ou não é uma constante de tempo de compilação." ),
           new AscError(kError_StaticModifiedNamespace, "O atributo estático não é permitido em definições do namespace." ),
           new AscError(kError_InvalidInterfaceNesting, "As definições de interface não devem ser aninhadas na classe ou em outras definições da interface." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "O atributo prototype é inválido." ),
           new AscError(kError_InaccessibleMethodReference, "Tentativa de acesso ao método inacessível %s por meio de uma referência com tipo estático %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Erro de sintaxe: esperando uma expressão depois do lançamento." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "A classe %s não pode estender %s, pois ambas são associadas a símbolos da biblioteca ou à linha do tempo principal." ),
           new AscError(kError_AttributesOnPackage, "Os atributos não são permitidos na definição do pacote." ),
           new AscError(kError_InternalError, "Erro interno: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Erro de sintaxe: inválido para o inicializador, somente 1 expressão esperada." ),
           new AscError(kError_IllegalSuperStatement, "Uma instrução super não pode ocorrer depois de uma instrução super, return ou throw." ),
           new AscError(kError_UnfoundPackageProperty, "Acesso de propriedade indefinida %s no pacote %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Nenhum construtor padrão encontrado na classe base %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* encontrado sem corresponder */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Erro de sintaxe: esperando uma chave esquerda({)ou literal de string(\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "Uma instrução super pode ser usada somente como o último item em uma lista de inicializadores de construtor." ),
           new AscError(kError_ThisUsedInInitializer, "Esta palavra-chave não pode ser usada em inicializadores de propriedade." ),
           new AscError(kError_NonConstantConfigInit, "O inicializador de um valor de configuração deve ser uma constante de tempo de compilação." ),
           new AscError(kError_NonConstConfigVar, "Uma variável de configuração pode somente ser declarada const." ),
           new AscError(kError_InvalidConfigLocation, "Um valor de configuração deve ser declarado no nível superior de um programa ou pacote." ),
           new AscError(kError_ShadowedConfigNamespace, "O namespace %s está em conflito com um namespace de configuração." ),
           new AscError(kError_InvalidPrecision, "A precisão deve ser um número inteiro entre 1 e 34." ),
           new AscError(kError_WrongVersion, "Versão incompatível: não é possível fazer referência à definição %s introduzida na versão %s do código com a versão %s." ),
           new AscError(kError_LossyConversion, "Inicialização inválida: a conversão no tipo %s perde dados." ),
   };

   public static final AscError[] errorConstantsRU = { 
           new AscError(kError_AmbiguousReference, "Неоднозначная ссылка на %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Спецификаторы уровня доступа с атрибутами пространства имен недопустимы." ),
           new AscError(kError_Unknown_Namespace, "Пространство имен не найдено или не является константой времени компиляции." ),
           new AscError(kError_InvalidSuperExpression, "Супервыражение можно использовать только внутри методов класса экземпляра." ),
           new AscError(kError_InvalidSuperStatement, "Супероператор можно использовать только внутри конструктора класса экземпляра." ),
           new AscError(kError_InvalidAttribute, "Недопустимый атрибут." ),
           new AscError(kError_InvalidOverride, "Атрибут \"override\" можно использовать только в определениях свойств класса." ),
           new AscError(kError_InvalidVirtual, "Атрибут \"virtual\" можно использовать только в определениях свойств класса." ),
           new AscError(kError_InvalidStatic, "Атрибут \"static\" можно использовать только в определениях внутри класса." ),
           new AscError(kError_InvalidPrivate, "Атрибут \"private\" можно использовать для определений свойств класса." ),
           new AscError(kError_Unsupported_Intrinsic, "Атрибут \"intrinsic\" больше не поддерживается." ),
           new AscError(kError_BaseClassIsFinal, "Базовый класс является окончательным." ),
           new AscError(kError_UnknownBaseClass, "Определение базового класса %s не найдено." ),
           new AscError(kError_DuplicateClassDefinition, "Повторное определение класса: %s." ),
           new AscError(kError_OverrideNotFound, "Метод, который помечен на переопределение, должен переопределять другой метод." ),
           new AscError(kError_DuplicateFunction, "Повторное определение функции." ),
           new AscError(kError_OverrideFinalAccessor, "Не удается переопределить окончательный метод доступа." ),
           new AscError(kError_IncompatibleOverride, "Несовместимое переопределение." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Переопределение функции, которая не отмечена для переопределения." ),
           new AscError(kError_FinalMethodRedefinition, "Невозможно переопределить окончательный метод." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Функции конструктора должны быть методами экземпляра." ),
           new AscError(kError_FuncIsStaticAndOverride, "Функции не могут быть одновременно статическими и переопределяющими." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Функции не могут быть одновременно статическими и виртуальными." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Функции не могут быть одновременно окончательными и виртуальными." ),
           new AscError(kError_RestParameterNotNamed, "Необходимо указать имя массива с аргументами переменных." ),
           new AscError(kError_VirtualVars, "Виртуальные переменные не поддерживаются." ),
           new AscError(kError_NativeVars, "Переменные не могут быть собственными." ),
           new AscError(kError_VarIsFinalAndVirtual, "Переменные не могут быть одновременно окончательными и виртуальными." ),
           new AscError(kError_NestedPackage, "Пакеты не могут быть вложенными." ),
           new AscError(kError_BreakHasNoTarget, "Цель оператора \"break\" не найдена." ),
           new AscError(kError_ContinueHasNoTarget, "Цель оператора \"continue\" не найдена." ),
           new AscError(kError_DuplicateLabel, "Двойное определение метки." ),
           new AscError(kError_AttributesAreNotCallable, "Атрибуты не могут быть вызваны." ),
           new AscError(kError_ThisUsedInStaticFunction, "Ключевое слово \"this\" не может использоваться в статических методах. Оно может использоваться только в методах экземпляра, в закрытии функций и в глобальных кодах." ),
           new AscError(kError_UndefinedNamespace, "Неопределенное пространство имен." ),
           new AscError(kError_UnknownInterfaceMethod, "Интерфейсный метод %s в пространстве имен %s не внедрен классом %s." ),
           new AscError(kError_UnknownInterface, "Интерфейс %s не найден." ),
           new AscError(kError_UnknownType, "Тип не найден или не является константой времени компиляции: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Неизвестный инициализатор параметров, или не является константой времени компиляции." ),
           new AscError(kError_MethodIsNotAConstructor, "Метод не может использоваться как конструктор." ),
           new AscError(kError_AssignmentToConstVar, "Недопустимое присваивание переменной, которая определена как константа." ),
           new AscError(kError_AssignmentToNonRefVar, "Нельзя выполнить присваивание неизвестной переменной." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Возвращаемое значение должно быть неопределенным." ),
           new AscError(kError_ConstInitializerNotConst, "Инициализатор констант неизвестен или не является константой времени компиляции." ),
           new AscError(kError_AccessorTypesMustMatch, "Типы средств доступа должны соответствовать." ),
           new AscError(kError_BadSetterReturnType, "Тип возвращаемого значения для определения установщика не должен указываться или должен быть пустым." ),
           new AscError(kError_PropertyIsWriteOnly, "Свойство \"только на запись\"." ),
           new AscError(kError_PropertyIsReadOnly, "Свойство \"только на чтение\"." ),
           new AscError(kError_Strict_UndefinedMethod, "Обращение к возможно неопределенному методу %s через ссылку статического типа %s." ),
           new AscError(kError_UnableToOpenFile, "Не удалось открыть файл: %s." ),
           new AscError(kError_InvalidMetaData, "Ошибочные метаданные." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Атрибуты метаданных не могут содержать более одного элемента." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Неявное приведение значения типа %s к несоответствующему типу %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Не удалось открыть прилагаемый файл: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Синтаксическая ошибка: ожидалось определение или директива." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Синтаксическая ошибка: ожидалось ключевое слово определения (как функция) после атрибута %s, а не %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Синтаксическая ошибка: ожидается XML перед пространством имен." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Синтаксическая ошибка: ожидается блок \"catch\" или закрывающий оператор." ),
           new AscError(kError_Parser_EachWithoutIn, "Синтаксическая ошибка: нельзя использовать ключевое слово \"each\" без оператора \"in\"." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Синтаксическая ошибка: ожидается левая скобка перед идентификатором." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "Ожидается CaseLabel." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Метка должна быть простым идентификатором." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Супервыражение должно иметь один операнд." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Ожидается оператор увеличения или уменьшения." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Ожидается одиночное выражение внутри скобок." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Синтаксическая ошибка: %s не ожидается" ),
           new AscError(kError_Parser_ExpectedToken, "Синтаксическая ошибка: %s перед %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Синтаксическая ошибка: ожидается точка с запятой перед %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Синтаксическая ошибка: дополнительные символы в конце программы." ),
           new AscError(kError_Lexical_General, "Синтаксическая ошибка." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Синтаксическая ошибка: строковый литерал должен завершиться до конца строки." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Синтаксическая ошибка: строковый литерал должен завершиться до конца строки." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Синтаксическая ошибка: ввод закончился до закрывающих кавычек для строкового литерала." ),
           new AscError(kError_Lexical_SyntaxError, "Синтаксическая ошибка." ),
           new AscError(kError_Lexical_NoMatchingTag, "Синтаксическая ошибка: в XML нет соответствующих тегов начала и окончания." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Нельзя удалять суперпотомков." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Повторение определения пространства имен." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Целью присваивания должно быть ссылочное значение." ),
           new AscError(kError_IncrementOperatorNotAReference, "Операнд увеличения должен быть ссылкой." ),
           new AscError(kError_InvalidIncrementOperand, "Операнд увеличения неправильный." ),
           new AscError(kError_InvalidDecrementOperand, "Операнд уменьшения неправильный." ),
           new AscError(kError_ExpectingExpression, "Ожидается выражение." ),
           new AscError(kError_MissingXMLTagName, "Отсутствует имя XML-тега." ),
           new AscError(kError_InvalidAbcFile, "Файл %s является недопустимым файлом ABC." ),
           new AscError(kError_Parser_FileIncludesItself, "Возможна бесконечная рекурсия к этому файлу: %s." ),
           new AscError(kError_CircularReference, "Обнаружена циклическая ссылка в %s." ),
           new AscError(kError_InvalidPublic, "Атрибут \"public\" может использоваться только внутри пакета." ),
           new AscError(kError_InvalidInternal, "Атрибут \"internal\" может использоваться только внутри пакета." ),
           new AscError(kError_InvalidNamespace, "Определенный пользователем атрибут пространства имен может использоваться на высшем уровне определения класса." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Неявное исправление значения статического типа %s на возможный несвязанный тип %s." ),
           new AscError(kError_UndefinedProperty, "Обращение возможного неопределенного свойства %s через ссылку со статическим типом %s ." ),
           new AscError(kError_UnfoundProperty, "Обращение несуществующего свойства %s." ),
           new AscError(kError_GetterCannotHaveParameters, "Определение получателя не должно содержать параметров." ),
           new AscError(kError_SetterMustHaveOneParameter, "Определение установщика должно содержать один параметр." ),
           new AscError(kError_SetterCannotHaveOptional, "Определение установщика не может содержать дополнительных параметров." ),
           new AscError(kError_BadGetterReturnType, "Возвращаемый тип определения получателя не должен быть пустым." ),
           new AscError(kError_InterfaceMethodWithBody, "Методы, которые определены в интерфейсе, не должны содержать тело." ),
           new AscError(kError_FunctionWithoutBody, "У функции нет тела." ),
           new AscError(kError_DuplicateAttribute, "Атрибут %s был определен несколько раз." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Повторное определение интерфейса: %s." ),
           new AscError(kError_CtorWithReturnType, "Конструктор не может указывать возвращаемый тип." ),
           new AscError(kError_InvalidClassNesting, "Классы не должны быть вложенными." ),
           new AscError(kError_InvalidFinalUsage, "Только атрибут \"final\" может использоваться в методе, который определен в классе." ),
           new AscError(kError_InvalidNative, "Собственный атрибут может использоваться только с определениями функции." ),
           new AscError(kError_InvalidDynamic, "Атрибут \"dynamic\" может использоваться только с определениями класса." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Синтаксическая ошибка: %s не является действительным типом." ),
           new AscError(kError_WrongNumberOfArguments, "Неправильное количество аргументов. Ожидается %s." ),
           new AscError(kError_TooManyArguments, "Неправильное количество аргументов. Ожидается не более %s." ),
           new AscError(kError_BadRequiredParameter, "Обязательные параметры нельзя использовать после дополнительных." ),
           new AscError(kError_VarInInterface, "Объявления переменных в интерфейсах недопустимо." ),
           new AscError(kError_InvalidRestDecl, "Параметры, указанные после ключевого слова определения параметра \"...rest\", могут относиться только к типу данных \"Array\"." ),
           new AscError(kError_CannotExtendInterface, "Класс может расширять только другой класс, но не интерфейс." ),
           new AscError(kError_CannotExtendClass, "Интерфейс может расширять только другой интерфейс, но %s является классом." ),
           new AscError(kError_InvalidOverrideUsage, "Атрибут \"override\" может использоваться только в методе, который определен в классе." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Метод интерфейса %s в пространстве имен %s реализуется с несовместимой сигнатурой в классе %s." ),
           new AscError(kError_NativeMethodWithBody, "Собственные методы не могут иметь тело." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Конструктор не может быть методом \"получатель\" или \"установщик\"." ),
           new AscError(kError_MissingFilespec, "Исходный файл AS не определен." ),
           new AscError(kError_CannotReturnFromStaticInit, "Оператор \"return\" нельзя использовать в статическом коде инициализации." ),
           new AscError(kError_InvalidProtected, "Атрибут \"protected\" можно использовать только для определения свойств класса." ),
           new AscError(kError_ConflictingNameInNamespace, "Конфликт с определением %s в пространстве имен %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Конфликт с наследуемым определением %s в пространстве имен %s." ),
           new AscError(kError_ConstructorMustBePublic, "Конструктор может быть объявлен только публичным." ),
           new AscError(kError_ConflictingAccessSpecifiers, "В определении может указываться только \"public\", \"private\", \"protected\" или \"internal\"." ),
           new AscError(kError_InvalidNestedAccessor, "Средства доступа не могут быть вложенными в другие функции." ),
           new AscError(kError_CannotInstantiateInterface, "Интерфейсы не могут быть реализованы с помощью нового оператора." ),
           new AscError(kError_BadAccessInterfaceMember, "Члены интерфейса не могут быть объявлены как публичные, частные, защищенные или внутренние." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Синтаксическая ошибка: отсутствует левая фигурная скобка ({) перед телом функции." ),
           new AscError(kError_CannotReturnFromPackageInit, "Оператор \"return\" нельзя использовать в коде инициализации пакетов." ),
           new AscError(kError_InvalidInterfaceNative, "Собственный атрибут нельзя использовать в определениях интерфейса." ),
           new AscError(kError_MultipleNamespaceAttributes, "В каждом определении можно использовать только один атрибут пространства имен." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Метод %s конфликтует с определением, которое наследуется из интерфейса %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Недопустимый атрибут интерфейса %s." ),
           new AscError(kError_NamespaceInInterface, "Объявление пространства имен в интерфейсах недопустимо." ),
           new AscError(kError_DuplicateImplements, "Класс %s реализует интерфейс %s несколько раз." ),
           new AscError(kError_AssignmentToDefinedFunction, "Недопустимое присваивание функции %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Атрибуты пространства имен недопустимы в методах интерфейса." ),
           new AscError(kError_MustReturnValue, "Функция не возвращает значение." ),
           new AscError(kError_InvalidNamespaceInitializer, "Инициализатор пространства имен должен являться строкой литерала или другим пространством имен." ),
           new AscError(kError_DefinitionNotFound, "Не удалось найти определение %s." ),
           new AscError(kError_InvalidLabel, "Недопустимое определение метки." ),
           new AscError(kError_IncompatableValueComparison, "Сравнение значений статического типа %s и предположительно несвязанного типа %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Оператор \"return\" не может использоваться в глобальном коде инициализации." ),
           new AscError(kError_InaccessiblePropertyReference, "Попытка вызова недоступного свойства %s с помощью ссылки со статическим типом %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Объект временно не обслуживается. Вместо этого используйте :* ." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Вызов предположительно неопределенного метода %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Прямая ссылка на базовый класс %s." ),
           new AscError(kError_IllegalPackageReference, "Пакет нельзя использовать как значение: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Несовместимое значение по умолчанию типа %s; ожидается %s." ),
           new AscError(kError_MultipleSwitchDefaults, "Переключатель имеет несколько значений по умолчанию, но допустимо только одно значение." ),
           new AscError(kError_AssignmentToDefinedClass, "Wu6Я_Illegal assignment to class %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Попытка удаления фиксированного свойства %s. Можно удалять только динамически определенные свойства." ),
           new AscError(kError_InvalidBaseTypeExpression, "Базовый класс не найден или не является константой времени компиляции." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Интерфейс не найден или не является константой времени компиляции." ),
           new AscError(kError_StaticModifiedNamespace, "Атрибут \"static\" не может быть использован в определениях пространства имен." ),
           new AscError(kError_InvalidInterfaceNesting, "Определения интерфейса не должны быть вложенными внутри класса или других определений интерфейса." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Недопустимый атрибут \"prototype\"." ),
           new AscError(kError_InaccessibleMethodReference, "Попытка вызова недоступного свойства %s с помощью ссылки со статическим типом %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Синтаксическая ошибка: после оператора \"throw\" ожидается выражение." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Класс %s не может расширять %s, так как они оба связаны с библиотечными символами или основной временной шкалой." ),
           new AscError(kError_AttributesOnPackage, "Атрибуты не могут использоваться в определении пакета." ),
           new AscError(kError_InternalError, "Внутренняя ошибка: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Синтаксическая ошибка: недопустимый инициализатор \"for-in\", ожидается только 1 выражение." ),
           new AscError(kError_IllegalSuperStatement, "Супероператор не может следовать за операторами \"this\", \"super\", \"return\" или \"throw\"." ),
           new AscError(kError_UnfoundPackageProperty, "Вызов неопределенного свойства %s в пакете %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Не удалось найти конструктор по умолчанию в базовом классе %s." ),
           new AscError(kError_BlockCommentNotTerminated, "Обнаружен /* без соответствующего */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Синтаксическая ошибка: ожидается открывающая скобка ({) или строковый литерал (\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "Оператор super может использоваться только в качестве последнего элемента в списке инициализаторов конструктора." ),
           new AscError(kError_ThisUsedInInitializer, "Ключевое слово this не может использоваться в инициализаторах свойств." ),
           new AscError(kError_NonConstantConfigInit, "Инициализатором для значения конфигурации должна являться константа периода компиляции." ),
           new AscError(kError_NonConstConfigVar, "Переменная конфигурации может быть объявлена только как const." ),
           new AscError(kError_InvalidConfigLocation, "Переменная конфигурации  должна быть объявлена на верхнем уровне программы или пакета." ),
           new AscError(kError_ShadowedConfigNamespace, "Пространство имен %s конфликтует с пространством имен конфигурации." ),
           new AscError(kError_InvalidPrecision, "Значение точности должно являться целым числом от 1 до 34." ),
           new AscError(kError_WrongVersion, "Несовместимая версия: невозможно сослаться на определение %s, представленное в версии %s из кода с версией %s." ),
           new AscError(kError_LossyConversion, "Недопустимая инициализация: при преобразовании в тип %s происходит потеря данных." ),
   };

   public static final AscError[] errorConstantsSV = { 
           new AscError(kError_AmbiguousReference, "Tvetydig referens till %s." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Åtkomstspecifikationer är inte tillåtna med namnutrymmesattribut." ),
           new AscError(kError_Unknown_Namespace, "Namnutrymmet hittades inte eller är inte en kompileringskonstant." ),
           new AscError(kError_InvalidSuperExpression, "Ett superuttryck får bara användas inuti metoder för klassförekomster." ),
           new AscError(kError_InvalidSuperStatement, "En superprogramsats får bara användas i konstruktorer för klassförekomster." ),
           new AscError(kError_InvalidAttribute, "Attributet är ogiltigt." ),
           new AscError(kError_InvalidOverride, "Attributet override får bara användas på definitioner av klassegenskaper." ),
           new AscError(kError_InvalidVirtual, "Attributet virtual får bara användas på definitioner av klassegenskaper." ),
           new AscError(kError_InvalidStatic, "Attributet static får bara användas på definitioner i en klass." ),
           new AscError(kError_InvalidPrivate, "Attributet private får bara användas på definitioner av klassegenskaper." ),
           new AscError(kError_Unsupported_Intrinsic, "Attributet intrinsic stöds inte längre." ),
           new AscError(kError_BaseClassIsFinal, "Basklassen är final." ),
           new AscError(kError_UnknownBaseClass, "Definitionen för basklass %s hittades inte." ),
           new AscError(kError_DuplicateClassDefinition, "Klassdefinitionen är en dubblett: %s." ),
           new AscError(kError_OverrideNotFound, "En metod som är markerad som override måste åsidosätta en annan metod." ),
           new AscError(kError_DuplicateFunction, "Funktionsdefinition är en dubblett." ),
           new AscError(kError_OverrideFinalAccessor, "Det går inte att åsidosätta en åtkomst av typen final." ),
           new AscError(kError_IncompatibleOverride, "Inkompatibel åsidosättning." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Åsidosätter en funktion som inte är markerad för åsidosättning." ),
           new AscError(kError_FinalMethodRedefinition, "Det går inte att omdefiniera en final metod." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Konstruktorfunktioner måste vara förekomstmetoder." ),
           new AscError(kError_FuncIsStaticAndOverride, "Funktioner kan inte vara både static och override." ),
           new AscError(kError_FuncIsStaticAndVirtual, "Funktioner kan inte vara både static och virtual." ),
           new AscError(kError_FuncIsVirtualAndFinal, "Funktioner kan inte vara både final och virtual." ),
           new AscError(kError_RestParameterNotNamed, "Du måste ange namnet på arrayen med argumentvariabler." ),
           new AscError(kError_VirtualVars, "Virtuella variabler stöds inte." ),
           new AscError(kError_NativeVars, "Variabler kan inte vara interna." ),
           new AscError(kError_VarIsFinalAndVirtual, "Variabler kan inte vara både final och virtual." ),
           new AscError(kError_NestedPackage, "Paket kan inte vara inkapslade." ),
           new AscError(kError_BreakHasNoTarget, "Målet för programsatsen break hittades inte." ),
           new AscError(kError_ContinueHasNoTarget, "Målet för programsatsen continue hittades inte." ),
           new AscError(kError_DuplicateLabel, "Duplicerad etikettsdefinition." ),
           new AscError(kError_AttributesAreNotCallable, "Det går inte att anropa attribut." ),
           new AscError(kError_ThisUsedInStaticFunction, "Nyckelordet this kan inte användas i statiska metoder. Det kan bara användas i förekomstmetoder, funktionsslut och global kod." ),
           new AscError(kError_UndefinedNamespace, "Odefinierat namnutrymme." ),
           new AscError(kError_UnknownInterfaceMethod, "Gränssnittsmetoden %s i namnutrymmet %s implementerades inte av klassen %s." ),
           new AscError(kError_UnknownInterface, "Gränssnittet %s hittades inte." ),
           new AscError(kError_UnknownType, "Typen hittades inte eller är inte en kompileringskonstant: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parameterinitieraren är okänd eller är inte en kompileringskonstant." ),
           new AscError(kError_MethodIsNotAConstructor, "Metoden kan inte användas som en konstruktor." ),
           new AscError(kError_AssignmentToConstVar, "Ogiltig tilldelning till en variabel som angetts som constant." ),
           new AscError(kError_AssignmentToNonRefVar, "Det går inte att tilldela till icke-referensvärden." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Returvärdet måste vara odefinierat." ),
           new AscError(kError_ConstInitializerNotConst, "Konstantinitieraren är okänd eller är inte en kompileringskonstant." ),
           new AscError(kError_AccessorTypesMustMatch, "Åtkomstyperna måste matcha." ),
           new AscError(kError_BadSetterReturnType, "Returtypen för en set-definition måste vara ospecificerad eller void." ),
           new AscError(kError_PropertyIsWriteOnly, "Egenskapen är lässkyddad." ),
           new AscError(kError_PropertyIsReadOnly, "Egenskapen är skrivskyddad." ),
           new AscError(kError_Strict_UndefinedMethod, "Anrop till den möjligen odefinierade metoden %s via en referens med den statiska typen %s." ),
           new AscError(kError_UnableToOpenFile, "Det går inte att öppna filen: %s." ),
           new AscError(kError_InvalidMetaData, "Ogiltiga metadata." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Attribut för metadata får inte ha fler än ett element." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "Implicit tvång för ett värde av typen %s till den orelaterade typen %s." ),
           new AscError(kError_Parser_UnableToOpenFile, "Det går inte att öppna den inkluderade filen: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Syntaxfel: definition eller ett direktiv förväntades." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Syntaxfel: ett definitionsnyckelord förväntades (till exempel en funktion) efter attributet %s, inte %s." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Syntaxfel: xml förväntades före namnutrymmet." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Syntaxfel: en catch- eller finally-sats förväntades." ),
           new AscError(kError_Parser_EachWithoutIn, "Syntaxfel: nyckelordet 'each' är inte tillåtet utan operatorn 'in'." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Syntaxfel: vänster parentes förväntades före identifieraren." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel förväntades." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Etiketten måste vara en enkel identifierare." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Ett superuttryck måste ha en operand." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Öknings- eller minskningsoperator förväntades." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Ett enda uttryck inom parentes förväntades." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Syntaxfel: %s förväntades inte." ),
           new AscError(kError_Parser_ExpectedToken, "Syntaxfel: %s förväntades före %s." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Syntaxfel: semikolon förväntades före %s." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Syntaxfel: extra tecken hittades efter programslutet." ),
           new AscError(kError_Lexical_General, "Syntaxfel." ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Syntaxfel: Stränglitteralen måste avslutas före radbrytningen." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Syntaxfel: Stränglitteralen måste avslutas före radbrytningen." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Syntaxfel: indata tog slut före det avslutande citattecknet för en stränglitteral." ),
           new AscError(kError_Lexical_SyntaxError, "Syntaxfel." ),
           new AscError(kError_Lexical_NoMatchingTag, "Syntaxfel: XML har inte matchande start- och sluttaggar." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Det går inte att ta bort underordnade objekt till super." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Duplicerad namnutrymmesdefinition." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Tilldelningens mål måste vara ett referensvärde." ),
           new AscError(kError_IncrementOperatorNotAReference, "Ökningsoperanden måste vara en referens." ),
           new AscError(kError_InvalidIncrementOperand, "Ogiltig ökningsoperand." ),
           new AscError(kError_InvalidDecrementOperand, "Ogiltig minskningsoperand." ),
           new AscError(kError_ExpectingExpression, "Ett uttryck förväntades." ),
           new AscError(kError_MissingXMLTagName, "Namnet på en XML-tagg saknas." ),
           new AscError(kError_InvalidAbcFile, "Filen %s är inte en giltig ABC-fil." ),
           new AscError(kError_Parser_FileIncludesItself, "Möjlig oändlig rekursion på grund av den här filen: %s." ),
           new AscError(kError_CircularReference, "Cirkulär typreferens upptäcktes i %s." ),
           new AscError(kError_InvalidPublic, "Attributet public får bara användas i ett paket." ),
           new AscError(kError_InvalidInternal, "Attributet internal får bara användas i ett paket." ),
           new AscError(kError_InvalidNamespace, "Ett användardefinierat namnutrymmesattribut kan bara användas på den högsta nivån i en klassdefinition." ),
           new AscError(kError_ImplicitCoercionToSubtype, "Implicit tvång för ett värde av den statiska typen %s till den möjligen orelaterade typen %s." ),
           new AscError(kError_UndefinedProperty, "Åtkomst till den möjligen odefinierade egenskapen %s via en referens med den statiska typen %s." ),
           new AscError(kError_UnfoundProperty, "Åtkomst till den odefinierade egenskapen %s." ),
           new AscError(kError_GetterCannotHaveParameters, "En get-definition får inte ha några parametrar." ),
           new AscError(kError_SetterMustHaveOneParameter, "En set-definition måste ha exakt en parameter." ),
           new AscError(kError_SetterCannotHaveOptional, "En set-definition får inte ha valfria parametrar." ),
           new AscError(kError_BadGetterReturnType, "Returtypen för en get-definition får inte vara void." ),
           new AscError(kError_InterfaceMethodWithBody, "Metoderna som är definierade i ett gränssnitt får inte har något innehåll." ),
           new AscError(kError_FunctionWithoutBody, "Funktionen har inget innehåll." ),
           new AscError(kError_DuplicateAttribute, "Attributet %s angavs flera gånger." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Dubblett av gränssnittsdefinition: %s." ),
           new AscError(kError_CtorWithReturnType, "En konstruktor kan inte ange en returtyp." ),
           new AscError(kError_InvalidClassNesting, "Klasser får inte kapslas in." ),
           new AscError(kError_InvalidFinalUsage, "Attributet final kan bara användas på en metod som är definierad i en klass." ),
           new AscError(kError_InvalidNative, "Attributet native kan bara användas med funktionsdefinitioner." ),
           new AscError(kError_InvalidDynamic, "Attributet dynamic kan bara användas med klassdefinitioner." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Syntaxfel: %s är inte en giltig typ." ),
           new AscError(kError_WrongNumberOfArguments, "Felaktigt antal argument.  %s.  förväntades" ),
           new AscError(kError_TooManyArguments, "Felaktigt antal argument.  Högst %s förväntades." ),
           new AscError(kError_BadRequiredParameter, "Obligatoriska parametrar är inte tillåtna efter valfria parametrar." ),
           new AscError(kError_VarInInterface, "Variabeldeklarationer får inte förekomma i gränssnitt." ),
           new AscError(kError_InvalidRestDecl, "Parametrar som anges efter nyckelordet …rest i parameterdefinitionen kan bara ha datatypen Array." ),
           new AscError(kError_CannotExtendInterface, "En klass kan bara utöka en annan klass, inte ett gränssnitt." ),
           new AscError(kError_CannotExtendClass, "Ett gränssnitt kan bara utöka andra gränssnitt, men %s är en klass." ),
           new AscError(kError_InvalidOverrideUsage, "Attributet override kan bara användas på en metod som är definierad i en klass." ),
           new AscError(kError_IncompatibleInterfaceMethod, "Gränssnittsmetoden %s i namnutrymmet %s implementerades med en inkompatibel signatur i klassen %s." ),
           new AscError(kError_NativeMethodWithBody, "Interna metoder får inte ha något innehåll." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "En konstruktor får inte vara en get- eller set-metod." ),
           new AscError(kError_MissingFilespec, "Ingen AS-källfil har angetts." ),
           new AscError(kError_CannotReturnFromStaticInit, "Programsatsen return kan inte användas i statisk initieringskod." ),
           new AscError(kError_InvalidProtected, "Attributet protected får bara användas på definitioner av klassegenskaper." ),
           new AscError(kError_ConflictingNameInNamespace, "Konflikt med definitionen %s i namnutrymmet %s." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Konflikt med den ärvda definitionen %s i namnutrymmet %s." ),
           new AscError(kError_ConstructorMustBePublic, "En konstruktor kan bara definieras som public." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Endast en av public, private, protected och internal får anges för en definition." ),
           new AscError(kError_InvalidNestedAccessor, "Åtkomster får inte kapslas i andra funktioner." ),
           new AscError(kError_CannotInstantiateInterface, "Gränssnitt kan inte skapas med operatorn new." ),
           new AscError(kError_BadAccessInterfaceMember, "Gränssnittsmedlemmar får inte deklareras som public, private, protected eller internal." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Syntaxfel: vänsterklammer ({) före funktionsinnehållet saknas." ),
           new AscError(kError_CannotReturnFromPackageInit, "Programsatsen return kan inte användas i paketinitieringskod." ),
           new AscError(kError_InvalidInterfaceNative, "Attributet native kan inte användas i gränssnittsdefinitioner." ),
           new AscError(kError_MultipleNamespaceAttributes, "Endast ett namnutrymmesattribut får användas per definition." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "Metoden %s står i konflikt med definitionen som har ärvts från gränssnittet %s." ),
           new AscError(kError_InvalidInterfaceAttribute, "Gränssnittsattributet %s är ogiltigt." ),
           new AscError(kError_NamespaceInInterface, "Namnutrymmesdeklarationer får inte förekomma i gränssnitt." ),
           new AscError(kError_DuplicateImplements, "Klassen %s implementerar gränssnittet %s flera gånger." ),
           new AscError(kError_AssignmentToDefinedFunction, "Ogiltig tilldelning till funktionen %s." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Namnutrymmesattribut tillåts inte för gränssnittsmetoder." ),
           new AscError(kError_MustReturnValue, "Funktionen returnerar inget värde." ),
           new AscError(kError_InvalidNamespaceInitializer, "En namnutrymmesstart måste vara antingen en litteral sträng eller ett annat namnutrymme." ),
           new AscError(kError_DefinitionNotFound, "Definitionen %s kunde inte hittas." ),
           new AscError(kError_InvalidLabel, "Etikettdefinitionen är ogiltig." ),
           new AscError(kError_IncompatableValueComparison, "Jämförelse av ett värde av den statiska typen %s och den möjligen orelaterade typen %s." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Programsatsen return kan inte användas i global initieringskod." ),
           new AscError(kError_InaccessiblePropertyReference, "Åtkomstförsök till otillgängliga egenskapen %s via en referens med den statiska typen %s." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Objektet är tillfälligt otillgängligt. Använd :* i stället." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Anrop till den möjligen odefinierade metoden %s." ),
           new AscError(kError_ForwardReferenceToBaseClass, "Framåtreferens till basklassen %s." ),
           new AscError(kError_IllegalPackageReference, "Paket kan inte användas som ett värde: %s." ),
           new AscError(kError_IncompatibleDefaultValue, "Inkompatibelt standardvärde av typen %s där %s förväntas." ),
           new AscError(kError_MultipleSwitchDefaults, "Programsatsen switch har mer än ett standardvärde. Bara ett standardvärde får användas." ),
           new AscError(kError_AssignmentToDefinedClass, "Ogiltig tilldelning till klassen %s." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "Försök att ta bort den fasta egenskapen %s.  Bara dynamiskt definierade egenskaper kan tas bort." ),
           new AscError(kError_InvalidBaseTypeExpression, "Basklassen hittades inte eller är inte en kompileringskonstant." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Gränssnittet hittades inte eller är inte en kompileringskonstant." ),
           new AscError(kError_StaticModifiedNamespace, "Attributet static tillåts inte i namnutrymmesdefinitioner." ),
           new AscError(kError_InvalidInterfaceNesting, "Gränssnittsdefinitioner får inte vara inkapslade i definitioner av klasser eller av andra gränssnitt." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Attributet prototype är ogiltigt." ),
           new AscError(kError_InaccessibleMethodReference, "Åtkomstförsök till den otillgängliga metoden %s via en referens med den statiska typen %s." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Syntaxfel: ett uttryck förväntades efter throw." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Klassen %s kan inte utöka %s eftersom båda är kopplade till bibliotekssymboler eller till huvudtidslinjen." ),
           new AscError(kError_AttributesOnPackage, "Attribut får inte användas i paketdefinitioner." ),
           new AscError(kError_InternalError, "Internt fel: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Syntaxfel: ogiltig for-in-initierare, bara 1 uttryck förväntades." ),
           new AscError(kError_IllegalSuperStatement, "En super-programsats får inte användas efter programsatserna this, super, return eller throw." ),
           new AscError(kError_UnfoundPackageProperty, "Åtkomst till den odefinierade egenskapen %s i paketet %s." ),
           new AscError(kError_NoDefaultBaseclassCtor, "Ingen standardkonstruktor i basklassen %s." ),
           new AscError(kError_BlockCommentNotTerminated, "/* påträffades utan matchande */ ." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntaxfel: vänster klammerparentes ({) eller stränglitteral (\"\") förväntades." ),
           new AscError(kError_InvalidES4SuperStatement, "En superprogramsats kan endast användas som det sista objektet i en initierarlista för en konstruktor." ),
           new AscError(kError_ThisUsedInInitializer, "Det här nyckelordet kan inte användas i egenskapsinitierare." ),
           new AscError(kError_NonConstantConfigInit, "Initieraren för ett konfigurationsvärde måste vara en kompileringskonstant." ),
           new AscError(kError_NonConstConfigVar, "En konfigurationsvariabel kan endast definieras som konstant." ),
           new AscError(kError_InvalidConfigLocation, "Ett konfigurationsvärde måste definieras på programmets eller paketets toppnivå." ),
           new AscError(kError_ShadowedConfigNamespace, "Det finns en konflikt mellan namnutrymmet %s och ett konfigurationsnamnutrymme." ),
           new AscError(kError_InvalidPrecision, "Precision måste vara ett heltal mellan 1 och 34." ),
           new AscError(kError_WrongVersion, "Inkompatibel version: det går inte att skapa referens för definitionen %s som lanserades i version %s utifrån koden med version %s." ),
           new AscError(kError_LossyConversion, "Ogiltig initiering: konvertering till typ %s kan orsaka dataförlust." ),
   };

   public static final AscError[] errorConstantsTR = { 
           new AscError(kError_AmbiguousReference, "%s öğesine belirsiz referans." ),
           new AscError(kError_NamespaceAccessSpecifiers, "Erişim belirticilere ad alanı nitelikleri ile birlikte izin verilmez." ),
           new AscError(kError_Unknown_Namespace, "Ad alanı bulunamadı veya derleme zamanı sabiti değil." ),
           new AscError(kError_InvalidSuperExpression, "Bir üst ifade yalnızca sınıf örneği yöntemleri içerisinde kullanılabilir." ),
           new AscError(kError_InvalidSuperStatement, "Bir üst ifade yalnızca sınıf örneği yapıcıları içerisinde kullanılabilir." ),
           new AscError(kError_InvalidAttribute, "Nitelik geçersiz." ),
           new AscError(kError_InvalidOverride, "Geçersiz kılma niteliği yalnızca sınıf özellik tanımlarında kullanılabilir." ),
           new AscError(kError_InvalidVirtual, "Sanal nitelik yalnızca sınıf özellik tanımlarında kullanılabilir." ),
           new AscError(kError_InvalidStatic, "Statik nitelik yalnızca bir sınıf içerisindeki tanımlarda kullanılabilir." ),
           new AscError(kError_InvalidPrivate, "Özel nitelik yalnızca sınıf özellik tanımlarında kullanılabilir." ),
           new AscError(kError_Unsupported_Intrinsic, "İç nitelik artık desteklenmiyor." ),
           new AscError(kError_BaseClassIsFinal, "Taban sınıfı son." ),
           new AscError(kError_UnknownBaseClass, "%s taban sınıfı tanımı bulunamadı." ),
           new AscError(kError_DuplicateClassDefinition, "Çoğaltma sınıfı tanımı: %s." ),
           new AscError(kError_OverrideNotFound, "Geçersiz olarak işaretli olan yöntem bir diğer yöntemi geçersiz kılmalıdır." ),
           new AscError(kError_DuplicateFunction, "Çoğaltma işlevi tanımı." ),
           new AscError(kError_OverrideFinalAccessor, "Bir son erişimci geçersiz kılınamaz." ),
           new AscError(kError_IncompatibleOverride, "Uyumsuz geçersizlik." ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "Geçersiz olarak işaretlenmemiş bir işlevi geçersiz kılma." ),
           new AscError(kError_FinalMethodRedefinition, "Bir son yöntem yeniden tanımlanamaz." ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "Yapıcı işlevleri, örnek yöntemler olmalıdır." ),
           new AscError(kError_FuncIsStaticAndOverride, "İşlevler, hem statik hem de geçersiz olamaz." ),
           new AscError(kError_FuncIsStaticAndVirtual, "İşlevler, hem statik hem de sanal olamaz." ),
           new AscError(kError_FuncIsVirtualAndFinal, "İşlevler, hem son hem de sanal olamaz." ),
           new AscError(kError_RestParameterNotNamed, "Değişken parametreler dizisi adını belirtmelidir." ),
           new AscError(kError_VirtualVars, "Sanal değişkenler desteklenmez." ),
           new AscError(kError_NativeVars, "Değişkenler doğal olamaz." ),
           new AscError(kError_VarIsFinalAndVirtual, "Değişkenler, hem son hem de sanal olamaz." ),
           new AscError(kError_NestedPackage, "Paketler iç içe olamaz." ),
           new AscError(kError_BreakHasNoTarget, "Kesme ifadesi hedefi bulunamadı." ),
           new AscError(kError_ContinueHasNoTarget, "Devam ifadesi hedefi bulunamadı." ),
           new AscError(kError_DuplicateLabel, "Çoğaltma etiketi tanımı." ),
           new AscError(kError_AttributesAreNotCallable, "Nitelikler çağrılabilir değildir." ),
           new AscError(kError_ThisUsedInStaticFunction, "Anahtar sözcük, statik yöntemlerde kullanılamaz. Yalnızca örnek yöntemlerde, işlev kapanmalarında ve global kodda kullanılabilir." ),
           new AscError(kError_UndefinedNamespace, "Tanımlanmamış ad alanı." ),
           new AscError(kError_UnknownInterfaceMethod, "%s ad alanındaki %s arabirim yöntemi %s sınıfı tarafından uygulanamadı." ),
           new AscError(kError_UnknownInterface, "%s arabirimi bulunamadı." ),
           new AscError(kError_UnknownType, "Tür bulunamadı veya derleme zamanı sabiti değil: %s." ),
           new AscError(kError_NonConstantParamInitializer, "Parametre başlatıcısı bilinmiyor veya derleme zamanı sabiti değil." ),
           new AscError(kError_MethodIsNotAConstructor, "Yöntem, yapıcı olarak kullanılamaz." ),
           new AscError(kError_AssignmentToConstVar, "Sabit olarak belirtilmiş bir değişkene kuraldışı atama." ),
           new AscError(kError_AssignmentToNonRefVar, "Referanssız bir değere atama yapılamaz." ),
           new AscError(kError_ReturnTypeMustBeUndefined, "Dönüş değeri tanımlanmamış olmalıdır." ),
           new AscError(kError_ConstInitializerNotConst, "Sabit başlatıcı bilinmiyor veya derleme zamanı sabiti değil." ),
           new AscError(kError_AccessorTypesMustMatch, "Erişimci türleri eşleşmelidir." ),
           new AscError(kError_BadSetterReturnType, "Ayarlayıcı tanımının dönüş türü belirtilmemiş veya boş olmalıdır." ),
           new AscError(kError_PropertyIsWriteOnly, "Özellik salt yazılır." ),
           new AscError(kError_PropertyIsReadOnly, "Özellik salt okunur." ),
           new AscError(kError_Strict_UndefinedMethod, "%s olası tanımlanmamış yöntemini %s statik türü ile bir referans üzerinden çağır." ),
           new AscError(kError_UnableToOpenFile, "Dosya açılamıyor: %s." ),
           new AscError(kError_InvalidMetaData, "Geçersiz meta verileri." ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "Meta veri niteliklerinde birden fazla öğe olamaz." ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "%s tür değerinin %s ilgisiz türüne örtük dayatması." ),
           new AscError(kError_Parser_UnableToOpenFile, "Dahil edilen dosya açılamıyor: %s." ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "Sözdizimi hatası: beklenen tanım veya direktif." ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "Sözdizimi hatası: %s niteliğinden sonra bir tanım anahtar sözcüğü (işlev gibi) bekleniyordu, %s değil." ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "Sözdizimi hatası: ad alanından önce xml bekleniyor." ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "Sözdizimi hatası: bir catch veya finally yan cümlesi bekleniyor." ),
           new AscError(kError_Parser_EachWithoutIn, "Sözdizimi hatası: ‘each’ anahtar sözcüğüne, ‘in’ operatörü olmadan izin verilmez." ),
           new AscError(kError_Parser_ExpectedLeftParen, "Sözdizimi hatası: kimlikten önce sol parantez bekleniyor." ),
           new AscError(kError_Parser_ExpectedCaseLabel, "CaseLabel bekleniyor." ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "Etiket, basit bir kimlik olmalıdır." ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "Bir üst ifadede bir işlenen olmalıdır." ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "Arttırma ve eksiltme operatörü bekleniyor." ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "Parantezler içinde tek bir ifade bekleniyor." ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "Sözdizimi hatası: %s öğesi beklenmiyor." ),
           new AscError(kError_Parser_ExpectedToken, "Sözdizimi hatası: %s öğesinden önce %s bekleniyor." ),
           new AscError(kError_Parser_ExpectedSemicolon, "Sözdizimi hatası: %s öğesinden önce noktalı virgül bekleniyor." ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "Sözdizimi hatası: program bitiminden sonra ilave karakterler bulundu." ),
           new AscError(kError_Lexical_General, "Sözdizimi hatası:" ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "Sözdizimi hatası: Bir dizgi değişmezi, satır kesmesinden önce sonlandırılmalıdır." ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "Sözdizimi hatası: Bir dizgi değişmezi, satır kesmesinden önce sonlandırılmalıdır." ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "Sözdizimi hatası: girdi, bir dizgi değişmezinin kapatılan tırnak işaretine ulaşmadan sonlandırıldı." ),
           new AscError(kError_Lexical_SyntaxError, "Sözdizimi hatası:" ),
           new AscError(kError_Lexical_NoMatchingTag, "Sözdizimi hatası: XML'de eşleşen başlama ve bitiş etiketi bulunmuyor." ),
           new AscError(kError_CannotDeleteSuperDecendants, "Üst alt öğeler silinemez." ),
           new AscError(kError_DuplicateNamespaceDefinition, "Çoğaltma ad alanı tanımı." ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "Atama hedefi, bir referans değeri olmalıdır." ),
           new AscError(kError_IncrementOperatorNotAReference, "Arttırma işleneni bir referans olmalıdır." ),
           new AscError(kError_InvalidIncrementOperand, "Arttırma işleneni geçersiz." ),
           new AscError(kError_InvalidDecrementOperand, "Eksiltme işleneni geçersiz." ),
           new AscError(kError_ExpectingExpression, "Bir ifade bekleniyor." ),
           new AscError(kError_MissingXMLTagName, "XML etiket adı eksik." ),
           new AscError(kError_InvalidAbcFile, "%s dosyası, geçerli bir ABC dosyası değildir." ),
           new AscError(kError_Parser_FileIncludesItself, "Bu dosya sonrasında olası sonsuz özyinelemeler: %s." ),
           new AscError(kError_CircularReference, "%s öğesinde dairesel türde referans algılandı." ),
           new AscError(kError_InvalidPublic, "Genel nitelik yalnızca paket içerisinde kullanılabilir." ),
           new AscError(kError_InvalidInternal, "Dahili nitelik yalnızca paket içerisinde kullanılabilir." ),
           new AscError(kError_InvalidNamespace, "Kullanıcı tanımlı bir ad alanı niteliği, yalnızca sınıf tanımının üst düzeyinde kullanılabilir." ),
           new AscError(kError_ImplicitCoercionToSubtype, "%s statik türünde bir değerin olası ilgisiz bir %s türüne örtük dayatması." ),
           new AscError(kError_UndefinedProperty, "%s olası tanımlanmamış özelliğinin %s statik türüne bir referans üzerinden erişimi." ),
           new AscError(kError_UnfoundProperty, "%s tanımlanmamış özelliğinin erişimi." ),
           new AscError(kError_GetterCannotHaveParameters, "Bir alıcı tanımında hiçbir parametre olmamalıdır." ),
           new AscError(kError_SetterMustHaveOneParameter, "Bir ayarlayıcı tanımında tam bir parametre olmalıdır." ),
           new AscError(kError_SetterCannotHaveOptional, "Bir ayarlayıcı tanımının isteğe bağlı parametreleri olamaz." ),
           new AscError(kError_BadGetterReturnType, "Bir alıcı tanımının dönüş türü boş olmamalıdır ." ),
           new AscError(kError_InterfaceMethodWithBody, "Bir arabirimde tanımlanan yöntemlerin bir gövdesi olmamalıdır." ),
           new AscError(kError_FunctionWithoutBody, "İşlevin bir gövdesi yoktur." ),
           new AscError(kError_DuplicateAttribute, "%s niteliği birden çok kez belirlendi." ),
           new AscError(kError_DuplicateInterfaceDefinition, "Çoğaltma arabirimi tanımı: %s." ),
           new AscError(kError_CtorWithReturnType, "Bir yapıcı bir döndürme türünü belirleyemez." ),
           new AscError(kError_InvalidClassNesting, "Sınıflar iç içe olmamalıdır." ),
           new AscError(kError_InvalidFinalUsage, "Son nitelik yalnızca sınıf içerisinde tanımlanan bir yöntem üzerinde kullanılabilir." ),
           new AscError(kError_InvalidNative, "Doğal nitelik yalnızca işlev tanımlarıyla birlikte kullanılabilir." ),
           new AscError(kError_InvalidDynamic, "Dinamik nitelik yalnızca sınıf tanımlarıyla birlikte kullanılabilir." ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "Sözdizimi hatası: Geçersiz bir tür olarak %s." ),
           new AscError(kError_WrongNumberOfArguments, "Yanlış değişken sayısı.  Beklenen %s." ),
           new AscError(kError_TooManyArguments, "Yanlış değişken sayısı.  %s öğeden fazla beklenmiyordu." ),
           new AscError(kError_BadRequiredParameter, "Gerekli parametrelere, isteğe bağlı parametrelerden sonra izin verilmez." ),
           new AscError(kError_VarInInterface, "Değişken bildirimlere arabirimlerde izin verilmez." ),
           new AscError(kError_InvalidRestDecl, "…rest parametresi tanımı anahtar sözcüğü sonrasında belirtilen parametreler yalnızca Dizi verileri türünde olabilir." ),
           new AscError(kError_CannotExtendInterface, "Bir sınıf yalnızca bir diğer sınıfı genişletebilir, bir arabirimi değil." ),
           new AscError(kError_CannotExtendClass, "Bir arabirim yalnızca diğer arabirimleri genişletebilir, ancak %s bir sınıftır." ),
           new AscError(kError_InvalidOverrideUsage, "Geçersiz kılma niteliği yalnızca sınıf içerisinde tanımlanan bir yöntem üzerinde kullanılabilir." ),
           new AscError(kError_IncompatibleInterfaceMethod, "%s ad alanındaki %s arabirim yöntemi %s sınıfında uyumsuz bir imzayla uygulandı." ),
           new AscError(kError_NativeMethodWithBody, "Doğal yöntemlerin bir gövdesi olamaz." ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "Bir yapıcı, bir alıcı veya ayarlayıcı yöntem olamaz." ),
           new AscError(kError_MissingFilespec, "AS kaynak dosyası belirlenmedi." ),
           new AscError(kError_CannotReturnFromStaticInit, "Dönüş ifadesi statik başlatma kodunda kullanılamaz." ),
           new AscError(kError_InvalidProtected, "Korumalı nitelik yalnızca sınıf özellik tanımlarında kullanılabilir." ),
           new AscError(kError_ConflictingNameInNamespace, "Ad alanında %s tanımıyla bir çakışma bulunmaktadır." ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "Ad alanında %s miras alınmış tanımıyla bir çakışma bulunmaktadır." ),
           new AscError(kError_ConstructorMustBePublic, "Bir yapıcı yalnızca bildirilmiş genel olabilir." ),
           new AscError(kError_ConflictingAccessSpecifiers, "Bir tanımda, genel, özel, korumalı veya dahiliden yalnızca biri belirlenebilir." ),
           new AscError(kError_InvalidNestedAccessor, "Erişimciler, diğer işlevlerde iç içe olamazlar." ),
           new AscError(kError_CannotInstantiateInterface, "Arabirimler yeni operatör ile başlatılamaz." ),
           new AscError(kError_BadAccessInterfaceMember, "Arabirim üyeleri, bildirilmiş genel, özel, korumalı veya dahili olamazlar." ),
           new AscError(kError_Parser_ExpectedLeftBrace, "Sözdizimi hatası: işlev gövdesinden önce sol parantez ({) eksik." ),
           new AscError(kError_CannotReturnFromPackageInit, "Döndürme ifadesi paket başlatma kodunda kullanılamaz." ),
           new AscError(kError_InvalidInterfaceNative, "Doğal nitelik arabirim tanımlarında kullanılamaz." ),
           new AscError(kError_MultipleNamespaceAttributes, "Her tanım için yalnızca bir ad alanı niteliği kullanılabilir." ),
           new AscError(kError_ConflictingInheritedNameInInterface, "%s yöntemi %s arabiriminden miras alınan tanımla çakışmaktadır." ),
           new AscError(kError_InvalidInterfaceAttribute, "%s arabirim niteliği geçersizdir." ),
           new AscError(kError_NamespaceInInterface, "Ad alanı bildirimlerine arabirimlerde izin verilmez." ),
           new AscError(kError_DuplicateImplements, "%s sınıfı %s arabirimini birden çok kez uygular." ),
           new AscError(kError_AssignmentToDefinedFunction, "%s işlevine kuraldışı atama." ),
           new AscError(kError_InterfaceNamespaceAttribute, "Ad alanı niteliklerine, arabirim yöntemlerinde izin verilmez." ),
           new AscError(kError_MustReturnValue, "İşlev bir değer geri getirmez." ),
           new AscError(kError_InvalidNamespaceInitializer, "Bir ad alanı başlatıcısı, ya bir dizgi değişmezi veya bir diğer ad alanı olmalıdır." ),
           new AscError(kError_DefinitionNotFound, "%s tanımı bulunamadı." ),
           new AscError(kError_InvalidLabel, "Etiket tanımı geçersizdir." ),
           new AscError(kError_IncompatableValueComparison, "%s statik türünde bir değer ve olası ilgisiz %s türünde bir değer arasında karşılaştırma." ),
           new AscError(kError_CannotReturnFromGlobalInit, "Dönüş ifadesi global başlatma kodunda kullanılamaz." ),
           new AscError(kError_InaccessiblePropertyReference, "%s erişilemez özelliğinin, %s statik türünde bir referans üzerinden erişim girişimi." ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Nesne geçici olarak servis dışıdır. Yerine, :* kullanın." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "Olası tanımlanmamış bir %s yöntemi çağrısı." ),
           new AscError(kError_ForwardReferenceToBaseClass, "%s taban sınıfına ileri referans." ),
           new AscError(kError_IllegalPackageReference, "Paket bir değer olarak kullanılamaz. %s." ),
           new AscError(kError_IncompatibleDefaultValue, "%s beklenirken, %s türünün varsayılan değeri uyumsuzdur." ),
           new AscError(kError_MultipleSwitchDefaults, "Değiştirmenin birden fazla varsayılanı vardır, ancak bir varsayılana izin verilir." ),
           new AscError(kError_AssignmentToDefinedClass, "%s sınıfına kuraldışı atama." ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "%s sabit özelliğini silme girişimi. Yalnızca dinamik olarak tanımlanan özellikler silinebilir." ),
           new AscError(kError_InvalidBaseTypeExpression, "Taban sınıfı bulunamadı veya derleme zamanı sabiti değil." ),
           new AscError(kError_InvalidInterfaceTypeExpression, "Arabirim bulunamadı veya derleme zamanı sabiti değil." ),
           new AscError(kError_StaticModifiedNamespace, "Ad alanı tanımlarında statik niteliğe izin verilmez." ),
           new AscError(kError_InvalidInterfaceNesting, "Arabirim tanımları, sınıf veya diğer arabirim tanımlarında iç içe olmamalıdır." ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "Prototip niteliği geçersizdir." ),
           new AscError(kError_InaccessibleMethodReference, "Erişilemez %s yönteminin, %s statik türünde bir referans üzerinden erişim girişimi." ),
           new AscError(kError_Parser_ThrowWithoutExpression, "Sözdizimi hatası: ortaya attıktan sonra bir ifade bekleniyor." ),
           new AscError(kError_Authoring_SymbolClassInheritance, "Her ikisi de kütüphane sembolleriyle veya ana zaman çizelgesiyle ilişkili olduğundan, %s sınıfı, %s öğesini genişletemez." ),
           new AscError(kError_AttributesOnPackage, "Paket tanımında niteliklere izin verilmez." ),
           new AscError(kError_InternalError, "Dahili hata: %s." ),
           new AscError(kError_ParserInvalidForInInitializer, "Sözdizimi hatası: Geçersiz for-in başlatıcısı, yalnızca 1 ifade bekleniyordu." ),
           new AscError(kError_IllegalSuperStatement, "this, super,  return veya throw ifadesinden sonra bir üst ifade gerçekleşemez." ),
           new AscError(kError_UnfoundPackageProperty, "%s paketinde %s tanımlanmamış özelliğinin erişimi." ),
           new AscError(kError_NoDefaultBaseclassCtor, "%s taban sınıfında hiçbir varsayılan yapıcı bulunamadı." ),
           new AscError(kError_BlockCommentNotTerminated, "/* ile eşleşmeyen */ bulundu." ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "Syntax Error: expecting a left brace({)or string literal(\"\")." ),
           new AscError(kError_InvalidES4SuperStatement, "A super statement can be used only as the last item in a constructor initializer list." ),
           new AscError(kError_ThisUsedInInitializer, "The this keyword can not be used in property initializers." ),
           new AscError(kError_NonConstantConfigInit, "The initializer for a configuration value must be a compile time constant." ),
           new AscError(kError_NonConstConfigVar, "A configuration variable may only be declared const." ),
           new AscError(kError_InvalidConfigLocation, "A configuration value must be declared at the top level of a program or package." ),
           new AscError(kError_ShadowedConfigNamespace, "Namespace %s conflicts with a configuration namespace." ),
           new AscError(kError_InvalidPrecision, "Precision must be an integer between 1 and 34." ),
           new AscError(kError_WrongVersion, "Incompatible Version: can not reference definition %s introduced in version %s from code with version %s." ),
           new AscError(kError_LossyConversion, "Invalid initialization: conversion to type %s loses data." ),
   };

   public static final AscError[] errorConstantsTW = { 
           new AscError(kError_AmbiguousReference, "%s 的參考模稜兩可。" ),
           new AscError(kError_NamespaceAccessSpecifiers, "存取規範不允許使用 namespace 屬性。" ),
           new AscError(kError_Unknown_Namespace, "找不到 namespace，或它不是編譯時期常數。" ),
           new AscError(kError_InvalidSuperExpression, "super 運算式只能在類別實體方法內使用。" ),
           new AscError(kError_InvalidSuperStatement, "super 陳述式只能在類別實體建構函式內使用。" ),
           new AscError(kError_InvalidAttribute, "屬性無效。" ),
           new AscError(kError_InvalidOverride, "override 屬性只能用於類別屬性定義。" ),
           new AscError(kError_InvalidVirtual, "virtual 屬性只能用於類別屬性定義。" ),
           new AscError(kError_InvalidStatic, "static 屬性只能用於類別中的定義。" ),
           new AscError(kError_InvalidPrivate, "private 屬性只能用於類別屬性定義。" ),
           new AscError(kError_Unsupported_Intrinsic, "不再支援 intrinsic 屬性。" ),
           new AscError(kError_BaseClassIsFinal, "基底類別為 final。" ),
           new AscError(kError_UnknownBaseClass, "找不到基底類別 %s 的定義。" ),
           new AscError(kError_DuplicateClassDefinition, "類別定義重複：%s。" ),
           new AscError(kError_OverrideNotFound, "標示為 override 的方法必須覆寫另一個方法。" ),
           new AscError(kError_DuplicateFunction, "函數定義重複。" ),
           new AscError(kError_OverrideFinalAccessor, "無法覆寫 final 存取子。" ),
           new AscError(kError_IncompatibleOverride, "覆寫不相容。" ),
           new AscError(kError_OverrideOfFuncNotMarkedForOverride, "正在覆寫未標示為 override 的函數。" ),
           new AscError(kError_FinalMethodRedefinition, "無法重新定義 final 方法。" ),
           new AscError(kError_ConstructorsMustBeInstanceMethods, "建構函式的函數必須是實體方法。" ),
           new AscError(kError_FuncIsStaticAndOverride, "函數無法同時為 static 及 override。" ),
           new AscError(kError_FuncIsStaticAndVirtual, "函數無法同時為 static 及 virtual。" ),
           new AscError(kError_FuncIsVirtualAndFinal, "函數無法同時為 final 及 virtual。" ),
           new AscError(kError_RestParameterNotNamed, "必須指定變數引數陣列的名稱。" ),
           new AscError(kError_VirtualVars, "不支援 virtual 變數。" ),
           new AscError(kError_NativeVars, "不能使用 native 變數。" ),
           new AscError(kError_VarIsFinalAndVirtual, "變數無法同時為 final 及 virtual。" ),
           new AscError(kError_NestedPackage, "Package 不能巢狀化。" ),
           new AscError(kError_BreakHasNoTarget, "找不到 break 陳述式的目標。" ),
           new AscError(kError_ContinueHasNoTarget, "找不到 continue 陳述式的目標。" ),
           new AscError(kError_DuplicateLabel, "標籤定義重複。" ),
           new AscError(kError_AttributesAreNotCallable, "無法呼叫屬性。" ),
           new AscError(kError_ThisUsedInStaticFunction, "this 關鍵字不能用於靜態方法中。它只能用於實體方法、函數結束項和全域程式碼中。" ),
           new AscError(kError_UndefinedNamespace, "未定義的 namespace。" ),
           new AscError(kError_UnknownInterfaceMethod, "Interface 方法 %s 於 namespace %s 內尚未被類別 %s 實作。" ),
           new AscError(kError_UnknownInterface, "找不到 Interface %s。" ),
           new AscError(kError_UnknownType, "找不到 Type，或它不是編譯時期常數：%s。" ),
           new AscError(kError_NonConstantParamInitializer, "參數初始設定式不明，或它不是編譯時期常數。" ),
           new AscError(kError_MethodIsNotAConstructor, "方法不能當作建構函式使用。" ),
           new AscError(kError_AssignmentToConstVar, "對指定為常數的變數的指定不合法。" ),
           new AscError(kError_AssignmentToNonRefVar, "無法指定給非參考值。" ),
           new AscError(kError_ReturnTypeMustBeUndefined, "傳回值必須是未定義的。" ),
           new AscError(kError_ConstInitializerNotConst, "常數初始設定式不明，或它不是編譯時期常數。" ),
           new AscError(kError_AccessorTypesMustMatch, "存取子類型必須相符。" ),
           new AscError(kError_BadSetterReturnType, "setter 定義的傳回類型必須是未指定的或虛值 (Void)。" ),
           new AscError(kError_PropertyIsWriteOnly, "屬性是唯寫的。" ),
           new AscError(kError_PropertyIsReadOnly, "屬性是唯讀的。" ),
           new AscError(kError_Strict_UndefinedMethod, "呼叫可能未定義的方法 %s (透過靜態類型 %s 的參考)。" ),
           new AscError(kError_UnableToOpenFile, "無法開啟檔案：%s。" ),
           new AscError(kError_InvalidMetaData, "中繼資料無效。" ),
           new AscError(kError_MetaDataAttributesHasMoreThanOneElement, "中繼資料屬性不能包含超過一個元素。" ),
           new AscError(kError_ImplicitCoercisionOfUnrelatedType, "%s 類型值以隱含方式強制轉型成不相關的類型 %s。" ),
           new AscError(kError_Parser_UnableToOpenFile, "無法開啟包含的檔案：%s。" ),
           new AscError(kError_Parser_DefinitionOrDirectiveExpected, "語法錯誤：需要定義或指示詞。" ),
           new AscError(kError_Parser_ExpectingAnnotatableDirectiveAfterAttributes, "語法錯誤：屬性 %s 之後必須是定義關鍵字 (例如函數)，而不是 %s。" ),
           new AscError(kError_Parser_ExpectedXMLBeforeNameSpace, "語法錯誤：namespace 之前必須是 xml。" ),
           new AscError(kError_Parser_ExpectingCatchOrFinally, "語法錯誤：需要 catch 或 finally 子句。" ),
           new AscError(kError_Parser_EachWithoutIn, "語法錯誤：不允許使用沒有 'in' 運算子的 'each' 關鍵字。" ),
           new AscError(kError_Parser_ExpectedLeftParen, "語法錯誤：識別名稱之前必須有左括號。" ),
           new AscError(kError_Parser_ExpectedCaseLabel, "需要 CaseLabel。" ),
           new AscError(kError_Parser_LabelIsNotIdentifier, "標籤必須是簡單的識別名稱。" ),
           new AscError(kError_Parser_WrongNumberOfSuperArgs, "super 運算式必須包含一個運算元。" ),
           new AscError(kError_Parser_ExpectingIncrOrDecrOperator, "需要遞增或遞減的運算子。" ),
           new AscError(kError_Parser_ExpectingASingleExpressionWithinParenthesis, "括號內必須是單一運算式。" ),
           new AscError(kError_Parser_ExpectedPrimaryExprBefore, "語法錯誤：未預期的 %s。" ),
           new AscError(kError_Parser_ExpectedToken, "語法錯誤：%s 必須在 %s 之前。" ),
           new AscError(kError_Parser_ExpectedSemicolon, "語法錯誤：%s 之前必須有分號。" ),
           new AscError(kError_Parser_ExtraCharsAfterEndOfProgram, "語法錯誤：程式結尾後出現額外字元。" ),
           new AscError(kError_Lexical_General, "語法錯誤。" ),
           new AscError(kError_Lexical_LineTerminatorInSingleQuotedStringLiteral, "語法錯誤：字串常值必須在斷行符號之前結束。" ),
           new AscError(kError_Lexical_LineTerminatorInDoubleQuotedStringLiteral, "語法錯誤：字串常值必須在斷行符號之前結束。" ),
           new AscError(kError_Lexical_EndOfStreamInStringLiteral, "語法錯誤：在到達字串常值的結束引號之前，輸入便已結束。" ),
           new AscError(kError_Lexical_SyntaxError, "語法錯誤。" ),
           new AscError(kError_Lexical_NoMatchingTag, "語法錯誤：XML 沒有相符的開始和結束標記。" ),
           new AscError(kError_CannotDeleteSuperDecendants, "無法刪除 super 子系。" ),
           new AscError(kError_DuplicateNamespaceDefinition, "namespace 定義重複。" ),
           new AscError(kError_ErrorNodeError, "%s" ),
           new AscError(kError_AssignmentTargetNotRefVal, "指定的目標必須是參考值。" ),
           new AscError(kError_IncrementOperatorNotAReference, "遞增的運算元必須是參考。" ),
           new AscError(kError_InvalidIncrementOperand, "遞增運算元無效。" ),
           new AscError(kError_InvalidDecrementOperand, "遞減運算元無效。" ),
           new AscError(kError_ExpectingExpression, "需要運算式。" ),
           new AscError(kError_MissingXMLTagName, "遺失 XML 標記名稱。" ),
           new AscError(kError_InvalidAbcFile, "檔案 %s 不是有效的 ABC 檔案。" ),
           new AscError(kError_Parser_FileIncludesItself, "可能導致無限遞迴，因為此檔案包括：%s。" ),
           new AscError(kError_CircularReference, "在 %s 中偵測到循環類型參考。" ),
           new AscError(kError_InvalidPublic, "public 屬性只能用於套件內部。" ),
           new AscError(kError_InvalidInternal, "internal 屬性只能用於套件內部。" ),
           new AscError(kError_InvalidNamespace, "使用者定義的 namespace 屬性只能用於類別定義的最上層。" ),
           new AscError(kError_ImplicitCoercionToSubtype, "靜態類型 %s 的值以隱含方式強制轉型成可能不相關的類型 %s。" ),
           new AscError(kError_UndefinedProperty, "存取可能未定義的屬性 %s (透過靜態類型 %s 的參考)。" ),
           new AscError(kError_UnfoundProperty, "存取未定義的屬性 %s。" ),
           new AscError(kError_GetterCannotHaveParameters, "getter 定義必須沒有參數。" ),
           new AscError(kError_SetterMustHaveOneParameter, "setter 定義只能有一個參數。" ),
           new AscError(kError_SetterCannotHaveOptional, "setter 定義不能包含選擇性參數。" ),
           new AscError(kError_BadGetterReturnType, "getter 定義的傳回類型不能是虛值 (Void)。" ),
           new AscError(kError_InterfaceMethodWithBody, "定義在 Interface 中的方法不能包含主體。" ),
           new AscError(kError_FunctionWithoutBody, "函數不包含主體。" ),
           new AscError(kError_DuplicateAttribute, "%s 屬性已經多次指定。" ),
           new AscError(kError_DuplicateInterfaceDefinition, "Interface 定義重複：%s。" ),
           new AscError(kError_CtorWithReturnType, "建構函式不能指定傳回類型。" ),
           new AscError(kError_InvalidClassNesting, "類別不能巢狀化。" ),
           new AscError(kError_InvalidFinalUsage, "final 屬性只能用於定義在類別中的方法。" ),
           new AscError(kError_InvalidNative, "native 屬性只能配合函數定義使用。" ),
           new AscError(kError_InvalidDynamic, "動態屬性只能配合類別定義使用。" ),
           new AscError(kError_Parser_keywordInsteadOfTypeExpr, "語法錯誤: %s 是無效類型。" ),
           new AscError(kError_WrongNumberOfArguments, "引數個數錯誤。需要 %s 個。" ),
           new AscError(kError_TooManyArguments, "引數個數錯誤。不能超過 %s 個。" ),
           new AscError(kError_BadRequiredParameter, "不允許必要的參數出現在選擇性參數之後。" ),
           new AscError(kError_VarInInterface, "不允許在 Interface 中出現變數宣告。" ),
           new AscError(kError_InvalidRestDecl, "指定於 ...rest 參數定義關鍵字後面的參數只能是 Array 資料類型。" ),
           new AscError(kError_CannotExtendInterface, "類別只能擴充另一個類別，不能擴充 Interface。" ),
           new AscError(kError_CannotExtendClass, "Interface 只能擴充其它的 Interface，但是 %s 為類別。" ),
           new AscError(kError_InvalidOverrideUsage, "override 屬性只能用於定義在類別中的方法。" ),
           new AscError(kError_IncompatibleInterfaceMethod, "Interface 方法 %s 於 namespace %s 內用類別 %s 中不相容的簽名實作。" ),
           new AscError(kError_NativeMethodWithBody, "native 方法不能包含主體。" ),
           new AscError(kError_ConstructorCannnotBeGetterSetter, "建構函式不能是 getter 或 setter 方法。" ),
           new AscError(kError_MissingFilespec, "未指定 AS 原始檔案。" ),
           new AscError(kError_CannotReturnFromStaticInit, "return 陳述式不能用於靜態初始化程式碼中。" ),
           new AscError(kError_InvalidProtected, "protected 屬性只能用於類別屬性定義。" ),
           new AscError(kError_ConflictingNameInNamespace, "定義 %s 於 namespace %s 中發生衝突。" ),
           new AscError(kError_ConflictingInheritedNameInNamespace, "已繼承定義 %s 於 namespace %s 中發生衝突。" ),
           new AscError(kError_ConstructorMustBePublic, "建構函式只能宣告為 public。" ),
           new AscError(kError_ConflictingAccessSpecifiers, "定義只能指定 public、private、protected 或 internal 其中之一。" ),
           new AscError(kError_InvalidNestedAccessor, "存取子不能在其它函數中巢狀化。" ),
           new AscError(kError_CannotInstantiateInterface, "Interface 不能使用新的運算子初始化。" ),
           new AscError(kError_BadAccessInterfaceMember, "Interface 成員不能宣告為 public、private、protected 或 internal。" ),
           new AscError(kError_Parser_ExpectedLeftBrace, "語法錯誤：函數主體前面遺失左邊大括弧 ({)。" ),
           new AscError(kError_CannotReturnFromPackageInit, "return 陳述式不能用於套件初始化程式碼中。" ),
           new AscError(kError_InvalidInterfaceNative, "native 屬性不能用於 Interface 定義。" ),
           new AscError(kError_MultipleNamespaceAttributes, "每一個定義只能使用一個 namespace 屬性。" ),
           new AscError(kError_ConflictingInheritedNameInInterface, "方法 %s 與從 Interface %s 繼承的定義發生衝突。" ),
           new AscError(kError_InvalidInterfaceAttribute, "Interface 屬性 %s 無效。" ),
           new AscError(kError_NamespaceInInterface, "不允許在 Interface 中出現 namespace 宣告。" ),
           new AscError(kError_DuplicateImplements, "類別 %s 會多次實作 Interface %s。" ),
           new AscError(kError_AssignmentToDefinedFunction, "函數 %s 的指定不合法。" ),
           new AscError(kError_InterfaceNamespaceAttribute, "不允許在 Interface 方法上出現 namespace 屬性。" ),
           new AscError(kError_MustReturnValue, "函數沒有傳回值。" ),
           new AscError(kError_InvalidNamespaceInitializer, "namespace 初始設定式必須是常值字串或其它 namespace。" ),
           new AscError(kError_DefinitionNotFound, "找不到定義 %s。" ),
           new AscError(kError_InvalidLabel, "標籤定義無效。" ),
           new AscError(kError_IncompatableValueComparison, "比較靜態類型 %s 的值和可能不相關的類型 %s。" ),
           new AscError(kError_CannotReturnFromGlobalInit, "return 陳述式不能用於全域初始化程式碼中。" ),
           new AscError(kError_InaccessiblePropertyReference, "嘗試存取無法存取的屬性 %s (透過靜態類型 %s 的參考)。" ),
           new AscError(kError_ColonObjectAnnoOutOfService, ":Object is temporarily out of service.Use :* instead." ),
           new AscError(kError_Strict_PlainUndefinedMethod, "呼叫可能未定義的方法 %s。" ),
           new AscError(kError_ForwardReferenceToBaseClass, "基底類別 %s 的向前參考。" ),
           new AscError(kError_IllegalPackageReference, "Package 不能當作值使用：%s。" ),
           new AscError(kError_IncompatibleDefaultValue, "不相容的 %s 類型預設值，該值必須是 %s。" ),
           new AscError(kError_MultipleSwitchDefaults, "此 switch 包含一個以上的預設值，但是只允許使用一個預設值。" ),
           new AscError(kError_AssignmentToDefinedClass, "類別 %s 的指定不合法。" ),
           new AscError(kError_Strict_AttemptToDeleteFixedProperty, "嘗試刪除固定屬性 %s。只能刪除以動態方式定義的屬性。" ),
           new AscError(kError_InvalidBaseTypeExpression, "找不到基底類別，或它不是編譯時期常數。" ),
           new AscError(kError_InvalidInterfaceTypeExpression, "找不到 Interface，或它不是編譯時期常數。" ),
           new AscError(kError_StaticModifiedNamespace, "不允許 namespace 定義中出現 static 屬性。" ),
           new AscError(kError_InvalidInterfaceNesting, "Interface 定義不能在類別或是其它 Interface 定義中巢狀化。" ),
           new AscError(kError_PrototypeIsAnInvalidAttribute, "prototype 屬性無效。" ),
           new AscError(kError_InaccessibleMethodReference, "嘗試存取無法存取的方法 %s (透過靜態類型 %s 的參考)。" ),
           new AscError(kError_Parser_ThrowWithoutExpression, "語法錯誤：throw 之後必須是運算式。" ),
           new AscError(kError_Authoring_SymbolClassInheritance, "類別 %s 不能擴充 %s，因為這兩種都與圖庫元件或主要時間軸有關聯。" ),
           new AscError(kError_AttributesOnPackage, "不允許套件定義出現屬性。" ),
           new AscError(kError_InternalError, "內部錯誤：%s。" ),
           new AscError(kError_ParserInvalidForInInitializer, "語法錯誤：for-in 初始設定式無效，只能出現 1 個運算式。" ),
           new AscError(kError_IllegalSuperStatement, "super 陳述式不能出現在 this、super、return 或 throw 陳述式之後。" ),
           new AscError(kError_UnfoundPackageProperty, "存取未定義的屬性 %s (在套件 %s 中)。" ),
           new AscError(kError_NoDefaultBaseclassCtor, "基底類別 %s 中找不到預設的建構函式。" ),
           new AscError(kError_BlockCommentNotTerminated, "找到 /*，但沒有對應的 */。" ),
           new AscError(kError_ParserExpectingLeftBraceOrStringLiteral, "語法錯誤: 應該使用左大括弧 ({) 或字串常值 (\"\")。" ),
           new AscError(kError_InvalidES4SuperStatement, "super 陳述式只能只能當作初始設定式建構函式中的最後項目使用。" ),
           new AscError(kError_ThisUsedInInitializer, "this 關鍵字不能用於屬性初始設定式中。" ),
           new AscError(kError_NonConstantConfigInit, "組態值的初始設定式必須是編譯階段常數。" ),
           new AscError(kError_NonConstConfigVar, "組態變數只能宣告為 const。" ),
           new AscError(kError_InvalidConfigLocation, "必須在程式或套件的最上層宣告組態值。" ),
           new AscError(kError_ShadowedConfigNamespace, "名稱空間 %s 與組態空間名稱發生衝突。" ),
           new AscError(kError_InvalidPrecision, "精確度必須是介於 1 和 34 之間的整數。" ),
           new AscError(kError_WrongVersion, "不相容的版本: 無法參照定義 %s (在版本 %s 中從版本 %s 的程式碼引進)。" ),
           new AscError(kError_LossyConversion, "初始化無效: 轉換為類型 %s 將遺失資料。" ),
   };

        public static final AscError[][] allErrorConstants =
        {
             errorConstantsEN,
             errorConstantsCN,
             errorConstantsCS,
             errorConstantsDA,
             errorConstantsDE,
             errorConstantsES,
             errorConstantsFI,
             errorConstantsFR,
             errorConstantsIT,
             errorConstantsJP,
             errorConstantsKR,
             errorConstantsNB,
             errorConstantsNL,
             errorConstantsPL,
             errorConstantsPT,
             errorConstantsRU,
             errorConstantsSV,
             errorConstantsTR,
             errorConstantsTW,
        };
   
   
   
};
