/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.i18n;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.webconsole.internal.i18n.CombinedResourceBundle;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleCache;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ResourceBundleManager
implements BundleListener {
    private final BundleContext bundleContext;
    private final ResourceBundleCache consoleResourceBundleCache;
    private final Map<Long, ResourceBundleCache> resourceBundleCaches = new ConcurrentHashMap<Long, ResourceBundleCache>();

    public ResourceBundleManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.consoleResourceBundleCache = new ResourceBundleCache(bundleContext.getBundle());
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void dispose() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public ResourceBundle getResourceBundle(Bundle provider, Locale locale) {
        ResourceBundle defaultResourceBundle = this.consoleResourceBundleCache.getResourceBundle(locale);
        if (provider == null || provider.equals(this.bundleContext.getBundle())) {
            return defaultResourceBundle;
        }
        ResourceBundleCache cache = this.resourceBundleCaches.computeIfAbsent(provider.getBundleId(), key -> new ResourceBundleCache(provider));
        ResourceBundle bundleResourceBundle = cache.getResourceBundle(locale);
        return new CombinedResourceBundle(bundleResourceBundle, defaultResourceBundle, locale);
    }

    public final void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.resourceBundleCaches.remove(event.getBundle().getBundleId());
        }
    }
}

