/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.felix.ipojo.extender.internal;

import org.osgi.framework.Bundle;

/**
 * Main Processor interface.
 * A bundle processor is an extender fragment, it analyzes the bundle content and creates the entities.
 * <p/>
 * Notice the difference between the <code>activate / deactivate </code> methods called when a bundle is starting
 * and stopping, and <code>start / stop</code> called when the iPOJO bundle is started and stopped.
 */
public interface BundleProcessor extends Lifecycle {
    /**
     * A bundle is started.
     *
     * @param bundle the bundle
     */
    void activate(Bundle bundle);

    /**
     * A bundle is stopping. This call is made during the stopping phase.
     *
     * @param bundle the bundle
     */
    void deactivate(Bundle bundle);
}
