/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.spi.helper;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.spi.Predicate;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class Predicates {
    public static Node node() {
        return new Node();
    }

    public static Reference reference(String refId) {
        return new Reference(refId);
    }

    public static Matcher pattern(String regex) {
        return new Matcher(regex);
    }

    public static Predicate on(final ElementType type) {
        return new Predicate(){

            @Override
            public boolean matches(BindingContext context) {
                return context.getElementType().equals((Object)type);
            }
        };
    }

    public static Predicate alwaysTrue() {
        return new Predicate(){

            @Override
            public boolean matches(BindingContext context) {
                return true;
            }
        };
    }

    public static Predicate and(final Predicate ... predicates) {
        if (predicates.length == 1) {
            return predicates[0];
        }
        return new Predicate(){

            @Override
            public boolean matches(BindingContext context) {
                for (Predicate predicate : predicates) {
                    if (predicate.matches(context)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Predicate or(final Collection<Predicate> predicates) {
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        return new Predicate(){

            @Override
            public boolean matches(BindingContext context) {
                for (Predicate predicate : predicates) {
                    if (!predicate.matches(context)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate or(Predicate ... predicates) {
        return Predicates.or(Arrays.asList(predicates));
    }

    public static Predicate onlySupportedElements(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (target == null) {
            return Predicates.alwaysTrue();
        }
        HashSet<Predicate> supportedTypes = new HashSet<Predicate>();
        for (ElementType type : target.value()) {
            supportedTypes.add(Predicates.on(type));
        }
        return Predicates.or(supportedTypes);
    }

    public static class Node {
        public Predicate named(final String expected) {
            return new Predicate(){

                @Override
                public boolean matches(BindingContext context) {
                    if (context.getFieldNode() != null) {
                        FieldNode field = context.getFieldNode();
                        return field.name.equals(expected);
                    }
                    if (context.getMethodNode() != null) {
                        MethodNode method = context.getMethodNode();
                        return method.name.equals(expected);
                    }
                    if (context.getClassNode() != null) {
                        ClassNode clazz = context.getClassNode();
                        return clazz.name.equals(expected);
                    }
                    return false;
                }
            };
        }
    }

    public static class Matcher {
        private Pattern pattern;

        public Matcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Predicate matches() {
            return new Predicate(){

                @Override
                public boolean matches(BindingContext context) {
                    return pattern.matcher(context.getAnnotationType().getClassName()).matches();
                }
            };
        }
    }

    public static class Reference {
        private String refId;

        public Reference(String refId) {
            this.refId = refId;
        }

        public Predicate exists() {
            return new Predicate(){

                @Override
                public boolean matches(BindingContext context) {
                    return context.getWorkbench().getIds().containsKey(refId);
                }
            };
        }
    }
}

