/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class InnerClassChecker
extends ClassVisitor
implements Opcodes {
    private final String m_name;
    private final Manipulator m_manipulator;

    public InnerClassChecker(String name, Manipulator manipulator) {
        super(589824);
        this.m_name = name;
        this.m_manipulator = manipulator;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 8) == 8) {
            return null;
        }
        if ((access & 0x100) == 256) {
            return null;
        }
        if (!ClassChecker.isGeneratedMethod(name, desc) && !name.endsWith("<init>")) {
            MethodDescriptor md = new MethodDescriptor(name, desc, (access & 8) == 8);
            this.m_manipulator.addMethodToInnerClass(this.m_name, md);
        }
        return null;
    }
}

