/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor;

import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;

public class ComponentVisitor
extends AnnotationVisitor {
    private Reporter reporter;
    private Element m_props = new Element("properties", "");
    private Element component = new Element("component", "");
    private ComponentWorkbench workbench;

    public ComponentVisitor(ComponentWorkbench workbench, Reporter reporter) {
        super(589824);
        this.workbench = workbench;
        this.reporter = reporter;
    }

    @Override
    public void visit(String name, Object value) {
        if (name.equals("public_factory") || name.equals("publicFactory")) {
            String factory = value.toString();
            if (factory.equalsIgnoreCase("false")) {
                this.component.addAttribute(new Attribute("public", "false"));
            } else {
                this.component.addAttribute(new Attribute("public", "true"));
            }
            return;
        }
        if (name.equals("name")) {
            this.component.addAttribute(new Attribute("name", value.toString()));
            return;
        }
        if (name.equals("immediate")) {
            this.component.addAttribute(new Attribute("immediate", value.toString()));
            return;
        }
        if (name.equals("architecture")) {
            this.component.addAttribute(new Attribute("architecture", value.toString()));
            return;
        }
        if (name.equals("propagation") && value != null) {
            if (this.arePropertiesEmpty()) {
                this.initComponentProperties();
            }
            this.m_props.addAttribute(new Attribute("propagation", value.toString()));
            return;
        }
        if (name.equals("managedservice") && value != null) {
            if (this.arePropertiesEmpty()) {
                this.initComponentProperties();
            }
            this.m_props.addAttribute(new Attribute("pid", value.toString()));
            return;
        }
        if ((name.equals("factory_method") || name.equals("factoryMethod")) && value != null) {
            this.component.addAttribute(new Attribute("factory-method", value.toString()));
            return;
        }
        if (name.equals("version") && value != null) {
            this.component.addAttribute(new Attribute("version", value.toString()));
        }
    }

    private boolean arePropertiesEmpty() {
        return this.m_props.getElements().length == 0;
    }

    private void initComponentProperties() {
        this.workbench.getElements().put(this.m_props, null);
        this.workbench.getIds().put("properties", this.m_props);
    }

    @Override
    public void visitEnd() {
        String classname = this.workbench.getType().getClassName();
        if (this.component.getAttribute("name") == null) {
            this.component.addAttribute(new Attribute("name", classname));
        }
        this.component.addAttribute(new Attribute("classname", classname));
        if (this.workbench.getRoot() == null) {
            this.workbench.setRoot(this.component);
        } else {
            this.reporter.error("Multiple 'component type' annotations on the class '{%s}'.", classname);
            this.reporter.warn("@Component will be ignored.", new Object[0]);
        }
    }
}

