/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.obr;

import aQute.bnd.build.ResolverMode;
import aQute.bnd.service.OBRIndexProvider;
import aQute.bnd.service.OBRResolutionMode;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RemoteRepositoryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.ResourceHandle;
import aQute.bnd.service.url.URLConnector;
import aQute.lib.deployer.obr.CachingURLResourceHandle;
import aQute.lib.deployer.obr.Capability;
import aQute.lib.deployer.obr.CapabilityType;
import aQute.lib.deployer.obr.DefaultURLConnector;
import aQute.lib.deployer.obr.IRepositoryListener;
import aQute.lib.deployer.obr.OBRSAXHandler;
import aQute.lib.deployer.obr.Property;
import aQute.lib.deployer.obr.Referral;
import aQute.lib.deployer.obr.Require;
import aQute.lib.deployer.obr.Resource;
import aQute.lib.deployer.obr.StopParseException;
import aQute.lib.filter.Filter;
import aQute.lib.osgi.Jar;
import aQute.libg.generics.Create;
import aQute.libg.reporter.Reporter;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseOBR
implements RegistryPlugin,
Plugin,
RemoteRepositoryPlugin,
OBRIndexProvider {
    public static final String PROP_NAME = "name";
    public static final String PROP_RESOLUTION_MODE = "mode";
    public static final String PROP_RESOLUTION_MODE_ANY = "any";
    public static final String REPOSITORY_FILE_NAME = "repository.xml";
    protected Registry registry;
    protected Reporter reporter;
    protected String name = this.getClass().getName();
    protected Set<OBRResolutionMode> supportedModes = EnumSet.allOf(OBRResolutionMode.class);
    private boolean initialised = false;
    private final Map<String, SortedMap<Version, Resource>> pkgResourceMap = new HashMap<String, SortedMap<Version, Resource>>();
    private final Map<String, SortedMap<Version, Resource>> bsnMap = new HashMap<String, SortedMap<Version, Resource>>();

    protected void addResourceToIndex(Resource resource) {
        this.addBundleSymbolicNameToIndex(resource);
        this.addPackagesToIndex(resource);
    }

    protected synchronized void reset() {
        this.initialised = false;
    }

    protected void initialiseIndexes() throws Exception {
    }

    protected final synchronized void init() throws Exception {
        if (!this.initialised) {
            this.bsnMap.clear();
            this.pkgResourceMap.clear();
            this.initialiseIndexes();
            final URLConnector connector = this.getConnector();
            IRepositoryListener listener = new IRepositoryListener(){

                public boolean processResource(Resource resource) {
                    AbstractBaseOBR.this.addResourceToIndex(resource);
                    return true;
                }

                public boolean processReferral(String fromUrl, Referral referral, int maxDepth, int currentDepth) {
                    try {
                        URL indexLocation = new URL(referral.getUrl());
                        try {
                            CachingURLResourceHandle indexHandle = new CachingURLResourceHandle(indexLocation.toExternalForm(), null, AbstractBaseOBR.this.getCacheDirectory(), connector, CachingURLResourceHandle.CachingMode.PreferRemote);
                            indexHandle.setReporter(AbstractBaseOBR.this.reporter);
                            return AbstractBaseOBR.this.readIndex(((Object)indexLocation).toString(), new FileInputStream(indexHandle.request()), this);
                        }
                        catch (Exception e) {
                            AbstractBaseOBR.this.reporter.error("Unable to read referral index at URL '%s' from parent index '%s': %s", indexLocation, fromUrl, e);
                        }
                    }
                    catch (MalformedURLException e) {
                        AbstractBaseOBR.this.reporter.error("Invalid referral URL '%s' from parent index '%s': %s", referral.getUrl(), fromUrl, e);
                    }
                    return false;
                }
            };
            Collection<URL> indexes = this.getOBRIndexes();
            for (URL indexLocation : indexes) {
                try {
                    CachingURLResourceHandle indexHandle = new CachingURLResourceHandle(indexLocation.toExternalForm(), null, this.getCacheDirectory(), connector, CachingURLResourceHandle.CachingMode.PreferRemote);
                    indexHandle.setReporter(this.reporter);
                    File indexFile = indexHandle.request();
                    this.readIndex(indexLocation.toExternalForm(), new FileInputStream(indexFile), listener);
                }
                catch (Exception e) {
                    this.reporter.error("Unable to read index at URL '%s': %s", indexLocation, e);
                }
            }
            this.initialised = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnector getConnector() {
        URLConnector connector;
        AbstractBaseOBR abstractBaseOBR = this;
        synchronized (abstractBaseOBR) {
            connector = this.registry != null ? this.registry.getPlugin(URLConnector.class) : null;
        }
        if (connector == null) {
            connector = new DefaultURLConnector();
        }
        return connector;
    }

    @Override
    public final synchronized void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public synchronized void setProperties(Map<String, String> map) {
        if (map.containsKey(PROP_NAME)) {
            this.name = map.get(PROP_NAME);
        }
        if (map.containsKey(PROP_RESOLUTION_MODE)) {
            this.supportedModes = EnumSet.noneOf(OBRResolutionMode.class);
            StringTokenizer tokenizer = new StringTokenizer(map.get(PROP_RESOLUTION_MODE), ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (PROP_RESOLUTION_MODE_ANY.equalsIgnoreCase(token)) {
                    this.supportedModes = EnumSet.allOf(OBRResolutionMode.class);
                    continue;
                }
                try {
                    this.supportedModes.add(OBRResolutionMode.valueOf(token));
                }
                catch (Exception e) {
                    if (this.reporter == null) continue;
                    this.reporter.error("Unknown OBR resolution mode: " + token, new Object[0]);
                }
            }
        }
    }

    @Override
    public File[] get(String bsn, String range) throws Exception {
        ResourceHandle[] handles = this.getHandles(bsn, range);
        return AbstractBaseOBR.requestAll(handles);
    }

    protected static File[] requestAll(ResourceHandle[] handles) throws IOException {
        File[] result = handles == null ? new File[]{} : new File[handles.length];
        int i = 0;
        while (i < result.length) {
            result[i] = handles[i].request();
            ++i;
        }
        return result;
    }

    protected ResourceHandle[] getHandles(String bsn, String rangeStr) throws Exception {
        this.init();
        if ("project".equals(rangeStr)) {
            return null;
        }
        SortedMap<Version, Resource> versionMap = this.bsnMap.get(bsn);
        if (versionMap == null || versionMap.isEmpty()) {
            return null;
        }
        List<Resource> resources = this.narrowVersionsByVersionRange(versionMap, rangeStr);
        List<ResourceHandle> handles = this.mapResourcesToHandles(resources);
        return handles.toArray(new ResourceHandle[handles.size()]);
    }

    @Override
    public synchronized void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public File get(String bsn, String range, RepositoryPlugin.Strategy strategy, Map<String, String> properties) throws Exception {
        ResourceHandle handle = this.getHandle(bsn, range, strategy, properties);
        return handle != null ? handle.request() : null;
    }

    @Override
    public ResourceHandle getHandle(String bsn, String range, RepositoryPlugin.Strategy strategy, Map<String, String> properties) throws Exception {
        ResourceHandle result;
        if (bsn != null) {
            result = this.resolveBundle(bsn, range, strategy);
        } else {
            ResolverMode mode;
            String pkgName = properties.get(CapabilityType.PACKAGE.getTypeName());
            String modeName = properties.get(CapabilityType.MODE.getTypeName());
            ResolverMode resolverMode = mode = modeName != null ? ResolverMode.valueOf(modeName) : null;
            if (pkgName != null) {
                result = this.resolvePackage(pkgName, range, strategy, mode, properties);
            } else {
                throw new IllegalArgumentException("Cannot resolve bundle: neither bsn nor package specified.");
            }
        }
        return result;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public File put(Jar jar) throws Exception {
        throw new UnsupportedOperationException("Read-only repository.");
    }

    @Override
    public List<String> list(String regex) throws Exception {
        this.init();
        Pattern pattern = regex != null ? Pattern.compile(regex) : null;
        LinkedList<String> result = new LinkedList<String>();
        for (String bsn : this.bsnMap.keySet()) {
            if (pattern != null && !pattern.matcher(bsn).matches()) continue;
            result.add(bsn);
        }
        return result;
    }

    @Override
    public List<Version> versions(String bsn) throws Exception {
        List<Version> list;
        this.init();
        SortedMap<Version, Resource> versionMap = this.bsnMap.get(bsn);
        if (versionMap != null) {
            list = new ArrayList<Version>(versionMap.size());
            list.addAll(versionMap.keySet());
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    void addBundleSymbolicNameToIndex(Resource resource) {
        Version version;
        String bsn = resource.getSymbolicName();
        String versionStr = resource.getVersion();
        try {
            version = new Version(versionStr);
        }
        catch (Exception e) {
            version = new Version("0.0.0");
        }
        SortedMap<Version, Resource> versionMap = this.bsnMap.get(bsn);
        if (versionMap == null) {
            versionMap = new TreeMap<Version, Resource>();
            this.bsnMap.put(bsn, versionMap);
        }
        versionMap.put(version, resource);
    }

    void addPackagesToIndex(Resource resource) {
        for (Capability capability : resource.getCapabilities()) {
            Version version;
            if (!CapabilityType.PACKAGE.getTypeName().equals(capability.getName())) continue;
            String pkgName = null;
            String versionStr = null;
            for (Property prop : capability.getProperties()) {
                if ("package".equals(prop.getName())) {
                    pkgName = prop.getValue();
                    continue;
                }
                if (!"version".equals(prop.getName())) continue;
                versionStr = prop.getValue();
            }
            try {
                version = new Version(versionStr);
            }
            catch (Exception e) {
                version = new Version("0.0.0");
            }
            if (pkgName == null) continue;
            SortedMap<Version, Resource> versionMap = this.pkgResourceMap.get(pkgName);
            if (versionMap == null) {
                versionMap = new TreeMap<Version, Resource>();
                this.pkgResourceMap.put(pkgName, versionMap);
            }
            versionMap.put(version, resource);
        }
    }

    boolean readIndex(String baseUrl, InputStream stream, IRepositoryListener listener) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        try {
            parser.parse(stream, (DefaultHandler)new OBRSAXHandler(baseUrl, listener));
            return true;
        }
        catch (StopParseException e) {
            return false;
        }
        finally {
            stream.close();
        }
    }

    List<Resource> narrowVersionsByFilter(String pkgName, SortedMap<Version, Resource> versionMap, Filter filter) {
        ArrayList<Resource> result = new ArrayList<Resource>(versionMap.size());
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("package", pkgName);
        for (Version version : versionMap.keySet()) {
            ((Dictionary)dict).put("version", version.toString());
            if (!filter.match(dict)) continue;
            result.add((Resource)versionMap.get(version));
        }
        return result;
    }

    List<Resource> narrowVersionsByVersionRange(SortedMap<Version, Resource> versionMap, String rangeStr) {
        ArrayList<Resource> result;
        if ("latest".equals(rangeStr)) {
            Version highest = versionMap.lastKey();
            result = Create.list(new Resource[]{(Resource)versionMap.get(highest)});
        } else {
            VersionRange range;
            VersionRange versionRange = range = rangeStr != null ? new VersionRange(rangeStr) : null;
            if (range != null && range.getLow() != null) {
                versionMap = versionMap.tailMap(range.getLow());
            }
            result = new ArrayList(versionMap.size());
            for (Version version : versionMap.keySet()) {
                if (range == null || range.includes(version)) {
                    result.add((Resource)versionMap.get(version));
                }
                if (range != null && range.isRange() && version.compareTo(range.getHigh()) >= 0) break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filterResourcesByResolverMode(Collection<Resource> resources, ResolverMode mode) {
        assert (mode != null);
        Properties modeCapability = new Properties();
        modeCapability.setProperty(CapabilityType.MODE.getTypeName(), mode.name());
        Iterator<Resource> iter = resources.iterator();
        while (iter.hasNext()) {
            Resource resource = iter.next();
            Require modeRequire = resource.findRequire(CapabilityType.MODE.getTypeName());
            if (modeRequire == null) continue;
            if (modeRequire.getFilter() == null) {
                iter.remove();
                continue;
            }
            try {
                Filter filter = new Filter(modeRequire.getFilter());
                if (filter.match(modeCapability)) continue;
                iter.remove();
            }
            catch (IllegalArgumentException e) {
                AbstractBaseOBR abstractBaseOBR = this;
                synchronized (abstractBaseOBR) {
                    if (this.reporter != null) {
                        this.reporter.error("Error parsing mode filter requirement on resource %s: %s", resource.getUrl(), modeRequire.getFilter());
                    }
                }
                iter.remove();
            }
        }
    }

    List<ResourceHandle> mapResourcesToHandles(Collection<Resource> resources) throws Exception {
        ArrayList<ResourceHandle> result = new ArrayList<ResourceHandle>(resources.size());
        for (Resource resource : resources) {
            ResourceHandle handle = this.mapResourceToHandle(resource);
            if (handle == null) continue;
            result.add(handle);
        }
        return result;
    }

    ResourceHandle mapResourceToHandle(Resource resource) throws Exception {
        CachingURLResourceHandle handle;
        CachingURLResourceHandle result = null;
        try {
            handle = new CachingURLResourceHandle(resource.getUrl(), resource.getBaseUrl(), this.getCacheDirectory(), this.getConnector(), CachingURLResourceHandle.CachingMode.PreferCache);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Broken link in repository index: " + e.getMessage());
        }
        if (handle.getLocation() == ResourceHandle.Location.local || this.getCacheDirectory() != null) {
            result = handle;
        }
        return result;
    }

    ResourceHandle resolveBundle(String bsn, String rangeStr, RepositoryPlugin.Strategy strategy) throws Exception {
        ResourceHandle selected;
        if (rangeStr == null) {
            rangeStr = "0.0.0";
        }
        if (strategy == RepositoryPlugin.Strategy.EXACT) {
            return this.findExactMatch(bsn, rangeStr, this.bsnMap);
        }
        ResourceHandle[] handles = this.getHandles(bsn, rangeStr);
        if (handles == null || handles.length == 0) {
            selected = null;
        } else {
            switch (strategy) {
                case LOWEST: {
                    selected = handles[0];
                    break;
                }
                default: {
                    selected = handles[handles.length - 1];
                }
            }
        }
        return selected;
    }

    ResourceHandle resolvePackage(String pkgName, String rangeStr, RepositoryPlugin.Strategy strategy, ResolverMode mode, Map<String, String> props) throws Exception {
        Resource selected;
        SortedMap<Version, Resource> versionMap;
        this.init();
        if (rangeStr == null) {
            rangeStr = "0.0.0";
        }
        if ((versionMap = this.pkgResourceMap.get(pkgName)) == null) {
            return null;
        }
        Filter filter = null;
        String filterStr = props.get("filter");
        if (filterStr != null) {
            filter = new Filter(filterStr);
        }
        List<Resource> resources = filter != null ? this.narrowVersionsByFilter(pkgName, versionMap, filter) : this.narrowVersionsByVersionRange(versionMap, rangeStr);
        if (mode != null) {
            this.filterResourcesByResolverMode(resources, mode);
        }
        if (resources == null || resources.isEmpty()) {
            selected = null;
        } else {
            switch (strategy) {
                case LOWEST: {
                    selected = resources.get(0);
                    break;
                }
                default: {
                    selected = resources.get(resources.size() - 1);
                }
            }
            this.expandPackageUses(pkgName, selected, props);
        }
        return selected != null ? this.mapResourceToHandle(selected) : null;
    }

    void expandPackageUses(String pkgName, Resource resource, Map<String, String> props) {
        LinkedList<String> internalUses = new LinkedList<String>();
        HashMap<String, Require> externalUses = new HashMap<String, Require>();
        internalUses.add(pkgName);
        Capability capability = resource.findPackageCapability(pkgName);
        Property usesProp = capability.findProperty("uses");
        if (usesProp != null) {
            StringTokenizer tokenizer = new StringTokenizer(usesProp.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                String usesPkgName = tokenizer.nextToken();
                Capability usesPkgCap = resource.findPackageCapability(usesPkgName);
                if (usesPkgCap != null) {
                    internalUses.add(usesPkgName);
                    continue;
                }
                Require require = resource.findPackageRequire(usesPkgName);
                if (require == null) continue;
                externalUses.put(usesPkgName, require);
            }
        }
        props.put("packages", this.listToString(internalUses));
        props.put("import-uses", this.formatPackageRequires(externalUses));
    }

    String listToString(List<?> list) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (Object item : list) {
            if (count++ > 0) {
                builder.append(',');
            }
            builder.append(item);
        }
        return builder.toString();
    }

    String formatPackageRequires(Map<String, Require> externalUses) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, Require> entry : externalUses.entrySet()) {
            String pkgName = entry.getKey();
            String filter = entry.getValue().getFilter();
            if (count++ > 0) {
                builder.append(',');
            }
            builder.append(pkgName);
            builder.append(";filter='");
            builder.append(filter);
            builder.append('\'');
        }
        return builder.toString();
    }

    ResourceHandle findExactMatch(String identity, String version, Map<String, SortedMap<Version, Resource>> resourceMap) throws Exception {
        VersionRange range = new VersionRange(version);
        if (range.isRange()) {
            return null;
        }
        SortedMap<Version, Resource> versions = resourceMap.get(identity);
        Resource resource = (Resource)versions.get(range.getLow());
        return this.mapResourceToHandle(resource);
    }

    protected static List<URL> parseLocations(String locationsStr) throws MalformedURLException {
        StringTokenizer tok = new StringTokenizer(locationsStr, ",");
        ArrayList<URL> urls = new ArrayList<URL>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            String urlStr = tok.nextToken().trim();
            urls.add(new URL(urlStr));
        }
        return urls;
    }

    @Override
    public Set<OBRResolutionMode> getSupportedModes() {
        return this.supportedModes;
    }
}

