/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class Names {
    private static List<Type> EXCLUSIONS = new ArrayList<Type>();

    public static String computeEffectiveMethodName(String name) {
        if (name != null && name.startsWith("__M_")) {
            return name.substring("__M_".length());
        }
        return name;
    }

    public static String getMethodIdentifier(MethodNode method) {
        String effectiveName = Names.computeEffectiveMethodName(method.name);
        if (effectiveName.startsWith("bind")) {
            return effectiveName.substring("bind".length());
        }
        if (effectiveName.startsWith("set")) {
            return effectiveName.substring("set".length());
        }
        if (effectiveName.startsWith("unbind")) {
            return effectiveName.substring("unbind".length());
        }
        if (effectiveName.startsWith("unset")) {
            return effectiveName.substring("unset".length());
        }
        if (effectiveName.startsWith("modified")) {
            return effectiveName.substring("modified".length());
        }
        if (effectiveName.startsWith("add")) {
            return effectiveName.substring("add".length());
        }
        if (effectiveName.startsWith("remove")) {
            return effectiveName.substring("remove".length());
        }
        Type[] arguments = Type.getArgumentTypes(method.desc);
        return Names.findSpecification(Arrays.asList(arguments));
    }

    private static String findSpecification(List<Type> types) {
        for (Type type : types) {
            if (EXCLUSIONS.contains(type)) continue;
            return type.getClassName();
        }
        return null;
    }

    public static boolean isCustomAnnotation(String desc) {
        String lowerCase = desc.toLowerCase();
        return lowerCase.contains("ipojo") || lowerCase.contains("handler");
    }

    static {
        EXCLUSIONS.add(Type.getType(Map.class));
        EXCLUSIONS.add(Type.getType(Dictionary.class));
        EXCLUSIONS.add(Type.getType("Lorg/osgi/framework/ServiceReference;"));
    }
}

