/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.util;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;

public class ChainedAnnotationVisitor
extends AnnotationVisitor {
    private List<AnnotationVisitor> m_visitors = new ArrayList<AnnotationVisitor>();

    public ChainedAnnotationVisitor() {
        super(589824);
    }

    public List<AnnotationVisitor> getVisitors() {
        return this.m_visitors;
    }

    @Override
    public void visit(String name, Object value) {
        for (AnnotationVisitor visitor : this.m_visitors) {
            visitor.visit(name, value);
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        for (AnnotationVisitor visitor : this.m_visitors) {
            visitor.visitEnum(name, desc, value);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        ChainedAnnotationVisitor chain = null;
        for (AnnotationVisitor visitor : this.m_visitors) {
            AnnotationVisitor child = visitor.visitAnnotation(name, desc);
            if (child == null) continue;
            if (chain == null) {
                chain = new ChainedAnnotationVisitor();
            }
            chain.getVisitors().add(child);
        }
        return chain;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        ChainedAnnotationVisitor chain = null;
        for (AnnotationVisitor visitor : this.m_visitors) {
            AnnotationVisitor child = visitor.visitArray(name);
            if (child == null) continue;
            if (chain == null) {
                chain = new ChainedAnnotationVisitor();
            }
            chain.getVisitors().add(child);
        }
        return chain;
    }

    @Override
    public void visitEnd() {
        for (AnnotationVisitor visitor : this.m_visitors) {
            visitor.visitEnd();
        }
    }
}

