/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.concurrent.ThreadFactory;

public class GroupThreadFactory
implements ThreadFactory {
    private final ThreadGroup m_threadGroup;

    public GroupThreadFactory() {
        this(GroupThreadFactory.defaultThreadGroup());
    }

    private static ThreadGroup defaultThreadGroup() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            return s.getThreadGroup();
        }
        return Thread.currentThread().getThreadGroup();
    }

    public GroupThreadFactory(ThreadGroup threadGroup) {
        this.m_threadGroup = threadGroup;
    }

    public Thread newThread(Runnable r) {
        return new Thread(this.m_threadGroup, r);
    }
}

