/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl.json;

import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.atomos.utils.substrate.api.resource.ResourceConfiguration;

public class ResourceJsonUtil {
    private static String BUNDLE_NAME = "{ \"name\" : \"%s\" }";
    private static String BUNDLES_END = "]";
    private static String BUNDLES_START = "\"bundles\" : [\n";
    private static String COMMA = ",\n";
    private static String END = "\n}";
    private static char NL = (char)10;
    private static String RESOURCE_PATTERN = "{ \"pattern\" : \"%s\" }";
    private static String RESOURCES_END = BUNDLES_END;
    private static String RESOURCES_START = "\"resources\" : [\n";
    private static String START = "{\n";

    private static Object ind(int num) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            indent.append("  ");
        }
        return indent.toString();
    }

    public static String json(ResourceConfiguration result) {
        TreeSet allResourceBundles = new TreeSet(String::compareTo);
        allResourceBundles.addAll(result.getResourceBundles());
        TreeSet allResourcePatterns = new TreeSet(String::compareTo);
        allResourcePatterns.addAll(result.getResourcePatterns());
        AtomicBoolean first = new AtomicBoolean();
        StringBuilder resourceConfig = new StringBuilder();
        resourceConfig.append(START);
        if (!allResourceBundles.isEmpty()) {
            resourceConfig.append(ResourceJsonUtil.ind(1)).append(BUNDLES_START);
            allResourceBundles.forEach(b -> {
                if (!first.compareAndSet(false, true)) {
                    resourceConfig.append(COMMA);
                }
                resourceConfig.append(ResourceJsonUtil.ind(2)).append(String.format(BUNDLE_NAME, b));
            });
            resourceConfig.append(NL).append(ResourceJsonUtil.ind(1)).append(BUNDLES_END);
        }
        first.set(false);
        if (!allResourcePatterns.isEmpty()) {
            if (!allResourceBundles.isEmpty()) {
                resourceConfig.append(COMMA);
            }
            resourceConfig.append(ResourceJsonUtil.ind(1)).append(RESOURCES_START);
            allResourcePatterns.forEach(p -> {
                if (!first.compareAndSet(false, true)) {
                    resourceConfig.append(COMMA);
                }
                resourceConfig.append(ResourceJsonUtil.ind(2)).append(String.format(RESOURCE_PATTERN, p));
            });
            resourceConfig.append(NL).append(ResourceJsonUtil.ind(1)).append(RESOURCES_END);
        }
        resourceConfig.append(END);
        return resourceConfig.toString();
    }
}

