/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.base;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.felix.atomos.Atomos;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.AtomosLayer;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.wiring.BundleCapability;

public class AtomosClassPath
extends AtomosBase {
    private final AtomosLayer bootLayer = this.createBootLayer();

    public AtomosClassPath(Map<String, String> config, Atomos.HeaderProvider headerProvider) {
        super(config, headerProvider);
    }

    private AtomosLayer createBootLayer() {
        this.lockWrite();
        try {
            AtomosLayerClassPath result = new AtomosLayerClassPath(Collections.emptyList(), this.nextLayerId.getAndIncrement(), "boot", AtomosLayer.LoaderType.SINGLE, new Path[0]);
            this.addAtomosLayer(result);
            AtomosLayerClassPath atomosLayerClassPath = result;
            return atomosLayerClassPath;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public ConnectFrameworkFactory findFrameworkFactory() {
        Iterator<ConnectFrameworkFactory> itr = ServiceLoader.load(ConnectFrameworkFactory.class, this.getClass().getClassLoader()).iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        throw new RuntimeException("No Framework implementation found.");
    }

    @Override
    protected void filterBasedOnReadEdges(AtomosContent atomosContent, Collection<BundleCapability> candidates) {
        this.filterNotVisible(atomosContent, candidates);
    }

    @Override
    public AtomosLayer getBootLayer() {
        return this.bootLayer;
    }

    @Override
    protected void addingLayer(AtomosBase.AtomosLayerBase atomosLayer) {
    }

    @Override
    protected void removedLayer(AtomosBase.AtomosLayerBase atomosLayer) {
    }

    public class AtomosLayerClassPath
    extends AtomosBase.AtomosLayerBase {
        private final Set<AtomosBase.AtomosLayerBase.AtomosContentBase> atomosContents;

        protected AtomosLayerClassPath(List<AtomosLayer> parents, long id, String name, AtomosLayer.LoaderType loaderType, Path ... paths) {
            super(parents, id, name, loaderType, paths);
            this.atomosContents = this.findAtomosContents();
        }

        @Override
        public final Set<AtomosContent> getAtomosContents() {
            return AtomosBase.asSet(this.atomosContents);
        }

        @Override
        protected void findBootModuleLayerAtomosContents(Set<AtomosBase.AtomosLayerBase.AtomosContentBase> result) {
        }
    }
}

