/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.osgi;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.shell.osgi.BundleCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

@Command(scope="osgi", name="bundle-level", description="Get or set the start level of a given bundle")
public class BundleLevel
extends BundleCommand {
    @Argument(index=1, name="startLevel", description="The bundles new start level", required=false, multiValued=false)
    Integer level;

    protected void doExecute(Bundle bundle) throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        if (ref == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        StartLevel sl = (StartLevel)this.getService(StartLevel.class, ref);
        if (sl == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        if (this.level == null) {
            System.out.println("Level " + sl.getBundleStartLevel(bundle));
        } else if (this.level < 50 && sl.getBundleStartLevel(bundle) > 50) {
            String str;
            do {
                StringBuffer sb = new StringBuffer();
                System.err.println("You are about to designate bundle as a system bundle.  Do you want to continue (yes/no): ");
                System.err.flush();
                while (true) {
                    int c;
                    if ((c = System.in.read()) < 0) {
                        return;
                    }
                    System.err.println((char)c);
                    if (c == 13 || c == 10) break;
                    sb.append((char)c);
                }
                str = sb.toString();
                if (!"yes".equals(str)) continue;
                sl.setBundleStartLevel(bundle, this.level.intValue());
                break;
            } while (!"no".equals(str));
        } else {
            sl.setBundleStartLevel(bundle, this.level.intValue());
        }
    }
}

