/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.features.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeaderParser {
    private HeaderParser() {
    }

    public static List<PathElement> parseHeader(String header) {
        String[] clauses;
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        if (header == null || header.trim().length() == 0) {
            return elements;
        }
        for (String clause : clauses = HeaderParser.parseDelimitedString(header, ",")) {
            String[] tokens = clause.split(";");
            if (tokens.length < 1) {
                throw new IllegalArgumentException("Invalid header clause: " + clause);
            }
            PathElement elem = new PathElement(tokens[0].trim());
            elements.add(elem);
            for (int i = 1; i < tokens.length; ++i) {
                int pos = tokens[i].indexOf(61);
                if (pos != -1) {
                    String value;
                    String name;
                    if (pos > 0 && tokens[i].charAt(pos - 1) == ':') {
                        name = tokens[i].substring(0, pos - 1).trim();
                        value = tokens[i].substring(pos + 1).trim();
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        elem.addDirective(name, value);
                        continue;
                    }
                    name = tokens[i].substring(0, pos).trim();
                    value = tokens[i].substring(pos + 1).trim();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    elem.addAttribute(name, value);
                    continue;
                }
                elem = new PathElement(tokens[i].trim());
                elements.add(elem);
            }
        }
        return elements;
    }

    public static String[] parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathElement {
        private String path;
        private Map<String, String> attributes;
        private Map<String, String> directives;

        public PathElement(String path) {
            this.path = path;
            this.attributes = new HashMap<String, String>();
            this.directives = new HashMap<String, String>();
        }

        public String getName() {
            return this.path;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void addAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public String getDirective(String name) {
            return this.directives.get(name);
        }

        public void addDirective(String name, String value) {
            this.directives.put(name, value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.path);
            for (Map.Entry<String, String> directive : this.directives.entrySet()) {
                sb.append(";").append(directive.getKey()).append(":=").append(directive.getValue());
            }
            for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                sb.append(";").append(attribute.getKey()).append("=").append(attribute.getValue());
            }
            return sb.toString();
        }
    }
}

