/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.aries.blueprint.mutable.MutableServiceReferenceMetadata;
import org.apache.aries.blueprint.reflect.ComponentMetadataImpl;
import org.apache.aries.blueprint.reflect.ReferenceListenerImpl;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceReferenceMetadataImpl
extends ComponentMetadataImpl
implements MutableServiceReferenceMetadata {
    protected int availability;
    protected String interfaceName;
    protected String componentName;
    protected String filter;
    protected Collection<ReferenceListener> referenceListeners;
    protected int proxyMethod;

    public ServiceReferenceMetadataImpl() {
    }

    public ServiceReferenceMetadataImpl(ServiceReferenceMetadata source) {
        super(source);
        this.availability = source.getAvailability();
        this.interfaceName = source.getInterface();
        this.componentName = source.getComponentName();
        this.filter = source.getFilter();
        for (ReferenceListener listener : source.getReferenceListeners()) {
            this.addServiceListener(new ReferenceListenerImpl(listener));
        }
    }

    @Override
    public int getAvailability() {
        return this.availability;
    }

    @Override
    public void setAvailability(int availability) {
        this.availability = availability;
    }

    @Override
    public String getInterface() {
        return this.interfaceName;
    }

    @Override
    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public Collection<ReferenceListener> getReferenceListeners() {
        if (this.referenceListeners == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.referenceListeners);
    }

    public void setReferenceListeners(Collection<ReferenceListener> listeners) {
        this.referenceListeners = listeners != null ? new ArrayList<ReferenceListener>(listeners) : null;
    }

    @Override
    public void addServiceListener(ReferenceListener bindingListenerMetadata) {
        if (this.referenceListeners == null) {
            this.referenceListeners = new ArrayList<ReferenceListener>();
        }
        this.referenceListeners.add(bindingListenerMetadata);
    }

    @Override
    public ReferenceListener addServiceListener(Target listenerComponent, String bindMethodName, String unbindMethodName) {
        ReferenceListenerImpl listener = new ReferenceListenerImpl(listenerComponent, bindMethodName, unbindMethodName);
        this.addServiceListener(listener);
        return listener;
    }

    @Override
    public void removeReferenceListener(ReferenceListener listener) {
        if (this.referenceListeners != null) {
            this.referenceListeners.remove(listener);
        }
    }

    @Override
    public int getProxyMethod() {
        return this.proxyMethod;
    }

    @Override
    public void setProxyMethod(int proxyMethod) {
        this.proxyMethod = proxyMethod;
    }
}

