/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent;

import java.io.IOException;
import org.apache.sshd.agent.AprLibrary;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.server.session.ServerSession;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentForwardSupport {
    private static final Logger log = LoggerFactory.getLogger(AgentForwardSupport.class);
    private final ServerSession session;
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;
    private boolean closed;

    public AgentForwardSupport(ServerSession session) {
        this.session = session;
    }

    public synchronized String initialize() throws IOException {
        try {
            if (this.authSocket == null) {
                String authSocket = AprLibrary.createLocalSocketAddress();
                this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
                this.handle = Local.create((String)authSocket, (long)this.pool);
                int result = Local.bind((long)this.handle, (long)0L);
                if (result != 0) {
                    AgentForwardSupport.throwException(result);
                }
                AprLibrary.secureLocalSocket(authSocket, this.handle);
                result = Local.listen((long)this.handle, (int)0);
                if (result != 0) {
                    AgentForwardSupport.throwException(result);
                }
                this.thread = new Thread(){

                    public void run() {
                        while (!AgentForwardSupport.this.closed) {
                            try {
                                long clientSock = Local.accept((long)AgentForwardSupport.this.handle);
                                if (!AgentForwardSupport.this.closed) {
                                    Socket.timeoutSet((long)clientSock, (long)10000000L);
                                    AgentForwardedChannel channel = new AgentForwardedChannel(clientSock);
                                    AgentForwardSupport.this.session.registerChannel(channel);
                                    OpenFuture future = (OpenFuture)channel.open().await();
                                    Throwable t = future.getException();
                                    if (t instanceof Exception) {
                                        throw (Exception)t;
                                    }
                                    if (t == null) continue;
                                    throw new Exception(t);
                                }
                                break;
                            }
                            catch (Exception e) {
                                if (AgentForwardSupport.this.closed) continue;
                                log.info("Exchange caught in authentication forwarding", (Throwable)e);
                            }
                        }
                    }
                };
                this.thread.start();
                this.authSocket = authSocket;
            }
            return this.authSocket;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.handle != 0L) {
            Socket.close((long)this.handle);
        }
    }

    private static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    public static class AgentForwardedChannel
    extends AbstractClientChannel
    implements Runnable {
        private final long socket;

        public AgentForwardedChannel(long socket) {
            super("auth-agent@openssh.com");
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int result;
                byte[] buf = new byte[1024];
                while ((result = Socket.recv((long)this.socket, (byte[])buf, (int)0, (int)buf.length)) != 70014) {
                    if (result < 0) {
                        AgentForwardSupport.throwException(result);
                    }
                    this.getOut().write(buf, 0, result);
                    this.getOut().flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.close(false);
            }
        }

        public synchronized OpenFuture open() throws Exception {
            return this.internalOpen();
        }

        protected synchronized void doOpen() throws Exception {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        }

        protected synchronized void doClose() {
            Socket.close((long)this.socket);
            super.doClose();
        }

        protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
            this.localWindow.consumeAndCheck(len);
            int result = Socket.send((long)this.socket, (byte[])data, (int)off, (int)len);
            if (result < 0) {
                AgentForwardSupport.throwException(result);
            }
        }
    }
}

