/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.config;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="edit", description="Create or edit a configuration.")
public class EditCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="pid", description="PID of the configuration", required=true, multiValued=false)
    String pid;
    @Option(name="--force", aliases={}, description="Force the edition of this config, even if another one was under edition", required=false, multiValued=false)
    boolean force;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        String oldPid = (String)this.session.get("ConfigCommand.PID");
        if (oldPid != null && !oldPid.equals(this.pid) && !this.force) {
            System.err.println("Another config is being edited.  Cancel / update first, or use the --force option");
            return;
        }
        Dictionary props = admin.getConfiguration(this.pid).getProperties();
        if (props == null) {
            props = new Properties();
        }
        this.session.put("ConfigCommand.PID", (Object)this.pid);
        this.session.put("ConfigCommand.Props", (Object)props);
    }
}

