/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.SystemUtils;
import org.apache.eventmesh.openconnect.ConnectorWorker;
import org.apache.eventmesh.openconnect.api.config.SourceConfig;
import org.apache.eventmesh.openconnect.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceWorker
implements ConnectorWorker {
    private static final Logger log = LoggerFactory.getLogger(SourceWorker.class);
    private final Source source;
    private final SourceConfig config;
    private final ExecutorService pollService = Executors.newSingleThreadExecutor();
    private final ExecutorService startService = Executors.newSingleThreadExecutor();
    private final BlockingQueue<ConnectRecord> queue;
    private final EventMeshTCPClient<CloudEvent> eventMeshTCPClient;
    private volatile boolean isRunning = false;

    public SourceWorker(Source source, SourceConfig config) throws Exception {
        this.source = source;
        this.config = config;
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
        this.eventMeshTCPClient = this.buildEventMeshPubClient(config);
        this.eventMeshTCPClient.init();
    }

    private EventMeshTCPClient<CloudEvent> buildEventMeshPubClient(SourceConfig config) {
        String meshAddress = config.getPubSubConfig().getMeshAddress();
        String meshIp = meshAddress.split(":")[0];
        int meshPort = Integer.parseInt(meshAddress.split(":")[1]);
        UserAgent agent = UserAgent.builder().env(config.getPubSubConfig().getEnv()).host("localhost").password(config.getPubSubConfig().getPassWord()).username(config.getPubSubConfig().getUserName()).group(config.getPubSubConfig().getGroup()).path("/").port(8362).subsystem(config.getPubSubConfig().getAppId()).pid(Integer.parseInt(SystemUtils.getProcessId())).version("2.0").idc(config.getPubSubConfig().getIdc()).build();
        UserAgent userAgent = MessageUtils.generatePubClient((UserAgent)agent);
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(meshIp).port(meshPort).userAgent(userAgent).build();
        return EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, CloudEvent.class);
    }

    @Override
    public void start() {
        log.info("source worker starting {}", (Object)this.source.name());
        log.info("event mesh address is {}", (Object)this.config.getPubSubConfig().getMeshAddress());
        this.isRunning = true;
        this.pollService.execute(this::startPoll);
        this.startService.execute(() -> {
            try {
                this.startConnector();
            }
            catch (Exception e) {
                log.error("source worker[{}] start fail", (Object)this.source.name(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    public void startPoll() {
        while (this.isRunning) {
            ConnectRecord connectRecord = null;
            try {
                connectRecord = this.queue.poll(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("poll connect record error", (Throwable)e);
            }
            if (connectRecord == null) continue;
            CloudEvent event = this.convertRecordToEvent(connectRecord);
            this.eventMeshTCPClient.publish((Object)event, 3000L);
        }
    }

    private void startConnector() throws Exception {
        this.source.start();
        while (this.isRunning) {
            List<ConnectRecord> connectorRecordList = this.source.poll();
            if (CollectionUtils.isEmpty(connectorRecordList)) continue;
            for (ConnectRecord record : connectorRecordList) {
                this.queue.put(record);
            }
        }
    }

    private CloudEvent convertRecordToEvent(ConnectRecord connectRecord) {
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSubject(this.config.getPubSubConfig().getSubject()).withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType("cloudevents").withData(Objects.requireNonNull(JsonUtils.toJSONString((Object)connectRecord.getData())).getBytes(StandardCharsets.UTF_8))).withExtension("ttl", (Number)10000)).build();
    }

    @Override
    public void stop() {
        log.info("source worker stopping");
        this.isRunning = false;
        try {
            this.source.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("source destroy error", (Throwable)e);
        }
        this.pollService.shutdown();
        try {
            this.pollService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("awaitTermination error", (Throwable)e);
        }
        try {
            this.eventMeshTCPClient.close();
        }
        catch (Exception e) {
            log.error("event mesh client close error", (Throwable)e);
        }
        log.info("source worker stopped");
    }
}

