/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EventMeshTcpConnectionHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(EventMeshTcpConnectionHandler.class);
    private final AtomicInteger connections = new AtomicInteger(0);
    private EventMeshTCPServer eventMeshTCPServer;

    public EventMeshTcpConnectionHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        log.info("client|tcp|channelRegistered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        log.info("client|tcp|channelUnregistered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
        super.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        log.info("client|tcp|channelActive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
        if (this.connections.incrementAndGet() > this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpClientMaxNum()) {
            log.warn("client|tcp|channelActive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"too many client connect this eventMesh server");
            ctx.close();
            return;
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.connections.decrementAndGet();
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        log.info("client|tcp|channelInactive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"");
        this.eventMeshTCPServer.getClientSessionGroupMapping().closeSession(ctx);
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("client|tcp|userEventTriggered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)evt.getClass().getName());
            this.eventMeshTCPServer.getClientSessionGroupMapping().closeSession(ctx);
        }
        ctx.fireUserEventTriggered(evt);
    }

    public int getConnectionCount() {
        return this.connections.get();
    }
}

