/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import com.fasterxml.jackson.core.type.TypeReference;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.ConsumerServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.ReplyMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.SubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.SubscribeStreamProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.UnsubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerService
extends ConsumerServiceGrpc.ConsumerServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(ConsumerService.class);
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final ThreadPoolExecutor subscribeThreadPoolExecutor;
    private final ThreadPoolExecutor replyThreadPoolExecutor;

    public ConsumerService(EventMeshGrpcServer eventMeshGrpcServer, ThreadPoolExecutor subscribeThreadPoolExecutor, ThreadPoolExecutor replyThreadPoolExecutor) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.subscribeThreadPoolExecutor = subscribeThreadPoolExecutor;
        this.replyThreadPoolExecutor = replyThreadPoolExecutor;
    }

    public void subscribe(CloudEvent request, StreamObserver<CloudEvent> responseObserver) {
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"subscribe", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)request), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
        this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromClient();
        EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        this.subscribeThreadPoolExecutor.submit(() -> {
            SubscribeProcessor subscribeProcessor = new SubscribeProcessor(this.eventMeshGrpcServer);
            try {
                subscribeProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SUBSCRIBE_ERR.getRetCode(), StatusCode.EVENTMESH_SUBSCRIBE_ERR.getErrMsg(), e});
                ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }

    public StreamObserver<CloudEvent> subscribeStream(StreamObserver<CloudEvent> responseObserver) {
        final EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        return new StreamObserver<CloudEvent>(){

            public void onNext(CloudEvent subscription) {
                Set subscriptionItems = (Set)JsonUtils.parseTypeReferenceObject((String)subscription.getTextData(), (TypeReference)new TypeReference<Set<SubscriptionItem>>(){});
                if (CollectionUtils.isNotEmpty((Collection)subscriptionItems)) {
                    log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"subscribeStream", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)subscription), ConsumerService.this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
                    ConsumerService.this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromClient();
                    ConsumerService.this.handleSubscriptionStream(subscription, emitter);
                } else {
                    log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"reply-to-server", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)subscription), ConsumerService.this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
                    ConsumerService.this.handleSubscribeReply(subscription, emitter);
                }
            }

            public void onError(Throwable t) {
                log.error("Receive error from client: {}", (Object)t.getMessage());
                emitter.onCompleted();
            }

            public void onCompleted() {
                log.info("Client finish sending messages");
                emitter.onCompleted();
            }
        };
    }

    private void handleSubscriptionStream(CloudEvent request, EventEmitter<CloudEvent> emitter) {
        this.subscribeThreadPoolExecutor.submit(() -> {
            SubscribeStreamProcessor streamProcessor = new SubscribeStreamProcessor(this.eventMeshGrpcServer);
            try {
                streamProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), e});
                ServiceUtils.sendStreamResponseCompleted(request, StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }

    private void handleSubscribeReply(CloudEvent subscription, EventEmitter<CloudEvent> emitter) {
        this.replyThreadPoolExecutor.submit(() -> {
            ReplyMessageProcessor replyMessageProcessor = new ReplyMessageProcessor(this.eventMeshGrpcServer);
            try {
                replyMessageProcessor.process(subscription, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), e});
                ServiceUtils.sendStreamResponseCompleted(subscription, StatusCode.EVENTMESH_SUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }

    public void unsubscribe(CloudEvent request, StreamObserver<CloudEvent> responseObserver) {
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"unsubscribe", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)request), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
        this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromClient();
        EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        this.subscribeThreadPoolExecutor.submit(() -> {
            UnsubscribeProcessor unsubscribeProcessor = new UnsubscribeProcessor(this.eventMeshGrpcServer);
            try {
                unsubscribeProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode(), StatusCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg(), e});
                ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_UNSUBSCRIBE_ERR, e.getMessage(), emitter);
            }
        });
    }
}

