/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.AbstractPublishCloudEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCloudEventProcessor
extends AbstractPublishCloudEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(RequestCloudEventProcessor.class);

    public RequestCloudEventProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        super(eventMeshGrpcServer, eventMeshGrpcServer.getAcl());
    }

    @Override
    public void handleCloudEvent(final CloudEvent message, final EventEmitter<CloudEvent> emitter) throws Exception {
        String protocolType = EventMeshCloudEventUtils.getProtocolType((CloudEvent)message);
        final ProtocolAdaptor grpcCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        io.cloudevents.CloudEvent cloudEvent = grpcCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)new EventMeshCloudEventWrapper(message));
        final String seqNum = EventMeshCloudEventUtils.getSeqNum((CloudEvent)message);
        final String uniqueId = EventMeshCloudEventUtils.getUniqueId((CloudEvent)message);
        final String topic = EventMeshCloudEventUtils.getSubject((CloudEvent)message);
        String producerGroup = EventMeshCloudEventUtils.getProducerGroup((CloudEvent)message);
        int ttl = Integer.parseInt(EventMeshCloudEventUtils.getTtl((CloudEvent)message));
        ProducerManager producerManager = this.eventMeshGrpcServer.getProducerManager();
        EventMeshProducer eventMeshProducer = producerManager.getEventMeshProducer(producerGroup);
        SendMessageContext sendMessageContext = new SendMessageContext(seqNum, cloudEvent, eventMeshProducer, this.eventMeshGrpcServer);
        this.eventMeshGrpcServer.getMetricsMonitor().recordSendMsgToQueue();
        final long startTime = System.currentTimeMillis();
        eventMeshProducer.request(sendMessageContext, new RequestReplyCallback(){

            public void onSuccess(io.cloudevents.CloudEvent event) {
                try {
                    RequestCloudEventProcessor.this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromQueue();
                    EventMeshCloudEventWrapper wrapper = (EventMeshCloudEventWrapper)grpcCommandProtocolAdaptor.fromCloudEvent(event);
                    emitter.onNext(wrapper.getMessage());
                    emitter.onCompleted();
                    long endTime = System.currentTimeMillis();
                    log.info("message|eventmesh2client|REPLY|RequestReply|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId});
                    RequestCloudEventProcessor.this.eventMeshGrpcServer.getMetricsMonitor().recordSendMsgToClient();
                }
                catch (Exception e) {
                    ServiceUtils.sendStreamResponseCompleted(message, StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR, EventMeshUtil.stackTrace(e, 2), emitter);
                    long endTime = System.currentTimeMillis();
                    log.error("message|mq2eventmesh|REPLY|RequestReply|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId, e});
                }
            }

            public void onException(Throwable e) {
                ServiceUtils.sendStreamResponseCompleted(message, StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR, EventMeshUtil.stackTrace(e, 2), emitter);
                long endTime = System.currentTimeMillis();
                log.error("message|eventMesh2mq|REPLY|RequestReply|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId, e});
            }
        }, ttl);
    }
}

