/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.AbstractHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.HTTPTrace;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumer.SubscriptionManager;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AdminMetricsProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.BatchSendMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.BatchSendMessageV2Processor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HeartBeatProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.LocalSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.LocalUnSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.RemoteSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.RemoteUnSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.ReplyMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncRemoteEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendSyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.UnSubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.WebHookProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.http.push.HTTPClientPool;
import org.apache.eventmesh.runtime.core.protocol.http.retry.HttpRetryer;
import org.apache.eventmesh.runtime.metrics.http.HTTPMetricsServer;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.eventmesh.webhook.receive.WebHookController;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshHTTPServer
extends AbstractHTTPServer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshHTTPServer.class);
    private final EventMeshServer eventMeshServer;
    private final EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private final Registry registry;
    private final Acl acl;
    public final EventBus eventBus = new EventBus();
    private ConsumerManager consumerManager;
    private SubscriptionManager subscriptionManager;
    private ProducerManager producerManager;
    private HttpRetryer httpRetryer;
    private ThreadPoolExecutor batchMsgExecutor;
    private ThreadPoolExecutor sendMsgExecutor;
    private ThreadPoolExecutor remoteMsgExecutor;
    private ThreadPoolExecutor replyMsgExecutor;
    private ThreadPoolExecutor pushMsgExecutor;
    private ThreadPoolExecutor clientManageExecutor;
    private ThreadPoolExecutor adminExecutor;
    private ThreadPoolExecutor webhookExecutor;
    private transient RateLimiter msgRateLimiter;
    private transient RateLimiter batchRateLimiter;
    private final transient HTTPClientPool httpClientPool = new HTTPClientPool(10);

    public EventMeshHTTPServer(EventMeshServer eventMeshServer, EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        super(eventMeshHttpConfiguration.getHttpServerPort(), eventMeshHttpConfiguration.isEventMeshServerUseTls(), eventMeshHttpConfiguration);
        this.eventMeshServer = eventMeshServer;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.registry = eventMeshServer.getRegistry();
        this.acl = eventMeshServer.getAcl();
    }

    private void initThreadPool() {
        this.batchMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerBatchMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerBatchMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerBatchBlockQSize()), (String)"eventMesh-batchMsg", (boolean)true);
        this.sendMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerSendMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerSendMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerSendMsgBlockQSize()), (String)"eventMesh-sendMsg", (boolean)true);
        this.remoteMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerRemoteMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerRemoteMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerRemoteMsgBlockQSize()), (String)"eventMesh-remoteMsg", (boolean)true);
        this.pushMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerPushMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerPushMsgThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerPushMsgBlockQSize()), (String)"eventMesh-pushMsg", (boolean)true);
        this.clientManageExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerClientManageThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerClientManageThreadNum(), new LinkedBlockingQueue(this.eventMeshHttpConfiguration.getEventMeshServerClientManageBlockQSize()), (String)"eventMesh-clientManage", (boolean)true);
        this.adminExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerAdminThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerAdminThreadNum(), new LinkedBlockingQueue(50), (String)"eventMesh-admin", (boolean)true);
        this.replyMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerReplyMsgThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerReplyMsgThreadNum(), new LinkedBlockingQueue(100), (String)"eventMesh-replyMsg", (boolean)true);
    }

    public void shutdownThreadPool() {
        if (this.batchMsgExecutor != null) {
            this.batchMsgExecutor.shutdown();
        }
        if (this.adminExecutor != null) {
            this.adminExecutor.shutdown();
        }
        if (this.clientManageExecutor != null) {
            this.clientManageExecutor.shutdown();
        }
        if (this.sendMsgExecutor != null) {
            this.sendMsgExecutor.shutdown();
        }
        if (this.remoteMsgExecutor != null) {
            this.remoteMsgExecutor.shutdown();
        }
        if (this.pushMsgExecutor != null) {
            this.pushMsgExecutor.shutdown();
        }
        if (this.replyMsgExecutor != null) {
            this.replyMsgExecutor.shutdown();
        }
    }

    private void init() throws Exception {
        if (log.isInfoEnabled()) {
            log.info("==================EventMeshHTTPServer Initialing==================");
        }
        super.init("eventMesh-http");
        this.initThreadPool();
        this.msgRateLimiter = RateLimiter.create((double)this.eventMeshHttpConfiguration.getEventMeshHttpMsgReqNumPerSecond());
        this.batchRateLimiter = RateLimiter.create((double)this.eventMeshHttpConfiguration.getEventMeshBatchMsgRequestNumPerSecond());
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshHttpConfiguration.getEventMeshMetricsPluginType()).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.httpRetryer = new HttpRetryer(this);
        this.httpRetryer.init();
        this.setMetrics(new HTTPMetricsServer(this, metricsRegistries));
        this.subscriptionManager = new SubscriptionManager();
        this.consumerManager = new ConsumerManager(this);
        this.consumerManager.init();
        this.producerManager = new ProducerManager(this);
        this.producerManager.init();
        this.setHandlerService(new HandlerService());
        this.getHandlerService().setMetrics(this.getMetrics());
        if (StringUtils.isNotEmpty((CharSequence)this.eventMeshHttpConfiguration.getEventMeshTracePluginType()) && this.eventMeshHttpConfiguration.isEventMeshServerTraceEnable()) {
            this.setUseTrace(this.eventMeshHttpConfiguration.isEventMeshServerTraceEnable());
        }
        this.getHandlerService().setHttpTrace(new HTTPTrace(this.eventMeshHttpConfiguration.isEventMeshServerTraceEnable()));
        this.registerHTTPRequestProcessor();
        this.initWebhook();
        if (log.isInfoEnabled()) {
            log.info("==================EventMeshHTTPServer initialized==================");
        }
    }

    @Override
    public void start() throws Exception {
        this.init();
        super.start();
        this.getMetrics().start();
        this.consumerManager.start();
        this.producerManager.start();
        this.httpRetryer.start();
        if (this.eventMeshHttpConfiguration.isEventMeshServerRegistryEnable()) {
            this.register();
        }
        if (log.isInfoEnabled()) {
            log.info("==================EventMeshHTTPServer started==================");
        }
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.getMetrics().shutdown();
        this.consumerManager.shutdown();
        this.shutdownThreadPool();
        this.httpClientPool.shutdown();
        this.producerManager.shutdown();
        this.httpRetryer.shutdown();
        if (this.eventMeshHttpConfiguration.isEventMeshServerRegistryEnable()) {
            this.unRegister();
        }
        if (log.isInfoEnabled()) {
            log.info("==================EventMeshHTTPServer shutdown==================");
        }
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshHttpConfiguration.getHttpServerPort();
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshHttpConfiguration.getEventMeshCluster());
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshHttpConfiguration.getEventMeshName() + "-" + "HTTP");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setProtocolType("HTTP");
            registerResult = this.registry.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            log.error("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() throws Exception {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshHttpConfiguration.getHttpServerPort();
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshHttpConfiguration.getEventMeshCluster());
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshHttpConfiguration.getEventMeshName());
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("HTTP");
        boolean registerResult = this.registry.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    public void registerHTTPRequestProcessor() {
        BatchSendMessageProcessor batchSendMessageProcessor = new BatchSendMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_BATCH_SEND.getRequestCode(), batchSendMessageProcessor, this.batchMsgExecutor);
        BatchSendMessageV2Processor batchSendMessageV2Processor = new BatchSendMessageV2Processor(this);
        this.registerProcessor(RequestCode.MSG_BATCH_SEND_V2.getRequestCode(), batchSendMessageV2Processor, this.batchMsgExecutor);
        SendSyncMessageProcessor sendSyncMessageProcessor = new SendSyncMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_SEND_SYNC.getRequestCode(), sendSyncMessageProcessor, this.sendMsgExecutor);
        SendAsyncMessageProcessor sendAsyncMessageProcessor = new SendAsyncMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_SEND_ASYNC.getRequestCode(), sendAsyncMessageProcessor, this.sendMsgExecutor);
        SendAsyncEventProcessor sendAsyncEventProcessor = new SendAsyncEventProcessor(this);
        this.getHandlerService().register(sendAsyncEventProcessor, this.sendMsgExecutor);
        SendAsyncRemoteEventProcessor sendAsyncRemoteEventProcessor = new SendAsyncRemoteEventProcessor(this);
        this.getHandlerService().register(sendAsyncRemoteEventProcessor, this.remoteMsgExecutor);
        AdminMetricsProcessor adminMetricsProcessor = new AdminMetricsProcessor(this);
        this.registerProcessor(RequestCode.ADMIN_METRICS.getRequestCode(), adminMetricsProcessor, this.adminExecutor);
        HeartBeatProcessor heartProcessor = new HeartBeatProcessor(this);
        this.registerProcessor(RequestCode.HEARTBEAT.getRequestCode(), heartProcessor, this.clientManageExecutor);
        SubscribeProcessor subscribeProcessor = new SubscribeProcessor(this);
        this.registerProcessor(RequestCode.SUBSCRIBE.getRequestCode(), subscribeProcessor, this.clientManageExecutor);
        LocalSubscribeEventProcessor localSubscribeEventProcessor = new LocalSubscribeEventProcessor(this);
        this.getHandlerService().register(localSubscribeEventProcessor, this.clientManageExecutor);
        RemoteSubscribeEventProcessor remoteSubscribeEventProcessor = new RemoteSubscribeEventProcessor(this);
        this.getHandlerService().register(remoteSubscribeEventProcessor, this.clientManageExecutor);
        UnSubscribeProcessor unSubscribeProcessor = new UnSubscribeProcessor(this);
        this.registerProcessor(RequestCode.UNSUBSCRIBE.getRequestCode(), unSubscribeProcessor, this.clientManageExecutor);
        LocalUnSubscribeEventProcessor localUnSubscribeEventProcessor = new LocalUnSubscribeEventProcessor(this);
        this.getHandlerService().register(localUnSubscribeEventProcessor, this.clientManageExecutor);
        RemoteUnSubscribeEventProcessor remoteUnSubscribeEventProcessor = new RemoteUnSubscribeEventProcessor(this);
        this.getHandlerService().register(remoteUnSubscribeEventProcessor, this.clientManageExecutor);
        ReplyMessageProcessor replyMessageProcessor = new ReplyMessageProcessor(this);
        this.registerProcessor(RequestCode.REPLY_MESSAGE.getRequestCode(), replyMessageProcessor, this.replyMsgExecutor);
    }

    private void initWebhook() throws Exception {
        this.webhookExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.getEventMeshServerWebhookThreadNum(), (int)this.eventMeshHttpConfiguration.getEventMeshServerWebhookThreadNum(), new LinkedBlockingQueue(100), (String)"eventMesh-webhook", (boolean)true);
        WebHookProcessor webHookProcessor = new WebHookProcessor();
        WebHookController webHookController = new WebHookController();
        webHookController.init();
        webHookProcessor.setWebHookController(webHookController);
        this.getHandlerService().register(webHookProcessor, this.webhookExecutor);
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public EventMeshHTTPConfiguration getEventMeshHttpConfiguration() {
        return this.eventMeshHttpConfiguration;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public HttpRetryer getHttpRetryer() {
        return this.httpRetryer;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public EventMeshServer getEventMeshServer() {
        return this.eventMeshServer;
    }

    public ThreadPoolExecutor getBatchMsgExecutor() {
        return this.batchMsgExecutor;
    }

    public ThreadPoolExecutor getSendMsgExecutor() {
        return this.sendMsgExecutor;
    }

    public ThreadPoolExecutor getReplyMsgExecutor() {
        return this.replyMsgExecutor;
    }

    public ThreadPoolExecutor getPushMsgExecutor() {
        return this.pushMsgExecutor;
    }

    public ThreadPoolExecutor getClientManageExecutor() {
        return this.clientManageExecutor;
    }

    public ThreadPoolExecutor getAdminExecutor() {
        return this.adminExecutor;
    }

    public RateLimiter getMsgRateLimiter() {
        return this.msgRateLimiter;
    }

    public RateLimiter getBatchRateLimiter() {
        return this.batchRateLimiter;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public HTTPClientPool getHttpClientPool() {
        return this.httpClientPool;
    }
}

