/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.HeartbeatItem;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.ClientType;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.ProtoSupport;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;

public class ServiceUtils {
    public static boolean validateCloudEventAttributes(CloudEvent cloudEvent) {
        return StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getIdc((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getEnv((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getIp((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getPid((CloudEvent)cloudEvent)) && StringUtils.isNumeric((CharSequence)EventMeshCloudEventUtils.getPid((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getSys((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getUserName((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getPassword((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getLanguage((CloudEvent)cloudEvent));
    }

    public static boolean validateCloudEventBatchAttributes(CloudEventBatch cloudEventBatch) {
        if (null == cloudEventBatch || cloudEventBatch.getEventsCount() < 1) {
            return false;
        }
        List eventsList = cloudEventBatch.getEventsList();
        for (CloudEvent cloudEvent : eventsList) {
            if (ServiceUtils.validateCloudEventAttributes(cloudEvent)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateCloudEventData(CloudEvent cloudEvent) {
        boolean flag;
        boolean bl = flag = StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getUniqueId((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getProducerGroup((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getSubject((CloudEvent)cloudEvent)) && StringUtils.isNotEmpty((CharSequence)EventMeshCloudEventUtils.getTtl((CloudEvent)cloudEvent));
        if (!flag) {
            return false;
        }
        String dataContentType = EventMeshCloudEventUtils.getDataContentType((CloudEvent)cloudEvent);
        if (ProtoSupport.isTextContent((String)dataContentType)) {
            return flag & StringUtils.isNotEmpty((CharSequence)cloudEvent.getTextData());
        }
        if (ProtoSupport.isProtoContent((String)dataContentType)) {
            return flag & cloudEvent.getProtoData() != Any.getDefaultInstance();
        }
        return flag & cloudEvent.getBinaryData() != ByteString.EMPTY;
    }

    public static boolean validateCloudEventBatchData(CloudEventBatch cloudEventBatch) {
        if (null == cloudEventBatch || cloudEventBatch.getEventsCount() < 1) {
            return false;
        }
        List eventsList = cloudEventBatch.getEventsList();
        for (CloudEvent cloudEvent : eventsList) {
            if (ServiceUtils.validateCloudEventData(cloudEvent)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateSubscription(GrpcType grpcType, CloudEvent subscription) {
        if (GrpcType.WEBHOOK == grpcType && StringUtils.isEmpty((CharSequence)EventMeshCloudEventUtils.getURL((CloudEvent)subscription))) {
            return false;
        }
        List subscriptionItems = (List)JsonUtils.parseTypeReferenceObject((String)subscription.getTextData(), (TypeReference)new TypeReference<List<SubscriptionItem>>(){});
        if (CollectionUtils.isEmpty((Collection)subscriptionItems) || StringUtils.isEmpty((CharSequence)EventMeshCloudEventUtils.getConsumerGroup((CloudEvent)subscription))) {
            return false;
        }
        for (SubscriptionItem item : subscriptionItems) {
            if (!StringUtils.isEmpty((CharSequence)item.getTopic()) && item.getMode() != SubscriptionMode.UNRECOGNIZED && item.getType() != SubscriptionType.UNRECOGNIZED) continue;
            return false;
        }
        return true;
    }

    public static boolean validateHeartBeat(CloudEvent heartbeat) {
        ClientType clientType = EventMeshCloudEventUtils.getClientType((CloudEvent)heartbeat);
        if (ClientType.SUB == clientType && StringUtils.isEmpty((CharSequence)EventMeshCloudEventUtils.getConsumerGroup((CloudEvent)heartbeat))) {
            return false;
        }
        if (ClientType.PUB == clientType && StringUtils.isEmpty((CharSequence)EventMeshCloudEventUtils.getProducerGroup((CloudEvent)heartbeat))) {
            return false;
        }
        List heartbeatItems = (List)JsonUtils.parseTypeReferenceObject((String)heartbeat.getTextData(), (TypeReference)new TypeReference<List<HeartbeatItem>>(){});
        for (HeartbeatItem item : heartbeatItems) {
            if (!StringUtils.isEmpty((CharSequence)item.getTopic())) continue;
            return false;
        }
        return true;
    }

    public static void sendResponseCompleted(StatusCode code, String message, EventEmitter<CloudEvent> emitter) {
        Instant instant = ServiceUtils.now();
        CloudEvent.Builder builder = CloudEvent.newBuilder().setId(RandomStringUtils.generateUUID()).putAttributes("status_code", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getRetCode()).build()).putAttributes("response_message", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getErrMsg() + " " + message).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
        emitter.onNext(builder.build());
        emitter.onCompleted();
    }

    public static void sendResponseCompleted(StatusCode code, EventEmitter<CloudEvent> emitter) {
        Instant instant = ServiceUtils.now();
        CloudEvent.Builder builder = CloudEvent.newBuilder().putAttributes("status_code", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getRetCode()).build()).putAttributes("response_message", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getErrMsg()).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
        emitter.onNext(builder.build());
        emitter.onCompleted();
    }

    public static void sendStreamResponseCompleted(CloudEvent cloudEvent, StatusCode code, EventEmitter<CloudEvent> emitter) {
        ServiceUtils.sendStreamResponse(cloudEvent, code, emitter);
        emitter.onCompleted();
    }

    public static void sendStreamResponseCompleted(CloudEvent cloudEvent, StatusCode code, String message, EventEmitter<CloudEvent> emitter) {
        ServiceUtils.sendStreamResponse(cloudEvent, code, message, emitter);
        emitter.onCompleted();
    }

    public static void sendStreamResponse(CloudEvent cloudEvent, StatusCode code, EventEmitter<CloudEvent> emitter) {
        Instant instant = ServiceUtils.now();
        CloudEvent.Builder builder = CloudEvent.newBuilder((CloudEvent)cloudEvent).putAttributes("status_code", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getRetCode()).build()).putAttributes("response_message", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getErrMsg()).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
        emitter.onNext(builder.build());
    }

    public static void sendStreamResponse(CloudEvent cloudEvent, StatusCode code, String message, EventEmitter<CloudEvent> emitter) {
        Instant instant = OffsetDateTime.now().toInstant();
        CloudEvent.Builder builder = CloudEvent.newBuilder((CloudEvent)cloudEvent).putAttributes("status_code", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(code.getRetCode()).build()).putAttributes("response_message", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StringUtils.isEmpty((CharSequence)message) ? code.getErrMsg() : message).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
        emitter.onNext(builder.build());
    }

    private static Instant now() {
        return OffsetDateTime.of(LocalDateTime.now(ZoneId.systemDefault()), ZoneOffset.UTC).toInstant();
    }
}

