/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;

@ThreadSafe
public class OrderedProcessor<ResultType>
implements AutoCloseable {
    private final int capacity;
    @GuardedBy(value="stateLock")
    private final Deque<QueueItem> pendingItems;
    private final Executor executor;
    private final Object stateLock = new Object();
    private final Object processingLock = new Object();
    @GuardedBy(value="stateLock")
    private int activeCount;
    @GuardedBy(value="stateLock")
    private boolean closed;

    public OrderedProcessor(int capacity, @NonNull Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be a non-negative number.");
        this.capacity = capacity;
        this.executor = executor;
        this.pendingItems = new ArrayDeque<QueueItem>();
        this.activeCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<QueueItem> toCancel = new ArrayList<QueueItem>();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            toCancel.addAll(this.pendingItems);
            this.pendingItems.clear();
            this.closed = true;
        }
        toCancel.forEach(i -> i.result.cancel(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ResultType> execute(@NonNull Supplier<CompletableFuture<ResultType>> toRun) {
        if (toRun == null) {
            throw new NullPointerException("toRun is marked non-null but is null");
        }
        CompletableFuture<Object> result = null;
        Object object = this.stateLock;
        synchronized (object) {
            Exceptions.checkNotClosed(this.closed, this);
            if (this.hasCapacity() && this.pendingItems.isEmpty()) {
                ++this.activeCount;
            } else {
                result = new CompletableFuture();
                this.pendingItems.add(new QueueItem(toRun, result));
            }
        }
        if (result == null) {
            object = this.processingLock;
            synchronized (object) {
                result = this.processInternal(toRun);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void executionComplete(Throwable exception) {
        Object object = this.stateLock;
        synchronized (object) {
            --this.activeCount;
        }
        object = this.processingLock;
        synchronized (object) {
            while (true) {
                QueueItem toProcess;
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (this.hasCapacity() && !this.pendingItems.isEmpty()) {
                        toProcess = this.pendingItems.pollFirst();
                        ++this.activeCount;
                    } else {
                        break;
                    }
                }
                Futures.completeAfter(() -> this.processInternal(toProcess.toRun), toProcess.result);
            }
        }
    }

    @GuardedBy(value="processingLock")
    private CompletableFuture<ResultType> processInternal(Supplier<CompletableFuture<ResultType>> toRun) {
        try {
            CompletableFuture<ResultType> result = toRun.get();
            result.whenCompleteAsync((r, ex) -> this.executionComplete((Throwable)ex), this.executor);
            return result;
        }
        catch (Throwable ex2) {
            if (!Exceptions.mustRethrow(ex2)) {
                this.executionComplete(ex2);
            }
            throw ex2;
        }
    }

    @GuardedBy(value="stateLock")
    private boolean hasCapacity() {
        return this.activeCount < this.capacity;
    }

    private class QueueItem {
        final Supplier<CompletableFuture<ResultType>> toRun;
        final CompletableFuture<ResultType> result;

        @ConstructorProperties(value={"toRun", "result"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public QueueItem(Supplier<CompletableFuture<ResultType>> toRun, CompletableFuture<ResultType> result) {
            this.toRun = toRun;
            this.result = result;
        }
    }
}

