/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.lmq.benchmark;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.test.util.StatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchLmqStore {
    private static Logger logger = LoggerFactory.getLogger(BenchLmqStore.class);
    private static String namesrv = System.getProperty("namesrv", "127.0.0.1:9876");
    private static String lmqTopic = System.getProperty("lmqTopic", "lmqTestTopic");
    private static boolean enableSub = Boolean.parseBoolean(System.getProperty("enableSub", "true"));
    private static String queuePrefix = System.getProperty("queuePrefix", "lmqTest");
    private static int tps = Integer.parseInt(System.getProperty("tps", "1"));
    private static int lmqNum = Integer.parseInt(System.getProperty("lmqNum", "1"));
    private static int sendThreadNum = Integer.parseInt(System.getProperty("sendThreadNum", "64"));
    private static int consumerThreadNum = Integer.parseInt(System.getProperty("consumerThreadNum", "64"));
    private static String brokerName = System.getProperty("brokerName", "broker-a");
    private static int size = Integer.parseInt(System.getProperty("size", "128"));
    private static int suspendTime = Integer.parseInt(System.getProperty("suspendTime", "2000"));
    private static final boolean RETRY_NO_MATCHED_MSG = Boolean.parseBoolean(System.getProperty("retry_no_matched_msg", "false"));
    private static boolean benchOffset = Boolean.parseBoolean(System.getProperty("benchOffset", "false"));
    private static int benchOffsetNum = Integer.parseInt(System.getProperty("benchOffsetNum", "1"));
    private static Map<MessageQueue, Long> offsetMap = new ConcurrentHashMap<MessageQueue, Long>(256);
    private static Map<MessageQueue, Boolean> pullStatus = new ConcurrentHashMap<MessageQueue, Boolean>(256);
    private static Map<Integer, Map<MessageQueue, Long>> pullEvent = new ConcurrentHashMap<Integer, Map<MessageQueue, Long>>(256);
    public static DefaultMQProducer defaultMQProducer;
    private static int pullConsumerNum;
    public static DefaultMQPullConsumer[] defaultMQPullConsumers;
    private static AtomicLong rid;
    private static final String LMQ_PREFIX = "%LMQ%";

    public static void main(String[] args) throws InterruptedException, MQClientException, MQBrokerException, RemotingException {
        defaultMQProducer = new DefaultMQProducer();
        defaultMQProducer.setProducerGroup("PID_LMQ_TEST");
        defaultMQProducer.setVipChannelEnabled(false);
        defaultMQProducer.setNamesrvAddr(namesrv);
        defaultMQProducer.start();
        for (int i = 0; i < pullConsumerNum; ++i) {
            DefaultMQPullConsumer defaultMQPullConsumer;
            BenchLmqStore.defaultMQPullConsumers[i] = defaultMQPullConsumer = new DefaultMQPullConsumer();
            defaultMQPullConsumer.setNamesrvAddr(namesrv);
            defaultMQPullConsumer.setVipChannelEnabled(false);
            defaultMQPullConsumer.setConsumerGroup("CID_RMQ_SYS_LMQ_TEST_" + i);
            defaultMQPullConsumer.setInstanceName("CID_RMQ_SYS_LMQ_TEST_" + i);
            defaultMQPullConsumer.setRegisterTopics(new HashSet<String>(Arrays.asList(lmqTopic)));
            defaultMQPullConsumer.setBrokerSuspendMaxTimeMillis((long)suspendTime);
            defaultMQPullConsumer.setConsumerTimeoutMillisWhenSuspend((long)(suspendTime + 1000));
            defaultMQPullConsumer.start();
        }
        Thread.sleep(3000L);
        if (benchOffset) {
            BenchLmqStore.doBenchOffset();
            return;
        }
        ScheduledThreadPoolExecutor consumerPool = new ScheduledThreadPoolExecutor(consumerThreadNum, (ThreadFactory)new ThreadFactoryImpl("test"));
        int i = 0;
        while (i < consumerThreadNum) {
            int idx = i++;
            consumerPool.scheduleWithFixedDelay(() -> {
                try {
                    Map<MessageQueue, Long> map = pullEvent.get(idx);
                    if (map == null) {
                        return;
                    }
                    for (Map.Entry<MessageQueue, Long> entry : map.entrySet()) {
                        try {
                            Boolean status = pullStatus.get(entry.getKey());
                            if (Boolean.TRUE.equals(status)) continue;
                            BenchLmqStore.doPull(map, entry.getKey(), entry.getValue());
                        }
                        catch (Exception e) {
                            logger.error("pull broker msg error", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("exec doPull task error", (Throwable)e);
                }
            }, 1L, 1L, TimeUnit.MILLISECONDS);
        }
        if (enableSub && lmqNum > 0 && StringUtils.isNotBlank((CharSequence)brokerName)) {
            for (i = 0; i < lmqNum; ++i) {
                long idx = rid.incrementAndGet();
                String queue = LMQ_PREFIX + queuePrefix + idx % (long)lmqNum;
                MessageQueue mq = new MessageQueue(queue, brokerName, 0);
                int queueHash = Math.abs(queue.hashCode()) % consumerThreadNum;
                pullEvent.putIfAbsent(queueHash, new ConcurrentHashMap());
                pullEvent.get(queueHash).put(mq, idx);
            }
        }
        Thread.sleep(5000L);
        BenchLmqStore.doSend();
    }

    public static void doSend() {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < size; j += 10) {
            sb.append("hello baby");
        }
        byte[] body = sb.toString().getBytes();
        String pubKey = "pub";
        ExecutorService sendPool = Executors.newFixedThreadPool(sendThreadNum);
        for (int i = 0; i < sendThreadNum; ++i) {
            sendPool.execute(() -> {
                while (true) {
                    if (StatUtil.isOverFlow(pubKey, tps)) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    long start = System.currentTimeMillis();
                    try {
                        long idx = rid.incrementAndGet();
                        Message message = new Message(lmqTopic, body);
                        String queue = lmqTopic;
                        if (lmqNum > 0) {
                            queue = LMQ_PREFIX + queuePrefix + idx % (long)lmqNum;
                            message.putUserProperty("INNER_MULTI_DISPATCH", queue);
                        }
                        SendResult sendResult = defaultMQProducer.send(message);
                        StatUtil.addInvoke(pubKey, System.currentTimeMillis() - start);
                        if (StatUtil.nowTps(pubKey) < 10) {
                            logger.warn("pub: {} ", (Object)sendResult.getMsgId());
                        }
                        if (!enableSub) continue;
                        MessageQueue mq = new MessageQueue(queue, sendResult.getMessageQueue().getBrokerName(), lmqNum > 0 ? 0 : sendResult.getMessageQueue().getQueueId());
                        int queueHash = Math.abs(queue.hashCode()) % consumerThreadNum;
                        pullEvent.putIfAbsent(queueHash, new ConcurrentHashMap());
                        pullEvent.get(queueHash).put(mq, idx);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                        StatUtil.addInvoke(pubKey, System.currentTimeMillis() - start, false);
                        continue;
                    }
                    break;
                }
            });
        }
    }

    public static void doPull(final Map<MessageQueue, Long> eventMap, final MessageQueue mq, final Long eventId) throws RemotingException, InterruptedException, MQClientException {
        long start;
        if (!enableSub) {
            eventMap.remove(mq, eventId);
            pullStatus.remove(mq);
            return;
        }
        DefaultMQPullConsumer defaultMQPullConsumer = defaultMQPullConsumers[(int)(eventId % (long)pullConsumerNum)];
        Long offset = offsetMap.get(mq);
        if (offset == null) {
            start = System.currentTimeMillis();
            offset = defaultMQPullConsumer.maxOffset(mq);
            StatUtil.addInvoke("maxOffset", System.currentTimeMillis() - start);
            offsetMap.put(mq, offset);
        }
        start = System.currentTimeMillis();
        if (null != pullStatus.putIfAbsent(mq, true)) {
            return;
        }
        defaultMQPullConsumer.pullBlockIfNotFound(mq, "*", offset.longValue(), 32, new PullCallback(){

            public void onSuccess(PullResult pullResult) {
                List list;
                StatUtil.addInvoke(pullResult.getPullStatus().name(), System.currentTimeMillis() - start);
                eventMap.remove(mq, eventId);
                pullStatus.remove(mq);
                offsetMap.put(mq, pullResult.getNextBeginOffset());
                StatUtil.addInvoke("doPull", System.currentTimeMillis() - start);
                if (PullStatus.NO_MATCHED_MSG.equals((Object)pullResult.getPullStatus()) && RETRY_NO_MATCHED_MSG) {
                    long idx = rid.incrementAndGet();
                    eventMap.put(mq, idx);
                }
                if ((list = pullResult.getMsgFoundList()) == null || list.isEmpty()) {
                    StatUtil.addInvoke("NoMsg", System.currentTimeMillis() - start);
                    return;
                }
                for (MessageExt messageExt : list) {
                    StatUtil.addInvoke("sub", System.currentTimeMillis() - messageExt.getBornTimestamp());
                    if (StatUtil.nowTps("sub") >= 10) continue;
                    logger.warn("sub: {}", (Object)messageExt.getMsgId());
                }
            }

            public void onException(Throwable e) {
                eventMap.remove(mq, eventId);
                pullStatus.remove(mq);
                logger.error("", e);
                StatUtil.addInvoke("doPull", System.currentTimeMillis() - start, false);
            }
        });
    }

    public static void doBenchOffset() throws RemotingException, InterruptedException, MQClientException {
        ExecutorService sendPool = Executors.newFixedThreadPool(sendThreadNum);
        final ConcurrentHashMap offsetMap = new ConcurrentHashMap();
        final String statKey = "benchOffset";
        TopicRouteData topicRouteData = defaultMQPullConsumers[0].getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().getMQClientAPIImpl().getTopicRouteInfoFromNameServer(lmqTopic, 3000L);
        HashMap brokerMap = ((BrokerData)topicRouteData.getBrokerDatas().get(0)).getBrokerAddrs();
        if (brokerMap == null || brokerMap.isEmpty()) {
            return;
        }
        final String brokerAddress = (String)brokerMap.get(0L);
        int i = 0;
        while (i < sendThreadNum) {
            final int flag = i++;
            sendPool.execute(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                if (StatUtil.isOverFlow(statKey, tps)) {
                                    Thread.sleep(100L);
                                }
                                long start = System.currentTimeMillis();
                                DefaultMQPullConsumer defaultMQPullConsumer = defaultMQPullConsumers[(int)(rid.incrementAndGet() % (long)pullConsumerNum)];
                                long id = rid.incrementAndGet();
                                String lmq = BenchLmqStore.LMQ_PREFIX + queuePrefix + id % (long)benchOffsetNum;
                                String lmqCid = "%LMQ%GID_LMQ@@c" + flag + "-" + id % (long)benchOffsetNum;
                                Long offset = (Long)offsetMap.get(lmq);
                                if (offset == null) {
                                    offsetMap.put(lmq, 0L);
                                }
                                long newOffset1 = (Long)offsetMap.get(lmq) + 1L;
                                UpdateConsumerOffsetRequestHeader updateHeader = new UpdateConsumerOffsetRequestHeader();
                                updateHeader.setTopic(lmq);
                                updateHeader.setConsumerGroup(lmqCid);
                                updateHeader.setQueueId(Integer.valueOf(0));
                                updateHeader.setCommitOffset(Long.valueOf(newOffset1));
                                defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().getMQClientAPIImpl().updateConsumerOffset(brokerAddress, updateHeader, 1000L);
                                QueryConsumerOffsetRequestHeader queryHeader = new QueryConsumerOffsetRequestHeader();
                                queryHeader.setTopic(lmq);
                                queryHeader.setConsumerGroup(lmqCid);
                                queryHeader.setQueueId(Integer.valueOf(0));
                                long newOffset2 = defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().getMQClientAPIImpl().queryConsumerOffset(brokerAddress, queryHeader, 1000L);
                                offsetMap.put(lmq, newOffset2);
                                if (newOffset1 != newOffset2) {
                                    StatUtil.addInvoke("ErrorOffset", 1L);
                                }
                                StatUtil.addInvoke(statKey, System.currentTimeMillis() - start);
                            }
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    static {
        pullConsumerNum = Integer.parseInt(System.getProperty("pullConsumerNum", "8"));
        defaultMQPullConsumers = new DefaultMQPullConsumer[pullConsumerNum];
        rid = new AtomicLong();
    }
}

