/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.test.factory.MQMessageFactory;

public class TagMessage {
    private List<String> tags = null;
    private String topic = null;
    private int msgSize = 0;
    private Map<String, List<Object>> rmqMsgs = new HashMap<String, List<Object>>();

    public TagMessage(String tag, String topic, int msgSize) {
        String[] tags = new String[]{tag};
        this.tags = Arrays.asList(tags);
        this.topic = topic;
        this.msgSize = msgSize;
        this.init();
    }

    public TagMessage(String[] tags, String topic, int msgSize) {
        this(Arrays.asList(tags), topic, msgSize);
    }

    public TagMessage(List<String> tags, String topic, int msgSize) {
        this.tags = tags;
        this.topic = topic;
        this.msgSize = msgSize;
        this.init();
    }

    private void init() {
        for (String tag : this.tags) {
            List<Object> tagMsgs = MQMessageFactory.getRMQMessage(tag, this.topic, this.msgSize);
            this.rmqMsgs.put(tag, tagMsgs);
        }
    }

    public List<Object> getMessageByTag(String tag) {
        if (this.tags.contains(tag)) {
            return this.rmqMsgs.get(tag);
        }
        return new ArrayList<Object>();
    }

    public List<Object> getMixedTagMessages() {
        ArrayList<Object> mixedMsgs = new ArrayList<Object>();
        for (int i = 0; i < this.msgSize; ++i) {
            for (String tag : this.tags) {
                mixedMsgs.add(this.rmqMsgs.get(tag).get(i));
            }
        }
        return mixedMsgs;
    }

    public List<Object> getMessageBodyByTag(String tag) {
        if (this.tags.contains(tag)) {
            return MQMessageFactory.getMessageBody(this.rmqMsgs.get(tag));
        }
        return new ArrayList<Object>();
    }

    public List<Object> getMessageBodyByTag(String ... tag) {
        return this.getMessageBodyByTag(Arrays.asList(tag));
    }

    public List<Object> getMessageBodyByTag(List<String> tags) {
        ArrayList<Object> msgBodys = new ArrayList<Object>();
        for (String tag : tags) {
            msgBodys.addAll(MQMessageFactory.getMessageBody(this.rmqMsgs.get(tag)));
        }
        return msgBodys;
    }

    public List<Object> getAllTagMessageBody() {
        ArrayList<Object> msgs = new ArrayList<Object>();
        for (String tag : this.tags) {
            msgs.addAll(MQMessageFactory.getMessageBody(this.rmqMsgs.get(tag)));
        }
        return msgs;
    }
}

