/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.service;

import com.google.protobuf.Timestamp;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.connector.openfunction.config.OpenFunctionServerConfig;
import org.apache.eventmesh.connector.openfunction.source.connector.OpenFunctionSourceConnector;
import org.apache.eventmesh.openconnect.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerService
extends PublisherServiceGrpc.PublisherServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(ProducerService.class);
    public OpenFunctionSourceConnector openFunctionSourceConnector;
    public BlockingQueue<ConnectRecord> queue;
    public OpenFunctionServerConfig config;

    public ProducerService(OpenFunctionSourceConnector openFunctionSourceConnector, OpenFunctionServerConfig serverConfig) {
        this.openFunctionSourceConnector = openFunctionSourceConnector;
        this.queue = openFunctionSourceConnector.queue();
        this.config = serverConfig;
    }

    public void publish(CloudEvent event, StreamObserver<CloudEvent> responseObserver) {
        log.info("receive cloudevents {}", (Object)event);
        Instant instant = ProducerService.now();
        CloudEvent.Builder builder = CloudEvent.newBuilder();
        ConnectRecord connectRecord = this.convertCloudEventToConnectorRecord(event);
        try {
            this.queue.put(connectRecord);
            builder.putAttributes("status_code", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StatusCode.SUCCESS.getRetCode()).build()).putAttributes("response_message", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StatusCode.SUCCESS.getErrMsg()).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
        }
        catch (InterruptedException e) {
            log.error("publish event error {}", (Object)e.getMessage());
            builder.putAttributes("status_code", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode()).build()).putAttributes("response_message", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg()).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
            throw new RuntimeException(e);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    private ConnectRecord convertCloudEventToConnectorRecord(CloudEvent event) {
        ConnectRecord connectRecord = new ConnectRecord(null, null, Long.valueOf(System.currentTimeMillis()), (Object)event.getTextData());
        for (String extensionName : event.getAttributesMap().keySet()) {
            connectRecord.addExtension(extensionName, Objects.requireNonNull(event.getAttributesOrThrow(extensionName)).getCeString());
        }
        connectRecord.addExtension("id", event.getId());
        connectRecord.addExtension("source", event.getSource());
        connectRecord.addExtension("type", event.getType());
        return connectRecord;
    }

    public void batchPublish(CloudEventBatch eventBatch, StreamObserver<CloudEvent> responseObserver) {
    }

    private static Instant now() {
        return OffsetDateTime.of(LocalDateTime.now(ZoneId.systemDefault()), ZoneOffset.UTC).toInstant();
    }
}

