/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.grpc.common;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.ClientType;
import org.apache.eventmesh.common.protocol.grpc.common.ProtoSupport;

public abstract class EventMeshCloudEventUtils {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private EventMeshCloudEventUtils() {
    }

    public static String getEnv(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getEnv(cloudEvent, null);
    }

    public static String getEnv(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("env").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getIdc(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getIdc(cloudEvent, null);
    }

    public static String getIdc(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("idc").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getSys(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getSys(cloudEvent, null);
    }

    public static String getSys(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("sys").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPid(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getPid(cloudEvent, null);
    }

    public static String getPid(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("pid").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getIp(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getIp(cloudEvent, null);
    }

    public static String getIp(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("ip").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getUserName(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getUserName(cloudEvent, null);
    }

    public static String getUserName(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("username").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPassword(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getPassword(cloudEvent, null);
    }

    public static String getPassword(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("passwd").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getLanguage(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getLanguage(cloudEvent, null);
    }

    public static String getLanguage(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("language").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getProtocolType(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getProtocolType(cloudEvent, null);
    }

    public static String getProtocolType(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("protocoltype").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getProtocolVersion(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getProtocolVersion(cloudEvent, null);
    }

    public static String getProtocolVersion(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("protocolversion").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getProtocolDesc(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getProtocolDesc(cloudEvent, null);
    }

    public static String getProtocolDesc(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("protocoldesc").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getSeqNum(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getSeqNum(cloudEvent, null);
    }

    public static String getSeqNum(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("seqnum").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getUniqueId(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getUniqueId(cloudEvent, null);
    }

    public static String getUniqueId(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("uniqueid").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getTtl(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getTtl(cloudEvent, null);
    }

    public static String getTtl(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("ttl").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getProducerGroup(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getProducerGroup(cloudEvent, null);
    }

    public static String getProducerGroup(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("producergroup").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getTag(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getTag(cloudEvent, null);
    }

    public static String getTag(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("tag").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getContentType(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getContentType(cloudEvent, null);
    }

    public static String getContentType(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("contenttype").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getSubject(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getSubject(cloudEvent, null);
    }

    public static String getSubject(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("subject").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getDataContentType(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getDataContentType(cloudEvent, null);
    }

    public static String getDataContentType(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("datacontenttype").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getResponseCode(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getResponseCode(cloudEvent, null);
    }

    public static String getResponseCode(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("status_code").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getResponseMessage(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getResponseMessage(cloudEvent, null);
    }

    public static String getResponseMessage(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("response_message").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getResponseTime(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getResponseTime(cloudEvent, null);
    }

    public static String getResponseTime(CloudEvent cloudEvent, String defaultValue) {
        try {
            Timestamp timestamp = cloudEvent.getAttributesOrThrow("time").getCeTimestamp();
            return EventMeshCloudEventUtils.covertProtoTimestamp(timestamp).toString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getCluster(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getCluster(cloudEvent, null);
    }

    public static String getCluster(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("cluster").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getConsumerGroup(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getConsumerGroup(cloudEvent, null);
    }

    public static String getConsumerGroup(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("consumergroup").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static ClientType getClientType(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getClientType(cloudEvent, null);
    }

    public static ClientType getClientType(CloudEvent cloudEvent, ClientType defaultValue) {
        try {
            int type = cloudEvent.getAttributesOrThrow("clienttype").getCeInteger();
            return ClientType.get(type);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getURL(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getURL(cloudEvent, null);
    }

    public static String getURL(CloudEvent cloudEvent, String defaultValue) {
        try {
            return cloudEvent.getAttributesOrThrow("url").getCeString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getDataContent(CloudEvent cloudEvent) {
        return EventMeshCloudEventUtils.getDataContent(cloudEvent, null);
    }

    public static String getDataContent(CloudEvent cloudEvent, String defaultValue) {
        String dataContentType = EventMeshCloudEventUtils.getDataContentType(cloudEvent);
        if (ProtoSupport.isTextContent(dataContentType)) {
            return Optional.ofNullable(cloudEvent.getTextData()).orElse(defaultValue);
        }
        if (ProtoSupport.isProtoContent(dataContentType)) {
            Any protoData = cloudEvent.getProtoData();
            return protoData == null || protoData == Any.getDefaultInstance() ? defaultValue : new String(protoData.toByteArray(), Constants.DEFAULT_CHARSET);
        }
        ByteString binaryData = cloudEvent.getBinaryData();
        return binaryData == null || ByteString.EMPTY == binaryData ? defaultValue : binaryData.toStringUtf8();
    }

    public static Map<String, String> getAttributes(CloudEvent cloudEvent) {
        if (Objects.isNull(cloudEvent)) {
            return new HashMap<String, String>(0);
        }
        Map attributesMap = Optional.ofNullable(cloudEvent.getAttributesMap()).orElse(new HashMap(0));
        HashMap<String, String> convertedAttributes = new HashMap<String, String>(attributesMap.size());
        attributesMap.forEach((key, value) -> {
            if (Objects.isNull(value)) {
                return;
            }
            if (value.hasCeBoolean()) {
                convertedAttributes.put((String)key, Boolean.toString(value.getCeBoolean()));
                return;
            }
            if (value.hasCeInteger()) {
                convertedAttributes.put((String)key, Integer.toString(value.getCeInteger()));
                return;
            }
            if (value.hasCeString()) {
                convertedAttributes.put((String)key, value.getCeString());
                return;
            }
            if (value.hasCeBytes()) {
                convertedAttributes.put((String)key, value.getCeBytes().toString(Constants.DEFAULT_CHARSET));
                return;
            }
            if (value.hasCeUri()) {
                convertedAttributes.put((String)key, value.getCeUri());
                return;
            }
            if (value.hasCeUriRef()) {
                convertedAttributes.put((String)key, value.getCeUriRef());
                return;
            }
            if (value.hasCeTimestamp()) {
                OffsetDateTime offsetDateTime = EventMeshCloudEventUtils.covertProtoTimestamp(value.getCeTimestamp());
                convertedAttributes.put((String)key, dateTimeFormatter.format(offsetDateTime.toLocalDateTime()));
                return;
            }
        });
        return convertedAttributes;
    }

    private static OffsetDateTime covertProtoTimestamp(Timestamp timestamp) {
        Instant instant = Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        return instant.atOffset(ZoneOffset.UTC);
    }
}

