/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementUtils;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PreparedStatementBindingMethodFilter
implements MethodFilter {
    private static final Map<String, List<String[]>> BIND_METHODS = PreparedStatementBindingMethodFilter.getBindVariableDesc();
    private final Map<String, List<String[]>> methods;

    private static Map<String, List<String[]>> getBindVariableDesc() {
        List<Method> methods = PreparedStatementUtils.findBindVariableSetMethod();
        HashMap<String, List<String[]>> bindMethod = new HashMap<String, List<String[]>>();
        for (Method method : methods) {
            ArrayList<String[]> parameterTypeList = (ArrayList<String[]>)bindMethod.get(method.getName());
            if (parameterTypeList == null) {
                parameterTypeList = new ArrayList<String[]>();
                bindMethod.put(method.getName(), parameterTypeList);
            }
            String[] paramTypeNames = PreparedStatementBindingMethodFilter.getParameterTypeNames(method.getParameterTypes());
            parameterTypeList.add(paramTypeNames);
        }
        return bindMethod;
    }

    private static String[] getParameterTypeNames(Class<?>[] paramTypes) {
        int len = paramTypes.length;
        String[] paramTypeNames = new String[len];
        for (int i = 0; i < len; ++i) {
            Class<?> paramType = paramTypes[i];
            paramTypeNames[i] = ReflectionUtils.getParameterTypeName(paramType);
        }
        return paramTypeNames;
    }

    public static PreparedStatementBindingMethodFilter includes(String ... names) {
        HashMap<String, List<String[]>> targets = new HashMap<String, List<String[]>>(names.length);
        for (String name : names) {
            List<String[]> paramTypes = BIND_METHODS.get(name);
            if (paramTypes == null) continue;
            targets.put(name, paramTypes);
        }
        return new PreparedStatementBindingMethodFilter(targets);
    }

    public static PreparedStatementBindingMethodFilter excludes(String ... names) {
        HashMap<String, List<String[]>> targets = new HashMap<String, List<String[]>>(BIND_METHODS);
        for (String name : names) {
            targets.remove(name);
        }
        return new PreparedStatementBindingMethodFilter(targets);
    }

    public PreparedStatementBindingMethodFilter() {
        this(BIND_METHODS);
    }

    public PreparedStatementBindingMethodFilter(Map<String, List<String[]>> methods) {
        this.methods = Objects.requireNonNull(methods, "methods");
    }

    @Override
    public boolean accept(InstrumentMethod method) {
        List<String[]> paramTypes = this.methods.get(method.getName());
        if (paramTypes == null) {
            return false;
        }
        for (Object[] objectArray : paramTypes) {
            if (!Arrays.equals(objectArray, method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

