/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import java.util.Objects;

public enum TransportModule {
    THRIFT,
    GRPC;


    public static TransportModule parse(String transportModule) {
        Objects.requireNonNull(transportModule, "transportModule");
        if (TransportModule.isEquals(THRIFT, transportModule)) {
            return THRIFT;
        }
        if (TransportModule.isEquals(GRPC, transportModule)) {
            return GRPC;
        }
        return null;
    }

    private static boolean isEquals(TransportModule transportModule, String transportModuleString) {
        String transportModuleName = transportModule.name();
        return transportModuleName.equalsIgnoreCase(transportModuleString);
    }

    public static TransportModule parse(String transportModule, TransportModule defaultModule) {
        Objects.requireNonNull(transportModule, "transportModule");
        Objects.requireNonNull(defaultModule, "defaultModule");
        TransportModule resolvedModule = TransportModule.parse(transportModule);
        if (resolvedModule == null) {
            return defaultModule;
        }
        return resolvedModule;
    }
}

