/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.cache.decorators;

import com.alibaba.nacos.common.cache.Cache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class LruCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private Map<K, V> keyMap;
    private K eldestKey;

    public LruCache(Cache<K, V> delegate, int size) {
        this.delegate = delegate;
        this.setSize(size);
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    public void setSize(final int size) {
        this.keyMap = new LinkedHashMap<K, V>(size, 0.75f, true){
            private static final long serialVersionUID = 4267176411845948333L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean tooBig;
                boolean bl = tooBig = this.size() > size;
                if (tooBig) {
                    LruCache.this.eldestKey = eldest.getKey();
                }
                return tooBig;
            }
        };
    }

    @Override
    public void put(K key, V val) {
        this.delegate.put(key, val);
        this.cycleKeyList(key);
    }

    @Override
    public V get(K key) {
        this.keyMap.get(key);
        return this.delegate.get(key);
    }

    @Override
    public V get(K key, Callable<? extends V> call) throws Exception {
        return this.delegate.get(key, call);
    }

    @Override
    public V remove(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.keyMap.clear();
    }

    private void cycleKeyList(K key) {
        this.keyMap.put(key, null);
        if (this.eldestKey != null) {
            this.delegate.remove(this.eldestKey);
            this.eldestKey = null;
        }
    }
}

