/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.grpc.Header;
import com.navercorp.pinpoint.grpc.HeaderReader;
import com.navercorp.pinpoint.grpc.server.ServerContext;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeaderPropagationInterceptor
implements ServerInterceptor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final HeaderReader<Header> headerReader;
    private final Context.Key<Header> contextKey;

    public HeaderPropagationInterceptor(HeaderReader<Header> headerReader) {
        this(headerReader, ServerContext.getAgentInfoKey());
    }

    public HeaderPropagationInterceptor(HeaderReader<Header> headerReader, Context.Key<Header> contextKey) {
        this.headerReader = Objects.requireNonNull(headerReader, "headerReader");
        this.contextKey = Objects.requireNonNull(contextKey, "contextKey");
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Header headerObject;
        try {
            headerObject = this.headerReader.extract(headers);
        }
        catch (Exception e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Header extract fail cause={}, method={} headers={}, attr={}", (Object)e.getMessage(), (Object)call.getMethodDescriptor().getFullMethodName(), (Object)headers, (Object)call.getAttributes(), (Object)e);
            }
            call.close(Status.INVALID_ARGUMENT.withDescription(e.getMessage()), new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
        Context currentContext = Context.current();
        Context newContext = currentContext.withValue(this.contextKey, (Object)headerObject);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("headerPropagation method={}, headers={}, attr={}", (Object)call.getMethodDescriptor().getFullMethodName(), (Object)headers, (Object)call.getAttributes());
        }
        ServerCall.Listener contextPropagateInterceptor = Contexts.interceptCall((Context)newContext, call, (Metadata)headers, next);
        return contextPropagateInterceptor;
    }
}

