/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.Header;
import com.navercorp.pinpoint.grpc.HeaderReader;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AgentHeaderReader
implements HeaderReader<Header> {
    protected final String name;

    public AgentHeaderReader(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public Header extract(Metadata headers) {
        String agentId = this.getId(headers, Header.AGENT_ID_KEY);
        String agentName = this.getAgentName(headers, Header.AGENT_NAME_KEY);
        String applicationName = this.getId(headers, Header.APPLICATION_NAME_KEY);
        long startTime = this.getTime(headers, Header.AGENT_START_TIME_KEY);
        int serviceType = this.getServiceType(headers);
        long socketId = this.getSocketId(headers);
        List<Integer> supportCommandCodeList = this.getSupportCommandCodeList(headers);
        Map<String, Object> properties = this.newProperties(headers);
        return new Header(this.name, agentId, agentName, applicationName, serviceType, startTime, socketId, supportCommandCodeList, properties);
    }

    protected Map<String, Object> newProperties(Metadata headers) {
        return Collections.emptyMap();
    }

    protected long getTime(Metadata headers, Metadata.Key<String> timeKey) {
        String timeStr = (String)headers.get(timeKey);
        if (timeStr == null) {
            throw Status.INVALID_ARGUMENT.withDescription(timeKey.name() + " header is missing").asRuntimeException();
        }
        try {
            return Long.parseLong(timeStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unsupported format");
        }
    }

    protected String getId(Metadata headers, Metadata.Key<String> idKey) {
        String id = (String)headers.get(idKey);
        if (id == null) {
            throw Status.INVALID_ARGUMENT.withDescription(idKey.name() + " header is missing").asRuntimeException();
        }
        return this.validateId(id, idKey);
    }

    protected String getAgentName(Metadata headers, Metadata.Key<String> idKey) {
        String name = (String)headers.get(idKey);
        if (!StringUtils.isEmpty((String)name)) {
            IdValidateUtils.CheckResult result = IdValidateUtils.checkId((String)name, (int)255);
            if (result == IdValidateUtils.CheckResult.FAIL_PATTERN) {
                throw Status.INVALID_ARGUMENT.withDescription("invalid " + idKey.name()).asRuntimeException();
            }
            if (result == IdValidateUtils.CheckResult.FAIL_LENGTH) {
                throw Status.INVALID_ARGUMENT.withDescription("invalid " + idKey.name() + ".length").asRuntimeException();
            }
        }
        return name;
    }

    protected long getSocketId(Metadata headers) {
        String socketIdStr = (String)headers.get(Header.SOCKET_ID);
        if (socketIdStr == null) {
            return -1L;
        }
        try {
            return Long.parseLong(socketIdStr);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    protected List<Integer> getSupportCommandCodeList(Metadata headers) {
        ArrayList<Integer> supportCommandCodeList = new ArrayList<Integer>();
        String value = (String)headers.get(Header.SUPPORT_COMMAND_CODE);
        if (value == null) {
            return Header.SUPPORT_COMMAND_CODE_LIST_NOT_EXIST;
        }
        List codeValueList = StringUtils.tokenizeToStringList((String)value, (String)";");
        try {
            for (String codeValue : codeValueList) {
                if (StringUtils.isEmpty((String)codeValue)) continue;
                String trimmedCodeValue = codeValue.trim();
                int code = Integer.parseInt(trimmedCodeValue);
                supportCommandCodeList.add(code);
            }
            return Collections.unmodifiableList(supportCommandCodeList);
        }
        catch (NumberFormatException e) {
            return Header.SUPPORT_COMMAND_CODE_LIST_PARSE_ERROR;
        }
    }

    String validateId(String id, Metadata.Key key) {
        if (!IdValidateUtils.validateId((String)id)) {
            throw Status.INVALID_ARGUMENT.withDescription("invalid " + key.name()).asRuntimeException();
        }
        return id;
    }

    protected int getServiceType(Metadata headers) {
        String serviceTypeStr = (String)headers.get(Header.SERVICE_TYPE_KEY);
        if (serviceTypeStr == null) {
            return ServiceType.UNDEFINED.getCode();
        }
        try {
            return Integer.parseInt(serviceTypeStr);
        }
        catch (NumberFormatException ignored) {
            return ServiceType.UNDEFINED.getCode();
        }
    }
}

