/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.grpc.MessageFormatUtils;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.trace.MetadataGrpc;
import com.navercorp.pinpoint.grpc.trace.PApiMetaData;
import com.navercorp.pinpoint.grpc.trace.PResult;
import com.navercorp.pinpoint.grpc.trace.PSqlMetaData;
import com.navercorp.pinpoint.grpc.trace.PStringMetaData;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.GrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.RetryResponseStreamObserver;
import com.navercorp.pinpoint.profiler.sender.grpc.RetryScheduler;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClientReconnectEventListener;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MetadataGrpcDataSender<T>
extends GrpcDataSender<T>
implements EnhancedDataSender<T> {
    private final MetadataGrpc.MetadataStub metadataStub;
    private final int maxAttempts;
    private final int retryDelayMillis;
    private final Timer retryTimer;
    private static final long MAX_PENDING_TIMEOUTS = 4096L;
    private final RetryScheduler<GeneratedMessageV3, PResult> retryScheduler;

    public MetadataGrpcDataSender(String host, int port, int executorQueueSize, MessageConverter<T, GeneratedMessageV3> messageConverter, ChannelFactory channelFactory, int retryMaxCount, int retryDelayMillis) {
        super(host, port, executorQueueSize, messageConverter, channelFactory);
        this.maxAttempts = this.getMaxAttempts(retryMaxCount);
        this.retryDelayMillis = retryDelayMillis;
        this.metadataStub = MetadataGrpc.newStub((Channel)this.managedChannel);
        this.retryTimer = this.newTimer("metadata-timer");
        this.retryScheduler = new RetryScheduler<GeneratedMessageV3, PResult>(){

            @Override
            public boolean isSuccess(PResult response) {
                return response.getSuccess();
            }

            @Override
            public void scheduleNextRetry(GeneratedMessageV3 request, int remainingRetryCount) {
                MetadataGrpcDataSender.this.scheduleNextRetry(request, remainingRetryCount);
            }
        };
    }

    private int getMaxAttempts(int retryMaxCount) {
        if (retryMaxCount < 0) {
            return 0;
        }
        return retryMaxCount;
    }

    private Timer newTimer(String name) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory("Pinpoint-" + name, true);
        return new HashedWheelTimer((ThreadFactory)threadFactory, 100L, TimeUnit.MILLISECONDS, 512, false, 4096L);
    }

    @Override
    public boolean request(T data, int retry) {
        throw new UnsupportedOperationException("unsupported operation request(data, retry)");
    }

    @Override
    public boolean request(T data, FutureListener<ResponseMessage> listener) {
        throw new UnsupportedOperationException("unsupported operation request(data, listener)");
    }

    @Override
    public boolean send(T data) {
        throw new UnsupportedOperationException("unsupported operation send(data)");
    }

    @Override
    public boolean addReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        throw new UnsupportedOperationException("unsupported operation addReconnectEventListener(eventListener)");
    }

    @Override
    public boolean removeReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        throw new UnsupportedOperationException("unsupported operation removeReconnectEventListener(eventListener)");
    }

    @Override
    public boolean request(final T data) {
        Runnable convertAndRun = new Runnable(){

            @Override
            public void run() {
                try {
                    GeneratedMessageV3 message = (GeneratedMessageV3)MetadataGrpcDataSender.this.messageConverter.toMessage(data);
                    if (MetadataGrpcDataSender.this.isDebug) {
                        MetadataGrpcDataSender.this.logger.debug("Request metadata={}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message));
                    }
                    MetadataGrpcDataSender.this.request0(message, MetadataGrpcDataSender.this.maxAttempts);
                }
                catch (Exception ex) {
                    MetadataGrpcDataSender.this.logger.info("Failed to request metadata={}", data, (Object)ex);
                }
            }
        };
        try {
            this.executor.execute(convertAndRun);
        }
        catch (RejectedExecutionException reject) {
            this.logger.info("Rejected metadata={}", data);
            return false;
        }
        return true;
    }

    private void request0(GeneratedMessageV3 message, int remainingRetryCount) {
        if (message instanceof PSqlMetaData) {
            PSqlMetaData sqlMetaData = (PSqlMetaData)message;
            StreamObserver<PResult> responseObserver = this.newResponseStream(message, remainingRetryCount);
            this.metadataStub.requestSqlMetaData(sqlMetaData, responseObserver);
        } else if (message instanceof PApiMetaData) {
            PApiMetaData apiMetaData = (PApiMetaData)message;
            StreamObserver<PResult> responseObserver = this.newResponseStream(message, remainingRetryCount);
            this.metadataStub.requestApiMetaData(apiMetaData, responseObserver);
        } else if (message instanceof PStringMetaData) {
            PStringMetaData stringMetaData = (PStringMetaData)message;
            StreamObserver<PResult> responseObserver = this.newResponseStream(message, remainingRetryCount);
            this.metadataStub.requestStringMetaData(stringMetaData, responseObserver);
        } else {
            this.logger.warn("Unsupported message {}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message));
        }
    }

    private StreamObserver<PResult> newResponseStream(GeneratedMessageV3 message, int remainingRetryCount) {
        return new RetryResponseStreamObserver<GeneratedMessageV3, PResult>(this.logger, this.retryScheduler, message, remainingRetryCount);
    }

    private void scheduleNextRetry(final GeneratedMessageV3 message, final int remainingRetryCount) {
        if (this.shutdown) {
            if (this.isDebug) {
                this.logger.debug("Request drop. Already shutdown request={}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message));
            }
            return;
        }
        if (remainingRetryCount <= 0) {
            if (this.isDebug) {
                this.logger.debug("Request drop. remainingRetryCount={}, request={}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message), (Object)remainingRetryCount);
            }
            return;
        }
        if (this.isDebug) {
            this.logger.debug("Request retry. request={}, remainingRetryCount={}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message), (Object)remainingRetryCount);
        }
        TimerTask timerTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (timeout.cancel()) {
                    return;
                }
                if (MetadataGrpcDataSender.this.shutdown) {
                    return;
                }
                MetadataGrpcDataSender.this.request0(message, remainingRetryCount);
            }
        };
        try {
            this.retryTimer.newTimeout(timerTask, (long)this.retryDelayMillis, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logger.debug("retry fail {}", (Object)e.getCause(), (Object)e);
        }
    }

    @Override
    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Timer retryTimer = this.retryTimer;
        if (retryTimer != null) {
            retryTimer.stop();
        }
        super.release();
    }
}

