/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.IOUtils;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutor;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.DefaultAsyncQueueingExecutorListener;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.buffer.ByteBufferFactory;
import com.navercorp.pinpoint.rpc.buffer.ByteBufferFactoryLocator;
import com.navercorp.pinpoint.rpc.buffer.ByteBufferType;
import com.navercorp.pinpoint.thrift.io.ByteBufferOutputStream;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer2;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory2;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;

public class NioUDPDataSender<T>
implements DataSender<T> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    public static final int SOCKET_TIMEOUT = 5000;
    public static final int SEND_BUFFER_SIZE = 0x100000;
    public static final int UDP_MAX_PACKET_LENGTH = 65507;
    private final DatagramChannel datagramChannel;
    private final HeaderTBaseSerializer2 serializer;
    private final ByteBufferOutputStream byteBufferOutputStream;
    private final AsyncQueueingExecutor<T> executor;
    private final MessageConverter<T, TBase<?, ?>> messageConverter;
    private volatile boolean closed = false;

    public NioUDPDataSender(String host, int port, String threadName, int queueSize, int timeout, int sendBufferSize, MessageConverter<T, TBase<?, ?>> messageConverter) {
        Objects.requireNonNull(host, "host");
        Objects.requireNonNull(threadName, "threadName");
        Assert.isTrue((queueSize > 0 ? 1 : 0) != 0, (String)"queueSize");
        Assert.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"timeout");
        Assert.isTrue((sendBufferSize > 0 ? 1 : 0) != 0, (String)"sendBufferSize");
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.logger.info("NioUDPDataSender initialized. host={}, port={}", (Object)host, (Object)port);
        this.datagramChannel = this.createChannel(host, port, timeout, sendBufferSize);
        HeaderTBaseSerializerFactory2 serializerFactory = new HeaderTBaseSerializerFactory2();
        this.serializer = serializerFactory.createSerializer();
        ByteBufferFactory bufferFactory = ByteBufferFactoryLocator.getFactory((ByteBufferType)ByteBufferType.DIRECT);
        ByteBuffer byteBuffer = bufferFactory.getBuffer(65507);
        this.byteBufferOutputStream = new ByteBufferOutputStream(byteBuffer);
        this.executor = this.createAsyncQueueingExecutor(queueSize, threadName);
    }

    private AsyncQueueingExecutor<T> createAsyncQueueingExecutor(int queueSize, String executorName) {
        DefaultAsyncQueueingExecutorListener listener = new DefaultAsyncQueueingExecutorListener<T>(){

            @Override
            public void execute(T message) {
                NioUDPDataSender.this.sendPacket(message);
            }
        };
        AsyncQueueingExecutor executor = new AsyncQueueingExecutor(queueSize, executorName, listener);
        return executor;
    }

    private DatagramChannel createChannel(String host, int port, int timeout, int sendBufferSize) {
        DatagramChannel datagramChannel = null;
        DatagramSocket socket = null;
        try {
            int checkSendBufferSize;
            datagramChannel = DatagramChannel.open();
            socket = datagramChannel.socket();
            socket.setSoTimeout(timeout);
            socket.setSendBufferSize(sendBufferSize);
            if (this.logger.isWarnEnabled() && sendBufferSize != (checkSendBufferSize = socket.getSendBufferSize())) {
                this.logger.warn("DatagramChannel.setSendBufferSize() error. {}!={}", (Object)sendBufferSize, (Object)checkSendBufferSize);
            }
            InetSocketAddress serverAddress = new InetSocketAddress(host, port);
            datagramChannel.connect(serverAddress);
            return datagramChannel;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(socket);
            IOUtils.closeQuietly((Closeable)datagramChannel);
            throw new IllegalStateException("DatagramChannel create fail. Cause" + e.getMessage(), e);
        }
    }

    @Override
    public boolean send(T data) {
        return this.executor.execute(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.closed = true;
            this.executor.stop();
        }
        finally {
            try {
                this.byteBufferOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendPacket(T message) {
        if (this.closed) {
            throw new PinpointSocketException("NioUDPDataSender already closed.");
        }
        if (message instanceof TBase) {
            TBase tBase = (TBase)message;
            this.sendPacket(tBase);
            return;
        }
        TBase<?, ?> tBase = this.messageConverter.toMessage(message);
        if (tBase != null) {
            this.sendPacket(tBase);
            return;
        }
        this.logger.warn("sendPacket fail. invalid type:{}", message != null ? message.getClass() : null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unknown message:{}", message);
        }
    }

    private void sendPacket(TBase<?, ?> tBase) {
        this.byteBufferOutputStream.clear();
        try {
            this.serializer.serialize(tBase, (OutputStream)this.byteBufferOutputStream);
        }
        catch (TException e) {
            throw new PinpointSocketException("Serialize " + tBase + " failed. Error:" + e.getMessage(), (Throwable)e);
        }
        ByteBuffer byteBuffer = this.byteBufferOutputStream.getByteBuffer();
        int bufferSize = byteBuffer.remaining();
        try {
            this.datagramChannel.write(byteBuffer);
        }
        catch (IOException e) {
            Thread currentThread = Thread.currentThread();
            if (currentThread.isInterrupted()) {
                this.logger.warn("{} thread interrupted.", (Object)currentThread.getName());
                throw new PinpointSocketException(currentThread.getName() + " thread interrupted.", (Throwable)e);
            }
            throw new PinpointSocketException("packet send error. size:" + bufferSize + ", " + tBase, (Throwable)e);
        }
    }
}

