/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaData;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.Result;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import java.util.Objects;

public class DefaultApiMetaDataService
implements ApiMetaDataService {
    private final SimpleCache<String> apiCache;
    private final EnhancedDataSender<MetaDataType> enhancedDataSender;

    public DefaultApiMetaDataService(EnhancedDataSender<MetaDataType> enhancedDataSender, SimpleCache<String> apiCache) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.apiCache = Objects.requireNonNull(apiCache, "apiCache");
    }

    @Override
    public int cacheApi(MethodDescriptor methodDescriptor) {
        String fullName = methodDescriptor.getFullName();
        Result result = this.apiCache.put(fullName);
        methodDescriptor.setApiId(result.getId());
        if (result.isNewValue()) {
            ApiMetaData apiMetadata = new ApiMetaData(result.getId(), methodDescriptor.getApiDescriptor(), methodDescriptor.getLineNumber(), methodDescriptor.getType());
            this.enhancedDataSender.request(apiMetadata);
        }
        return result.getId();
    }
}

