/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogramUtils;
import com.navercorp.pinpoint.profiler.context.thrift.JvmGcTypeThriftMessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.ThreadDumpThriftMessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcDetailedMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSource;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.FileDescriptorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.loadedclass.LoadedClassMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import com.navercorp.pinpoint.profiler.monitor.metric.totalthread.TotalThreadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetricSnapshot;
import com.navercorp.pinpoint.thrift.dto.TActiveTrace;
import com.navercorp.pinpoint.thrift.dto.TActiveTraceHistogram;
import com.navercorp.pinpoint.thrift.dto.TAgentStat;
import com.navercorp.pinpoint.thrift.dto.TAgentStatBatch;
import com.navercorp.pinpoint.thrift.dto.TCpuLoad;
import com.navercorp.pinpoint.thrift.dto.TDataSource;
import com.navercorp.pinpoint.thrift.dto.TDataSourceList;
import com.navercorp.pinpoint.thrift.dto.TDeadlock;
import com.navercorp.pinpoint.thrift.dto.TDirectBuffer;
import com.navercorp.pinpoint.thrift.dto.TFileDescriptor;
import com.navercorp.pinpoint.thrift.dto.TJvmGc;
import com.navercorp.pinpoint.thrift.dto.TJvmGcDetailed;
import com.navercorp.pinpoint.thrift.dto.TJvmGcType;
import com.navercorp.pinpoint.thrift.dto.TLoadedClass;
import com.navercorp.pinpoint.thrift.dto.TResponseTime;
import com.navercorp.pinpoint.thrift.dto.TTotalThreadCount;
import com.navercorp.pinpoint.thrift.dto.TTransaction;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDump;
import java.util.List;
import org.apache.thrift.TBase;

public class StatThriftMessageConverter
implements MessageConverter<MetricType, TBase<?, ?>> {
    private final ThreadDumpThriftMessageConverter threadDumpMessageConverter = new ThreadDumpThriftMessageConverter();
    private final JvmGcTypeThriftMessageConverter jvmGcTypeMessageConverter = new JvmGcTypeThriftMessageConverter();

    @Override
    public TBase<?, ?> toMessage(MetricType message) {
        if (message instanceof AgentStatMetricSnapshotBatch) {
            AgentStatMetricSnapshotBatch agentStatMetricSnapshotBatch = (AgentStatMetricSnapshotBatch)message;
            TAgentStatBatch agentStatBatch = new TAgentStatBatch();
            agentStatBatch.setAgentId(agentStatMetricSnapshotBatch.getAgentId());
            agentStatBatch.setStartTimestamp(agentStatMetricSnapshotBatch.getStartTimestamp());
            for (AgentStatMetricSnapshot agentStatMetricSnapshot : agentStatMetricSnapshotBatch.getAgentStats()) {
                TAgentStat agentStat = this.convertAgentStat(agentStatMetricSnapshot);
                agentStatBatch.addToAgentStats(agentStat);
            }
            return agentStatBatch;
        }
        if (message instanceof AgentStatMetricSnapshot) {
            AgentStatMetricSnapshot agentStatMetricSnapshot = (AgentStatMetricSnapshot)message;
            TAgentStat agentStat = this.convertAgentStat(agentStatMetricSnapshot);
            return agentStat;
        }
        return null;
    }

    private TAgentStat convertAgentStat(AgentStatMetricSnapshot agentStatMetricSnapshot) {
        LoadedClassMetricSnapshot loadedClassMetricSnapshot;
        TotalThreadMetricSnapshot totalThreadMetricSnapshot;
        BufferMetricSnapshot bufferMetricSnapshot;
        FileDescriptorMetricSnapshot fileDescriptorMetricSnapshot;
        DeadlockMetricSnapshot deadlockMetricSnapshot;
        ResponseTimeValue responseTimeValue;
        DataSourceMetricSnapshot dataSourceMetricSnapshot;
        ActiveTraceHistogram activeTraceHistogram;
        TransactionMetricSnapshot transactionMetricSnapshot;
        CpuLoadMetricSnapshot cpuLoadMetricSnapshot;
        TAgentStat agentStat = new TAgentStat();
        agentStat.setTimestamp(agentStatMetricSnapshot.getTimestamp());
        agentStat.setCollectInterval(agentStatMetricSnapshot.getCollectInterval());
        agentStat.setAgentId(agentStatMetricSnapshot.getAgentId());
        agentStat.setStartTimestamp(agentStatMetricSnapshot.getStartTimestamp());
        JvmGcMetricSnapshot jvmGcMetricSnapshot = agentStatMetricSnapshot.getGc();
        if (jvmGcMetricSnapshot != null) {
            TJvmGc jvmGc = this.convertJvmGc(jvmGcMetricSnapshot);
            agentStat.setGc(jvmGc);
        }
        if ((cpuLoadMetricSnapshot = agentStatMetricSnapshot.getCpuLoad()) != null) {
            TCpuLoad cpuLoad = this.convertCpuLoad(cpuLoadMetricSnapshot);
            agentStat.setCpuLoad(cpuLoad);
        }
        if ((transactionMetricSnapshot = agentStatMetricSnapshot.getTransaction()) != null) {
            TTransaction transaction = this.convertTransaction(transactionMetricSnapshot);
            agentStat.setTransaction(transaction);
        }
        if ((activeTraceHistogram = agentStatMetricSnapshot.getActiveTrace()) != null) {
            TActiveTrace activeTrace = this.convertActiveTrace(activeTraceHistogram);
            agentStat.setActiveTrace(activeTrace);
        }
        if ((dataSourceMetricSnapshot = agentStatMetricSnapshot.getDataSourceList()) != null) {
            TDataSourceList dataSourceList = this.convertDataSourceList(dataSourceMetricSnapshot);
            agentStat.setDataSourceList(dataSourceList);
        }
        if ((responseTimeValue = agentStatMetricSnapshot.getResponseTime()) != null) {
            TResponseTime responseTime = this.convertResponseTime(responseTimeValue);
            agentStat.setResponseTime(responseTime);
        }
        if ((deadlockMetricSnapshot = agentStatMetricSnapshot.getDeadlock()) != null) {
            TDeadlock deadlock = this.convertDeadlock(deadlockMetricSnapshot);
            agentStat.setDeadlock(deadlock);
        }
        if ((fileDescriptorMetricSnapshot = agentStatMetricSnapshot.getFileDescriptor()) != null) {
            TFileDescriptor fileDescriptor = this.convertFileDescriptor(fileDescriptorMetricSnapshot);
            agentStat.setFileDescriptor(fileDescriptor);
        }
        if ((bufferMetricSnapshot = agentStatMetricSnapshot.getDirectBuffer()) != null) {
            TDirectBuffer directBuffer = this.convertDirectBuffer(bufferMetricSnapshot);
            agentStat.setDirectBuffer(directBuffer);
        }
        if ((totalThreadMetricSnapshot = agentStatMetricSnapshot.getTotalThread()) != null) {
            TTotalThreadCount totalThreadCount = this.convertTotalThreadCount(totalThreadMetricSnapshot);
            agentStat.setTotalThreadCount(totalThreadCount);
        }
        if ((loadedClassMetricSnapshot = agentStatMetricSnapshot.getLoadedClassCount()) != null) {
            TLoadedClass loadedClass = this.convertLoadedClass(loadedClassMetricSnapshot);
            agentStat.setLoadedClass(loadedClass);
        }
        return agentStat;
    }

    private TJvmGc convertJvmGc(JvmGcMetricSnapshot jvmGcMetricSnapshot) {
        TJvmGc jvmGc = new TJvmGc();
        jvmGc.setJvmMemoryHeapMax(jvmGcMetricSnapshot.getJvmMemoryHeapMax());
        jvmGc.setJvmMemoryHeapUsed(jvmGcMetricSnapshot.getJvmMemoryHeapUsed());
        jvmGc.setJvmMemoryNonHeapMax(jvmGcMetricSnapshot.getJvmMemoryNonHeapMax());
        jvmGc.setJvmMemoryNonHeapUsed(jvmGcMetricSnapshot.getJvmMemoryNonHeapUsed());
        jvmGc.setJvmGcOldCount(jvmGcMetricSnapshot.getJvmGcOldCount());
        jvmGc.setJvmGcOldTime(jvmGcMetricSnapshot.getJvmGcOldTime());
        TJvmGcType jvmGcType = this.jvmGcTypeMessageConverter.toMessage((Object)jvmGcMetricSnapshot.getType());
        jvmGc.setType(jvmGcType);
        if (jvmGcMetricSnapshot.getJvmGcDetailed() != null) {
            JvmGcDetailedMetricSnapshot jvmGcDetailedMetricSnapshot = jvmGcMetricSnapshot.getJvmGcDetailed();
            TJvmGcDetailed jvmGcDetailed = new TJvmGcDetailed();
            jvmGcDetailed.setJvmPoolNewGenUsed(jvmGcDetailedMetricSnapshot.getJvmPoolNewGenUsed());
            jvmGcDetailed.setJvmPoolOldGenUsed(jvmGcDetailedMetricSnapshot.getJvmPoolOldGenUsed());
            jvmGcDetailed.setJvmPoolSurvivorSpaceUsed(jvmGcDetailedMetricSnapshot.getJvmPoolSurvivorSpaceUsed());
            jvmGcDetailed.setJvmPoolCodeCacheUsed(jvmGcDetailedMetricSnapshot.getJvmPoolCodeCacheUsed());
            jvmGcDetailed.setJvmPoolPermGenUsed(jvmGcDetailedMetricSnapshot.getJvmPoolPermGenUsed());
            jvmGcDetailed.setJvmPoolMetaspaceUsed(jvmGcDetailedMetricSnapshot.getJvmPoolMetaspaceUsed());
            jvmGcDetailed.setJvmGcNewCount(jvmGcDetailedMetricSnapshot.getJvmGcNewCount());
            jvmGcDetailed.setJvmGcNewTime(jvmGcDetailedMetricSnapshot.getJvmGcNewTime());
            jvmGc.setJvmGcDetailed(jvmGcDetailed);
        }
        return jvmGc;
    }

    private TCpuLoad convertCpuLoad(CpuLoadMetricSnapshot cpuLoadMetricSnapshot) {
        TCpuLoad cpuLoad = new TCpuLoad();
        cpuLoad.setJvmCpuLoad(cpuLoadMetricSnapshot.getJvmCpuUsage());
        cpuLoad.setSystemCpuLoad(cpuLoadMetricSnapshot.getSystemCpuUsage());
        return cpuLoad;
    }

    private TTransaction convertTransaction(TransactionMetricSnapshot transactionMetricSnapshot) {
        TTransaction transaction = new TTransaction();
        transaction.setSampledNewCount(transactionMetricSnapshot.getSampledNewCount());
        transaction.setSampledContinuationCount(transactionMetricSnapshot.getSampledContinuationCount());
        transaction.setUnsampledNewCount(transactionMetricSnapshot.getUnsampledNewCount());
        transaction.setUnsampledContinuationCount(transactionMetricSnapshot.getUnsampledContinuationCount());
        transaction.setSkippedNewCount(transactionMetricSnapshot.getSkippedNewCount());
        transaction.setSkippedContinuationCount(transactionMetricSnapshot.getSkippedContinuationCount());
        return transaction;
    }

    private TActiveTrace convertActiveTrace(ActiveTraceHistogram activeTraceHistogramMetricSnapshot) {
        TActiveTrace activeTrace = new TActiveTrace();
        TActiveTraceHistogram activeTraceHistogram = new TActiveTraceHistogram();
        if (activeTraceHistogramMetricSnapshot.getHistogramSchema() != null) {
            activeTraceHistogram.setHistogramSchemaType(activeTraceHistogramMetricSnapshot.getHistogramSchema().getTypeCode());
        }
        List<Integer> activeTraceCounts = ActiveTraceHistogramUtils.asList(activeTraceHistogramMetricSnapshot);
        activeTraceHistogram.setActiveTraceCount(activeTraceCounts);
        activeTrace.setHistogram(activeTraceHistogram);
        return activeTrace;
    }

    private TDataSourceList convertDataSourceList(DataSourceMetricSnapshot dataSourceMetricSnapshot) {
        TDataSourceList dataSourceList = new TDataSourceList();
        for (DataSource dataSourceCollectData : dataSourceMetricSnapshot.getDataSourceList()) {
            TDataSource dataSource = new TDataSource(dataSourceCollectData.getId());
            dataSource.setServiceTypeCode(dataSourceCollectData.getServiceTypeCode());
            if (dataSourceCollectData.getDatabaseName() != null) {
                dataSource.setDatabaseName(dataSourceCollectData.getDatabaseName());
            }
            if (dataSourceCollectData.getActiveConnectionSize() != 0) {
                dataSource.setActiveConnectionSize(dataSourceCollectData.getActiveConnectionSize());
            }
            if (dataSourceCollectData.getUrl() != null) {
                dataSource.setUrl(dataSourceCollectData.getUrl());
            }
            dataSource.setMaxConnectionSize(dataSourceCollectData.getMaxConnectionSize());
            dataSourceList.addToDataSourceList(dataSource);
        }
        return dataSourceList;
    }

    private TResponseTime convertResponseTime(ResponseTimeValue responseTimeValue) {
        TResponseTime responseTime = new TResponseTime();
        if (responseTimeValue.getAvg() != 0L) {
            responseTime.setAvg(responseTimeValue.getAvg());
        }
        if (responseTimeValue.getMax() != 0L) {
            responseTime.setMax(responseTimeValue.getMax());
        }
        return responseTime;
    }

    private TDeadlock convertDeadlock(DeadlockMetricSnapshot deadlockMetricSnapshot) {
        TDeadlock deadlock = new TDeadlock();
        deadlock.setDeadlockedThreadCount(deadlockMetricSnapshot.getDeadlockedThreadCount());
        for (ThreadDumpMetricSnapshot threadDumpMetricSnapshot : deadlockMetricSnapshot.getDeadlockedThreadList()) {
            TThreadDump threadDump = this.threadDumpMessageConverter.toMessage(threadDumpMetricSnapshot);
            if (threadDump == null) continue;
            deadlock.addToDeadlockedThreadList(threadDump);
        }
        return deadlock;
    }

    private TFileDescriptor convertFileDescriptor(FileDescriptorMetricSnapshot fileDescriptorMetricSnapshot) {
        TFileDescriptor fileDescriptor = new TFileDescriptor();
        fileDescriptor.setOpenFileDescriptorCount(fileDescriptorMetricSnapshot.getOpenFileDescriptorCount());
        return fileDescriptor;
    }

    private TDirectBuffer convertDirectBuffer(BufferMetricSnapshot bufferMetricSnapshot) {
        TDirectBuffer tdirectBuffer = new TDirectBuffer();
        tdirectBuffer.setDirectCount(bufferMetricSnapshot.getDirectCount());
        tdirectBuffer.setDirectMemoryUsed(bufferMetricSnapshot.getDirectMemoryUsed());
        tdirectBuffer.setMappedCount(bufferMetricSnapshot.getMappedCount());
        tdirectBuffer.setMappedMemoryUsed(bufferMetricSnapshot.getMappedMemoryUsed());
        return tdirectBuffer;
    }

    private TTotalThreadCount convertTotalThreadCount(TotalThreadMetricSnapshot totalThreadMetricSnapshot) {
        TTotalThreadCount tTotalThreadCount = new TTotalThreadCount();
        tTotalThreadCount.setTotalThreadCount((long)totalThreadMetricSnapshot.getTotalThreadCount());
        return tTotalThreadCount;
    }

    private TLoadedClass convertLoadedClass(LoadedClassMetricSnapshot loadedClassMetricSnapshot) {
        TLoadedClass tLoadedClass = new TLoadedClass();
        tLoadedClass.setLoadedClassCount((long)loadedClassMetricSnapshot.getLoadedClassCount());
        tLoadedClass.setUnloadedClassCount(loadedClassMetricSnapshot.getUnloadedClassCount());
        return tLoadedClass;
    }
}

