/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import com.navercorp.pinpoint.profiler.context.module.SpanStatChannelFactory;
import com.navercorp.pinpoint.profiler.context.provider.thrift.AbstractClientFactoryProvider;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.util.Objects;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;

public class SpanClientFactoryProvider
extends AbstractClientFactoryProvider
implements Provider<PinpointClientFactory> {
    private final ThriftTransportConfig thriftTransportConfig;
    private final Provider<ChannelFactory> channelFactoryProvider;
    private final Provider<Timer> spanStatConnectTimer;

    @Inject
    public SpanClientFactoryProvider(ThriftTransportConfig thriftTransportConfig, @SpanStatChannelFactory Provider<ChannelFactory> channelFactoryProvider, @SpanStatChannelFactory Provider<Timer> spanStatConnectTimer) {
        this.thriftTransportConfig = Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        this.channelFactoryProvider = Objects.requireNonNull(channelFactoryProvider, "channelFactoryProvider");
        this.spanStatConnectTimer = Objects.requireNonNull(spanStatConnectTimer, "spanStatConnectTimer");
    }

    public PinpointClientFactory get() {
        if (!"TCP".equalsIgnoreCase(this.thriftTransportConfig.getSpanDataSenderTransportType())) {
            return null;
        }
        DefaultPinpointClientFactory pinpointClientFactory = new DefaultPinpointClientFactory((ChannelFactory)this.channelFactoryProvider.get(), (Timer)this.spanStatConnectTimer.get());
        pinpointClientFactory.setWriteTimeoutMillis(3000L);
        pinpointClientFactory.setRequestTimeoutMillis(5000L);
        int writeBufferHighWaterMark = this.getByteSize(this.thriftTransportConfig.getSpanDataSenderWriteBufferHighWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(16L));
        int writeBufferLowWaterMark = this.getByteSize(this.thriftTransportConfig.getSpanDataSenderWriteBufferLowWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(8L));
        if (writeBufferLowWaterMark > writeBufferHighWaterMark) {
            this.logger.warn("must be writeBufferHighWaterMark({}) >= writeBufferLowWaterMark({})", (Object)writeBufferHighWaterMark, (Object)writeBufferLowWaterMark);
            writeBufferLowWaterMark = writeBufferHighWaterMark;
        }
        pinpointClientFactory.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        pinpointClientFactory.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return pinpointClientFactory;
    }
}

