/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MetadataMessageConverter;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import java.util.Objects;
import org.apache.thrift.TBase;

public class MetadataMessageConverterProvider
implements Provider<MessageConverter<MetaDataType, TBase<?, ?>>> {
    private final String applicationName;
    private final String agentId;
    private final long agentStartTime;

    @Inject
    public MetadataMessageConverterProvider(@ApplicationName String applicationName, @AgentId String agentId, @AgentStartTime long agentStartTime) {
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTime = agentStartTime;
    }

    public MessageConverter<MetaDataType, TBase<?, ?>> get() {
        return new MetadataMessageConverter(this.applicationName, this.agentId, this.agentStartTime);
    }
}

