/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.filedescriptor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.JvmType;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.common.util.OsType;
import com.navercorp.pinpoint.common.util.OsUtils;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.FileDescriptorMetric;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDescriptorMetricProvider
implements Provider<FileDescriptorMetric> {
    private static final String UNSUPPORTED_METRIC = "UNSUPPORTED_FILE_DESCRIPTOR_METRIC";
    private static final String ORACLE_FILE_DESCRIPTOR_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.oracle.OracleFileDescriptorMetric";
    private static final String IBM_FILE_DESCRIPTOR_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.ibm.IbmFileDescriptorMetric";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String vendorName;
    private final String osName;

    @Inject
    public FileDescriptorMetricProvider(ContextConfig contextConfig) {
        Objects.requireNonNull(contextConfig, "contextConfig");
        this.vendorName = contextConfig.getProfilerJvmVendorName();
        this.osName = contextConfig.getProfilerOSName();
    }

    public FileDescriptorMetric get() {
        JvmVersion jvmVersion = JvmUtils.getVersion();
        JvmType jvmType = this.getJvmType();
        OsType osType = this.getOsType();
        String classToLoad = this.getMetricClassName(osType, jvmVersion, jvmType);
        FileDescriptorMetric fileDescriptorMetric = this.createFileDescriptorMetric(classToLoad);
        this.logger.info("loaded : {}", (Object)fileDescriptorMetric);
        return fileDescriptorMetric;
    }

    @VisibleForTesting
    String getMetricClassName(OsType osType, JvmVersion jvmVersion, JvmType jvmType) {
        if (!this.isSupportedOS(osType)) {
            this.logger.warn("Unsupported operating system {}/{}/{}", (Object)osType, (Object)jvmVersion, (Object)jvmType);
            return UNSUPPORTED_METRIC;
        }
        if (this.isOracleJdk(jvmType) && jvmVersion.onOrAfter(JvmVersion.JAVA_5)) {
            return ORACLE_FILE_DESCRIPTOR_METRIC;
        }
        if (jvmType == JvmType.IBM && jvmVersion.onOrAfter(JvmVersion.JAVA_8)) {
            return IBM_FILE_DESCRIPTOR_METRIC;
        }
        return UNSUPPORTED_METRIC;
    }

    private boolean isOracleJdk(JvmType jvmType) {
        EnumSet<JvmType> orackeJdk = EnumSet.of(JvmType.ORACLE, JvmType.OPENJDK);
        return orackeJdk.contains(jvmType);
    }

    private boolean isSupportedOS(OsType osType) {
        EnumSet<OsType[]> supportedOs = EnumSet.of(OsType.MAC, new OsType[]{OsType.SOLARIS, OsType.LINUX, OsType.AIX, OsType.HP_UX, OsType.BSD});
        return supportedOs.contains(osType);
    }

    private JvmType getJvmType() {
        JvmType jvmType = JvmType.fromVendor((String)this.vendorName);
        if (jvmType == JvmType.UNKNOWN) {
            return JvmUtils.getType();
        }
        return jvmType;
    }

    private OsType getOsType() {
        OsType osType = OsType.fromVendor((String)this.osName);
        if (osType == OsType.UNKNOWN) {
            return OsUtils.getType();
        }
        return osType;
    }

    private FileDescriptorMetric createFileDescriptorMetric(String classToLoad) {
        if (classToLoad == null) {
            return FileDescriptorMetric.UNSUPPORTED_FILE_DESCRIPTOR_METRIC;
        }
        if (UNSUPPORTED_METRIC.equals(classToLoad)) {
            return FileDescriptorMetric.UNSUPPORTED_FILE_DESCRIPTOR_METRIC;
        }
        try {
            Class<?> fileDescriptorMetricClass = Class.forName(classToLoad);
            try {
                Constructor<?> fileDescriptorMetricConstructor = fileDescriptorMetricClass.getConstructor(new Class[0]);
                return (FileDescriptorMetric)fileDescriptorMetricConstructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("Unknown FileDescriptorMetric : {}", (Object)classToLoad);
                return FileDescriptorMetric.UNSUPPORTED_FILE_DESCRIPTOR_METRIC;
            }
        }
        catch (Exception e) {
            this.logger.warn("Error creating FileDescriptorMetric [{}]", (Object)classToLoad);
            return FileDescriptorMetric.UNSUPPORTED_FILE_DESCRIPTOR_METRIC;
        }
    }
}

