/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.sampler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;
import com.navercorp.pinpoint.profiler.sampler.BasicTraceSampler;
import com.navercorp.pinpoint.profiler.sampler.RateLimitTraceSampler;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceSamplerProvider
implements Provider<TraceSampler> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Sampler sampler;
    private final IdGenerator idGenerator;
    private final ContextConfig contextConfig;

    @Inject
    public TraceSamplerProvider(ContextConfig contextConfig, Sampler sampler, IdGenerator idGenerator) {
        this.contextConfig = Objects.requireNonNull(contextConfig, "contextConfig");
        this.sampler = Objects.requireNonNull(sampler, "sampler");
        this.idGenerator = Objects.requireNonNull(idGenerator, "idGenerator");
    }

    public TraceSampler get() {
        this.logger.info("new BasicTraceSampler()");
        Object traceSampler = new BasicTraceSampler(this.idGenerator, this.sampler);
        int samplingNewThroughput = this.contextConfig.getSamplingNewThroughput();
        int samplingContinueThroughput = this.contextConfig.getSamplingContinueThroughput();
        if (samplingNewThroughput > 0 || samplingContinueThroughput > 0) {
            traceSampler = new RateLimitTraceSampler(samplingNewThroughput, samplingContinueThroughput, this.idGenerator, (TraceSampler)traceSampler);
            this.logger.info("new RateLimitTraceSampler {}/{}", (Object)samplingNewThroughput, (Object)samplingContinueThroughput);
        }
        return traceSampler;
    }
}

